/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.managers.log.Log;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.TimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class WebTimer {
    public static String defaultThreadName = "WebTimer";
    public static int defaultCyclesLimit = 0;
    public static boolean useEdtByDefault = true;
    protected final List<ActionListener> listeners = new ArrayList<ActionListener>(1);
    protected int id = 0;
    protected int lastId;
    protected final Map<Integer, Boolean> running = new Hashtable<Integer, Boolean>();
    protected long sleepStart = 0L;
    protected long sleepTime = 0L;
    protected int cycleCount = 0;
    protected Thread exec = null;
    protected long delay;
    protected long initialDelay;
    protected boolean repeats = true;
    protected boolean coalesce = true;
    protected boolean useEventDispatchThread = true;
    protected boolean useDaemonThread = false;
    protected boolean nonBlockingStop = false;
    protected String actionCommand = "";
    protected String name = null;
    protected int cyclesLimit = 0;

    public WebTimer(String delay) {
        this(TextUtils.parseDelay(delay));
    }

    public WebTimer(long delay) {
        this(defaultThreadName, delay);
    }

    public WebTimer(String name, String delay) {
        this(name, TextUtils.parseDelay(delay));
    }

    public WebTimer(String name, long delay) {
        this(name, delay, null);
    }

    public WebTimer(long delay, long initialDelay) {
        this(defaultThreadName, delay, initialDelay);
    }

    public WebTimer(String name, long delay, long initialDelay) {
        this(name, delay, initialDelay, null);
    }

    public WebTimer(String delay, ActionListener listener) {
        this(TextUtils.parseDelay(delay), listener);
    }

    public WebTimer(long delay, ActionListener listener) {
        this(defaultThreadName, delay, listener);
    }

    public WebTimer(String name, String delay, ActionListener listener) {
        this(name, TextUtils.parseDelay(delay), listener);
    }

    public WebTimer(String name, long delay, ActionListener listener) {
        this(name, delay, -1L, listener);
    }

    public WebTimer(long delay, long initialDelay, ActionListener listener) {
        this(defaultThreadName, delay, initialDelay, listener);
    }

    public WebTimer(String name, String delay, String initialDelay, ActionListener listener) {
        this(name, TextUtils.parseDelay(delay), TextUtils.parseDelay(initialDelay), listener);
    }

    public WebTimer(String name, long delay, long initialDelay, ActionListener listener) {
        this.setName(name);
        this.setDelay(delay);
        this.setInitialDelay(initialDelay);
        this.addActionListener(listener);
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public String getInitialStringDelay() {
        return TextUtils.toStringDelay(this.initialDelay);
    }

    public WebTimer setInitialDelay(String initialDelay) {
        this.setInitialDelay(TextUtils.parseDelay(initialDelay));
        return this;
    }

    public WebTimer setInitialDelay(long initialDelay) {
        if (initialDelay != -1L && initialDelay < 0L) {
            throw new IllegalArgumentException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
        return this;
    }

    public long getDelay() {
        return this.delay;
    }

    public String getStringDelay() {
        return TextUtils.toStringDelay(this.delay);
    }

    public WebTimer setDelay(String delay) {
        this.setDelay(TextUtils.parseDelay(delay));
        return this;
    }

    public WebTimer setDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        this.delay = delay;
        return this;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public WebTimer setRepeats(boolean repeats) {
        this.repeats = repeats;
        return this;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public WebTimer setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
        return this;
    }

    public boolean isUseEventDispatchThread() {
        return this.useEventDispatchThread;
    }

    public WebTimer setUseEventDispatchThread(boolean useEventDispatchThread) {
        this.useEventDispatchThread = useEventDispatchThread;
        return this;
    }

    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    public WebTimer setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
        return this;
    }

    public boolean isNonBlockingStop() {
        return this.nonBlockingStop;
    }

    public WebTimer setNonBlockingStop(boolean nonBlockingStop) {
        this.nonBlockingStop = nonBlockingStop;
        return this;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public WebTimer setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
        return this;
    }

    public int getCyclesLimit() {
        return this.cyclesLimit;
    }

    public WebTimer setCyclesLimit(int cyclesLimit) {
        this.cyclesLimit = cyclesLimit;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebTimer setName(String name) {
        this.name = name;
        if (this.exec != null) {
            this.exec.setName(name);
        }
        return this;
    }

    public long getCycleTimePassed() {
        return System.currentTimeMillis() - this.sleepStart;
    }

    public long getCycleTimeLeft() {
        return this.sleepTime - this.getCycleTimePassed();
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public int getCycleNumber() {
        return this.cycleCount + 1;
    }

    public boolean isLastCycle() {
        return this.getCyclesLimit() > 0 && this.getCycleNumber() == this.getCyclesLimit();
    }

    public WebTimer start() {
        this.startExec();
        return this;
    }

    public WebTimer stop() {
        this.stopExec();
        return this;
    }

    public WebTimer restart() {
        this.stopExec();
        this.startExec();
        return this;
    }

    public WebTimer restart(long delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(long initialDelay, long delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(String delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public WebTimer restart(String initialDelay, String delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.exec != null && this.exec.isAlive();
    }

    protected synchronized void startExec() {
        if (this.isRunning()) {
            return;
        }
        final int currentId = this.lastId = this.id++;
        this.exec = new Thread(new Runnable(){

            @Override
            public void run() {
                block6: {
                    WebTimer.this.setAlive(currentId, true);
                    try {
                        long actualInitialDelay;
                        long l = actualInitialDelay = WebTimer.this.getInitialDelay() < 0L ? WebTimer.this.getDelay() : WebTimer.this.getInitialDelay();
                        if (actualInitialDelay > 0L) {
                            WebTimer.this.sleepStart = System.currentTimeMillis();
                            WebTimer.this.sleepTime = actualInitialDelay;
                            Thread.sleep(actualInitialDelay);
                        }
                        if (!WebTimer.this.shouldContinue(-1, currentId)) break block6;
                        WebTimer.this.cycleCount = 0;
                        if (WebTimer.this.repeats) {
                            while (WebTimer.this.shouldContinue(WebTimer.this.cycleCount, currentId)) {
                                WebTimer.this.fireActionPerformed(currentId);
                                ++WebTimer.this.cycleCount;
                                if (WebTimer.this.shouldContinue(WebTimer.this.cycleCount, currentId)) {
                                    if (WebTimer.this.getDelay() <= 0L) continue;
                                    long currentDelay = WebTimer.this.getDelay();
                                    WebTimer.this.sleepStart = System.currentTimeMillis();
                                    WebTimer.this.sleepTime = currentDelay;
                                    Thread.sleep(currentDelay);
                                    continue;
                                }
                                break block6;
                            }
                            break block6;
                        }
                        WebTimer.this.fireActionPerformed(currentId);
                        ++WebTimer.this.cycleCount;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                WebTimer.this.cleanUp(currentId);
            }
        }, this.name);
        this.exec.setDaemon(this.useDaemonThread);
        this.exec.start();
    }

    protected boolean shouldContinue(int cycle, int id) {
        return this.running.get(id) != false && !Thread.currentThread().isInterrupted() && (this.cyclesLimit <= 0 || this.cyclesLimit > cycle);
    }

    protected void setAlive(int id, boolean alive) {
        this.running.put(id, alive);
    }

    protected void cleanUp(int id) {
        this.running.remove(id);
    }

    protected synchronized void stopExec() {
        if (this.exec != null) {
            this.exec.interrupt();
            this.setAlive(this.lastId, false);
            if (!this.nonBlockingStop) {
                try {
                    this.exec.join();
                }
                catch (InterruptedException e) {
                    Log.error((Object)this, (Throwable)e);
                }
            }
        }
    }

    public WebTimer addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
        return this;
    }

    public WebTimer removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
        return this;
    }

    public List<ActionListener> getListeners() {
        return this.listeners;
    }

    public void fireActionPerformed(int id) {
        block2: {
            ArrayList<ActionListener> listenerList;
            ActionEvent actionEvent;
            block3: {
                block4: {
                    if (this.listeners.size() <= 0) break block2;
                    actionEvent = this.createActionEvent();
                    listenerList = CollectionUtils.copy(this.listeners);
                    if (!this.useEventDispatchThread) break block3;
                    if (!this.coalesce) break block4;
                    if (!this.shouldContinue(this.cycleCount, id)) break block2;
                    CoreSwingUtils.invokeAndWaitSafely(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener listener : listenerList) {
                                listener.actionPerformed(actionEvent);
                            }
                        }
                    });
                    break block2;
                }
                for (final ActionListener listener : listenerList) {
                    if (!this.shouldContinue(this.cycleCount, id)) continue;
                    CoreSwingUtils.invokeAndWaitSafely(new Runnable(){

                        @Override
                        public void run() {
                            listener.actionPerformed(actionEvent);
                        }
                    });
                }
                break block2;
            }
            for (ActionListener listener : listenerList) {
                listener.actionPerformed(actionEvent);
            }
        }
    }

    protected ActionEvent createActionEvent() {
        return new ActionEvent(this, 0, this.actionCommand, TimeUtils.currentTime(), 0);
    }

    public String toString() {
        return this.name + ", delay (" + this.getStringDelay() + "), initialDelay (" + this.getInitialStringDelay() + ")";
    }

    public static WebTimer delay(String delay, ActionListener listener) {
        return WebTimer.delay(TextUtils.parseDelay(delay), listener);
    }

    public static WebTimer delay(long delay, ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, listener);
    }

    public static WebTimer delay(String name, String delay, ActionListener listener) {
        return WebTimer.delay(name, TextUtils.parseDelay(delay), listener);
    }

    public static WebTimer delay(String name, long delay, ActionListener listener) {
        return WebTimer.delay(name, delay, true, listener);
    }

    public static WebTimer delay(String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(TextUtils.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, useEventDispatchThread, listener);
    }

    public static WebTimer delay(String name, String delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.delay(name, TextUtils.parseDelay(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(String name, long delay, boolean useEventDispatchThread, ActionListener listener) {
        WebTimer once = new WebTimer(name, delay, listener);
        once.setRepeats(false);
        once.setUseEventDispatchThread(useEventDispatchThread);
        once.start();
        return once;
    }

    public static WebTimer repeat(String delay, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String delay, int cyclesLimit, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, int cyclesLimit, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, String delay, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(name, pd, pd, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, String delay, int cyclesLimit, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(name, pd, pd, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, long delay, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, long delay, int cyclesLimit, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String delay, boolean useEventDispatchThread, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String delay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, String delay, boolean useEventDispatchThread, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(name, pd, pd, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, String delay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        long pd = TextUtils.parseDelay(delay);
        return WebTimer.repeat(name, pd, pd, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, int cyclesLimit, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, int cyclesLimit, ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, boolean useEventDispatchThread, ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(String name, long delay, long initialDelay, int cyclesLimit, boolean useEventDispatchThread, ActionListener listener) {
        WebTimer repeat = new WebTimer(name, delay, initialDelay, listener);
        repeat.setRepeats(true);
        repeat.setUseEventDispatchThread(useEventDispatchThread);
        repeat.setCyclesLimit(cyclesLimit);
        repeat.start();
        return repeat;
    }

    public static WebTimer repeat(boolean useDaemonThread, String name, long delay, ActionListener listener) {
        return WebTimer.repeat(useDaemonThread, name, delay, delay, listener);
    }

    public static WebTimer repeat(boolean useDaemonThread, String name, long delay, long initialDelay, ActionListener listener) {
        return WebTimer.repeat(useDaemonThread, name, delay, initialDelay, defaultCyclesLimit, listener);
    }

    public static WebTimer repeat(boolean useDaemonThread, String name, long delay, long initialDelay, int cyclesLimit, ActionListener listener) {
        WebTimer repeat = new WebTimer(name, delay, initialDelay, listener);
        repeat.setRepeats(true);
        repeat.setUseDaemonThread(useDaemonThread);
        repeat.setUseEventDispatchThread(false);
        repeat.setCyclesLimit(cyclesLimit);
        repeat.start();
        return repeat;
    }
}

