/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.font.DerivedFontAttributes;
import com.alee.utils.map.SoftHashMap;
import java.awt.Font;
import java.util.Map;

public class FontUtils {
    private static final Map<DerivedFontAttributes, Font> derivedFontsCache = new SoftHashMap<DerivedFontAttributes, Font>();

    public static void clearDerivedFontsCache() {
        if (derivedFontsCache != null) {
            derivedFontsCache.clear();
        }
    }

    public static Font getCachedDerivedFont(Font font, int style, int size) {
        DerivedFontAttributes attribute = FontUtils.getFontAttribute(font, style, size);
        Font derivedFont = derivedFontsCache.get(attribute);
        if (derivedFont == null) {
            derivedFont = font.deriveFont(style, size);
            derivedFontsCache.put(attribute, derivedFont);
        }
        return derivedFont;
    }

    protected static DerivedFontAttributes getFontAttribute(Font font, int style, int size) {
        return new DerivedFontAttributes(font, style, size);
    }
}

