/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.version;

import com.alee.managers.version.VersionInfo;
import com.alee.managers.version.VersionManager;
import com.alee.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class VersionUpdater {
    private static final String s = File.separator;
    private static final String propertiesPath = "build" + s + "version.properties";
    private static final String versionPath = "modules" + s + "ui" + s + "src" + s + "com" + s + "alee" + s + "laf" + s + "resources" + s + "version.xml";

    public static void main(String[] args) throws IOException {
        VersionManager.initialize();
        if (args.length == 0 || args[0].equals("increment") || args[0].equals("decrement")) {
            VersionUpdater.updateVersion(args.length == 0 || args[0].equals("increment") ? 1 : -1);
        } else if (args[0].equals("update")) {
            VersionUpdater.updateVersion(-1);
            VersionUpdater.updateVersion(1);
        }
    }

    private static void updateVersion(int change) throws IOException {
        File propertiesFile = new File(propertiesPath);
        Properties properties = new Properties();
        FileInputStream inputStream = new FileInputStream(propertiesFile);
        properties.load(inputStream);
        inputStream.close();
        properties.setProperty("build.number", "" + (Integer.parseInt(properties.getProperty("build.number")) + change));
        FileOutputStream outputStream = new FileOutputStream(propertiesFile);
        properties.store(outputStream, null);
        outputStream.close();
        File versionFile = new File(versionPath);
        VersionInfo versionInfo = (VersionInfo)XmlUtils.fromXML(versionFile);
        versionInfo.setBuild(versionInfo.getBuild() + change);
        versionInfo.setDate(System.currentTimeMillis());
        XmlUtils.toXML((Object)versionInfo, versionFile);
    }
}

