/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.painter.AbstractPainter;
import com.alee.extended.painter.Painter;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.toolbar.WebToolBarStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import javax.swing.SwingConstants;

public class WebToolBarCorner
extends WebPanel
implements SwingConstants {
    private static Painter<WebToolBarCorner> painter = new WebToolBarCornerPainter();
    private int position = 8;

    public WebToolBarCorner() {
        super(painter);
    }

    public WebToolBarCorner(int position) {
        super(painter);
        this.setPosition(position);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    private static class WebToolBarCornerPainter
    extends AbstractPainter<WebToolBarCorner> {
        private static final float[] fractions = new float[]{0.0f, 0.5f};
        private static final Color[] colors = new Color[]{WebToolBarStyle.bottomBgColor, WebToolBarStyle.topBgColor};

        private WebToolBarCornerPainter() {
        }

        @Override
        public void paint(Graphics2D g2d, Rectangle b, WebToolBarCorner c) {
            boolean left;
            boolean top;
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            boolean bl = top = c.getPosition() == 8 || c.getPosition() == 2;
            boolean bl2 = ltr ? c.getPosition() == 8 || c.getPosition() == 6 : (left = c.getPosition() == 2 || c.getPosition() == 4);
            if (top) {
                if (left) {
                    Rectangle gradientBounds = new Rectangle(b.x, b.y, b.width * 2, b.height * 2);
                    g2d.setPaint(new RadialGradientPaint(gradientBounds, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2d.fill(b);
                    g2d.setPaint(c.isEnabled() ? WebToolBarStyle.borderColor : WebToolBarStyle.disabledBorderColor);
                    g2d.drawLine(b.x + b.width - 1, b.y + b.height - 1, b.x + b.width - 1, b.y + b.height - 1);
                } else {
                    Rectangle gradientBounds = new Rectangle(b.x - b.width, b.y, b.width * 2, b.height * 2);
                    g2d.setPaint(new RadialGradientPaint(gradientBounds, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                    g2d.fill(b);
                    g2d.setPaint(c.isEnabled() ? WebToolBarStyle.borderColor : WebToolBarStyle.disabledBorderColor);
                    g2d.drawLine(b.x, b.y + b.height - 1, b.x, b.y + b.height - 1);
                }
            } else if (left) {
                Rectangle gradientBounds = new Rectangle(b.x, b.y - b.height, b.width * 2, b.height * 2);
                g2d.setPaint(new RadialGradientPaint(gradientBounds, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                g2d.fill(b);
                g2d.setPaint(c.isEnabled() ? WebToolBarStyle.borderColor : WebToolBarStyle.disabledBorderColor);
                g2d.drawLine(b.x + b.width - 1, b.y, b.x + b.width - 1, b.y);
            } else {
                Rectangle gradientBounds = new Rectangle(b.x - b.width, b.y - b.height, b.width * 2, b.height * 2);
                g2d.setPaint(new RadialGradientPaint(gradientBounds, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE));
                g2d.fill(b);
                g2d.setPaint(c.isEnabled() ? WebToolBarStyle.borderColor : WebToolBarStyle.disabledBorderColor);
                g2d.drawLine(b.x, b.y, b.x, b.y);
            }
        }
    }
}

