/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.extended.panel.WebButtonGroup;
import com.alee.laf.button.WebButtonStyle;
import com.alee.laf.rootpane.WebResizeCorner;
import com.alee.laf.rootpane.WebRootPaneUI;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;

public class WebRootPaneLayout
extends AbstractLayoutManager {
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSize(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSize(parent, false);
    }

    @Override
    public void layoutContainer(Container parent) {
        Container contentPane;
        Dimension ps;
        JRootPane root = (JRootPane)parent;
        WebRootPaneUI rootUI = (WebRootPaneUI)root.getUI();
        Insets i = parent.getInsets();
        Insets ci = new Insets(1, 1, 1, 1);
        Dimension s = parent.getSize();
        int w = s.width - i.right - i.left;
        int h = s.height - i.top - i.bottom;
        boolean ltr = root.getComponentOrientation().isLeftToRight();
        WebButtonGroup windowButtons = rootUI.getWindowButtons();
        JComponent titleComponent = rootUI.getTitleComponent();
        JMenuBar menuBar = root.getJMenuBar();
        WebResizeCorner resizeCorner = rootUI.getResizeCorner();
        boolean showWindowButtons = windowButtons != null && rootUI.isShowWindowButtons() && (rootUI.isShowMinimizeButton() || rootUI.isShowMaximizeButton() || rootUI.isShowCloseButton());
        boolean showTitleComponent = titleComponent != null && rootUI.isShowTitleComponent();
        boolean showMenuBar = menuBar != null && rootUI.isShowMenuBar();
        boolean showResizeCorner = resizeCorner != null && rootUI.isResizable() && rootUI.isShowResizeCorner() && !rootUI.isFrameMaximized();
        int nextY = 0;
        int buttonsWidth = 0;
        if (showWindowButtons) {
            parent.setComponentZOrder(windowButtons, 0);
            ps = windowButtons.getPreferredSize();
            int buttonsShear = this.getButtonsShear(rootUI);
            int x = ltr ? s.width - i.right - buttonsShear - ps.width : i.left + buttonsShear;
            windowButtons.setVisible(true);
            windowButtons.setBounds(x, i.top, ps.width, ps.height);
            buttonsWidth = ps.width;
        } else if (windowButtons != null) {
            windowButtons.setVisible(false);
        }
        if (showTitleComponent) {
            ps = titleComponent.getPreferredSize();
            titleComponent.setVisible(true);
            titleComponent.setBounds(ltr ? i.left : i.left + buttonsWidth, i.top, w - buttonsWidth, ps.height);
            nextY += ps.height;
        } else if (titleComponent != null) {
            titleComponent.setVisible(false);
        }
        JLayeredPane layeredPane = root.getLayeredPane();
        if (layeredPane != null) {
            layeredPane.setBounds(i.left + ci.left, i.top + ci.top, w - ci.left - ci.right, h - ci.top - ci.bottom);
        }
        if (showMenuBar) {
            Dimension mbd = menuBar.getPreferredSize();
            menuBar.setVisible(true);
            menuBar.setBounds(0, nextY, w - ci.left - ci.right, mbd.height);
            nextY += mbd.height;
        } else if (menuBar != null) {
            menuBar.setVisible(false);
        }
        Component glassPane = root.getGlassPane();
        if (glassPane != null) {
            glassPane.setBounds(i.left, i.top, w, h);
        }
        if ((contentPane = root.getContentPane()) != null) {
            contentPane.setBounds(0, nextY, w - ci.left - ci.right, h < nextY ? 0 : h - nextY - ci.top - ci.bottom);
        }
        if (showResizeCorner) {
            Dimension ps2 = ((JComponent)resizeCorner).getPreferredSize();
            resizeCorner.setVisible(true);
            resizeCorner.setBounds(s.width - i.right - ps2.width - 2, s.height - i.bottom - ps2.height - 2, ps2.width, ps2.height);
        } else if (resizeCorner != null) {
            resizeCorner.setVisible(false);
        }
    }

    private Dimension calculateSize(Container parent, boolean preferred) {
        int tpHeight;
        int tpWidth;
        int buttonsShear;
        Insets i = parent.getInsets();
        Insets ci = new Insets(1, 1, 1, 1);
        JRootPane root = (JRootPane)parent;
        WebRootPaneUI rootUI = (WebRootPaneUI)root.getUI();
        WebButtonGroup windowButtons = rootUI.getWindowButtons();
        JComponent titleComponent = rootUI.getTitleComponent();
        JMenuBar menuBar = root.getJMenuBar();
        WebResizeCorner resizeCorner = rootUI.getResizeCorner();
        boolean showWindowButtons = windowButtons != null && rootUI.isShowWindowButtons() && (rootUI.isShowMinimizeButton() || rootUI.isShowMaximizeButton() || rootUI.isShowCloseButton());
        boolean showTitleComponent = titleComponent != null && rootUI.isShowTitleComponent();
        boolean showMenuBar = menuBar != null && rootUI.isShowMenuBar();
        boolean showResizeCorner = resizeCorner != null && rootUI.isShowResizeCorner() && !rootUI.isFrameMaximized();
        Dimension titleDim = showTitleComponent ? titleComponent.getPreferredSize() : new Dimension(0, 0);
        Dimension buttonsDim = showWindowButtons ? windowButtons.getPreferredSize() : new Dimension(0, 0);
        Dimension menuDim = showMenuBar ? menuBar.getPreferredSize() : new Dimension(0, 0);
        if (preferred) {
            if (showWindowButtons) {
                buttonsShear = this.getButtonsShear(rootUI);
                if (showTitleComponent) {
                    if (showMenuBar) {
                        tpWidth = Math.max(titleDim.width + buttonsDim.width + buttonsShear, menuDim.width);
                        tpHeight = Math.max(titleDim.height, buttonsDim.height) + menuDim.height;
                    } else {
                        tpWidth = titleDim.width + buttonsDim.width + buttonsShear;
                        tpHeight = Math.max(titleDim.height, buttonsDim.height);
                    }
                } else if (showMenuBar) {
                    tpWidth = menuDim.width + buttonsDim.width + buttonsShear;
                    tpHeight = Math.max(menuDim.height, buttonsDim.height);
                } else {
                    tpWidth = buttonsShear + buttonsDim.width + buttonsShear;
                    tpHeight = 0;
                }
            } else if (showTitleComponent && showMenuBar) {
                tpWidth = Math.max(titleDim.width, menuDim.width);
                tpHeight = titleDim.height + menuDim.height;
            } else if (showTitleComponent) {
                tpWidth = titleDim.width;
                tpHeight = titleDim.height;
            } else if (showMenuBar) {
                tpWidth = menuDim.width;
                tpHeight = menuDim.height;
            } else {
                tpWidth = 0;
                tpHeight = 0;
            }
        } else if (showWindowButtons) {
            buttonsShear = this.getButtonsShear(rootUI);
            if (showTitleComponent) {
                tpWidth = titleDim.width + buttonsDim.width + buttonsShear;
                tpHeight = Math.max(titleDim.height, buttonsDim.height);
            } else {
                tpWidth = buttonsShear + buttonsDim.width + buttonsShear;
                tpHeight = buttonsDim.height;
            }
        } else if (showTitleComponent) {
            tpWidth = titleDim.width;
            tpHeight = titleDim.height;
        } else {
            tpWidth = 0;
            tpHeight = 0;
        }
        int cpWidth = 0;
        int cpHeight = 0;
        Dimension cpd = preferred ? (root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize()) : new Dimension(0, 0);
        if (cpd != null) {
            cpWidth = cpd.width;
            cpHeight = cpd.height;
        }
        if (showResizeCorner) {
            parent.setComponentZOrder(resizeCorner, 0);
            Dimension rcd = ((JComponent)resizeCorner).getPreferredSize();
            if (rcd != null) {
                cpWidth = Math.max(cpWidth, rcd.width);
                cpHeight = Math.max(cpHeight, rcd.height);
            }
        }
        int width = i.left + MathUtils.max(tpWidth, cpWidth += ci.left + ci.right) + i.right;
        int height = i.top + tpHeight + (cpHeight += ci.top + ci.bottom) + i.bottom;
        NinePatchIcon shadeIcon = rootUI.getShadeIcon(root);
        Dimension d = new Dimension(width, height);
        return shadeIcon != null ? SwingUtils.max(d, shadeIcon.getPreferredSize()) : d;
    }

    private int getButtonsShear(WebRootPaneUI webRootPaneUI) {
        int round = webRootPaneUI.getRound();
        return webRootPaneUI.isAttachButtons() && round > 0 ? round - WebButtonStyle.shadeWidth : 0;
    }
}

