/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.optionpane;

import com.alee.global.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.optionpane.WebOptionPaneStyle;
import com.alee.managers.language.LM;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class WebOptionPaneUI
extends BasicOptionPaneUI {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/question.png"));

    public static ComponentUI createUI(JComponent c) {
        return new WebOptionPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(this.optionPane);
        LookAndFeel.installProperty(this.optionPane, "opaque", Boolean.FALSE);
        this.optionPane.setBackground(WebOptionPaneStyle.backgroundColor);
        this.optionPane.setBorder(LafUtils.createWebBorder(15, 15, 15, 15));
    }

    @Override
    protected Container createMessageArea() {
        Container messageArea = super.createMessageArea();
        SwingUtils.setOpaqueRecursively(messageArea, false);
        return messageArea;
    }

    @Override
    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = this.getSizeButtonsToSameWidth();
            boolean createdAll = true;
            int numButtons = buttons.length;
            JButton[] createdButtons = null;
            int maxWidth = 0;
            if (sizeButtonsToSame) {
                createdButtons = new JButton[numButtons];
            }
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    WebButton aButton;
                    if (button instanceof Icon) {
                        aButton = new WebButton((Icon)button);
                    } else {
                        String text = button.toString();
                        aButton = new WebButton(text);
                        if (LM.contains(text)) {
                            aButton.setLanguage(text, new Object[0]);
                        }
                    }
                    aButton.setName("OptionPane.button");
                    aButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                }
                if (sizeButtonsToSame && createdAll && newComponent instanceof JButton) {
                    createdButtons[counter] = (JButton)newComponent;
                    maxWidth = Math.max(maxWidth, newComponent.getMinimumSize().width);
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        JButton defaultButton;
                        JRootPane root;
                        if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }
                });
            }
            ((BasicOptionPaneUI.ButtonAreaLayout)container.getLayout()).setSyncAllWidths(sizeButtonsToSame && createdAll);
        }
    }

    @Override
    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Object[] defaultOptions;
                int type = this.optionPane.getOptionType();
                if (type == 0) {
                    defaultOptions = new WebButton[2];
                    defaultOptions[0] = new WebButton("");
                    defaultOptions[0].setShineColor(StyleConstants.greenHighlight);
                    defaultOptions[0].setLanguage("weblaf.optionpane.yes", new Object[0]);
                    defaultOptions[1] = new WebButton("");
                    defaultOptions[1].setShineColor(StyleConstants.redHighlight);
                    defaultOptions[1].setLanguage("weblaf.optionpane.no", new Object[0]);
                } else if (type == 1) {
                    defaultOptions = new WebButton[3];
                    defaultOptions[0] = new WebButton("");
                    defaultOptions[0].setShineColor(StyleConstants.greenHighlight);
                    defaultOptions[0].setLanguage("weblaf.optionpane.yes", new Object[0]);
                    defaultOptions[1] = new WebButton("");
                    defaultOptions[1].setShineColor(StyleConstants.redHighlight);
                    defaultOptions[1].setLanguage("weblaf.optionpane.no", new Object[0]);
                    defaultOptions[2] = new WebButton("");
                    ((WebButton)defaultOptions[2]).setShineColor(StyleConstants.yellowHighlight);
                    ((WebButton)defaultOptions[2]).setLanguage("weblaf.optionpane.cancel", new Object[0]);
                } else if (type == 2) {
                    defaultOptions = new WebButton[2];
                    defaultOptions[0] = new WebButton("");
                    defaultOptions[0].setShineColor(StyleConstants.greenHighlight);
                    defaultOptions[0].setLanguage("weblaf.optionpane.ok", new Object[0]);
                    defaultOptions[1] = new WebButton("");
                    defaultOptions[1].setShineColor(StyleConstants.redHighlight);
                    ((WebButton)defaultOptions[1]).setLanguage("weblaf.optionpane.cancel", new Object[0]);
                } else {
                    defaultOptions = new WebButton[]{new WebButton("")};
                    defaultOptions[0].setShineColor(StyleConstants.greenHighlight);
                    defaultOptions[0].setLanguage("weblaf.optionpane.ok", new Object[0]);
                }
                int count = 0;
                for (Object button : defaultOptions) {
                    this.configureButton((WebButton)button);
                    ((AbstractButton)button).addActionListener(this.createButtonActionListener(count));
                    ++count;
                }
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private void configureButton(WebButton button) {
        button.setLeftRightSpacing(10);
        button.setMinimumSize(new Dimension(70, 0));
        button.setRolloverShine(WebOptionPaneStyle.highlightControlButtons);
        Font buttonFont = UIManager.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        return WebOptionPaneUI.getTypeIcon(messageType);
    }

    public static ImageIcon getTypeIcon(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        switch (messageType) {
            case 0: {
                return ERROR_ICON;
            }
            case 1: {
                return INFORMATION_ICON;
            }
            case 2: {
                return WARNING_ICON;
            }
            case 3: {
                return QUESTION_ICON;
            }
        }
        return null;
    }
}

