/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.tab;

import com.alee.extended.tab.DocumentData;
import com.alee.extended.tab.DocumentDataListener;
import com.alee.extended.tab.DocumentDragHandler;
import com.alee.extended.tab.PaneDataAdapter;
import com.alee.extended.tab.SplitData;
import com.alee.extended.tab.StructureData;
import com.alee.extended.tab.WebDocumentPane;
import com.alee.laf.menu.WebPopupMenu;
import com.alee.laf.splitpane.WebSplitPane;
import com.alee.laf.tabbedpane.TabbedPaneStyle;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.hotkey.HotkeyRunnable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Customizer;
import com.alee.utils.swing.menu.PopupMenuGenerator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PaneData<T extends DocumentData>
implements StructureData<T>,
SwingConstants {
    protected WebDocumentPane<T> documentPane;
    protected final WebTabbedPane tabbedPane;
    protected final DefaultFocusTracker focusTracker;
    protected List<T> data = new ArrayList<T>();

    public PaneData(WebDocumentPane<T> documentPane) {
        this.documentPane = documentPane;
        this.tabbedPane = new WebTabbedPane(TabbedPaneStyle.attached);
        this.tabbedPane.putClientProperty("document.pane.data", this);
        this.updateTabbedPaneCustomizer(documentPane);
        HotkeyManager.registerHotkey((Component)this.tabbedPane, this.tabbedPane, Hotkey.CTRL_W, new HotkeyRunnable(){

            @Override
            public void run(KeyEvent e) {
                PaneData.this.closeSelected();
            }
        });
        DocumentDragHandler.install(this);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PaneData.this.checkSelection();
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtils.isMiddleMouseButton(e)) {
                    Object document;
                    int index;
                    if (PaneData.this.getDocumentPane().isCloseable() && (index = PaneData.this.tabbedPane.getTabAt(e.getPoint())) != -1 && ((DocumentData)(document = PaneData.this.get(index))).isCloseable()) {
                        PaneData.this.close(document);
                    }
                } else if (SwingUtils.isPopupTrigger(e)) {
                    WebDocumentPane documentPane = PaneData.this.getDocumentPane();
                    if (!documentPane.isTabMenuEnabled()) {
                        return;
                    }
                    final int index = PaneData.this.tabbedPane.getTabAt(e.getPoint());
                    if (index == -1) {
                        return;
                    }
                    Object document = PaneData.this.get(index);
                    boolean csb = documentPane.isCloseable() && ((DocumentData)document).isCloseable();
                    boolean ocsb = documentPane.isCloseable() && PaneData.this.data.size() > 1;
                    boolean spb = PaneData.this.data.size() > 1 && documentPane.isSplitEnabled();
                    boolean spl = PaneData.this.tabbedPane.getParent() instanceof WebSplitPane;
                    boolean hor = spl && ((WebSplitPane)PaneData.this.tabbedPane.getParent()).getOrientation() == 1;
                    PopupMenuGenerator pmg = new PopupMenuGenerator("document-pane-menu");
                    pmg.setIconSettings(PaneData.class, "icons/menu/", ".png");
                    pmg.setLanguagePrefix("weblaf.ex.docpane");
                    pmg.addItem("close", "close", Hotkey.CTRL_W, csb, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.close(PaneData.this.get(index));
                        }
                    });
                    pmg.addItem((Object)"closeOthers", "closeOthers", ocsb, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.closeOthers(PaneData.this.get(index));
                        }
                    });
                    pmg.addSeparator();
                    pmg.addItem((Object)"left", "left", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 2);
                        }
                    });
                    pmg.addItem((Object)"right", "right", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 4);
                        }
                    });
                    pmg.addItem((Object)"top", "top", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 1);
                        }
                    });
                    pmg.addItem((Object)"bottom", "bottom", spb, new ActionListener((DocumentData)document){
                        final /* synthetic */ DocumentData val$document;
                        {
                            this.val$document = documentData;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.split(this.val$document, 3);
                        }
                    });
                    pmg.addSeparator();
                    pmg.addItem((Object)"rotate", "rotate", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.rotate();
                        }
                    });
                    pmg.addItem((Object)(hor ? "swapHor" : "swapVer"), "swap", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.swap();
                        }
                    });
                    pmg.addItem((Object)(hor ? "unsplitHor" : "unsplitVer"), "unsplit", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.merge();
                        }
                    });
                    pmg.addItem((Object)"unsplit", "unsplitall", spl, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PaneData.this.mergeAll();
                        }
                    });
                    WebPopupMenu menu = (WebPopupMenu)pmg.getMenu();
                    Dimension mps = menu.getPreferredSize();
                    Rectangle bounds = PaneData.this.tabbedPane.getBoundsAt(index);
                    menu.show(PaneData.this.tabbedPane, bounds.x + bounds.width / 2 - mps.width / 2, bounds.y + bounds.height - menu.getShadeWidth() + 5);
                }
            }
        });
        this.focusTracker = new DefaultFocusTracker(true){

            @Override
            public void focusChanged(boolean focused) {
                if (focused) {
                    PaneData.this.activate();
                }
                PaneData.this.checkSelection();
            }
        };
        FocusManager.addFocusTracker(this.tabbedPane, this.focusTracker);
    }

    public void checkSelection() {
        WebDocumentPane documentPane = this.getDocumentPane();
        if (documentPane != null) {
            documentPane.checkSelection();
        }
    }

    protected void updateTabbedPaneCustomizer(WebDocumentPane<T> documentPane) {
        Customizer<WebTabbedPane> customizer = documentPane.getTabbedPaneCustomizer();
        if (customizer != null) {
            customizer.customize(this.tabbedPane);
        }
    }

    @Override
    public Component getComponent() {
        return this.getTabbedPane();
    }

    @Override
    public PaneData<T> findClosestPane() {
        return this;
    }

    public WebDocumentPane getDocumentPane() {
        return this.documentPane;
    }

    public void setDocumentPane(WebDocumentPane<T> documentPane) {
        this.documentPane = documentPane;
        this.updateTabbedPaneCustomizer(documentPane);
        this.updateTabTitleComponents();
    }

    public WebTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public List<T> getData() {
        return this.data;
    }

    public List<String> getDocumentIds() {
        ArrayList<String> ids = new ArrayList<String>(this.data.size());
        for (DocumentData document : this.data) {
            ids.add(document.getId());
        }
        return ids;
    }

    public int count() {
        return this.data.size();
    }

    public boolean contains(T document) {
        return this.contains(((DocumentData)document).getId());
    }

    public boolean contains(String documentId) {
        for (DocumentData document : this.data) {
            if (!document.getId().equals(documentId)) continue;
            return true;
        }
        return false;
    }

    public void add(T document) {
        this.add(document, -1);
    }

    public void add(T document, int index) {
        int i = index != -1 ? index : this.tabbedPane.getTabCount();
        this.data.add(i, document);
        this.tabbedPane.insertTab("", ((DocumentData)document).getIcon(), (Component)((DocumentData)document).getComponent(), null, i);
        this.tabbedPane.setBackgroundAt(i, ((DocumentData)document).getBackground());
        this.tabbedPane.setTabComponentAt(i, this.createTabComponent(document));
        ((DocumentData)document).addListener(new PaneDataAdapter(this));
    }

    protected JComponent createTabComponent(T document) {
        return this.getDocumentPane().getTabTitleComponentProvider().createTabTitleComponent(this, document);
    }

    public void updateTabTitleComponents() {
        for (DocumentData document : this.getData()) {
            this.updateTabTitleComponent(document);
        }
    }

    public void updateTabTitleComponent(T document) {
        this.getTabbedPane().setTabComponentAt(this.indexOf(document), this.createTabComponent(document));
    }

    public void updateTabBackground(T document) {
        this.getTabbedPane().setBackgroundAt(this.indexOf(document), ((DocumentData)document).getBackground());
    }

    public void updateTabComponent(T document) {
        this.getTabbedPane().setComponentAt(this.indexOf(document), (Component)((DocumentData)document).getComponent());
    }

    public void open(T document) {
        this.add(document);
        this.getDocumentPane().fireDocumentOpened(document, this, this.indexOf(document));
    }

    public T get(int index) {
        return (T)((DocumentData)this.data.get(index));
    }

    public T get(String id) {
        for (DocumentData document : this.data) {
            if (!document.getId().equals(id)) continue;
            return (T)document;
        }
        return null;
    }

    public T getSelected() {
        int index = this.tabbedPane.getSelectedIndex();
        return (T)(index != -1 ? (DocumentData)this.data.get(index) : null);
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setSelected(String id) {
        this.setSelected(this.indexOf(id));
    }

    public void setSelected(T document) {
        this.setSelected(this.indexOf(document));
    }

    public void setSelected(int index) {
        if (0 <= index && index < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(index);
        } else if (this.tabbedPane.getTabCount() > 0) {
            this.tabbedPane.setSelectedIndex(0);
        }
    }

    public void selectPrevious() {
        int count = this.count();
        if (count > 1) {
            int selected = this.getSelectedIndex() - 1;
            this.setSelected(selected == -1 ? count - 1 : selected);
        }
    }

    public void selectNext() {
        int count = this.count();
        if (count > 1) {
            int selected = this.getSelectedIndex() + 1;
            this.setSelected(selected == count ? 0 : selected);
        }
    }

    public int indexOf(String id) {
        return this.indexOf(this.get(id));
    }

    public int indexOf(T document) {
        return this.data.indexOf(document);
    }

    public boolean remove(int index) {
        return this.remove(this.get(index));
    }

    public boolean remove(String id) {
        return this.remove(this.get(id));
    }

    public boolean remove(T document) {
        int index;
        if (document != null && (index = this.indexOf(document)) != -1) {
            ((DocumentData)document).removeListener(this.findDocumentListener(document));
            this.tabbedPane.remove(index);
            this.data.remove(document);
            return true;
        }
        return false;
    }

    protected DocumentDataListener<T> findDocumentListener(T document) {
        List<DocumentDataListener> listeners = ((DocumentData)document).getListeners();
        for (DocumentDataListener listener : listeners) {
            PaneData paneData;
            if (!(listener instanceof PaneDataAdapter) || (paneData = ((PaneDataAdapter)listener).getPaneData()) != this) continue;
            return listener;
        }
        return null;
    }

    public void closeAll() {
        for (DocumentData document : CollectionUtils.copy(this.data)) {
            this.close(document);
        }
    }

    public boolean close(int index) {
        return this.close(this.get(index));
    }

    public boolean close(String id) {
        return this.close(this.get(id));
    }

    public boolean close(T document) {
        if (document != null) {
            int index;
            WebDocumentPane documentPane = this.getDocumentPane();
            if (documentPane.fireDocumentClosing(document, this, index = this.indexOf(document))) {
                boolean removed = this.remove(document);
                this.mergeIfEmpty();
                documentPane.fireDocumentClosed(document, this, index);
                return removed;
            }
            return false;
        }
        return false;
    }

    public void closeOthers(T document) {
        for (DocumentData doc : CollectionUtils.copy(this.data)) {
            if (doc == document || !doc.isCloseable()) continue;
            this.close(doc);
        }
    }

    public void closeSelected() {
        T selected = this.getSelected();
        if (selected != null) {
            this.close(selected);
        }
    }

    public void activate() {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.activate(this);
        }
    }

    public boolean isActive() {
        return this.getDocumentPane().getActivePane() == this;
    }

    public void split(T document, int direction) {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.split(this, document, direction);
        }
    }

    public void mergeIfEmpty() {
        if (this.count() == 0) {
            this.merge();
        }
    }

    public void rotate() {
        Container parent = this.tabbedPane.getParent();
        if (parent instanceof WebSplitPane) {
            SplitData splitData = WebDocumentPane.getData((WebSplitPane)parent);
            splitData.changeOrientation();
        }
    }

    public void swap() {
        Container parent = this.tabbedPane.getParent();
        if (parent instanceof WebSplitPane) {
            SplitData splitData = WebDocumentPane.getData((WebSplitPane)parent);
            splitData.swapSides();
        }
    }

    public void merge() {
        WebDocumentPane documentPane = this.getDocumentPane();
        if (documentPane != null) {
            documentPane.merge(this);
        }
    }

    public void mergeAll() {
        WebDocumentPane pane = this.getDocumentPane();
        if (pane != null) {
            pane.merge(pane.getStructureRoot());
        }
    }
}

