/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxArea;
import com.alee.laf.panel.WebPanel;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;

public class WebSyntaxPanel
extends WebPanel {
    private final WebSyntaxArea syntaxArea;

    public WebSyntaxPanel(SyntaxPreset ... presets) {
        this("", presets);
    }

    public WebSyntaxPanel(String code, SyntaxPreset ... presets) {
        super("syntax-panel");
        this.syntaxArea = new WebSyntaxArea(code, new SyntaxPreset[0]);
        this.syntaxArea.applyPresets(SyntaxPreset.base, SyntaxPreset.viewable, SyntaxPreset.hideMenu, SyntaxPreset.ideaTheme, SyntaxPreset.transparent);
        this.syntaxArea.applyPresets(presets);
        this.syntaxArea.setText(code);
        this.syntaxArea.setHighlightCurrentLine(false);
        this.syntaxArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                WebSyntaxPanel.this.syntaxArea.setHighlightCurrentLine(WebSyntaxPanel.this.shouldHighlightCurrentLine());
            }

            @Override
            public void focusLost(FocusEvent e) {
                WebSyntaxPanel.this.syntaxArea.setHighlightCurrentLine(false);
                WebSyntaxPanel.this.syntaxArea.setCaretPosition(0);
            }
        });
        this.add((Component)((Object)this.syntaxArea));
    }

    public void setCode(String code) {
        this.syntaxArea.setText(code);
        this.syntaxArea.setHighlightCurrentLine(this.shouldHighlightCurrentLine());
    }

    protected boolean shouldHighlightCurrentLine() {
        return this.syntaxArea.getLineCount() > 1;
    }

    public void applyPresets(SyntaxPreset ... presets) {
        this.syntaxArea.applyPresets(presets);
    }

    public void applyPresets(List<SyntaxPreset> presets) {
        this.syntaxArea.applyPresets(presets);
    }

    public WebSyntaxArea getSyntaxArea() {
        return this.syntaxArea;
    }
}

