/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.extended.syntax.PresetType;
import com.alee.extended.syntax.SyntaxPreset;
import com.alee.extended.syntax.WebSyntaxScrollPane;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.utils.EventUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.DocumentChangeListener;
import com.alee.utils.swing.DocumentEventMethods;
import com.alee.utils.swing.DocumentEventRunnable;
import com.alee.utils.swing.EventMethods;
import com.alee.utils.swing.FocusEventRunnable;
import com.alee.utils.swing.KeyEventRunnable;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.MouseEventRunnable;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RUndoManager;

public class WebSyntaxArea
extends RSyntaxTextArea
implements DocumentEventMethods,
EventMethods {
    protected RUndoManager undoManager;
    protected SyntaxPreset themePreset;

    public WebSyntaxArea(SyntaxPreset ... presets) {
        this.applyPresets(presets);
        this.applyPresets(SyntaxPreset.ideaTheme);
        this.initialize();
    }

    public WebSyntaxArea(String text, SyntaxPreset ... presets) {
        super(text);
        this.applyPresets(presets);
        this.applyPresets(SyntaxPreset.ideaTheme);
        this.clearHistory();
        this.initialize();
    }

    public WebSyntaxArea(int rows, int cols, SyntaxPreset ... presets) {
        super(rows, cols);
        this.applyPresets(presets);
        this.applyPresets(SyntaxPreset.ideaTheme);
        this.initialize();
    }

    public WebSyntaxArea(String text, int rows, int cols, SyntaxPreset ... presets) {
        super(text, rows, cols);
        this.applyPresets(presets);
        this.applyPresets(SyntaxPreset.ideaTheme);
        this.clearHistory();
        this.initialize();
    }

    public WebSyntaxArea(int textMode, SyntaxPreset ... presets) {
        super(textMode);
        this.applyPresets(presets);
        this.applyPresets(SyntaxPreset.ideaTheme);
        this.initialize();
    }

    protected void initialize() {
        this.onKeyPress(Hotkey.CTRL_SHIFT_Z, new KeyEventRunnable(){

            @Override
            public void run(KeyEvent e) {
                WebSyntaxArea.this.redoLastAction();
            }
        });
    }

    protected RUndoManager createUndoManager() {
        this.undoManager = super.createUndoManager();
        return this.undoManager;
    }

    public RUndoManager getUndoManager() {
        return this.undoManager;
    }

    public void clearHistory() {
        this.undoManager.discardAllEdits();
    }

    public WebSyntaxScrollPane createScroll() {
        return this.createScroll(true, true);
    }

    public WebSyntaxScrollPane createScroll(boolean drawBorder) {
        return this.createScroll(drawBorder, true);
    }

    public WebSyntaxScrollPane createScroll(boolean drawBorder, boolean drawInnerBorder) {
        WebSyntaxScrollPane scrollPane = new WebSyntaxScrollPane((Component)((Object)this), drawBorder, drawInnerBorder);
        if (this.themePreset != null) {
            this.themePreset.apply(this);
        }
        return scrollPane;
    }

    public SyntaxPreset getThemePreset() {
        return this.themePreset;
    }

    public void applyPresets(SyntaxPreset ... presets) {
        for (SyntaxPreset preset : presets) {
            this.applyPresetImpl(preset);
        }
    }

    public void applyPresets(List<SyntaxPreset> presets) {
        for (SyntaxPreset preset : presets) {
            this.applyPresetImpl(preset);
        }
    }

    protected void applyPresetImpl(SyntaxPreset preset) {
        preset.apply(this);
        if (preset.getType() == PresetType.theme) {
            this.themePreset = preset;
        }
    }

    @Override
    public Pair<DocumentChangeListener, PropertyChangeListener> onChange(DocumentEventRunnable runnable) {
        return EventUtils.onChange((JTextComponent)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseEventRunnable runnable) {
        return EventUtils.onMousePress((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMousePress(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMousePress((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseEnter(MouseEventRunnable runnable) {
        return EventUtils.onMouseEnter((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMouseExit(MouseEventRunnable runnable) {
        return EventUtils.onMouseExit((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMouseDrag(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseDrag((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseEventRunnable runnable) {
        return EventUtils.onMouseClick((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMouseClick(MouseButton mouseButton, MouseEventRunnable runnable) {
        return EventUtils.onMouseClick((Component)((Object)this), mouseButton, runnable);
    }

    @Override
    public MouseAdapter onDoubleClick(MouseEventRunnable runnable) {
        return EventUtils.onDoubleClick((Component)((Object)this), runnable);
    }

    @Override
    public MouseAdapter onMenuTrigger(MouseEventRunnable runnable) {
        return EventUtils.onMenuTrigger((Component)((Object)this), runnable);
    }

    @Override
    public KeyAdapter onKeyType(KeyEventRunnable runnable) {
        return EventUtils.onKeyType((Component)((Object)this), runnable);
    }

    @Override
    public KeyAdapter onKeyType(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyType((Component)((Object)this), hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyPress(KeyEventRunnable runnable) {
        return EventUtils.onKeyPress((Component)((Object)this), runnable);
    }

    @Override
    public KeyAdapter onKeyPress(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyPress((Component)((Object)this), hotkey, runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease((Component)((Object)this), runnable);
    }

    @Override
    public KeyAdapter onKeyRelease(HotkeyData hotkey, KeyEventRunnable runnable) {
        return EventUtils.onKeyRelease((Component)((Object)this), hotkey, runnable);
    }

    @Override
    public FocusAdapter onFocusGain(FocusEventRunnable runnable) {
        return EventUtils.onFocusGain((Component)((Object)this), runnable);
    }

    @Override
    public FocusAdapter onFocusLoss(FocusEventRunnable runnable) {
        return EventUtils.onFocusLoss((Component)((Object)this), runnable);
    }
}

