/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.syntax;

import com.alee.managers.log.Log;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;

public enum SyntaxTheme {
    idea,
    dark,
    vs,
    eclipse;


    public Icon getIcon() {
        return new ImageIcon(SyntaxTheme.class.getResource("icons/" + (Object)((Object)this) + ".png"));
    }

    public String getName() {
        switch (this) {
            case idea: {
                return "IntelliJ IDEA";
            }
            case dark: {
                return "Dark";
            }
            case vs: {
                return "Visual Studio";
            }
            case eclipse: {
                return "Eclipse";
            }
        }
        return null;
    }

    public void apply(RSyntaxTextArea syntaxArea) {
        try {
            Theme.load((InputStream)SyntaxTheme.class.getResourceAsStream("themes/" + (Object)((Object)this) + ".xml")).apply(syntaxArea);
        }
        catch (IOException e) {
            Log.error((Object)this, (Throwable)e);
        }
    }
}

