/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.panel;

import com.alee.extended.layout.OverlayData;
import com.alee.extended.layout.OverlayLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.swing.DataProvider;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

public class WebOverlay
extends WebPanel
implements SwingConstants {
    private Component component;
    private Map<Component, OverlayData> overlayData;

    public WebOverlay() {
        super(new OverlayLayout());
        this.initialize();
    }

    public WebOverlay(Component component) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
    }

    public WebOverlay(Component component, Component overlay) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(overlay);
    }

    public WebOverlay(Component component, Component overlay, int halign, int valign) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(overlay, halign, valign);
    }

    public WebOverlay(Component component, Component overlay, DataProvider<Rectangle> rectangleProvider) {
        super(new OverlayLayout());
        this.initialize();
        this.setComponent(component);
        this.addOverlay(overlay, rectangleProvider);
    }

    private void initialize() {
        this.component = null;
        this.overlayData = new HashMap<Component, OverlayData>();
    }

    public Insets getComponentMargin() {
        return this.getActualLayout().getComponentMargin();
    }

    public void setComponentMargin(int margin) {
        this.getActualLayout().setComponentMargin(margin);
    }

    public void setComponentMargin(int top, int left, int bottom, int right) {
        this.getActualLayout().setComponentMargin(top, left, bottom, right);
    }

    public void setComponentMargin(Insets margin) {
        this.getActualLayout().setComponentMargin(margin);
    }

    public Insets getOverlayMargin() {
        return this.getActualLayout().getOverlayMargin();
    }

    public void setOverlayMargin(int margin) {
        this.getActualLayout().setOverlayMargin(margin);
    }

    public void setOverlayMargin(int top, int left, int bottom, int right) {
        this.getActualLayout().setOverlayMargin(top, left, bottom, right);
    }

    public void setOverlayMargin(Insets margin) {
        this.getActualLayout().setOverlayMargin(margin);
    }

    public OverlayLayout getActualLayout() {
        return (OverlayLayout)super.getLayout();
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            this.remove(this.component);
        }
        this.component = component;
        this.add(component, (Object)"COMPONENT");
    }

    public Component getComponent() {
        return this.component;
    }

    public void addOverlay(Component overlay) {
        this.overlayData.put(overlay, new OverlayData());
        this.add(overlay, "OVERLAY", 0);
    }

    public void addOverlay(Component overlay, int halign, int valign) {
        this.overlayData.put(overlay, new OverlayData(halign, valign));
        this.add(overlay, "OVERLAY", 0);
    }

    public void addOverlay(Component overlay, DataProvider<Rectangle> rectangleProvider) {
        this.overlayData.put(overlay, new OverlayData(rectangleProvider));
        this.add(overlay, "OVERLAY", 0);
    }

    public void removeOverlay(Component overlay) {
        this.overlayData.remove(overlay);
        this.remove(overlay);
    }

    public OverlayData getOverlayData(Component overlay) {
        return this.overlayData.get(overlay);
    }
}

