/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.label;

import com.alee.laf.label.WebLabelStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class WebMultiLineLabelUI
extends BasicLabelUI
implements ComponentListener {
    public static final String PROPERTY_KEY = "WrappedText";
    protected static Rectangle paintIconR = new Rectangle();
    protected static Rectangle paintTextR = new Rectangle();
    protected static Rectangle paintViewR = new Rectangle();
    protected static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    private static int defaultSize = 4;
    private FontMetrics metrics;
    private boolean drawShade = WebLabelStyle.drawShade;
    private Color shadeColor = WebLabelStyle.shadeColor;

    public static ComponentUI createUI(JComponent c) {
        return new WebMultiLineLabelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SwingUtils.setOrientation(c);
    }

    @Override
    protected void uninstallDefaults(JLabel c) {
        super.uninstallDefaults(c);
        this.clearCache(c);
    }

    @Override
    protected void installListeners(JLabel c) {
        super.installListeners(c);
        c.addComponentListener(this);
    }

    @Override
    protected void uninstallListeners(JLabel c) {
        super.uninstallListeners(c);
        c.removeComponentListener(this);
    }

    public boolean isDrawShade() {
        return this.drawShade;
    }

    public void setDrawShade(boolean drawShade) {
        this.drawShade = drawShade;
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
    }

    protected void clearCache(JLabel l) {
        l.putClientProperty(PROPERTY_KEY, null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String name = e.getPropertyName();
        if (name.equals("text") || "font".equals(name)) {
            this.clearCache((JLabel)e.getSource());
        }
    }

    protected void updateLayout(JLabel l, FontMetrics fm, int width, int height) {
        if (fm == null) {
            fm = l.getFontMetrics(l.getFont());
        }
        this.metrics = fm;
        String text = l.getText();
        Icon icon = l.getIcon();
        Insets insets = l.getInsets(paintViewInsets);
        WebMultiLineLabelUI.paintViewR.x = insets.left;
        WebMultiLineLabelUI.paintViewR.y = insets.top;
        WebMultiLineLabelUI.paintViewR.width = width - (insets.left + insets.right);
        WebMultiLineLabelUI.paintViewR.height = height - (insets.top + insets.bottom);
        WebMultiLineLabelUI.paintIconR.height = 0;
        WebMultiLineLabelUI.paintIconR.width = 0;
        WebMultiLineLabelUI.paintIconR.y = 0;
        WebMultiLineLabelUI.paintIconR.x = 0;
        WebMultiLineLabelUI.paintTextR.height = 0;
        WebMultiLineLabelUI.paintTextR.width = 0;
        WebMultiLineLabelUI.paintTextR.y = 0;
        WebMultiLineLabelUI.paintTextR.x = 0;
        this.layoutCL(l, fm, text, icon, paintViewR, paintIconR, paintTextR);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        Map hints = SwingUtils.setupTextAntialias(g);
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        this.updateLayout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g, WebMultiLineLabelUI.paintIconR.x, WebMultiLineLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                this.paintTextLines(g, label, fm);
            }
        }
        SwingUtils.restoreTextAntialias(g, hints);
    }

    protected void paintTextLines(Graphics g, JLabel label, FontMetrics fm) {
        int textHeight;
        List<String> lines = this.getTextLines(label);
        int height = this.getAvailableHeight(label);
        for (textHeight = lines.size() * fm.getHeight(); textHeight > height; textHeight -= fm.getHeight()) {
        }
        WebMultiLineLabelUI.paintTextR.height = Math.min(textHeight, height);
        WebMultiLineLabelUI.paintTextR.y = this.alignmentY(label, fm, paintTextR);
        int textX = WebMultiLineLabelUI.paintTextR.x;
        int textY = WebMultiLineLabelUI.paintTextR.y;
        Iterator<String> it = lines.iterator();
        while (it.hasNext() && paintTextR.contains(textX, textY + WebMultiLineLabelUI.getAscent(fm))) {
            String text = it.next().trim();
            if (it.hasNext() && !paintTextR.contains(textX, textY + fm.getHeight() + WebMultiLineLabelUI.getAscent(fm))) {
                text = this.clip(text);
            }
            int x = this.alignmentX(label, fm, text);
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, text, x, textY);
            } else {
                this.paintDisabledText(label, g, text, x, textY);
            }
            textY += fm.getHeight();
        }
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (this.drawShade) {
            g.setColor(l.getForeground());
            this.paintShadowText(g, s, textX, textY);
        } else {
            int mnemIndex = l.getDisplayedMnemonicIndex();
            g.setColor(l.getForeground());
            SwingUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        }
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        if (this.drawShade) {
            g.setColor(l.getBackground().darker());
            this.paintShadowText(g, s, textX, textY);
        } else {
            int mnemIndex = l.getDisplayedMnemonicIndex();
            g.setColor(l.getForeground());
            SwingUtils.drawStringUnderlineCharAt(g, s, mnemIndex, textX, textY);
        }
    }

    private void paintShadowText(Graphics g, String s, int textX, int textY) {
        g.translate(textX, textY);
        LafUtils.paintTextShadow((Graphics2D)g, s, this.shadeColor);
        g.translate(-textX, -textY);
    }

    protected int getAvailableHeight(JLabel l) {
        l.getInsets(paintViewInsets);
        return l.getHeight() - WebMultiLineLabelUI.paintViewInsets.top - WebMultiLineLabelUI.paintViewInsets.bottom;
    }

    protected String clip(String text) {
        if (text.length() < 3) {
            return "...";
        }
        return text.substring(0, text.length() - 3) + "...";
    }

    protected int alignmentY(JLabel label, FontMetrics fm, Rectangle bounds) {
        int height = this.getAvailableHeight(label);
        int textHeight = bounds.height;
        int align = label.getVerticalAlignment();
        switch (align) {
            case 1: {
                return WebMultiLineLabelUI.getAscent(fm) + WebMultiLineLabelUI.paintViewInsets.top;
            }
            case 3: {
                return WebMultiLineLabelUI.getAscent(fm) + height - WebMultiLineLabelUI.paintViewInsets.top + WebMultiLineLabelUI.paintViewInsets.bottom - textHeight;
            }
        }
        int textY = WebMultiLineLabelUI.paintViewInsets.top + (height - textHeight) / 2 + WebMultiLineLabelUI.getAscent(fm);
        return Math.max(textY, WebMultiLineLabelUI.getAscent(fm) + WebMultiLineLabelUI.paintViewInsets.top);
    }

    private static int getAscent(FontMetrics fm) {
        return fm.getAscent() + fm.getLeading();
    }

    protected int alignmentX(JLabel label, FontMetrics fm, String s) {
        boolean ltr = label.getComponentOrientation().isLeftToRight();
        int align = label.getHorizontalAlignment();
        if (align == 4 || align == 11 && ltr || align == 10 && !ltr) {
            return WebMultiLineLabelUI.paintTextR.x + (WebMultiLineLabelUI.paintTextR.width - fm.stringWidth(s));
        }
        if (align == 0) {
            return WebMultiLineLabelUI.paintTextR.x + (WebMultiLineLabelUI.paintTextR.width / 2 - fm.stringWidth(s) / 2);
        }
        return WebMultiLineLabelUI.paintTextR.x;
    }

    private static boolean isHTMLString(String s) {
        if (s != null && s.length() >= 6 && s.charAt(0) == '<' && s.charAt(5) == '>') {
            String tag = s.substring(1, 5);
            return tag.equalsIgnoreCase("html");
        }
        return false;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        JLabel label = (JLabel)c;
        if (WebMultiLineLabelUI.isHTMLString(label.getText())) {
            return d;
        }
        if (c.getParent() != null) {
            Insets insets = c.getParent().getInsets();
            Dimension size = c.getParent().getSize();
            if (size.width > 0) {
                d.width = size.width - insets.left - insets.right;
            }
        }
        this.updateLayout(label, null, d.width, d.height);
        d.height = Math.max(d.height, this.getPreferredHeight(label));
        return d;
    }

    protected int getPreferredHeight(JLabel label) {
        int numOfLines = this.getTextLines(label).size();
        Insets insets = label.getInsets(paintViewInsets);
        return numOfLines * this.metrics.getHeight() + insets.top + insets.bottom;
    }

    protected List<String> getTextLines(JLabel l) {
        List<String> lines = (List<String>)l.getClientProperty(PROPERTY_KEY);
        if (lines == null) {
            lines = this.prepareLines(l);
            l.putClientProperty(PROPERTY_KEY, lines);
        }
        return lines;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.clearCache((JLabel)e.getSource());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected List<String> prepareLines(JLabel l) {
        ArrayList<String> lines = new ArrayList<String>(defaultSize);
        String text = l.getText();
        if (text == null) {
            return null;
        }
        PlainDocument doc = new PlainDocument();
        try {
            doc.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            return null;
        }
        Element root = doc.getDefaultRootElement();
        int j = root.getElementCount();
        for (int i = 0; i < j; ++i) {
            this.wrap(lines, root.getElement(i));
        }
        return lines;
    }

    protected void wrap(List<String> lines, Element elem) {
        int p1 = elem.getEndOffset();
        Document doc = elem.getDocument();
        int p0 = elem.getStartOffset();
        while (p0 < p1) {
            int p = this.calculateBreakPosition(doc, p0, p1);
            try {
                lines.add(doc.getText(p0, p - p0));
            }
            catch (BadLocationException e) {
                throw new Error("Can't get line text. p0=" + p0 + " p=" + p);
            }
            p0 = p == p0 ? p1 : p;
        }
    }

    protected int calculateBreakPosition(Document doc, int p0, int p1) {
        Segment segment = SegmentCache.getSegment();
        try {
            doc.getText(p0, p1 - p0, segment);
        }
        catch (BadLocationException e) {
            throw new Error("Can't get line text");
        }
        int width = WebMultiLineLabelUI.paintTextR.width;
        int p = p0 + Utilities.getBreakLocation(segment, this.metrics, 0, width, null, p0);
        SegmentCache.releaseSegment(segment);
        return p;
    }

    protected static final class SegmentCache {
        private ArrayList<Segment> segments = new ArrayList(2);
        private static SegmentCache cache = new SegmentCache();

        private SegmentCache() {
        }

        public static Segment getSegment() {
            int size = SegmentCache.cache.segments.size();
            if (size > 0) {
                return SegmentCache.cache.segments.remove(size - 1);
            }
            return new Segment();
        }

        public static void releaseSegment(Segment segment) {
            segment.array = null;
            segment.count = 0;
            SegmentCache.cache.segments.add(segment);
        }
    }
}

