/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.WebBreadcrumbButton;
import com.alee.extended.breadcrumb.WebBreadcrumbLabel;
import com.alee.extended.breadcrumb.WebFileBreadcrumbStyle;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListElement;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.file.FileComparator;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.AncestorEvent;

public class WebFileBreadcrumb
extends WebBreadcrumb {
    public static ImageIcon typeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/type.png"));
    public static ImageIcon dateIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/date.png"));
    public static ImageIcon sizeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/size.png"));
    private boolean displayFileIcon = WebFileBreadcrumbStyle.displayFileIcon;
    private boolean displayFileName = WebFileBreadcrumbStyle.displayFileName;
    private boolean displayFileTip = WebFileBreadcrumbStyle.displayFileTip;
    private int fileNameLength = WebFileBreadcrumbStyle.fileNameLength;
    private int listFileNameLength = WebFileBreadcrumbStyle.listFileNameLength;
    private boolean showFullNameInTip = WebFileBreadcrumbStyle.showFullNameInTip;
    private int maxVisibleListFiles = WebFileBreadcrumbStyle.maxVisibleListFiles;
    private boolean autoExpandLastElement = WebFileBreadcrumbStyle.autoExpandLastElement;
    private File root;
    private File currentFile;

    public WebFileBreadcrumb() {
        this(FileUtils.getSystemRoot());
    }

    public WebFileBreadcrumb(String root) {
        this(new File(root));
    }

    public WebFileBreadcrumb(File root) {
        this.initialize();
        this.setRoot(root);
    }

    public WebFileBreadcrumb(boolean decorated) {
        super(decorated);
        this.initialize();
        this.setRoot(FileUtils.getSystemRoot());
    }

    public WebFileBreadcrumb(String root, boolean decorated) {
        this(new File(root), decorated);
    }

    public WebFileBreadcrumb(File root, boolean decorated) {
        super(decorated);
        this.initialize();
        this.setRoot(root);
    }

    private void initialize() {
        this.setEncloseLastElement(WebFileBreadcrumbStyle.encloseLastElement);
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.setRoot(new File(root));
    }

    public void setRoot(File root) {
        this.root = root.getAbsoluteFile();
        this.setCurrentFile(root);
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String currentFile) {
        this.setCurrentFile(new File(currentFile));
    }

    public void setCurrentFile(File currentFile) {
        if (!FileUtils.equals(this.root, currentFile = currentFile.getAbsoluteFile()) && !FileUtils.isParent(this.root, currentFile)) {
            this.root = FileUtils.getTopParent(currentFile);
        }
        this.currentFile = currentFile;
        this.updatePath();
    }

    public boolean isDisplayFileIcon() {
        return this.displayFileIcon;
    }

    public void setDisplayFileIcon(boolean displayFileIcon) {
        this.displayFileIcon = displayFileIcon;
        this.updatePath();
    }

    public boolean isDisplayFileName() {
        return this.displayFileName;
    }

    public void setDisplayFileName(boolean displayFileName) {
        this.displayFileName = displayFileName;
        this.updatePath();
    }

    public boolean isDisplayFileTip() {
        return this.displayFileTip;
    }

    public void setDisplayFileTip(boolean displayFileTip) {
        this.displayFileTip = displayFileTip;
        this.updatePath();
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
        this.updatePath();
    }

    public int getListFileNameLength() {
        return this.listFileNameLength;
    }

    public void setListFileNameLength(int listFileNameLength) {
        this.listFileNameLength = listFileNameLength;
    }

    public boolean isShowFullNameInTip() {
        return this.showFullNameInTip;
    }

    public void setShowFullNameInTip(boolean showFullNameInTip) {
        this.showFullNameInTip = showFullNameInTip;
        this.updatePath();
    }

    public int getMaxVisibleListFiles() {
        return this.maxVisibleListFiles;
    }

    public void setMaxVisibleListFiles(int maxVisibleListFiles) {
        this.maxVisibleListFiles = maxVisibleListFiles;
    }

    public boolean isAutoExpandLastElement() {
        return this.autoExpandLastElement;
    }

    public void setAutoExpandLastElement(boolean autoExpandLastElement) {
        this.autoExpandLastElement = autoExpandLastElement;
    }

    private void updatePath() {
        this.setAutoUpdate(false);
        this.removeAll();
        File current = this.currentFile;
        while (!FileUtils.equals(current, this.root)) {
            this.addFile(current);
            current = current.getParentFile();
        }
        this.addFile(this.root);
        this.setAutoUpdate(true);
    }

    private void addFile(final File file) {
        if (file.isDirectory()) {
            boolean showFullName = this.showFullNameInTip;
            final WebBreadcrumbButton fileButton = new WebBreadcrumbButton();
            if (this.displayFileIcon) {
                fileButton.setIcon(FileUtils.getFileIcon(file));
            }
            if (this.displayFileName) {
                String fileName = FileUtils.getDisplayFileName(file);
                String shortName = FileUtils.getShortFileName(fileName, this.fileNameLength);
                showFullName = showFullName && shortName.length() != fileName.length();
                fileButton.setText(shortName);
            }
            if (this.displayFileTip) {
                this.installTip(file, fileButton, showFullName);
            }
            fileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File[] files = file.listFiles();
                    if (files != null && files.length > 0) {
                        Arrays.sort(files, new FileComparator());
                        WebFileBreadcrumb.this.showFilesPopup(files, fileButton);
                    } else {
                        TooltipManager.showOneTimeTooltip((Component)fileButton, null, "There are no files inside");
                    }
                }
            });
            this.add((Component)fileButton, 0);
        } else {
            boolean showFullName = this.showFullNameInTip;
            WebBreadcrumbLabel fileButton = new WebBreadcrumbLabel();
            if (this.displayFileIcon) {
                fileButton.setIcon(FileUtils.getFileIcon(file));
            }
            if (this.displayFileName) {
                String fileName = FileUtils.getDisplayFileName(file);
                String shortName = FileUtils.getShortFileName(fileName, this.fileNameLength);
                showFullName = showFullName && shortName.length() != fileName.length();
                fileButton.setText(shortName);
            }
            if (this.displayFileTip) {
                this.installTip(file, fileButton, showFullName);
            }
            this.add((Component)fileButton, 0);
        }
    }

    private void showFilesPopup(File[] files, final WebBreadcrumbButton fileButton) {
        WebWindow window = new WebWindow(SwingUtils.getWindowAncestor(fileButton));
        window.setCloseOnFocusLoss(true);
        window.setAlwaysOnTop(true);
        final WebList list = new WebList(files);
        list.setRolloverSelectionEnabled(true);
        list.setSelectedIndex(0);
        list.setVisibleRowCount(Math.min(this.maxVisibleListFiles, files.length));
        list.setCellRenderer(new WebListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                WebListElement element = (WebListElement)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                File child = (File)value;
                element.setIcon(FileUtils.getFileIcon(child));
                String fileName = FileUtils.getDisplayFileName(child);
                element.setText(FileUtils.getShortFileName(fileName, WebFileBreadcrumb.this.listFileNameLength));
                return element;
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (list.getSelectedIndex() != -1) {
                    WebFileBreadcrumb.this.setCurrentFile((File)list.getSelectedValue());
                    Component lc = WebFileBreadcrumb.this.getLastComponent();
                    lc.requestFocus();
                    lc.requestFocusInWindow();
                    if (WebFileBreadcrumb.this.autoExpandLastElement && lc instanceof AbstractButton) {
                        ((AbstractButton)lc).doClick();
                    }
                }
            }
        };
        list.addMouseListener(mouseAdapter);
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Hotkey.ESCAPE.isTriggered(e)) {
                    fileButton.requestFocusInWindow();
                }
            }
        });
        WebScrollPane listScroll = new WebScrollPane(list);
        listScroll.setShadeWidth(0);
        listScroll.setDrawFocus(false);
        window.add(listScroll);
        window.applyComponentOrientation(this.getComponentOrientation());
        window.pack();
        Point los = fileButton.getLocationOnScreen();
        Insets bi = list.getWebListCellRenderer().getBorder().getBorderInsets(list);
        if (this.getComponentOrientation().isLeftToRight()) {
            window.setLocation(los.x + fileButton.getInsets().left - listScroll.getInsets().left - bi.left, los.y + fileButton.getHeight() + 2);
        } else {
            window.setLocation(los.x + fileButton.getWidth() - fileButton.getInsets().right - listScroll.getWidth() + listScroll.getInsets().right + bi.right, los.y + fileButton.getHeight() + 2);
        }
        window.setVisible(true);
        list.requestFocusInWindow();
    }

    private void installTip(File file, final JComponent component, boolean showFullName) {
        WebPanel panel = new WebPanel(new VerticalFlowLayout(4, 4));
        panel.setOpaque(false);
        if (showFullName) {
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileName(file), FileUtils.getFileIcon(file)));
            panel.add((Component)new WebSeparator(false, 0, true));
        }
        panel.add((Component)new WebLabel(FileUtils.getFileTypeDescription(file), typeIcon));
        if (FileUtils.isFile(file)) {
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileModificationDate(file), dateIcon));
            panel.add((Component)new WebLabel(FileUtils.getDisplayFileSize(file), sizeIcon));
        }
        TooltipManager.setTooltip((Component)component, panel);
        component.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                TooltipManager.removeTooltips(component);
            }
        });
    }
}

