/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.state;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.api.ClassFileSource;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.bytecode.analysis.types.ClassNameUtils;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.state.ClassCache;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.bytestream.BaseByteData;
import org.benf.cfr.reader.util.collections.ListFactory;
import org.benf.cfr.reader.util.collections.MapFactory;
import org.benf.cfr.reader.util.functors.UnaryFunction;
import org.benf.cfr.reader.util.getopt.Options;

public class DCCommonState {
    private final ClassCache classCache = new ClassCache(this);
    private final ClassFileSource classFileSource;
    private final Options options;
    private transient LinkedHashSet<String> couldNotLoadClasses = new LinkedHashSet();
    private Map<String, ClassFile> classFileCache = MapFactory.newExceptionRetainingLazyMap(new UnaryFunction<String, ClassFile>(){

        @Override
        public ClassFile invoke(String arg) {
            return DCCommonState.this.loadClassFileAtPath(arg);
        }
    });

    public DCCommonState(Options options, ClassFileSource classFileSource) {
        this.options = options;
        this.classFileSource = classFileSource;
    }

    public void configureWith(ClassFile classFile) {
        this.classFileSource.informAnalysisRelativePathDetail(classFile.getUsePath(), classFile.getFilePath());
    }

    String getPossiblyRenamedFileFromClassFileSource(String name) {
        return this.classFileSource.getPossiblyRenamedPath(name);
    }

    public Set<String> getCouldNotLoadClasses() {
        return this.couldNotLoadClasses;
    }

    private ClassFile loadClassFileAtPath(String path) {
        try {
            Pair<byte[], String> content = this.classFileSource.getClassFileContent(path);
            BaseByteData data = new BaseByteData(content.getFirst());
            ClassFile res = new ClassFile(data, content.getSecond(), this);
            return res;
        }
        catch (Exception e) {
            this.couldNotLoadClasses.add(path);
            throw new CannotLoadClassException(path, e);
        }
    }

    public List<JavaTypeInstance> explicitlyLoadJar(String path) {
        List<JavaTypeInstance> output = ListFactory.newList();
        Collection<String> classPaths = this.classFileSource.addJar(path);
        for (String classPath : classPaths) {
            if (!classPath.toLowerCase().endsWith(".class")) continue;
            output.add(this.classCache.getRefClassFor(classPath.substring(0, classPath.length() - 6)));
        }
        return output;
    }

    public ClassFile getClassFile(String path) throws CannotLoadClassException {
        return this.classFileCache.get(path);
    }

    public JavaRefTypeInstance getClassTypeOrNull(String path) {
        try {
            ClassFile classFile = this.getClassFile(path);
            return (JavaRefTypeInstance)classFile.getClassType();
        }
        catch (CannotLoadClassException e) {
            return null;
        }
    }

    public ClassFile getClassFile(JavaTypeInstance classInfo) throws CannotLoadClassException {
        String path = classInfo.getRawName();
        path = ClassNameUtils.convertToPath(path) + ".class";
        return this.getClassFile(path);
    }

    public ClassFile getClassFileMaybePath(String pathOrName) throws CannotLoadClassException {
        if (pathOrName.endsWith(".class")) {
            return this.getClassFile(pathOrName);
        }
        File f = new File(pathOrName);
        if (f.exists()) {
            return this.getClassFile(pathOrName);
        }
        return this.getClassFile(ClassNameUtils.convertToPath(pathOrName) + ".class");
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public Options getOptions() {
        return this.options;
    }

    public AnalysisType detectClsJar(String path) {
        String lcPath = path.toLowerCase();
        if (lcPath.endsWith(".jar") || lcPath.endsWith(".war")) {
            return AnalysisType.JAR;
        }
        return AnalysisType.CLASS;
    }
}

