/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import sun.tools.attach.HotSpotAttachProvider;
import sun.tools.attach.WindowsVirtualMachine;

public class WindowsAttachProvider
extends HotSpotAttachProvider {
    private static final long FS_PERSISTENT_ACLS = 8L;
    private static volatile boolean wasTempPathChecked;
    private static boolean isTempPathSecure;

    public WindowsAttachProvider() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows 9") || string.equals("Windows Me")) {
            throw new RuntimeException("This provider is not supported on this version of Windows");
        }
        String string2 = System.getProperty("os.arch");
        if (!string2.equals("x86") && !string2.equals("amd64")) {
            throw new RuntimeException("This provider is not supported on this processor architecture");
        }
    }

    @Override
    public String name() {
        return "sun";
    }

    @Override
    public String type() {
        return "windows";
    }

    @Override
    public VirtualMachine attachVirtualMachine(String string) throws AttachNotSupportedException, IOException {
        this.checkAttachPermission();
        this.testAttachable(string);
        return new WindowsVirtualMachine(this, string);
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        if (WindowsAttachProvider.isTempPathSecure()) {
            return super.listVirtualMachines();
        }
        return this.listJavaProcesses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTempPathSecure() {
        if (wasTempPathChecked) return isTempPathSecure;
        Class<WindowsAttachProvider> clazz = WindowsAttachProvider.class;
        synchronized (WindowsAttachProvider.class) {
            if (wasTempPathChecked) return isTempPathSecure;
            String string = WindowsAttachProvider.tempPath();
            if (string != null && string.length() >= 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                long l = WindowsAttachProvider.volumeFlags(string.substring(0, 3));
                isTempPathSecure = (l & 8L) != 0L;
            }
            wasTempPathChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isTempPathSecure;
        }
    }

    private static native String tempPath();

    private static native long volumeFlags(String var0);

    private List<VirtualMachineDescriptor> listJavaProcesses() {
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int[] nArray = new int[1024];
        int n = WindowsAttachProvider.enumProcesses(nArray, nArray.length);
        for (int i = 0; i < n; ++i) {
            if (!WindowsAttachProvider.isLibraryLoadedByProcess("jvm.dll", nArray[i])) continue;
            String string2 = Integer.toString(nArray[i]);
            try {
                new WindowsVirtualMachine(this, string2).detach();
                String string3 = string2 + "@" + string;
                arrayList.add(new HotSpotAttachProvider.HotSpotVirtualMachineDescriptor(this, string2, string3));
                continue;
            }
            catch (AttachNotSupportedException attachNotSupportedException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private static native int enumProcesses(int[] var0, int var1);

    private static native boolean isLibraryLoadedByProcess(String var0, int var1);

    static {
        System.loadLibrary("attach");
    }
}

