/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.io;

import com.strobel.core.OS;
import java.io.PrintStream;

public class Ansi {
    public static final boolean SUPPORTED = Boolean.getBoolean("Ansi") || OS.get().isUnix() && System.console() != null;
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m";
    private static final String XTERM_256_SEPARATOR = "5;";
    private static final String SEPARATOR = ";";
    private static final String END = "\u001b[m";
    private String start = "";

    public Ansi(Attribute attr, Color foreground, Color background) {
        this.init(attr, AnsiColor.forStandardColor(foreground), AnsiColor.forStandardColor(background));
    }

    public Ansi(Attribute attr, AnsiColor foreground, AnsiColor background) {
        this.init(attr, foreground, background);
    }

    public Ansi(String format) {
        String[] tokens = format.split(SEPARATOR);
        Attribute attribute = null;
        try {
            if (tokens.length > 0 && tokens[0].length() > 0) {
                attribute = Attribute.valueOf(tokens[0]);
            }
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        Color foreground = null;
        try {
            if (tokens.length > 1 && tokens[1].length() > 0) {
                foreground = Color.valueOf(tokens[1]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        Color background = null;
        try {
            if (tokens.length > 2 && tokens[2].length() > 0) {
                background = Color.valueOf(tokens[2]);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.init(attribute, AnsiColor.forStandardColor(foreground), AnsiColor.forStandardColor(background));
    }

    private void init(Attribute attr, AnsiColor foreground, AnsiColor background) {
        StringBuilder buff = new StringBuilder();
        if (attr != null) {
            buff.append((Object)attr);
        }
        if (foreground != null) {
            if (buff.length() > 0) {
                buff.append(SEPARATOR);
            }
            if (foreground.isStandardColor()) {
                buff.append(30 + foreground._standardColor.ordinal());
            } else {
                buff.append(38).append(SEPARATOR).append(XTERM_256_SEPARATOR).append(foreground._colorIndex);
            }
        }
        if (background != null) {
            if (buff.length() > 0) {
                buff.append(SEPARATOR);
            }
            if (background.isStandardColor()) {
                buff.append(40 + background._standardColor.ordinal());
            } else {
                buff.append(48).append(SEPARATOR).append(XTERM_256_SEPARATOR).append(background._colorIndex);
            }
        }
        buff.insert(0, PREFIX);
        buff.append(SUFFIX);
        this.start = buff.toString();
    }

    public String toString() {
        Enum attr = null;
        Enum foreground = null;
        Color background = null;
        String[] stringArray = this.start.substring(PREFIX.length(), this.start.length() - SUFFIX.length()).split(SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            int i = Integer.parseInt(token);
            if (i < 30) {
                Attribute[] attributeArray = Attribute.values();
                int n3 = attributeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Attribute value = attributeArray[n4];
                    if (value.toString().equals(token)) {
                        attr = value;
                        break;
                    }
                    ++n4;
                }
            } else if (i < 40) {
                foreground = Color.values()[i - 30];
            } else {
                background = Color.values()[i - 40];
            }
            ++n2;
        }
        StringBuilder buff = new StringBuilder();
        if (attr != null) {
            buff.append(attr.name());
        }
        buff.append(';');
        if (foreground != null) {
            buff.append(foreground.name());
        }
        buff.append(';');
        if (background != null) {
            buff.append(background.name());
        }
        int end = buff.length() - 1;
        while (end >= 0 && buff.charAt(end) == ';') {
            --end;
        }
        return buff.substring(0, end + 1);
    }

    public String colorize(String message) {
        if (SUPPORTED) {
            StringBuilder buff = new StringBuilder(this.start.length() + message.length() + END.length());
            buff.append(this.start).append(message).append(END);
            return buff.toString();
        }
        return message;
    }

    public void print(PrintStream ps, String message) {
        if (SUPPORTED) {
            ps.print(this.start);
        }
        ps.print(message);
        if (SUPPORTED) {
            ps.print(END);
        }
    }

    public void println(PrintStream ps, String message) {
        this.print(ps, message);
        ps.println();
    }

    public void format(PrintStream ps, String format, Object ... args) {
        if (SUPPORTED) {
            ps.print(this.start);
        }
        ps.format(format, args);
        if (SUPPORTED) {
            ps.print(END);
        }
    }

    public void out(String message) {
        this.print(System.out, message);
    }

    public void outLine(String message) {
        this.println(System.out, message);
    }

    public void outFormat(String format, Object ... args) {
        this.format(System.out, format, args);
    }

    public void err(String message) {
        this.print(System.err, message);
    }

    public void errLine(String message) {
        this.print(System.err, message);
    }

    public void errFormat(String format, Object ... args) {
        this.format(System.err, format, args);
    }

    public static final class AnsiColor {
        public static final AnsiColor BLACK = new AnsiColor(Color.BLACK);
        public static final AnsiColor RED = new AnsiColor(Color.RED);
        public static final AnsiColor GREEN = new AnsiColor(Color.GREEN);
        public static final AnsiColor YELLOW = new AnsiColor(Color.YELLOW);
        public static final AnsiColor BLUE = new AnsiColor(Color.BLUE);
        public static final AnsiColor MAGENTA = new AnsiColor(Color.MAGENTA);
        public static final AnsiColor CYAN = new AnsiColor(Color.CYAN);
        public static final AnsiColor WHITE = new AnsiColor(Color.WHITE);
        private final int _colorIndex;
        private final Color _standardColor;

        public AnsiColor(int colorIndex) {
            this._colorIndex = colorIndex;
            this._standardColor = null;
        }

        public AnsiColor(Color standardColor) {
            this._colorIndex = -1;
            this._standardColor = standardColor;
        }

        public final int getColorIndex() {
            return this._colorIndex;
        }

        public final boolean isStandardColor() {
            return this._standardColor != null;
        }

        public final Color getStandardColor() {
            return this._standardColor;
        }

        public static AnsiColor forStandardColor(Color color) {
            if (color == null) {
                return null;
            }
            switch (color) {
                case BLACK: {
                    return BLACK;
                }
                case RED: {
                    return RED;
                }
                case GREEN: {
                    return GREEN;
                }
                case YELLOW: {
                    return YELLOW;
                }
                case BLUE: {
                    return BLUE;
                }
                case MAGENTA: {
                    return MAGENTA;
                }
                case CYAN: {
                    return CYAN;
                }
                case WHITE: {
                    return WHITE;
                }
            }
            return new AnsiColor(color);
        }
    }

    public static enum Attribute {
        NORMAL(0),
        BRIGHT(1),
        DIM(2),
        UNDERLINE(4),
        BLINK(5),
        REVERSE(7),
        HIDDEN(8);

        private final String value;

        private Attribute(int value) {
            this.value = String.valueOf(value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Color {
        BLACK,
        RED,
        GREEN,
        YELLOW,
        BLUE,
        MAGENTA,
        CYAN,
        WHITE;

    }
}

