/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.utilities;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.ConversionType;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodBinder;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayInitializerExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.utilities.TypeUtilities;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RedundantCastUtility {
    @NotNull
    public static List<CastExpression> getRedundantCastsInside(Function<AstNode, ResolveResult> resolver, AstNode site) {
        VerifyArgument.notNull(resolver, "resolver");
        if (site == null) {
            return Collections.emptyList();
        }
        CastCollector visitor = new CastCollector(resolver);
        site.acceptVisitor(visitor, null);
        return new ArrayList<CastExpression>(visitor.getFoundCasts());
    }

    public static boolean isCastRedundant(Function<AstNode, ResolveResult> resolver, CastExpression cast) {
        AstNode parent = RedundantCastUtility.skipParenthesesUp(cast.getParent());
        if (parent == null) {
            return false;
        }
        if (parent.getRole() == Roles.ARGUMENT || parent.isReference()) {
            parent = parent.getParent();
        }
        IsRedundantVisitor visitor = new IsRedundantVisitor(resolver, false);
        parent.acceptVisitor(visitor, null);
        return visitor.isRedundant();
    }

    public static void removeCast(CastExpression castExpression) {
        if (castExpression == null || castExpression.isNull()) {
            return;
        }
        Expression operand = castExpression.getExpression();
        if (operand instanceof ParenthesizedExpression) {
            operand = ((ParenthesizedExpression)operand).getExpression();
        }
        if (operand.isNull()) {
            return;
        }
        AstNode toBeReplaced = castExpression;
        AstNode parent = castExpression.getParent();
        while (parent instanceof ParenthesizedExpression) {
            toBeReplaced = parent;
            parent = parent.getParent();
        }
        toBeReplaced.replaceWith(operand);
    }

    @Nullable
    private static Expression removeParentheses(Expression e) {
        Expression result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    @Nullable
    private static AstNode skipParenthesesUp(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = result.getParent();
        }
        return result;
    }

    private static class CastCollector
    extends IsRedundantVisitor {
        private final Set<CastExpression> _foundCasts = new HashSet<CastExpression>();

        CastCollector(Function<AstNode, ResolveResult> resolver) {
            super(resolver, true);
        }

        private Set<CastExpression> getFoundCasts() {
            return this._foundCasts;
        }

        @Override
        public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            return null;
        }

        @Override
        public Void visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
            return null;
        }

        @Override
        public Void visitLocalTypeDeclarationStatement(LocalTypeDeclarationStatement node, Void data) {
            return null;
        }

        @Override
        public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
            return null;
        }

        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
            return null;
        }

        @Override
        protected void addToResults(@NotNull CastExpression cast, boolean force) {
            if (force || !this.isTypeCastSemantic(cast)) {
                this._foundCasts.add(cast);
            }
        }
    }

    private static class IsRedundantVisitor
    extends DepthFirstAstVisitor<Void, Void> {
        private final boolean _isRecursive;
        private final Function<AstNode, ResolveResult> _resolver;
        private boolean _isRedundant;

        IsRedundantVisitor(Function<AstNode, ResolveResult> resolver, boolean recursive) {
            this._isRecursive = recursive;
            this._resolver = resolver;
        }

        public final boolean isRedundant() {
            return this._isRedundant;
        }

        @Override
        protected Void visitChildren(AstNode node, Void data) {
            if (this._isRecursive) {
                return (Void)super.visitChildren(node, data);
            }
            return null;
        }

        @Override
        public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
            this.processPossibleTypeCast(node.getRight(), this.getType(node.getLeft()));
            return (Void)super.visitAssignmentExpression(node, data);
        }

        @Override
        public Void visitVariableDeclaration(VariableDeclarationStatement node, Void data) {
            TypeReference leftType = this.getType(node.getType());
            if (leftType != null) {
                for (VariableInitializer initializer : node.getVariables()) {
                    this.processPossibleTypeCast(initializer.getInitializer(), leftType);
                }
            }
            return (Void)super.visitVariableDeclaration(node, data);
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            TypeReference leftType = this.getType(node.getReturnType());
            if (leftType != null) {
                for (VariableInitializer initializer : node.getVariables()) {
                    this.processPossibleTypeCast(initializer.getInitializer(), leftType);
                }
            }
            return (Void)super.visitFieldDeclaration(node, data);
        }

        @Override
        public Void visitReturnStatement(ReturnStatement node, Void data) {
            MethodDeclaration methodDeclaration = CollectionUtilities.firstOrDefault(node.getAncestors(MethodDeclaration.class));
            if (methodDeclaration != null && !methodDeclaration.isNull()) {
                TypeReference returnType = this.getType(methodDeclaration.getReturnType());
                Expression returnValue = node.getExpression();
                if (returnType != null && !returnValue.isNull()) {
                    this.processPossibleTypeCast(returnValue, returnType);
                }
            }
            return (Void)super.visitReturnStatement(node, data);
        }

        @Override
        public Void visitBinaryOperatorExpression(BinaryOperatorExpression node, Void data) {
            BinaryOperatorType operator = node.getOperator();
            TypeDefinition resultType = operator.isRelational() ? BuiltinTypes.Boolean : this.getType(node);
            this.processBinaryExpressionOperand(node.getRight(), node.getLeft(), operator, resultType);
            this.processBinaryExpressionOperand(node.getLeft(), node.getRight(), operator, resultType);
            return (Void)super.visitBinaryOperatorExpression(node, data);
        }

        @Override
        public Void visitInvocationExpression(InvocationExpression node, Void data) {
            super.visitInvocationExpression(node, data);
            this.processCall(node);
            return null;
        }

        @Override
        public Void visitObjectCreationExpression(ObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            this.processCall(node);
            return null;
        }

        @Override
        public Void visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void data) {
            for (Expression argument : node.getArguments()) {
                argument.acceptVisitor(this, data);
            }
            this.processCall(node);
            node.getTypeDeclaration().acceptVisitor(this, data);
            return null;
        }

        @Override
        public Void visitArrayInitializerExpression(ArrayInitializerExpression node, Void data) {
            this.processArrayInitializer(node);
            return (Void)super.visitArrayInitializerExpression(node, data);
        }

        private void processArrayInitializer(ArrayInitializerExpression node) {
            TypeReference expectedArrayType = TypeUtilities.getExpectedTypeByParent(this._resolver, node);
            if (expectedArrayType == null || !expectedArrayType.isArray()) {
                return;
            }
            TypeReference target = expectedArrayType.getElementType();
            for (Expression element : node.getElements()) {
                ConversionType sourceToMiddle;
                if (!(element instanceof CastExpression)) continue;
                Expression value = ((CastExpression)element).getExpression();
                TypeReference middle = this.getType(element);
                TypeReference source = this.getType(value);
                if (middle == null || source == null || !this.getConversion(target, middle, null).isImplicit() || !this.getConversion(target, source, value).isImplicit() || !this.getConversion(source, middle, null).isImplicit() || !(sourceToMiddle = this.getConversion(middle, source, value)).isImplicit() || !sourceToMiddle.isLossless()) continue;
                this.addToResults((CastExpression)element, false);
            }
        }

        @Override
        public Void visitCastExpression(CastExpression node, Void data) {
            Expression operand = node.getExpression();
            if (operand.isNull()) {
                return null;
            }
            TypeReference topCastType = this.getType(node);
            if (topCastType == null) {
                return null;
            }
            Expression e = RedundantCastUtility.removeParentheses(operand);
            if (e instanceof CastExpression) {
                boolean nullReferencePossible;
                CastExpression innerCast = (CastExpression)e;
                TypeReference innerCastType = this.getType(innerCast.getType());
                if (innerCastType == null) {
                    return null;
                }
                Expression innerOperand = innerCast.getExpression();
                TypeReference innerOperandType = this.getType(innerOperand);
                TypeReference expectedType = TypeUtilities.getExpectedTypeByParent(this._resolver, node);
                boolean bl = nullReferencePossible = expectedType != null && !expectedType.isPrimitive() && !innerOperandType.isPrimitive() && innerCastType.isPrimitive();
                if (!innerCastType.isPrimitive()) {
                    if (innerOperandType != null && MetadataHelper.getConversionType(topCastType, innerOperandType).isDirect()) {
                        this.addToResults(innerCast, false);
                    }
                } else if (!nullReferencePossible) {
                    ConversionType valueToInner = this.getNumericConversion(innerCastType, innerOperandType, innerOperand);
                    ConversionType outerToInner = this.getNumericConversion(innerCastType, topCastType, innerOperand);
                    if (outerToInner == ConversionType.IDENTITY) {
                        if (valueToInner == ConversionType.IDENTITY) {
                            this.addToResults(node, false);
                            this.addToResults(innerCast, true);
                        } else {
                            this.addToResults(innerCast, true);
                        }
                    } else if (valueToInner == ConversionType.IDENTITY) {
                        this.addToResults(innerCast, true);
                    } else {
                        ConversionType valueToOuter = this.getNumericConversion(topCastType, innerOperandType, innerOperand);
                        if (outerToInner == ConversionType.IMPLICIT && valueToOuter.isDirect()) {
                            this.addToResults(innerCast, true);
                        } else if (valueToInner == ConversionType.IMPLICIT && valueToOuter.isImplicit()) {
                            this.addToResults(innerCast, true);
                        }
                    }
                }
            } else {
                AstNode parent = node.getParent();
                if (parent instanceof ConditionalExpression) {
                    TypeReference conditionalType;
                    TypeReference operandType = this.getType(operand);
                    if (!MetadataHelper.isSameType(operandType, conditionalType = this.getType(parent), true)) {
                        if (!this.checkResolveAfterRemoveCast(parent)) {
                            return null;
                        }
                        Expression thenExpression = ((ConditionalExpression)parent).getTrueExpression();
                        Expression elseExpression = ((ConditionalExpression)parent).getFalseExpression();
                        Expression opposite = thenExpression == node ? elseExpression : thenExpression;
                        TypeReference oppositeType = this.getType(opposite);
                        if (oppositeType == null || !MetadataHelper.isSameType(conditionalType, oppositeType, true)) {
                            return null;
                        }
                    } else if (topCastType.isPrimitive() && !operandType.isPrimitive()) {
                        return null;
                    }
                } else {
                    if (parent instanceof SynchronizedStatement && this.getType(e) instanceof PrimitiveType) {
                        return null;
                    }
                    if (e instanceof LambdaExpression || e instanceof MethodGroupExpression) {
                        TypeReference functionalInterfaceType;
                        if (parent instanceof ParenthesizedExpression && parent.getParent() != null && parent.getParent().isReference()) {
                            return null;
                        }
                        TypeReference lambdaType = this.getType(e);
                        if (lambdaType != null) {
                            TypeReference asSubType = MetadataHelper.asSubType(lambdaType, topCastType);
                            functionalInterfaceType = asSubType != null ? asSubType : lambdaType;
                        } else {
                            DynamicCallSite callSite = e.getUserData(Keys.DYNAMIC_CALL_SITE);
                            if (callSite == null) {
                                return null;
                            }
                            functionalInterfaceType = callSite.getMethodType().getReturnType();
                        }
                        if (!MetadataHelper.isAssignableFrom(topCastType, functionalInterfaceType, false)) {
                            return null;
                        }
                    }
                }
                this.processAlreadyHasTypeCast(node);
            }
            return (Void)super.visitCastExpression(node, data);
        }

        protected TypeReference getType(AstNode node) {
            ResolveResult result = this._resolver.apply(node);
            return result != null ? result.getType() : null;
        }

        @NotNull
        protected List<TypeReference> getTypes(AstNodeCollection<? extends AstNode> nodes) {
            if (nodes == null || nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<TypeReference> types = new ArrayList<TypeReference>();
            for (AstNode astNode : nodes) {
                TypeReference nodeType = this.getType(astNode);
                if (nodeType == null) {
                    return Collections.emptyList();
                }
                types.add(nodeType);
            }
            return types;
        }

        protected void processPossibleTypeCast(Expression rightExpression, @Nullable TypeReference leftType) {
            if (leftType == null) {
                return;
            }
            Expression r = RedundantCastUtility.removeParentheses(rightExpression);
            if (!(r instanceof CastExpression)) {
                return;
            }
            AstType castAstType = ((CastExpression)r).getType();
            TypeReference castType = castAstType.toTypeReference();
            Expression castOperand = ((CastExpression)r).getExpression();
            if (castOperand.isNull() || castType == null) {
                return;
            }
            TypeReference operandType = this.getType(castOperand);
            if (operandType == null) {
                return;
            }
            if (MetadataHelper.isAssignableFrom(leftType, operandType, false)) {
                this.addToResults((CastExpression)r, false);
                return;
            }
            ResolveResult rr = this._resolver.apply(castOperand);
            if (rr.isCompileTimeConstant()) {
                TypeReference unboxedCastType = IsRedundantVisitor.unbox(castType);
                TypeReference unboxedLeftType = IsRedundantVisitor.unbox(leftType);
                if (TypeUtilities.isValidPrimitiveLiteralAssignment(unboxedLeftType, rr.getConstantValue()) && TypeUtilities.isValidPrimitiveLiteralAssignment(unboxedCastType, rr.getConstantValue())) {
                    this.addToResults((CastExpression)r, true);
                }
            }
        }

        protected void addToResults(@NotNull CastExpression cast, boolean force) {
            if (force || !this.isTypeCastSemantic(cast)) {
                this._isRedundant = true;
            }
        }

        protected void processBinaryExpressionOperand(Expression operand, Expression other, BinaryOperatorType op, TypeReference resultType) {
            if (operand instanceof CastExpression) {
                boolean isApplicable;
                CastExpression cast = (CastExpression)operand;
                Expression toCast = cast.getExpression();
                TypeReference castType = this.getType(cast);
                TypeReference innerType = this.getType(toCast);
                TypeReference otherType = this.getType(other);
                if (castType != null && innerType != null && (isApplicable = TypeUtilities.isBinaryOperatorApplicable(op, innerType, otherType, op.isRelational() ? null : resultType, false))) {
                    this.addToResults(cast, false);
                }
            }
        }

        protected void processCall(@NotNull Expression e) {
            int realParametersEnd;
            TypeReference targetType;
            AstNodeCollection<Expression> arguments = e.getChildrenByRole(Roles.ARGUMENT);
            if (arguments.isEmpty()) {
                return;
            }
            MemberReference reference = e.getUserData(Keys.MEMBER_REFERENCE);
            if (reference == null && e.getParent() instanceof MemberReferenceExpression) {
                reference = e.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (!(reference instanceof MethodReference)) {
                return;
            }
            MethodReference method = (MethodReference)reference;
            Expression target = e.getChildByRole(Roles.TARGET_EXPRESSION);
            if (target instanceof MemberReferenceExpression) {
                target = target.getChildByRole(Roles.TARGET_EXPRESSION);
            }
            if ((targetType = this.getType(target)) == null) {
                targetType = method.getDeclaringType();
            } else if (!(targetType instanceof RawType) && MetadataHelper.isRawType(targetType)) {
                targetType = MetadataHelper.eraseRecursive(targetType);
            } else {
                TypeReference asSuper = MetadataHelper.asSuper(method.getDeclaringType(), targetType);
                TypeReference asSubType = asSuper != null ? MetadataHelper.asSubType(method.getDeclaringType(), asSuper) : null;
                targetType = asSubType != null ? asSubType : targetType;
            }
            List<MethodReference> candidates = MetadataHelper.findMethods(targetType, MetadataFilters.matchName(method.getName()));
            MethodDefinition resolvedMethod = method.resolve();
            ArrayList<TypeReference> originalTypes = new ArrayList<TypeReference>();
            List<ParameterDefinition> parameters = method.getParameters();
            Expression lastArgument = arguments.lastOrNullObject();
            ArrayList<TypeReference> newTypes = null;
            int syntheticLeadingCount = 0;
            int syntheticTrailingCount = 0;
            for (ParameterDefinition parameter : parameters) {
                if (!parameter.isSynthetic()) break;
                ++syntheticLeadingCount;
                originalTypes.add(parameter.getParameterType());
            }
            int i = parameters.size() - 1;
            while (i >= 0 && parameters.get(i).isSynthetic()) {
                --i;
                ++syntheticTrailingCount;
            }
            for (Expression argument : arguments) {
                TypeReference argumentType = this.getType(argument);
                if (argumentType == null) {
                    return;
                }
                originalTypes.add(argumentType);
            }
            int i2 = realParametersEnd = parameters.size() - syntheticTrailingCount;
            while (i2 < parameters.size()) {
                originalTypes.add(parameters.get(i2).getParameterType());
                ++i2;
            }
            i2 = syntheticLeadingCount;
            Expression a = arguments.firstOrNullObject();
            while (i2 < realParametersEnd && a != null && !a.isNull()) {
                block20: {
                    ParameterDefinition newParameter;
                    TypeReference castType;
                    CastExpression cast;
                    block21: {
                        boolean castNeeded;
                        boolean sameMethod;
                        ParameterDefinition p;
                        TypeReference parameterType;
                        Expression arg = RedundantCastUtility.removeParentheses(a);
                        if (!(arg instanceof CastExpression) || a == lastArgument && i2 == parameters.size() - 1 && resolvedMethod != null && resolvedMethod.isVarArgs()) break block20;
                        cast = (CastExpression)arg;
                        Expression castOperand = cast.getExpression();
                        castType = this.getType(cast);
                        TypeReference operandType = this.getType(castOperand);
                        if (castType == null || operandType == null || castType.isPrimitive() && !operandType.isPrimitive() && !(parameterType = (p = parameters.get(i2)).getParameterType()).isPrimitive()) break block20;
                        if (newTypes == null) {
                            newTypes = new ArrayList<TypeReference>(originalTypes);
                        } else {
                            newTypes.clear();
                            newTypes.addAll(originalTypes);
                        }
                        newTypes.set(i2, operandType);
                        MethodBinder.BindResult result = MethodBinder.selectMethod(candidates, newTypes);
                        if (result.isFailure() || result.isAmbiguous() || !(sameMethod = StringUtilities.equals(method.getErasedSignature(), result.getMethod().getErasedSignature()))) break block20;
                        newParameter = result.getMethod().getParameters().get(i2);
                        if (!castType.isPrimitive()) break block21;
                        boolean bl = castNeeded = !MetadataHelper.isSameType(castType, IsRedundantVisitor.unbox(newParameter.getParameterType()));
                        if (castNeeded) break block20;
                    }
                    if (MetadataHelper.isAssignableFrom(newParameter.getParameterType(), castType)) {
                        this.addToResults(cast, false);
                    }
                }
                a = a.getNextSibling(Roles.ARGUMENT);
                ++i2;
            }
        }

        protected void processAlreadyHasTypeCast(CastExpression cast) {
            AstNode parent = cast.getParent();
            while (parent instanceof ParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent == null || cast.getRole() == Roles.ARGUMENT && !(parent instanceof IndexerExpression) || parent instanceof AssignmentExpression || parent instanceof ReturnStatement || parent instanceof CastExpression || parent instanceof BinaryOperatorExpression) {
                return;
            }
            if (this.isTypeCastSemantic(cast)) {
                return;
            }
            TypeReference castTo = this.getType(cast.getType());
            Expression operand = cast.getExpression();
            TypeReference operandType = this.getType(operand);
            if (castTo == null || operandType == null) {
                return;
            }
            TypeReference expectedType = TypeUtilities.getExpectedTypeByParent(this._resolver, cast);
            boolean isCharConversion = operandType == BuiltinTypes.Character ^ castTo == BuiltinTypes.Character;
            if (expectedType != null) {
                if (isCharConversion && !expectedType.isPrimitive()) {
                    return;
                }
                operandType = expectedType;
            } else if (isCharConversion) {
                return;
            }
            if (operandType == BuiltinTypes.Null && castTo.isPrimitive()) {
                return;
            }
            if (parent.isReference()) {
                if (operandType.isPrimitive() && !castTo.isPrimitive()) {
                    return;
                }
                TypeReference referenceType = this.getType(parent);
                if (!operandType.isPrimitive() && referenceType != null && !this.isCastRedundantInReferenceExpression(referenceType, operand)) {
                    return;
                }
            }
            if (this.arrayAccessAtTheLeftSideOfAssignment(parent)) {
                if (MetadataHelper.isAssignableFrom(operandType, castTo, false) && MetadataHelper.getArrayRank(operandType) == MetadataHelper.getArrayRank(castTo)) {
                    this.addToResults(cast, false);
                }
            } else if (MetadataHelper.isAssignableFrom(castTo, operandType, false)) {
                this.addToResults(cast, false);
            }
        }

        protected boolean arrayAccessAtTheLeftSideOfAssignment(AstNode node) {
            AssignmentExpression assignment = CollectionUtilities.firstOrDefault(node.getAncestors(AssignmentExpression.class));
            if (assignment == null) {
                return false;
            }
            Expression left = assignment.getLeft();
            return left.isAncestorOf(node) && left instanceof IndexerExpression;
        }

        protected boolean isCastRedundantInReferenceExpression(TypeReference type, Expression operand) {
            return false;
        }

        protected boolean checkResolveAfterRemoveCast(AstNode parent) {
            List<MethodReference> candidates;
            MethodBinder.BindResult result;
            AstNode grandParent = parent.getParent();
            if (grandParent == null || parent.getRole() != Roles.ARGUMENT) {
                return true;
            }
            TypeReference targetType = grandParent instanceof InvocationExpression ? this.getType(((InvocationExpression)grandParent).getTarget()) : this.getType(grandParent);
            if (targetType == null) {
                return false;
            }
            Expression expression = (Expression)grandParent.clone();
            AstNodeCollection<Expression> arguments = expression.getChildrenByRole(Roles.ARGUMENT);
            List<TypeReference> argumentTypes = this.getTypes(arguments);
            if (argumentTypes.isEmpty()) {
                return arguments.isEmpty();
            }
            MemberReference memberReference = grandParent.getUserData(Keys.MEMBER_REFERENCE);
            if (!(memberReference instanceof MethodReference) && grandParent.getParent() != null) {
                memberReference = grandParent.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (!(memberReference instanceof MethodReference)) {
                return false;
            }
            MethodReference method = (MethodReference)memberReference;
            MethodDefinition resolvedMethod = method.resolve();
            if (resolvedMethod == null) {
                return false;
            }
            int argumentIndex = CollectionUtilities.indexOf(grandParent.getChildrenByRole(Roles.ARGUMENT), (Expression)parent);
            Expression toReplace = CollectionUtilities.get(arguments, argumentIndex);
            if (toReplace instanceof ConditionalExpression) {
                TypeReference newArgumentType;
                Expression falseOperand;
                TypeReference operandType;
                Expression trueExpression = ((ConditionalExpression)toReplace).getTrueExpression();
                Expression falseExpression = ((ConditionalExpression)toReplace).getFalseExpression();
                if (trueExpression instanceof CastExpression) {
                    Expression trueOperand = ((CastExpression)trueExpression).getExpression();
                    TypeReference operandType2 = this.getType(trueOperand);
                    if (operandType2 != null) {
                        trueExpression.replaceWith(trueOperand);
                    }
                } else if (falseExpression instanceof CastExpression && (operandType = this.getType(falseOperand = ((CastExpression)falseExpression).getExpression())) != null) {
                    falseExpression.replaceWith(falseOperand);
                }
                if ((newArgumentType = this.getType(toReplace)) == null) {
                    return false;
                }
                argumentTypes.set(argumentIndex, newArgumentType);
            }
            return (result = MethodBinder.selectMethod(candidates = MetadataHelper.findMethods(targetType, MetadataFilters.matchName(resolvedMethod.getName())), argumentTypes)) != null && !result.isFailure() && !result.isAmbiguous() && StringUtilities.equals(resolvedMethod.getErasedSignature(), result.getMethod().getErasedSignature());
        }

        public boolean isTypeCastSemantic(CastExpression cast) {
            TypeReference expectedType;
            Expression operand = cast.getExpression();
            if (operand.isNull()) {
                return false;
            }
            if (this.isInPolymorphicCall(cast)) {
                return true;
            }
            TypeReference opType = this.getType(operand);
            TypeReference castType = this.getType(cast.getType());
            if (opType == null || castType == null) {
                return false;
            }
            AstNode parent = RedundantCastUtility.skipParenthesesUp(cast.getParent());
            TypeReference binaryTypeAfterRemoval = null;
            if (parent instanceof BinaryOperatorExpression) {
                BinaryOperatorExpression b = (BinaryOperatorExpression)parent;
                BinaryOperatorType operator = b.getOperator();
                Expression firstOperand = b.getLeft();
                Expression otherOperand = b.getRight();
                if (!firstOperand.isNull() && !otherOperand.isNull()) {
                    if (otherOperand.isAncestorOf(cast, b)) {
                        Expression temp = otherOperand;
                        otherOperand = firstOperand;
                        firstOperand = temp;
                    }
                    if (this.castChangesBinarySemantics(firstOperand, otherOperand, operand, operator)) {
                        return true;
                    }
                    TypeReference tFirst = this.getType(firstOperand);
                    TypeReference tOther = this.getType(otherOperand);
                    if (tFirst != null && tFirst.isPrimitive() || tOther != null && tOther.isPrimitive()) {
                        TypeReference t2;
                        TypeReference t1 = MetadataHelper.findCommonSuperType(IsRedundantVisitor.unbox(tFirst), IsRedundantVisitor.unbox(tOther));
                        if (!MetadataResolver.areEquivalent(t1, t2 = MetadataHelper.findCommonSuperType(IsRedundantVisitor.unbox(opType), IsRedundantVisitor.unbox(tOther)))) {
                            return true;
                        }
                        binaryTypeAfterRemoval = t2;
                    }
                }
            }
            if (castType instanceof PrimitiveType) {
                if (opType instanceof PrimitiveType) {
                    ConversionType conversionType = this.getNumericConversion(castType, opType, operand);
                    if (conversionType.isImplicit() || conversionType == ConversionType.EXPLICIT_TO_UNBOXED) {
                        if (conversionType.isLossless()) {
                            return false;
                        }
                        if (castType.isEquivalentTo(binaryTypeAfterRemoval)) {
                            return false;
                        }
                    }
                    return true;
                }
            } else if (castType instanceof IGenericInstance ? MetadataHelper.isRawType(opType) && !MetadataHelper.isAssignableFrom(castType, opType) : MetadataHelper.isRawType(castType) && opType instanceof IGenericInstance && !MetadataHelper.isAssignableFrom(castType, opType)) {
                return true;
            }
            if (operand instanceof LambdaExpression || operand instanceof MethodGroupExpression) {
                MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
                TypeReference serializable = parser.parseTypeDescriptor("java/lang/Serializable");
                if (!castType.isPrimitive() && MetadataHelper.isSubType(castType, serializable)) {
                    return true;
                }
                if (castType instanceof CompoundTypeReference) {
                    boolean redundant = false;
                    CompoundTypeReference compoundType = (CompoundTypeReference)castType;
                    List<TypeReference> interfaces = compoundType.getInterfaces();
                    int start = 0;
                    TypeReference baseType = compoundType.getBaseType();
                    if (baseType == null) {
                        baseType = CollectionUtilities.first(interfaces);
                        start = 1;
                    }
                    int i = start;
                    while (i < interfaces.size()) {
                        TypeReference conjunct = interfaces.get(i);
                        if (MetadataHelper.isAssignableFrom(baseType, conjunct)) {
                            redundant = true;
                            break;
                        }
                        ++i;
                    }
                    if (!redundant) {
                        return true;
                    }
                }
            }
            return parent instanceof ConditionalExpression && opType.isPrimitive() && !(this.getType(parent) instanceof PrimitiveType) && (expectedType = TypeUtilities.getExpectedTypeByParent(this._resolver, (Expression)parent)) != null && IsRedundantVisitor.unbox(expectedType).isPrimitive();
        }

        private static TypeReference unbox(TypeReference t) {
            return t != null ? MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(t) : null;
        }

        private ConversionType getConversion(@NotNull TypeReference target, @NotNull TypeReference source, @Nullable Expression value) {
            TypeReference unboxedTarget = IsRedundantVisitor.unbox(target);
            TypeReference unboxedSource = IsRedundantVisitor.unbox(source);
            if (unboxedTarget.getSimpleType().isNumeric() && unboxedSource.getSimpleType().isNumeric()) {
                return this.getNumericConversion(target, source, value);
            }
            return MetadataHelper.getConversionType(target, source);
        }

        private ConversionType getNumericConversion(@NotNull TypeReference target, @NotNull TypeReference source, @Nullable Expression value) {
            Object constantValue;
            TypeReference unboxedTarget = IsRedundantVisitor.unbox(target);
            TypeReference unboxedSource = IsRedundantVisitor.unbox(source);
            JvmType jvmSource = unboxedSource.getSimpleType();
            JvmType jvmTarget = unboxedTarget.getSimpleType();
            if (jvmSource == JvmType.Boolean || !jvmSource.isNumeric() || jvmTarget == JvmType.Boolean || !jvmTarget.isNumeric()) {
                return ConversionType.NONE;
            }
            ResolveResult resolveResult = value != null ? this._resolver.apply(value) : null;
            Object object = constantValue = resolveResult != null ? resolveResult.getConstantValue() : null;
            if (constantValue != null && TypeUtilities.isValidPrimitiveLiteralAssignment(unboxedTarget, constantValue) && TypeUtilities.isValidPrimitiveLiteralAssignment(unboxedSource, constantValue)) {
                return ConversionType.IDENTITY;
            }
            return MetadataHelper.getNumericConversionType(target, source);
        }

        public boolean isInPolymorphicCall(CastExpression cast) {
            Expression operand = cast.getExpression();
            if ((operand instanceof InvocationExpression || operand instanceof MemberReferenceExpression && operand.getParent() instanceof InvocationExpression || operand instanceof ObjectCreationExpression) && IsRedundantVisitor.isPolymorphicMethod(operand)) {
                return true;
            }
            return cast.getRole() == Roles.ARGUMENT && IsRedundantVisitor.isPolymorphicMethod(RedundantCastUtility.skipParenthesesUp(cast.getParent()));
        }

        private static boolean isPolymorphicMethod(AstNode expression) {
            if (expression == null) {
                return false;
            }
            MemberReference memberReference = expression.getUserData(Keys.MEMBER_REFERENCE);
            if (memberReference == null && expression.getParent() instanceof MemberReferenceExpression) {
                memberReference = expression.getParent().getUserData(Keys.MEMBER_REFERENCE);
            }
            if (memberReference != null) {
                List<CustomAnnotation> annotations = memberReference.getAnnotations();
                for (CustomAnnotation annotation : annotations) {
                    String typeName = annotation.getAnnotationType().getInternalName();
                    if (!StringUtilities.equals(typeName, "java.lang.invoke.MethodHandle.PolymorphicSignature")) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean castChangesBinarySemantics(Expression operand, Expression otherOperand, Expression toCast, BinaryOperatorType operator) {
            boolean isPrimitiveOperationWithoutCast;
            boolean isPrimitiveOperationWithCast;
            TypeReference operandType = this.getType(operand);
            TypeReference otherType = this.getType(otherOperand);
            TypeReference castType = this.getType(toCast);
            if (operator == BinaryOperatorType.EQUALITY || operator == BinaryOperatorType.INEQUALITY) {
                if (TypeUtilities.isPrimitive(otherType)) {
                    isPrimitiveOperationWithCast = TypeUtilities.isPrimitiveOrWrapper(operandType);
                    isPrimitiveOperationWithoutCast = TypeUtilities.isPrimitiveOrWrapper(castType);
                } else {
                    isPrimitiveOperationWithCast = TypeUtilities.isPrimitive(operandType);
                    isPrimitiveOperationWithoutCast = TypeUtilities.isPrimitive(castType);
                }
            } else {
                isPrimitiveOperationWithCast = operandType != null && operandType.isPrimitive() || otherType != null && otherType.isPrimitive();
                isPrimitiveOperationWithoutCast = castType != null && castType.isPrimitive() || operandType != null && operandType.isPrimitive();
            }
            return isPrimitiveOperationWithCast ^ isPrimitiveOperationWithoutCast;
        }
    }
}

