/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.IdentifierExpressionBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.OptionalNode;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Repeat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class StringSwitchRewriterTransform
extends ContextTrackingVisitor<Void> {
    private static final VariableDeclarationStatement TABLE_SWITCH_INPUT;
    private static final Pattern HASH_CODE_PATTERN;
    private static final BlockStatement CASE_BODY_PATTERN;

    static {
        SimpleType intType = new SimpleType("int");
        intType.putUserData(Keys.TYPE_REFERENCE, BuiltinTypes.Integer);
        TABLE_SWITCH_INPUT = new VariableDeclarationStatement((AstType)intType, "$any$", new PrimitiveExpression(-34, -1));
        HASH_CODE_PATTERN = new NamedNode("hashCodeCall", new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new AnyNode("target").toExpression(), "hashCode", new AstType[0]), new Expression[0]));
        BlockStatement caseBody = new BlockStatement();
        IfElseStatement test = new IfElseStatement(-34, new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new NamedNode("input", new IdentifierExpression(-34, "$any$")).toExpression(), "equals", new AstType[0]), new NamedNode("stringValue", new PrimitiveExpression(-34, "$any$")).toExpression()), new BlockStatement(new ExpressionStatement(new AssignmentExpression(new NamedNode("tableSwitchInput", new IdentifierExpression(-34, "$any$")).toExpression(), new NamedNode("tableSwitchCaseValue", new PrimitiveExpression(-34, PrimitiveExpression.ANY_VALUE)).toExpression())), new OptionalNode(new BreakStatement(-34)).toStatement()));
        IfElseStatement additionalTest = new IfElseStatement(-34, new InvocationExpression(-34, (Expression)new MemberReferenceExpression(-34, new IdentifierExpressionBackReference("input").toExpression(), "equals", new AstType[0]), new NamedNode("stringValue", new PrimitiveExpression(-34, "$any$")).toExpression()), new BlockStatement(new ExpressionStatement(new AssignmentExpression(new IdentifierExpressionBackReference("tableSwitchInput").toExpression(), new NamedNode("tableSwitchCaseValue", new PrimitiveExpression(-34, PrimitiveExpression.ANY_VALUE)).toExpression())), new OptionalNode(new BreakStatement(-34)).toStatement()));
        caseBody.add(test);
        caseBody.add(new Repeat(additionalTest).toStatement());
        caseBody.add(new BreakStatement(-34));
        CASE_BODY_PATTERN = caseBody;
    }

    public StringSwitchRewriterTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement node, Void data) {
        super.visitSwitchStatement(node, data);
        Statement previous = node.getPreviousStatement();
        if (previous == null || previous.isNull()) {
            return null;
        }
        Statement next = node.getNextStatement();
        if (next == null || next.isNull()) {
            return null;
        }
        if (!(next instanceof SwitchStatement) && ((next = next.getNextStatement()) == null || next.isNull())) {
            return null;
        }
        if (!(next instanceof SwitchStatement)) {
            return null;
        }
        Match m1 = TABLE_SWITCH_INPUT.match(previous);
        if (!m1.success()) {
            return null;
        }
        Expression input = node.getExpression();
        if (input == null || input.isNull()) {
            return null;
        }
        Match m2 = HASH_CODE_PATTERN.match(input);
        if (!m2.success()) {
            return null;
        }
        InvocationExpression hashCodeCall = (InvocationExpression)CollectionUtilities.first(m2.get("hashCodeCall"));
        MemberReference hashCodeMethod = hashCodeCall.getUserData(Keys.MEMBER_REFERENCE);
        if (!(hashCodeMethod instanceof MethodReference) || !"java/lang/String".equals(hashCodeMethod.getDeclaringType().getInternalName())) {
            return null;
        }
        final LinkedHashMap<Integer, ArrayList<String>> tableInputMap = new LinkedHashMap<Integer, ArrayList<String>>();
        AstNode tableSwitchInput = null;
        for (SwitchSection section : node.getSwitchSections()) {
            Match m3 = CASE_BODY_PATTERN.match(section.getStatements().firstOrNullObject());
            if (!m3.success()) {
                return null;
            }
            if (tableSwitchInput == null) {
                tableSwitchInput = (IdentifierExpression)CollectionUtilities.first(m3.get("tableSwitchInput"));
                assert (tableSwitchInput != null);
            }
            List stringValues = CollectionUtilities.toList(m3.get("stringValue"));
            List tableSwitchCaseValues = CollectionUtilities.toList(m3.get("tableSwitchCaseValue"));
            if (stringValues.isEmpty() || stringValues.size() != tableSwitchCaseValues.size()) {
                return null;
            }
            int i = 0;
            while (i < stringValues.size()) {
                PrimitiveExpression stringValue = (PrimitiveExpression)stringValues.get(i);
                PrimitiveExpression tableSwitchCaseValue = (PrimitiveExpression)tableSwitchCaseValues.get(i);
                if (!(tableSwitchCaseValue.getValue() instanceof Integer)) {
                    return null;
                }
                Integer k = (Integer)tableSwitchCaseValue.getValue();
                String v = (String)stringValue.getValue();
                ArrayList<String> list = (ArrayList<String>)tableInputMap.get(k);
                if (list == null) {
                    list = new ArrayList<String>();
                    tableInputMap.put(k, list);
                }
                list.add(v);
                ++i;
            }
        }
        if (tableSwitchInput == null) {
            return null;
        }
        SwitchStatement tableSwitch = (SwitchStatement)next;
        if (!tableSwitchInput.matches(tableSwitch.getExpression())) {
            return null;
        }
        boolean allCasesFound = CollectionUtilities.all(tableSwitch.getSwitchSections(), new Predicate<SwitchSection>(){

            @Override
            public boolean test(SwitchSection s) {
                return !s.getCaseLabels().isEmpty() && CollectionUtilities.all(s.getCaseLabels(), new Predicate<CaseLabel>(){

                    @Override
                    public boolean test(CaseLabel c) {
                        return c.getExpression().isNull() || c.getExpression() instanceof PrimitiveExpression && ((PrimitiveExpression)c.getExpression()).getValue() instanceof Integer && tableInputMap.containsKey(((PrimitiveExpression)c.getExpression()).getValue());
                    }
                });
            }
        });
        if (!allCasesFound) {
            return null;
        }
        AstNode newInput = (AstNode)CollectionUtilities.first(m2.get("target"));
        newInput.remove();
        tableSwitch.getExpression().replaceWith(newInput);
        for (SwitchSection s : tableSwitch.getSwitchSections()) {
            for (CaseLabel c : s.getCaseLabels()) {
                if (c.getExpression() == null || c.getExpression().isNull()) continue;
                PrimitiveExpression test = (PrimitiveExpression)c.getExpression();
                Integer testValue = (Integer)test.getValue();
                List stringValues = (List)tableInputMap.get(testValue);
                assert (stringValues != null && !stringValues.isEmpty());
                test.setValue(stringValues.get(0));
                CaseLabel insertionPoint = c;
                int i = 1;
                while (i < stringValues.size()) {
                    CaseLabel newLabel = new CaseLabel(new PrimitiveExpression(-34, stringValues.get(i)));
                    s.getCaseLabels().insertAfter(insertionPoint, newLabel);
                    insertionPoint = newLabel;
                    ++i;
                }
            }
        }
        node.remove();
        previous.remove();
        return null;
    }
}

