/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.JavaPrimitiveCast;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.semantics.ResolveResult;

public class SimplifyArithmeticExpressionsTransform
extends ContextTrackingVisitor<Void> {
    private final JavaResolver _resolver;

    public SimplifyArithmeticExpressionsTransform(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
    }

    @Override
    public Void visitUnaryOperatorExpression(UnaryOperatorExpression node, Void data) {
        super.visitUnaryOperatorExpression(node, data);
        UnaryOperatorType operator = node.getOperator();
        switch (operator) {
            case MINUS: 
            case PLUS: {
                Number negatedValue;
                boolean isNegative;
                PrimitiveExpression operand;
                boolean minus;
                boolean bl = minus = operator == UnaryOperatorType.MINUS;
                if (!(node.getExpression() instanceof PrimitiveExpression) || !((operand = (PrimitiveExpression)node.getExpression()).getValue() instanceof Number)) break;
                if (operand.getValue() instanceof Float || operand.getValue() instanceof Double) {
                    double value = (Double)JavaPrimitiveCast.cast(JvmType.Double, operand.getValue());
                    isNegative = !Double.isNaN(value) && (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(operand.getValue(), true), -value);
                } else {
                    long value = (Long)JavaPrimitiveCast.cast(JvmType.Long, operand.getValue());
                    isNegative = value < 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(operand.getValue(), true), -value);
                }
                if (minus != isNegative) break;
                operand.remove();
                node.replaceWith(operand);
                if (!isNegative) break;
                operand.setValue(negatedValue);
            }
        }
        return null;
    }

    @Override
    public Void visitBinaryOperatorExpression(BinaryOperatorExpression node, Void data) {
        super.visitBinaryOperatorExpression(node, data);
        BinaryOperatorType operator = node.getOperator();
        switch (operator) {
            case ADD: 
            case SUBTRACT: {
                Number negatedValue;
                boolean isNegative;
                PrimitiveExpression right;
                ResolveResult leftResult = this._resolver.apply(node.getLeft());
                if (leftResult == null || leftResult.getType() == null || leftResult.getType().isEquivalentTo(CommonTypeReferences.String)) {
                    return null;
                }
                if (!(node.getRight() instanceof PrimitiveExpression) || !((right = (PrimitiveExpression)node.getRight()).getValue() instanceof Number)) break;
                if (right.getValue() instanceof Float || right.getValue() instanceof Double) {
                    double value = (Double)JavaPrimitiveCast.cast(JvmType.Double, right.getValue());
                    isNegative = !Double.isNaN(value) && (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(right.getValue(), true), -value);
                } else {
                    long value = (Long)JavaPrimitiveCast.cast(JvmType.Long, right.getValue());
                    isNegative = value < 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(right.getValue(), true), -value);
                }
                if (!isNegative) break;
                right.setValue(negatedValue);
                node.setOperator(operator == BinaryOperatorType.ADD ? BinaryOperatorType.SUBTRACT : BinaryOperatorType.ADD);
                break;
            }
            case EXCLUSIVE_OR: {
                long value;
                if (!(node.getRight() instanceof PrimitiveExpression)) break;
                Expression left = node.getLeft();
                PrimitiveExpression right = (PrimitiveExpression)node.getRight();
                if (!(right.getValue() instanceof Number) || (value = ((Long)JavaPrimitiveCast.cast(JvmType.Long, right.getValue())).longValue()) != -1L) break;
                left.remove();
                UnaryOperatorExpression replacement = new UnaryOperatorExpression(UnaryOperatorType.BITWISE_NOT, left);
                node.replaceWith(replacement);
            }
        }
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
        super.visitAssignmentExpression(node, data);
        AssignmentOperatorType operator = node.getOperator();
        switch (operator) {
            case ADD: 
            case SUBTRACT: {
                Number negatedValue;
                boolean isNegative;
                PrimitiveExpression right;
                TypeReference typeReference;
                CastExpression cast;
                AstType castType;
                ResolveResult leftResult = this._resolver.apply(node.getLeft());
                if (leftResult == null || leftResult.getType() == null || leftResult.getType().isEquivalentTo(CommonTypeReferences.String)) {
                    return null;
                }
                Expression rValue = node.getRight();
                boolean dropCast = false;
                if (rValue instanceof CastExpression && (castType = (cast = (CastExpression)rValue).getType()) != null && !castType.isNull() && (typeReference = castType.getUserData(Keys.TYPE_REFERENCE)) != null) {
                    JvmType jvmType = typeReference.getSimpleType();
                    switch (jvmType) {
                        case Byte: 
                        case Character: 
                        case Short: {
                            if (!(cast.getExpression() instanceof PrimitiveExpression)) break;
                            rValue = cast.getExpression();
                            dropCast = true;
                        }
                    }
                }
                if (!(rValue instanceof PrimitiveExpression) || !((right = (PrimitiveExpression)rValue).getValue() instanceof Number)) break;
                if (right.getValue() instanceof Float || right.getValue() instanceof Double) {
                    double value = (Double)JavaPrimitiveCast.cast(JvmType.Double, right.getValue());
                    isNegative = !Double.isNaN(value) && (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(right.getValue(), true), -value);
                } else {
                    long value = (Long)JavaPrimitiveCast.cast(JvmType.Long, right.getValue());
                    isNegative = value < 0L;
                    negatedValue = (Number)JavaPrimitiveCast.cast(JvmType.forValue(right.getValue(), true), -value);
                }
                if (isNegative) {
                    right.setValue(negatedValue);
                    node.setOperator(operator == AssignmentOperatorType.ADD ? AssignmentOperatorType.SUBTRACT : AssignmentOperatorType.ADD);
                }
                if (!dropCast) break;
                rValue.remove();
                node.setRight(rValue);
            }
        }
        return null;
    }
}

