/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.ConversionType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.semantics.ResolveResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RemoveImplicitBoxingTransform
extends ContextTrackingVisitor<Void> {
    private static final Set<String> BOX_METHODS = new HashSet<String>();
    private static final Set<String> UNBOX_METHODS = new HashSet<String>();
    private final JavaResolver _resolver;

    static {
        String[] boxTypes = new String[]{"java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Long", "java/lang/Float", "java/lang/Double"};
        String[] unboxMethods = new String[]{"byteValue:()B", "shortValue:()S", "intValue:()I", "longValue:()J", "floatValue:()F", "doubleValue:()D"};
        String[] boxMethods = new String[]{"java/lang/Boolean.valueOf:(Z)Ljava/lang/Boolean;", "java/lang/Character.valueOf:(C)Ljava/lang/Character;", "java/lang/Byte.valueOf:(B)Ljava/lang/Byte;", "java/lang/Short.valueOf:(S)Ljava/lang/Short;", "java/lang/Integer.valueOf:(I)Ljava/lang/Integer;", "java/lang/Long.valueOf:(J)Ljava/lang/Long;", "java/lang/Float.valueOf:(F)Ljava/lang/Float;", "java/lang/Double.valueOf:(D)Ljava/lang/Double;"};
        Collections.addAll(BOX_METHODS, boxMethods);
        String[] stringArray = boxTypes;
        int n = boxTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String boxType = stringArray[n2];
            String[] stringArray2 = unboxMethods;
            int n3 = unboxMethods.length;
            int n4 = 0;
            while (n4 < n3) {
                String unboxMethod = stringArray2[n4];
                UNBOX_METHODS.add(String.valueOf(boxType) + "." + unboxMethod);
                ++n4;
            }
            ++n2;
        }
        UNBOX_METHODS.add("java/lang/Character.charValue:()C");
        UNBOX_METHODS.add("java/lang/Boolean.booleanValue:()Z");
    }

    public RemoveImplicitBoxingTransform(DecompilerContext context) {
        super(context);
        this._resolver = new JavaResolver(context);
    }

    @Override
    public Void visitInvocationExpression(InvocationExpression node, Void data) {
        super.visitInvocationExpression(node, data);
        if (node.getArguments().size() == 1 && node.getTarget() instanceof MemberReferenceExpression) {
            this.removeBoxing(node);
        } else {
            this.removeUnboxing(node);
        }
        return null;
    }

    private boolean isValidPrimitiveParent(InvocationExpression node, AstNode parent) {
        if (parent == null || parent.isNull()) {
            return false;
        }
        if (parent instanceof BinaryOperatorExpression) {
            BinaryOperatorExpression binary = (BinaryOperatorExpression)parent;
            if (binary.getLeft() instanceof NullReferenceExpression || binary.getRight() instanceof NullReferenceExpression) {
                return false;
            }
            ResolveResult leftResult = this._resolver.apply(binary.getLeft());
            ResolveResult rightResult = this._resolver.apply(binary.getRight());
            return leftResult != null && rightResult != null && leftResult.getType() != null && rightResult.getType() != null && (node == binary.getLeft() ? rightResult.getType().isPrimitive() : leftResult.getType().isPrimitive());
        }
        if (node.getRole() == Roles.TARGET_EXPRESSION && parent instanceof MemberReferenceExpression && this.isUnboxingExpression(parent.getParent())) {
            return true;
        }
        return node.getRole() != Roles.TARGET_EXPRESSION && !(parent instanceof ClassOfExpression) && !(parent instanceof SynchronizedStatement) && !(parent instanceof ThrowStatement);
    }

    private boolean isUnboxingExpression(AstNode node) {
        if (!(node instanceof InvocationExpression)) {
            return false;
        }
        InvocationExpression e = (InvocationExpression)node;
        if (e.isNull()) {
            return false;
        }
        Expression target = e.getTarget();
        if (!(target instanceof MemberReferenceExpression)) {
            return false;
        }
        MemberReference reference = e.getUserData(Keys.MEMBER_REFERENCE);
        if (!(reference instanceof MethodReference)) {
            return false;
        }
        String key = String.valueOf(reference.getFullName()) + ":" + reference.getSignature();
        return UNBOX_METHODS.contains(key);
    }

    private void removeUnboxing(InvocationExpression e) {
        if (!this.isUnboxingExpression(e)) {
            return;
        }
        this.performUnboxingRemoval(e, (MemberReferenceExpression)e.getTarget());
    }

    private boolean performUnboxingRemoval(InvocationExpression e, MemberReferenceExpression target) {
        Expression boxedValue = target.getTarget();
        MethodReference unboxMethod = (MethodReference)e.getUserData(Keys.MEMBER_REFERENCE);
        AstBuilder astBuilder = this.context.getUserData(Keys.AST_BUILDER);
        TypeReference targetType = unboxMethod.getReturnType();
        TypeReference sourceType = unboxMethod.getDeclaringType();
        switch (MetadataHelper.getNumericConversionType(targetType, sourceType)) {
            case IDENTITY: 
            case IMPLICIT: 
            case IMPLICIT_LOSSY: {
                boxedValue.remove();
                e.replaceWith(new CastExpression(astBuilder.convertType(unboxMethod.getReturnType()), boxedValue));
                return true;
            }
        }
        return false;
    }

    private void removeBoxing(InvocationExpression node) {
        if (!this.isValidPrimitiveParent(node, node.getParent())) {
            return;
        }
        MemberReference reference = node.getUserData(Keys.MEMBER_REFERENCE);
        if (!(reference instanceof MethodReference)) {
            return;
        }
        String key = String.valueOf(reference.getFullName()) + ":" + reference.getSignature();
        if (!BOX_METHODS.contains(key)) {
            return;
        }
        AstNodeCollection<Expression> arguments = node.getArguments();
        Expression underlyingValue = arguments.firstOrNullObject();
        ResolveResult valueResult = this._resolver.apply(underlyingValue);
        if (valueResult == null || valueResult.getType() == null) {
            return;
        }
        TypeReference sourceType = valueResult.getType();
        TypeReference targetType = ((MethodReference)reference).getReturnType();
        ConversionType conversionType = MetadataHelper.getNumericConversionType(targetType, sourceType);
        switch (conversionType) {
            case IMPLICIT: 
            case IMPLICIT_LOSSY: 
            case EXPLICIT: 
            case EXPLICIT_TO_UNBOXED: {
                AstBuilder astBuilder = this.context.getUserData(Keys.AST_BUILDER);
                if (astBuilder == null) {
                    return;
                }
                TypeReference castType = conversionType == ConversionType.EXPLICIT_TO_UNBOXED ? MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(targetType) : targetType;
                underlyingValue.remove();
                node.replaceWith(new CastExpression(astBuilder.convertType(castType), underlyingValue));
            }
        }
    }
}

