/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;

public class InsertConstantReferencesTransform
extends ContextTrackingVisitor<Void> {
    public InsertConstantReferencesTransform(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitPrimitiveExpression(PrimitiveExpression node, Void data) {
        Object value = node.getValue();
        if (value instanceof Number) {
            this.tryRewriteConstant(node, value);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryRewriteConstant(PrimitiveExpression node, Object value) {
        AstType astType;
        FieldReference field;
        TypeReference declaringType;
        String fieldName;
        block53: {
            FieldDeclaration declaration;
            FieldDefinition actualField;
            JvmType jvmType;
            if (value instanceof Double) {
                double d = (Double)value;
                jvmType = JvmType.Double;
                if (d == Double.POSITIVE_INFINITY) {
                    fieldName = "POSITIVE_INFINITY";
                } else if (d == Double.NEGATIVE_INFINITY) {
                    fieldName = "NEGATIVE_INFINITY";
                } else if (Double.isNaN(d)) {
                    fieldName = "NaN";
                } else if (d == Double.MIN_VALUE) {
                    fieldName = "MIN_VALUE";
                } else if (d == Double.MAX_VALUE) {
                    fieldName = "MAX_VALUE";
                } else {
                    if (d != Double.MIN_NORMAL) return;
                    fieldName = "MIN_NORMAL";
                }
            } else if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                jvmType = JvmType.Float;
                if (f == Float.POSITIVE_INFINITY) {
                    fieldName = "POSITIVE_INFINITY";
                } else if (f == Float.NEGATIVE_INFINITY) {
                    fieldName = "NEGATIVE_INFINITY";
                } else if (Float.isNaN(f)) {
                    fieldName = "NaN";
                } else if (f == Float.MIN_VALUE) {
                    fieldName = "MIN_VALUE";
                } else if (f == Float.MAX_VALUE) {
                    fieldName = "MAX_VALUE";
                } else {
                    if (f != Float.MIN_NORMAL) return;
                    fieldName = "MIN_NORMAL";
                }
            } else if (value instanceof Long) {
                long l = (Long)value;
                jvmType = JvmType.Long;
                if (l == Long.MIN_VALUE) {
                    fieldName = "MIN_VALUE";
                } else {
                    if (l != Long.MAX_VALUE) return;
                    fieldName = "MAX_VALUE";
                }
            } else if (value instanceof Integer) {
                int i = (Integer)value;
                jvmType = JvmType.Integer;
                if (i == Integer.MIN_VALUE) {
                    fieldName = "MIN_VALUE";
                } else {
                    if (i != Integer.MAX_VALUE) return;
                    fieldName = "MAX_VALUE";
                }
            } else if (value instanceof Short) {
                short s = (Short)value;
                jvmType = JvmType.Short;
                if (s == Short.MIN_VALUE) {
                    fieldName = "MIN_VALUE";
                } else {
                    if (s != Short.MAX_VALUE) return;
                    fieldName = "MAX_VALUE";
                }
            } else {
                if (!(value instanceof Byte)) return;
                byte b = (Byte)value;
                jvmType = JvmType.Byte;
                if (b == -128) {
                    fieldName = "MIN_VALUE";
                } else {
                    if (b != 127) return;
                    fieldName = "MAX_VALUE";
                }
            }
            TypeDefinition currentType = this.context.getCurrentType();
            MetadataParser parser = currentType != null ? new MetadataParser(currentType) : new MetadataParser(IMetadataResolver.EMPTY);
            declaringType = parser.parseTypeDescriptor("java/lang/" + jvmType.name());
            field = parser.parseField(declaringType, fieldName, jvmType.getDescriptorPrefix());
            if (currentType == null || !(node.getParent() instanceof VariableInitializer) || !(node.getParent().getParent() instanceof FieldDeclaration) || !StringUtilities.equals(currentType.getInternalName(), declaringType.getInternalName()) || (actualField = (declaration = (FieldDeclaration)node.getParent().getParent()).getUserData(Keys.FIELD_DEFINITION)) != null && !StringUtilities.equals(actualField.getName(), fieldName)) break block53;
            switch (fieldName) {
                case "POSITIVE_INFINITY": {
                    node.replaceWith(new BinaryOperatorExpression(new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)1.0 : (Number)Float.valueOf(1.0f)), BinaryOperatorType.DIVIDE, new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)0.0 : (Number)Float.valueOf(0.0f))));
                    return;
                }
                case "NEGATIVE_INFINITY": {
                    node.replaceWith(new BinaryOperatorExpression(new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)-1.0 : (Number)Float.valueOf(-1.0f)), BinaryOperatorType.DIVIDE, new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)0.0 : (Number)Float.valueOf(0.0f))));
                    return;
                }
                case "NaN": {
                    node.replaceWith(new BinaryOperatorExpression(new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)0.0 : (Number)Float.valueOf(0.0f)), BinaryOperatorType.DIVIDE, new PrimitiveExpression(node.getOffset(), jvmType == JvmType.Double ? (Number)0.0 : (Number)Float.valueOf(0.0f))));
                    return;
                }
            }
            return;
        }
        AstBuilder astBuilder = this.context.getUserData(Keys.AST_BUILDER);
        if (astBuilder != null) {
            astType = astBuilder.convertType(declaringType);
        } else {
            astType = new SimpleType(declaringType.getName());
            astType.putUserData(Keys.TYPE_REFERENCE, declaringType);
        }
        MemberReferenceExpression memberReference = new MemberReferenceExpression(node.getOffset(), (Expression)new TypeReferenceExpression(node.getOffset(), astType), fieldName, new AstType[0]);
        memberReference.putUserData(Keys.MEMBER_REFERENCE, field);
        memberReference.putUserData(Keys.CONSTANT_VALUE, value);
        node.replaceWith(memberReference);
    }
}

