/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.functions.Function;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class BreakTargetRelocation
extends ContextTrackingVisitor<Void> {
    public BreakTargetRelocation(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
        super.visitMethodDeclaration(node, p);
        this.runForMethod(node);
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        super.visitConstructorDeclaration(node, p);
        this.runForMethod(node);
        return null;
    }

    private void runForMethod(AstNode node) {
        LinkedHashMap<String, LabelInfo> labels = new LinkedHashMap<String, LabelInfo>();
        for (AstNode n : node.getDescendantsAndSelf()) {
            LabelInfo labelInfo;
            if (n instanceof LabelStatement) {
                LabelStatement label = (LabelStatement)n;
                labelInfo = (LabelInfo)labels.get(label.getLabel());
                if (labelInfo == null) {
                    labels.put(label.getLabel(), new LabelInfo(label));
                    continue;
                }
                labelInfo.label = label;
                labelInfo.labelTarget = label.getNextSibling();
                labelInfo.labelIsLast = true;
                continue;
            }
            if (!(n instanceof GotoStatement)) continue;
            GotoStatement gotoStatement = (GotoStatement)n;
            labelInfo = (LabelInfo)labels.get(gotoStatement.getLabel());
            if (labelInfo == null) {
                labelInfo = new LabelInfo(gotoStatement.getLabel());
                labels.put(gotoStatement.getLabel(), labelInfo);
            } else {
                labelInfo.labelIsLast = false;
            }
            labelInfo.gotoStatements.add(gotoStatement);
        }
        for (LabelInfo labelInfo : labels.values()) {
            this.run(labelInfo);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void run(LabelInfo labelInfo) {
        block41: {
            if (!BreakTargetRelocation.$assertionsDisabled && labelInfo == null) {
                throw new AssertionError();
            }
            label = labelInfo.label;
            if (label == null || labelInfo.gotoStatements.isEmpty()) {
                return;
            }
            paths = new ArrayList<Stack<AstNode>>();
            for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
                paths.add(this.buildPath(gotoStatement));
            }
            paths.add(this.buildPath(label));
            commonAncestor = this.findLowestCommonAncestor(paths);
            if (commonAncestor instanceof SwitchStatement && labelInfo.gotoStatements.size() == 1 && label.getParent() instanceof BlockStatement && label.getParent().getParent() instanceof SwitchSection && label.getParent().getParent().getParent() == commonAncestor && (s = labelInfo.gotoStatements.get(0)).getParent() instanceof BlockStatement && s.getParent().getParent() instanceof SwitchSection && s.getParent().getParent().getParent() == commonAncestor) {
                parentSwitch = (SwitchStatement)commonAncestor;
                targetSection = (SwitchSection)label.getParent().getParent();
                fallThroughBlock = (BlockStatement)s.getParent();
                fallThroughSection = (SwitchSection)fallThroughBlock.getParent();
                if (fallThroughSection.getNextSibling() != targetSection) {
                    fallThroughSection.remove();
                    parentSwitch.getSwitchSections().insertBefore(targetSection, fallThroughSection);
                }
                parentBlock = (BlockStatement)label.getParent();
                s.remove();
                label.remove();
                if (fallThroughBlock.getStatements().isEmpty()) {
                    fallThroughBlock.remove();
                }
                if (parentBlock.getStatements().isEmpty()) {
                    parentBlock.remove();
                }
                return;
            }
            paths.clear();
            for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
                paths.add(this.buildPath(gotoStatement));
            }
            paths.add(this.buildPath(label));
            parent = this.findLowestCommonAncestorBlock(paths);
            if (parent == null) {
                return;
            }
            if (this.convertToContinue(parent, labelInfo, paths)) {
                return;
            }
            remainingNodes = new LinkedHashSet<AstNode>();
            orderedNodes = new LinkedList<AstNode>();
            startNode = (AstNode)((Stack)paths.get(0)).peek();
            if (!BreakTargetRelocation.$assertionsDisabled && startNode == null) {
                throw new AssertionError();
            }
            for (Stack path : paths) {
                if (path.isEmpty()) {
                    return;
                }
                remainingNodes.add((AstNode)path.peek());
            }
            current = startNode;
            ** GOTO lbl61
            {
                if (current instanceof Statement) {
                    orderedNodes.addLast(current);
                }
                if (remainingNodes.remove(current)) ** GOTO lbl61
                current = current.getNextSibling();
                do {
                    if (current != null && !remainingNodes.isEmpty()) continue block3;
lbl61:
                    // 3 sources

                } while (BreakTargetRelocation.lookAhead(current, remainingNodes));
            }
            if (remainingNodes.isEmpty()) break block41;
            current = startNode.getPreviousSibling();
            ** GOTO lbl71
            {
                if (current instanceof Statement) {
                    orderedNodes.addFirst(current);
                }
                if (remainingNodes.remove(current)) ** GOTO lbl71
                current = current.getPreviousSibling();
                do {
                    if (current != null && !remainingNodes.isEmpty()) continue block5;
lbl71:
                    // 3 sources

                } while (BreakTargetRelocation.lookBehind(current, remainingNodes));
            }
        }
        if (!remainingNodes.isEmpty()) {
            return;
        }
        insertBefore = ((AstNode)orderedNodes.getLast()).getNextSibling();
        insertAfter = ((AstNode)orderedNodes.getFirst()).getPreviousSibling();
        newBlock = new BlockStatement();
        blockStatements = newBlock.getStatements();
        loopData = this.assessForLoop(commonAncestor, paths, label, labelInfo.gotoStatements);
        rewriteAsLoop = loopData.continueStatements.isEmpty() == false;
        for (AstNode node : orderedNodes) {
            node.remove();
            blockStatements.add((Statement)node);
        }
        label.remove();
        if (rewriteAsLoop) {
            loop = new WhileStatement(new PrimitiveExpression(-34, true));
            loop.setEmbeddedStatement(newBlock);
            if (!AstNode.isUnconditionalBranch(CollectionUtilities.lastOrDefault(newBlock.getStatements()))) {
                newBlock.getStatements().add(new BreakStatement(-34));
            }
            if (loopData.needsLabel) {
                labeledStatement = new LabeledStatement(label.getLabel(), loop);
                insertedStatement = labeledStatement;
                labelInfo.newLabeledStatement = labeledStatement;
            } else {
                insertedStatement = loop;
            }
        } else if (newBlock.getStatements().hasSingleElement() && AstNode.isLoop(newBlock.getStatements().firstOrNullObject())) {
            loop = newBlock.getStatements().firstOrNullObject();
            loop.remove();
            labeledStatement = new LabeledStatement(label.getLabel(), loop);
            insertedStatement = labeledStatement;
            labelInfo.newLabeledStatement = labeledStatement;
        } else {
            labeledStatement = new LabeledStatement(label.getLabel(), newBlock);
            insertedStatement = labeledStatement;
            labelInfo.newLabeledStatement = labeledStatement;
        }
        if (parent.getParent() instanceof LabelStatement) {
            insertionPoint /* !! */  = parent;
            while (insertionPoint /* !! */  != null && insertionPoint /* !! */ .getParent() instanceof LabelStatement) {
                insertionPoint /* !! */  = CollectionUtilities.firstOrDefault(insertionPoint /* !! */ .getAncestors(BlockStatement.class));
            }
            if (insertionPoint /* !! */  == null) {
                return;
            }
            insertionPoint /* !! */ .addChild(insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else if (insertBefore != null) {
            parent.insertChildBefore(insertBefore, insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else if (insertAfter != null) {
            parent.insertChildAfter(insertAfter, insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else {
            parent.getStatements().add(insertedStatement);
        }
        for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
            if (loopData.continueStatements.contains(gotoStatement)) {
                continueStatement = new ContinueStatement(-34);
                if (loopData.needsLabel) {
                    continueStatement.setLabel(gotoStatement.getLabel());
                }
                gotoStatement.replaceWith(continueStatement);
                continue;
            }
            breakStatement = new BreakStatement(-34);
            breakStatement.setLabel(gotoStatement.getLabel());
            gotoStatement.replaceWith(breakStatement);
        }
        if (rewriteAsLoop && !loopData.preexistingContinueStatements.isEmpty() && (existingLoop = CollectionUtilities.firstOrDefault(insertedStatement.getAncestors(), new Predicate<AstNode>(){

            @Override
            public boolean test(AstNode node) {
                return AstNode.isLoop(node);
            }
        })) != null) {
            loopLabel = String.valueOf(label.getLabel()) + "_Outer";
            existingLoop.replaceWith(new Function<AstNode, AstNode>(){

                @Override
                public AstNode apply(AstNode input) {
                    return new LabeledStatement(loopLabel, (Statement)existingLoop);
                }
            });
            for (ContinueStatement statement : loopData.preexistingContinueStatements) {
                statement.setLabel(loopLabel);
            }
        }
    }

    private boolean convertToContinue(BlockStatement parent, final LabelInfo labelInfo, List<Stack<AstNode>> paths) {
        boolean isContinue;
        if (!AstNode.isLoop(parent.getParent())) {
            return false;
        }
        AstNode loop = parent.getParent();
        AstNode nextAfterLoop = loop.getNextNode();
        AstNode n = labelInfo.label;
        while (n.getNextSibling() == null) {
            n = n.getParent();
        }
        boolean bl = isContinue = (n = n.getNextSibling()) == nextAfterLoop || loop instanceof ForStatement && n.getRole() == ForStatement.ITERATOR_ROLE && n.getParent() == loop;
        if (!isContinue) {
            return false;
        }
        boolean loopNeedsLabel = false;
        for (AstNode astNode : loop.getDescendantsAndSelf()) {
            if (astNode instanceof ContinueStatement && StringUtilities.equals(((ContinueStatement)astNode).getLabel(), labelInfo.name)) {
                loopNeedsLabel = true;
                continue;
            }
            if (!(astNode instanceof BreakStatement) || !StringUtilities.equals(((BreakStatement)astNode).getLabel(), labelInfo.name)) continue;
            loopNeedsLabel = true;
        }
        for (Stack stack : paths) {
            AstNode start = (AstNode)stack.firstElement();
            boolean continueNeedsLabel = false;
            if (!(start instanceof GotoStatement)) continue;
            AstNode node = start;
            while (node != null && node != loop) {
                if (AstNode.isLoop(node)) {
                    continueNeedsLabel = true;
                    loopNeedsLabel = true;
                    break;
                }
                node = node.getParent();
            }
            int offset = ((GotoStatement)start).getOffset();
            if (continueNeedsLabel) {
                start.replaceWith(new ContinueStatement(offset, labelInfo.name));
                continue;
            }
            start.replaceWith(new ContinueStatement(offset));
        }
        labelInfo.label.remove();
        if (loopNeedsLabel) {
            loop.replaceWith(new Function<AstNode, AstNode>(){

                @Override
                public AstNode apply(AstNode input) {
                    return new LabeledStatement(labelInfo.name, (Statement)input);
                }
            });
        }
        return true;
    }

    private AssessForLoopResult assessForLoop(AstNode commonAncestor, List<Stack<AstNode>> paths, LabelStatement label, List<GotoStatement> statements) {
        HashSet<GotoStatement> gotoStatements = new HashSet<GotoStatement>(statements);
        HashSet<GotoStatement> continueStatements = new HashSet<GotoStatement>();
        HashSet<ContinueStatement> preexistingContinueStatements = new HashSet<ContinueStatement>();
        boolean labelSeen = false;
        boolean loopEncountered = false;
        for (Stack<AstNode> path : paths) {
            if (CollectionUtilities.firstOrDefault(path) != label && (loopEncountered = CollectionUtilities.any(path, new Predicate<AstNode>(){

                @Override
                public boolean test(AstNode node) {
                    return AstNode.isLoop(node);
                }
            }))) break;
        }
        for (AstNode node : commonAncestor.getDescendantsAndSelf()) {
            if (node == label) {
                labelSeen = true;
                continue;
            }
            if (labelSeen && node instanceof GotoStatement && gotoStatements.contains(node)) {
                continueStatements.add((GotoStatement)node);
                continue;
            }
            if (!(node instanceof ContinueStatement) || !StringUtilities.isNullOrEmpty(((ContinueStatement)node).getLabel())) continue;
            preexistingContinueStatements.add((ContinueStatement)node);
        }
        return new AssessForLoopResult(loopEncountered, continueStatements, preexistingContinueStatements);
    }

    private static boolean lookAhead(AstNode start, Set<AstNode> targets) {
        AstNode current = start;
        while (current != null && !targets.isEmpty()) {
            if (targets.contains(current)) {
                return true;
            }
            current = current.getNextSibling();
        }
        return false;
    }

    private static boolean lookBehind(AstNode start, Set<AstNode> targets) {
        AstNode current = start;
        while (current != null && !targets.isEmpty()) {
            if (targets.contains(current)) {
                return true;
            }
            current = current.getPreviousSibling();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private BlockStatement findLowestCommonAncestorBlock(List<Stack<AstNode>> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        current = null;
        match = null;
        sinceLastMatch = new Stack<AstNode>();
        while (true) {
            for (Stack<AstNode> path : paths) {
                if (!path.isEmpty()) {
                    if (current == null) {
                        current = path.peek();
                        continue;
                    }
                    if (path.peek() == current) {
                        continue;
                    }
                }
                ** GOTO lbl36
            }
            for (Stack<AstNode> path : paths) {
                path.pop();
            }
            if (current instanceof BlockStatement) {
                sinceLastMatch.clear();
                match = (BlockStatement)current;
            } else {
                sinceLastMatch.push(current);
            }
            current = null;
        }
lbl-1000:
        // 1 sources

        {
            i = 0;
            n = paths.size();
            while (i < n) {
                paths.get(i).push((AstNode)sinceLastMatch.peek());
                ++i;
            }
            sinceLastMatch.pop();
lbl36:
            // 2 sources

            ** while (!sinceLastMatch.isEmpty())
        }
lbl37:
        // 1 sources

        return match;
    }

    /*
     * Unable to fully structure code
     */
    private Statement findLowestCommonAncestor(List<Stack<AstNode>> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        current = null;
        match = null;
        sinceLastMatch = new Stack<AstNode>();
        while (true) {
            for (Stack<AstNode> path : paths) {
                if (!path.isEmpty()) {
                    if (current == null) {
                        current = path.peek();
                        continue;
                    }
                    if (path.peek() == current) {
                        continue;
                    }
                }
                ** GOTO lbl36
            }
            for (Stack<AstNode> path : paths) {
                path.pop();
            }
            if (current instanceof Statement) {
                sinceLastMatch.clear();
                match = (Statement)current;
            } else {
                sinceLastMatch.push(current);
            }
            current = null;
        }
lbl-1000:
        // 1 sources

        {
            i = 0;
            n = paths.size();
            while (i < n) {
                paths.get(i).push((AstNode)sinceLastMatch.peek());
                ++i;
            }
            sinceLastMatch.pop();
lbl36:
            // 2 sources

            ** while (!sinceLastMatch.isEmpty())
        }
lbl37:
        // 1 sources

        return match;
    }

    private Stack<AstNode> buildPath(AstNode node) {
        assert (node != null);
        Stack<AstNode> path = new Stack<AstNode>();
        path.push(node);
        AstNode current = node;
        while (current != null) {
            path.push(current);
            if (current instanceof MethodDeclaration) break;
            current = current.getParent();
        }
        return path;
    }

    private static final class AssessForLoopResult {
        final boolean needsLabel;
        final Set<GotoStatement> continueStatements;
        final Set<ContinueStatement> preexistingContinueStatements;

        private AssessForLoopResult(boolean needsLabel, Set<GotoStatement> continueStatements, Set<ContinueStatement> preexistingContinueStatements) {
            this.needsLabel = needsLabel;
            this.continueStatements = continueStatements;
            this.preexistingContinueStatements = preexistingContinueStatements;
        }
    }

    private static final class LabelInfo {
        final String name;
        final List<GotoStatement> gotoStatements = new ArrayList<GotoStatement>();
        boolean labelIsLast;
        LabelStatement label;
        AstNode labelTarget;
        LabeledStatement newLabeledStatement;

        LabelInfo(String name) {
            this.name = name;
        }

        LabelInfo(LabelStatement label) {
            this.label = label;
            this.labelTarget = label.getNextSibling();
            this.name = label.getLabel();
        }
    }
}

