/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;

public class VariableInitializer
extends AstNode {
    public static final VariableInitializer NULL = new NullVariableInitializer();

    public VariableInitializer() {
    }

    public VariableInitializer(String name) {
        this.setName(name);
    }

    public VariableInitializer(String name, Expression initializer) {
        this.setName(name);
        this.setInitializer(initializer);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    public final Expression getInitializer() {
        return this.getChildByRole(Roles.EXPRESSION);
    }

    public final void setInitializer(Expression value) {
        this.setChildByRole(Roles.EXPRESSION, value);
    }

    public final String getName() {
        return this.getChildByRole(Roles.IDENTIFIER).getName();
    }

    public final void setName(String value) {
        this.setChildByRole(Roles.IDENTIFIER, Identifier.create(value));
    }

    public final Identifier getNameToken() {
        return this.getChildByRole(Roles.IDENTIFIER);
    }

    public final void setNameToken(Identifier value) {
        this.setChildByRole(Roles.IDENTIFIER, value);
    }

    public final JavaTokenNode getAssignToken() {
        return this.getChildByRole(Roles.ASSIGN);
    }

    public Role<? extends VariableInitializer> getRole() {
        return super.getRole();
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitVariableInitializer(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof VariableInitializer) {
            VariableInitializer otherInitializer = (VariableInitializer)other;
            return !other.isNull() && VariableInitializer.matchString(this.getName(), otherInitializer.getName()) && this.getInitializer().matches(otherInitializer.getInitializer(), match);
        }
        return false;
    }

    @Override
    public String toString() {
        Expression initializer = this.getInitializer();
        if (initializer.isNull()) {
            return "[VariableInitializer " + this.getName() + "]";
        }
        return "[VariableInitializer " + this.getName() + " = " + initializer + "]";
    }

    public static VariableInitializer forPattern(Pattern pattern) {
        return new PatternPlaceholder(VerifyArgument.notNull(pattern, "pattern"));
    }

    public static /* bridge */ /* synthetic */ AstNode forPattern(Pattern pattern) {
        return VariableInitializer.forPattern(pattern);
    }

    private static final class NullVariableInitializer
    extends VariableInitializer {
        private NullVariableInitializer() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }

    private static final class PatternPlaceholder
    extends VariableInitializer {
        final Pattern child;

        PatternPlaceholder(Pattern child) {
            this.child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this.child, data);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this.child.matchesCollection(role, position, match, backtrackingInfo);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this.child.matches(other, match);
        }
    }
}

