/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.ArrayUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class PackageDeclaration
extends AstNode {
    public static final PackageDeclaration NULL = new NullPackageDeclaration();

    public PackageDeclaration() {
    }

    public PackageDeclaration(String name) {
        this.setName(name);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    public final JavaTokenNode getPackageToken() {
        return this.getChildByRole(Roles.PACKAGE_KEYWORD);
    }

    public final JavaTokenNode getSemicolonToken() {
        return this.getChildByRole(Roles.SEMICOLON);
    }

    public final AstNodeCollection<Identifier> getIdentifiers() {
        return this.getChildrenByRole(Roles.IDENTIFIER);
    }

    public final String getName() {
        StringBuilder sb = new StringBuilder();
        for (Identifier identifier : this.getIdentifiers()) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(identifier.getName());
        }
        return sb.toString();
    }

    public final void setName(String name) {
        if (name == null) {
            this.getChildrenByRole(Roles.IDENTIFIER).clear();
            return;
        }
        String[] parts = name.split("\\.");
        Identifier[] identifiers = new Identifier[parts.length];
        int i = 0;
        while (i < identifiers.length) {
            identifiers[i] = Identifier.create(parts[i]);
            ++i;
        }
        this.getChildrenByRole(Roles.IDENTIFIER).replaceWith(ArrayUtilities.asUnmodifiableList(identifiers));
    }

    public static String BuildQualifiedName(String name1, String name2) {
        if (StringUtilities.isNullOrEmpty(name1)) {
            return name2;
        }
        if (StringUtilities.isNullOrEmpty(name2)) {
            return name1;
        }
        return String.valueOf(name1) + "." + name2;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitPackageDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof PackageDeclaration && !other.isNull() && PackageDeclaration.matchString(this.getName(), ((PackageDeclaration)other).getName());
    }

    private static final class NullPackageDeclaration
    extends PackageDeclaration {
        private NullPackageDeclaration() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

