/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.core.Comparer;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.ast.AnonymousObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ArrayCreationExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.CastExpression;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IndexerExpression;
import com.strobel.decompiler.languages.java.ast.InstanceOfExpression;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaPrimitiveCast;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ObjectCreationExpression;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.SimpleType;
import com.strobel.decompiler.languages.java.ast.SuperReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WildcardType;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;

public class JavaResolver
implements Function<AstNode, ResolveResult> {
    private final DecompilerContext _context;

    public JavaResolver(DecompilerContext context) {
        this._context = VerifyArgument.notNull(context, "context");
    }

    @Override
    public ResolveResult apply(AstNode input) {
        return input.acceptVisitor(new ResolveVisitor(this._context), null);
    }

    private static ResolveResult resolveTypeFromVariable(Variable variable) {
        if (variable == null) {
            return null;
        }
        TypeReference type = variable.getType();
        if (type == null) {
            VariableDefinition originalVariable;
            ParameterDefinition parameter;
            if (variable.isParameter() && (parameter = variable.getOriginalParameter()) != null) {
                type = parameter.getParameterType();
            }
            if ((originalVariable = variable.getOriginalVariable()) != null) {
                type = originalVariable.getVariableType();
            }
        }
        if (type != null) {
            return new ResolveResult(type);
        }
        return null;
    }

    private static ResolveResult resolveType(AstType type) {
        if (type == null || type.isNull()) {
            return null;
        }
        return JavaResolver.resolveType(type.toTypeReference());
    }

    private static ResolveResult resolveType(TypeReference type) {
        return type == null ? null : new ResolveResult(type);
    }

    private static ResolveResult resolveTypeFromMember(MemberReference member) {
        if (member == null) {
            return null;
        }
        if (member instanceof FieldReference) {
            return new ResolveResult(((FieldReference)member).getFieldType());
        }
        if (member instanceof MethodReference) {
            MethodReference method = (MethodReference)member;
            if (method.isConstructor()) {
                return new ResolveResult(method.getDeclaringType());
            }
            return new ResolveResult(method.getReturnType());
        }
        return null;
    }

    private static final class BinaryOperations {
        private BinaryOperations() {
        }

        static Object doBinary(BinaryOperatorType operator, JvmType type, Object left, Object right) {
            switch (operator) {
                case BITWISE_AND: {
                    return BinaryOperations.and(type, left, right);
                }
                case BITWISE_OR: {
                    return BinaryOperations.or(type, left, right);
                }
                case EXCLUSIVE_OR: {
                    return BinaryOperations.xor(type, left, right);
                }
                case LOGICAL_AND: {
                    return BinaryOperations.andAlso(left, right);
                }
                case LOGICAL_OR: {
                    return BinaryOperations.orElse(left, right);
                }
                case GREATER_THAN: {
                    return BinaryOperations.greaterThan(type, left, right);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return BinaryOperations.greaterThanOrEqual(type, left, right);
                }
                case EQUALITY: {
                    return BinaryOperations.equal(type, left, right);
                }
                case INEQUALITY: {
                    return BinaryOperations.notEqual(type, left, right);
                }
                case LESS_THAN: {
                    return BinaryOperations.lessThan(type, left, right);
                }
                case LESS_THAN_OR_EQUAL: {
                    return BinaryOperations.lessThanOrEqual(type, left, right);
                }
                case ADD: {
                    return BinaryOperations.add(type, left, right);
                }
                case SUBTRACT: {
                    return BinaryOperations.subtract(type, left, right);
                }
                case MULTIPLY: {
                    return BinaryOperations.multiply(type, left, right);
                }
                case DIVIDE: {
                    return BinaryOperations.divide(type, left, right);
                }
                case MODULUS: {
                    return BinaryOperations.remainder(type, left, right);
                }
                case SHIFT_LEFT: {
                    return BinaryOperations.leftShift(type, left, right);
                }
                case SHIFT_RIGHT: {
                    return BinaryOperations.rightShift(type, left, right);
                }
                case UNSIGNED_SHIFT_RIGHT: {
                    return BinaryOperations.unsignedRightShift(type, left, right);
                }
            }
            return null;
        }

        private static Object add(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() + ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() + ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() + ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() + ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() + ((Number)right).longValue();
                    }
                    case Float: {
                        return Float.valueOf(((Number)left).floatValue() + ((Number)right).floatValue());
                    }
                    case Double: {
                        return ((Number)left).doubleValue() + ((Number)right).doubleValue();
                    }
                }
            }
            return null;
        }

        private static Object subtract(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() - ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() - ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() - ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() - ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() - ((Number)right).longValue();
                    }
                    case Float: {
                        return Float.valueOf(((Number)left).floatValue() - ((Number)right).floatValue());
                    }
                    case Double: {
                        return ((Number)left).doubleValue() - ((Number)right).doubleValue();
                    }
                }
            }
            return null;
        }

        private static Object multiply(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() * ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() * ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() * ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() * ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() * ((Number)right).longValue();
                    }
                    case Float: {
                        return Float.valueOf(((Number)left).floatValue() * ((Number)right).floatValue());
                    }
                    case Double: {
                        return ((Number)left).doubleValue() * ((Number)right).doubleValue();
                    }
                }
            }
            return null;
        }

        private static Object divide(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                if (type.isIntegral() && ((Number)right).longValue() == 0L) {
                    return null;
                }
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() / ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() / ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() / ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() / ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() / ((Number)right).longValue();
                    }
                    case Float: {
                        return Float.valueOf(((Number)left).floatValue() / ((Number)right).floatValue());
                    }
                    case Double: {
                        return ((Number)left).doubleValue() / ((Number)right).doubleValue();
                    }
                }
            }
            return null;
        }

        private static Object remainder(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() % ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() % ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() % ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() % ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() % ((Number)right).longValue();
                    }
                    case Float: {
                        return Float.valueOf(((Number)left).floatValue() % ((Number)right).floatValue());
                    }
                    case Double: {
                        return ((Number)left).doubleValue() % ((Number)right).doubleValue();
                    }
                }
            }
            return null;
        }

        private static Object and(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() & ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() & ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() & ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() & ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() & ((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object or(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() | ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() | ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() | ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() | ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() | ((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object xor(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() ^ ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() ^ ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() ^ ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() ^ ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() ^ ((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object leftShift(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() << ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() << ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() << ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() << ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() << (int)((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object rightShift(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() >> ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() >> ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() >> ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() >> ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() >> (int)((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object unsignedRightShift(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: {
                        return (byte)(((Number)left).intValue() >>> ((Number)right).intValue());
                    }
                    case Character: {
                        return (char)((Number)left).intValue() >>> ((Number)right).intValue();
                    }
                    case Short: {
                        return (short)((Number)left).intValue() >>> ((Number)right).intValue();
                    }
                    case Integer: {
                        return ((Number)left).intValue() >>> ((Number)right).intValue();
                    }
                    case Long: {
                        return ((Number)left).longValue() >>> (int)((Number)right).longValue();
                    }
                }
            }
            return null;
        }

        private static Object andAlso(Object left, Object right) {
            if (Boolean.TRUE.equals(BinaryOperations.asBoolean(left)) && Boolean.TRUE.equals(BinaryOperations.asBoolean(right))) {
                return true;
            }
            return false;
        }

        private static Object orElse(Object left, Object right) {
            if (!Boolean.TRUE.equals(BinaryOperations.asBoolean(left)) && !Boolean.TRUE.equals(BinaryOperations.asBoolean(right))) {
                return false;
            }
            return true;
        }

        private static Boolean asBoolean(Object o) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Number) {
                Number n = (Number)o;
                if (o instanceof Float) {
                    if (n.floatValue() != 0.0f) {
                        return true;
                    }
                    return false;
                }
                if (o instanceof Double) {
                    if (n.doubleValue() != 0.0) {
                        return true;
                    }
                    return false;
                }
                if (n.longValue() != 0L) {
                    return true;
                }
                return false;
            }
            return null;
        }

        private static Boolean lessThan(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() < ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() < ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() < ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }

        private static Boolean lessThanOrEqual(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() <= ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() <= ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() <= ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }

        private static Boolean greaterThan(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() > ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() > ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() > ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }

        private static Boolean greaterThanOrEqual(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() >= ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() >= ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() >= ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }

        private static Boolean equal(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() == ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() == ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() == ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }

        private static Boolean notEqual(JvmType type, Object left, Object right) {
            if (left instanceof Number && right instanceof Number) {
                switch (type) {
                    case Byte: 
                    case Character: 
                    case Short: 
                    case Integer: 
                    case Long: {
                        if (((Number)left).longValue() != ((Number)right).longValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Float: {
                        if (((Number)left).floatValue() != ((Number)right).floatValue()) {
                            return true;
                        }
                        return false;
                    }
                    case Double: {
                        if (((Number)left).doubleValue() != ((Number)right).doubleValue()) {
                            return true;
                        }
                        return false;
                    }
                }
            }
            return null;
        }
    }

    private static final class PrimitiveResolveResult
    extends ResolveResult {
        private final Object _value;

        private PrimitiveResolveResult(TypeReference type, Object value) {
            super(type);
            this._value = value;
        }

        @Override
        public boolean isCompileTimeConstant() {
            return true;
        }

        @Override
        public Object getConstantValue() {
            return this._value;
        }
    }

    private static final class ResolveVisitor
    extends ContextTrackingVisitor<ResolveResult> {
        protected ResolveVisitor(DecompilerContext context) {
            super(context);
        }

        @Override
        public ResolveResult visitVariableDeclaration(VariableDeclarationStatement node, Void data) {
            return JavaResolver.resolveType(node.getType());
        }

        @Override
        public ResolveResult visitVariableInitializer(VariableInitializer node, Void data) {
            return node.getInitializer().acceptVisitor(this, data);
        }

        @Override
        public ResolveResult visitObjectCreationExpression(ObjectCreationExpression node, Void p) {
            return node.getType().acceptVisitor(this, p);
        }

        @Override
        public ResolveResult visitAnonymousObjectCreationExpression(AnonymousObjectCreationExpression node, Void p) {
            ResolveResult result = JavaResolver.resolveTypeFromMember(node.getUserData(Keys.MEMBER_REFERENCE));
            if (result != null) {
                return result;
            }
            return node.getType().acceptVisitor(this, p);
        }

        @Override
        public ResolveResult visitComposedType(ComposedType node, Void p) {
            return JavaResolver.resolveType(node.toTypeReference());
        }

        @Override
        public ResolveResult visitSimpleType(SimpleType node, Void p) {
            return JavaResolver.resolveType(node.toTypeReference());
        }

        @Override
        public ResolveResult visitThisReferenceExpression(ThisReferenceExpression node, Void data) {
            if (node.getTarget().isNull()) {
                return JavaResolver.resolveType(node.getUserData(Keys.TYPE_REFERENCE));
            }
            return node.getTarget().acceptVisitor(this, data);
        }

        @Override
        public ResolveResult visitSuperReferenceExpression(SuperReferenceExpression node, Void data) {
            if (node.getTarget().isNull()) {
                return JavaResolver.resolveType(node.getUserData(Keys.TYPE_REFERENCE));
            }
            return node.getTarget().acceptVisitor(this, data);
        }

        @Override
        public ResolveResult visitTypeReference(TypeReferenceExpression node, Void p) {
            return JavaResolver.resolveType(node.getType().getUserData(Keys.TYPE_REFERENCE));
        }

        @Override
        public ResolveResult visitWildcardType(WildcardType node, Void p) {
            return JavaResolver.resolveType(node.toTypeReference());
        }

        @Override
        public ResolveResult visitIdentifier(Identifier node, Void p) {
            ResolveResult result = JavaResolver.resolveTypeFromMember(node.getUserData(Keys.MEMBER_REFERENCE));
            if (result != null) {
                return result;
            }
            return JavaResolver.resolveTypeFromVariable(node.getUserData(Keys.VARIABLE));
        }

        @Override
        public ResolveResult visitIdentifierExpression(IdentifierExpression node, Void data) {
            ResolveResult result = JavaResolver.resolveTypeFromMember(node.getUserData(Keys.MEMBER_REFERENCE));
            if (result != null) {
                return result;
            }
            Variable variable = node.getUserData(Keys.VARIABLE);
            if (variable == null) {
                return null;
            }
            result = JavaResolver.resolveTypeFromVariable(variable);
            if (result != null) {
                return result;
            }
            return (ResolveResult)super.visitIdentifierExpression(node, data);
        }

        protected ResolveResult resolveLambda(AstNode node) {
            TypeReference lambdaType = node.getUserData(Keys.TYPE_REFERENCE);
            if (lambdaType != null) {
                return JavaResolver.resolveType(lambdaType);
            }
            DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
            if (callSite != null) {
                return JavaResolver.resolveType(callSite.getMethodType().getReturnType());
            }
            return null;
        }

        @Override
        public ResolveResult visitMethodGroupExpression(MethodGroupExpression node, Void data) {
            return this.resolveLambda(node);
        }

        @Override
        public ResolveResult visitLambdaExpression(LambdaExpression node, Void data) {
            return this.resolveLambda(node);
        }

        @Override
        public ResolveResult visitMemberReferenceExpression(MemberReferenceExpression node, Void p) {
            ResolveResult targetResult = node.getTarget().acceptVisitor(this, p);
            MemberReference memberReference = node.getUserData(Keys.MEMBER_REFERENCE);
            if (memberReference == null) {
                if (StringUtilities.equals(node.getMemberName(), "length") && targetResult != null && targetResult.getType() != null && targetResult.getType().isArray()) {
                    return new ResolveResult(BuiltinTypes.Integer);
                }
                if (node.getParent() instanceof InvocationExpression) {
                    memberReference = node.getParent().getUserData(Keys.MEMBER_REFERENCE);
                }
            } else if (targetResult != null && targetResult.getType() != null) {
                MethodDefinition resolvedMethod;
                FieldDefinition resolvedField;
                memberReference = memberReference instanceof FieldReference ? MetadataHelper.asMemberOf((resolvedField = ((FieldReference)memberReference).resolve()) != null ? resolvedField : (FieldReference)memberReference, targetResult.getType()) : MetadataHelper.asMemberOf((resolvedMethod = ((MethodReference)memberReference).resolve()) != null ? resolvedMethod : (MethodReference)memberReference, targetResult.getType());
            }
            return JavaResolver.resolveTypeFromMember(memberReference);
        }

        @Override
        public ResolveResult visitInvocationExpression(InvocationExpression node, Void p) {
            ResolveResult result = JavaResolver.resolveTypeFromMember(node.getUserData(Keys.MEMBER_REFERENCE));
            if (result != null) {
                return result;
            }
            return node.getTarget().acceptVisitor(this, p);
        }

        @Override
        protected ResolveResult visitChildren(AstNode node, Void p) {
            ResolveResult result = null;
            AstNode child = node.getFirstChild();
            while (child != null) {
                AstNode next = child.getNextSibling();
                if (!(child instanceof JavaTokenNode)) {
                    ResolveResult childResult = child.acceptVisitor(this, p);
                    if (childResult == null) {
                        return null;
                    }
                    if (result == null) {
                        result = childResult;
                    } else if (!(result.isCompileTimeConstant() && childResult.isCompileTimeConstant() && Comparer.equals(result.getConstantValue(), childResult.getConstantValue()))) {
                        TypeReference commonSuperType = this.doBinaryPromotion(result, childResult);
                        if (commonSuperType != null) {
                            result = new ResolveResult(commonSuperType);
                        } else {
                            return null;
                        }
                    }
                }
                child = next;
            }
            return null;
        }

        private TypeReference doBinaryPromotion(ResolveResult left, ResolveResult right) {
            TypeReference leftType = left.getType();
            TypeReference rightType = right.getType();
            if (leftType == null) {
                return rightType;
            }
            if (rightType == null) {
                return leftType;
            }
            if (StringUtilities.equals(leftType.getInternalName(), "java/lang/String")) {
                return leftType;
            }
            if (StringUtilities.equals(rightType.getInternalName(), "java/lang/String")) {
                return rightType;
            }
            return MetadataHelper.findCommonSuperType(leftType, rightType);
        }

        private TypeReference doBinaryPromotionStrict(ResolveResult left, ResolveResult right) {
            if (left == null || right == null) {
                return null;
            }
            TypeReference leftType = left.getType();
            TypeReference rightType = right.getType();
            if (leftType == null || rightType == null) {
                return null;
            }
            leftType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(leftType);
            rightType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(rightType);
            if (StringUtilities.equals(leftType.getInternalName(), "java/lang/String")) {
                return leftType;
            }
            if (StringUtilities.equals(rightType.getInternalName(), "java/lang/String")) {
                return rightType;
            }
            return MetadataHelper.findCommonSuperType(leftType, rightType);
        }

        @Override
        public ResolveResult visitPrimitiveExpression(PrimitiveExpression node, Void p) {
            TypeReference primitiveType;
            String literalValue = node.getLiteralValue();
            Object value = node.getValue();
            if (value instanceof String || value == null && literalValue != null) {
                TypeDefinition currentType = this.context.getCurrentType();
                IMetadataResolver resolver = currentType != null ? currentType.getResolver() : MetadataSystem.instance();
                primitiveType = resolver.lookupType("java/lang/String");
            } else {
                primitiveType = value instanceof Number ? (value instanceof Byte ? BuiltinTypes.Byte : (value instanceof Short ? BuiltinTypes.Short : (value instanceof Integer ? BuiltinTypes.Integer : (value instanceof Long ? BuiltinTypes.Long : (value instanceof Float ? BuiltinTypes.Float : (value instanceof Double ? BuiltinTypes.Double : null)))))) : (value instanceof Character ? BuiltinTypes.Character : (value instanceof Boolean ? BuiltinTypes.Boolean : null));
            }
            if (primitiveType == null) {
                return null;
            }
            return new PrimitiveResolveResult(primitiveType, value != null ? value : literalValue);
        }

        @Override
        public ResolveResult visitClassOfExpression(ClassOfExpression node, Void data) {
            TypeReference type = node.getType().getUserData(Keys.TYPE_REFERENCE);
            if (type == null) {
                return null;
            }
            if (BuiltinTypes.Class.isGenericType()) {
                return new ResolveResult(BuiltinTypes.Class.makeGenericType(type));
            }
            return new ResolveResult(BuiltinTypes.Class);
        }

        @Override
        public ResolveResult visitCastExpression(CastExpression node, Void data) {
            ResolveResult childResult = node.getExpression().acceptVisitor(this, data);
            ResolveResult typeResult = JavaResolver.resolveType(node.getType());
            if (typeResult == null) {
                return childResult;
            }
            TypeReference resolvedType = typeResult.getType();
            if (resolvedType != null) {
                if (resolvedType.isPrimitive() && childResult != null && childResult.isCompileTimeConstant()) {
                    return new PrimitiveResolveResult(resolvedType, JavaPrimitiveCast.cast(resolvedType.getSimpleType(), childResult.getConstantValue()));
                }
                return new ResolveResult(resolvedType);
            }
            return typeResult;
        }

        @Override
        public ResolveResult visitNullReferenceExpression(NullReferenceExpression node, Void data) {
            return new ResolveResult(BuiltinTypes.Null);
        }

        @Override
        public ResolveResult visitBinaryOperatorExpression(BinaryOperatorExpression node, Void data) {
            Object result;
            TypeReference resultType;
            ResolveResult leftResult = node.getLeft().acceptVisitor(this, data);
            ResolveResult rightResult = node.getRight().acceptVisitor(this, data);
            if (leftResult == null || rightResult == null) {
                return null;
            }
            TypeReference leftType = leftResult.getType();
            TypeReference rightType = rightResult.getType();
            if (leftType == null || rightType == null) {
                return null;
            }
            TypeReference operandType = this.doBinaryPromotionStrict(leftResult, rightResult);
            if (operandType == null) {
                return null;
            }
            block0 : switch (node.getOperator()) {
                case LOGICAL_AND: 
                case LOGICAL_OR: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case EQUALITY: 
                case INEQUALITY: {
                    resultType = BuiltinTypes.Boolean;
                    break;
                }
                default: {
                    switch (operandType.getSimpleType()) {
                        case Byte: 
                        case Character: 
                        case Short: {
                            resultType = BuiltinTypes.Integer;
                            break block0;
                        }
                    }
                    resultType = operandType;
                }
            }
            if (leftResult.isCompileTimeConstant() && rightResult.isCompileTimeConstant() && operandType.isPrimitive() && (result = BinaryOperations.doBinary(node.getOperator(), operandType.getSimpleType(), leftResult.getConstantValue(), rightResult.getConstantValue())) != null) {
                return new PrimitiveResolveResult(resultType, result);
            }
            return new ResolveResult(resultType);
        }

        @Override
        public ResolveResult visitInstanceOfExpression(InstanceOfExpression node, Void data) {
            ResolveResult childResult = node.getExpression().acceptVisitor(this, data);
            if (childResult == null) {
                return new ResolveResult(BuiltinTypes.Boolean);
            }
            TypeReference childType = childResult.getType();
            ResolveResult typeResult = JavaResolver.resolveType(node.getType());
            if (childType == null || typeResult == null || typeResult.getType() == null) {
                return new ResolveResult(BuiltinTypes.Boolean);
            }
            return new PrimitiveResolveResult(BuiltinTypes.Boolean, MetadataHelper.isSubType(typeResult.getType(), childType));
        }

        @Override
        public ResolveResult visitIndexerExpression(IndexerExpression node, Void data) {
            ResolveResult childResult = node.getTarget().acceptVisitor(this, data);
            if (childResult == null || childResult.getType() == null || !childResult.getType().isArray()) {
                return null;
            }
            TypeReference elementType = childResult.getType().getElementType();
            if (elementType == null) {
                return null;
            }
            return new ResolveResult(elementType);
        }

        @Override
        public ResolveResult visitUnaryOperatorExpression(UnaryOperatorExpression node, Void data) {
            Object resultValue;
            TypeReference resultType;
            ResolveResult childResult = node.getExpression().acceptVisitor(this, data);
            if (childResult == null || childResult.getType() == null) {
                return null;
            }
            switch (childResult.getType().getSimpleType()) {
                case Byte: 
                case Character: 
                case Short: 
                case Integer: {
                    resultType = BuiltinTypes.Integer;
                    break;
                }
                default: {
                    resultType = childResult.getType();
                }
            }
            if (childResult.isCompileTimeConstant() && (resultValue = UnaryOperations.doUnary(node.getOperator(), childResult.getConstantValue())) != null) {
                return new PrimitiveResolveResult(resultType, resultValue);
            }
            return new ResolveResult(resultType);
        }

        @Override
        public ResolveResult visitConditionalExpression(ConditionalExpression node, Void data) {
            ResolveResult leftResult;
            ResolveResult conditionResult = node.getCondition().acceptVisitor(this, data);
            if (conditionResult != null && conditionResult.isCompileTimeConstant()) {
                if (Boolean.TRUE.equals(conditionResult.getConstantValue())) {
                    return node.getTrueExpression().acceptVisitor(this, data);
                }
                if (Boolean.FALSE.equals(conditionResult.getConstantValue())) {
                    return node.getFalseExpression().acceptVisitor(this, data);
                }
            }
            if ((leftResult = node.getTrueExpression().acceptVisitor(this, data)) == null || leftResult.getType() == null) {
                return null;
            }
            ResolveResult rightResult = node.getFalseExpression().acceptVisitor(this, data);
            if (rightResult == null || rightResult.getType() == null) {
                return null;
            }
            TypeReference resultType = MetadataHelper.findCommonSuperType(leftResult.getType(), rightResult.getType());
            if (resultType != null) {
                if (leftResult.getType().isPrimitive() || rightResult.getType().isPrimitive()) {
                    return new ResolveResult(MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(resultType));
                }
                return new ResolveResult(resultType);
            }
            return null;
        }

        @Override
        public ResolveResult visitArrayCreationExpression(ArrayCreationExpression node, Void data) {
            TypeReference elementType = node.getType().toTypeReference();
            if (elementType == null) {
                return null;
            }
            int rank = node.getDimensions().size() + node.getAdditionalArraySpecifiers().size();
            TypeReference arrayType = elementType;
            int i = 0;
            while (i < rank) {
                arrayType = arrayType.makeArrayType();
                ++i;
            }
            return new ResolveResult(arrayType);
        }

        @Override
        public ResolveResult visitAssignmentExpression(AssignmentExpression node, Void data) {
            ResolveResult leftResult = node.getLeft().acceptVisitor(this, data);
            if (leftResult != null && leftResult.getType() != null) {
                return new ResolveResult(leftResult.getType());
            }
            return null;
        }

        @Override
        public ResolveResult visitParenthesizedExpression(ParenthesizedExpression node, Void data) {
            return node.getExpression().acceptVisitor(this, data);
        }
    }

    private static final class UnaryOperations {
        private UnaryOperations() {
        }

        static Object doUnary(UnaryOperatorType operator, Object operand) {
            switch (operator) {
                case NOT: {
                    return UnaryOperations.isFalse(operand);
                }
                case BITWISE_NOT: {
                    return UnaryOperations.not(operand);
                }
                case MINUS: {
                    return UnaryOperations.minus(operand);
                }
                case PLUS: {
                    return UnaryOperations.plus(operand);
                }
                case INCREMENT: {
                    return UnaryOperations.preIncrement(operand);
                }
                case DECREMENT: {
                    return UnaryOperations.preDecrement(operand);
                }
                case POST_INCREMENT: {
                    return UnaryOperations.postIncrement(operand);
                }
                case POST_DECREMENT: {
                    return UnaryOperations.postDecrement(operand);
                }
            }
            return null;
        }

        private static Object isFalse(Object operand) {
            if (Boolean.TRUE.equals(operand)) {
                return Boolean.FALSE;
            }
            if (Boolean.FALSE.equals(operand)) {
                return Boolean.TRUE;
            }
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Float) {
                    if (n.floatValue() != 0.0f) {
                        return true;
                    }
                    return false;
                }
                if (n instanceof Double) {
                    if (n.doubleValue() != 0.0) {
                        return true;
                    }
                    return false;
                }
                if (n.longValue() != 0L) {
                    return true;
                }
                return false;
            }
            return null;
        }

        private static Object not(Object operand) {
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Byte) {
                    return (int)(~n.byteValue());
                }
                if (n instanceof Short) {
                    return (int)(~n.shortValue());
                }
                if (n instanceof Integer) {
                    return ~n.intValue();
                }
                if (n instanceof Long) {
                    return n.longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                }
            } else if (operand instanceof Character) {
                return (int)(~((Character)operand).charValue());
            }
            return null;
        }

        private static Object minus(Object operand) {
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Byte) {
                    return (int)(-n.byteValue());
                }
                if (n instanceof Short) {
                    return (int)(-n.shortValue());
                }
                if (n instanceof Integer) {
                    return -n.intValue();
                }
                if (n instanceof Long) {
                    return -n.longValue();
                }
            } else if (operand instanceof Character) {
                return (int)(-((Character)operand).charValue());
            }
            return null;
        }

        private static Object plus(Object operand) {
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Byte) {
                    return (int)n.byteValue();
                }
                if (n instanceof Short) {
                    return (int)n.shortValue();
                }
                if (n instanceof Integer) {
                    return n.intValue();
                }
                if (n instanceof Long) {
                    return n.longValue();
                }
            } else if (operand instanceof Character) {
                return (int)((Character)operand).charValue();
            }
            return null;
        }

        private static Object preIncrement(Object operand) {
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Byte) {
                    byte b = n.byteValue();
                    b = (byte)(b + 1);
                    return b;
                }
                if (n instanceof Short) {
                    short s = n.shortValue();
                    s = (short)(s + 1);
                    return s;
                }
                if (n instanceof Integer) {
                    int i = n.intValue();
                    return ++i;
                }
                if (n instanceof Long) {
                    long l = n.longValue();
                    return ++l;
                }
            } else if (operand instanceof Character) {
                char c = ((Character)operand).charValue();
                c = (char)(c + '\u0001');
                return Character.valueOf(c);
            }
            return null;
        }

        private static Object preDecrement(Object operand) {
            if (operand instanceof Number) {
                Number n = (Number)operand;
                if (n instanceof Byte) {
                    byte b = n.byteValue();
                    b = (byte)(b - 1);
                    return b;
                }
                if (n instanceof Short) {
                    short s = n.shortValue();
                    s = (short)(s - 1);
                    return s;
                }
                if (n instanceof Integer) {
                    int i = n.intValue();
                    return --i;
                }
                if (n instanceof Long) {
                    long l = n.longValue();
                    return --l;
                }
            } else if (operand instanceof Character) {
                char c = ((Character)operand).charValue();
                c = (char)(c - '\u0001');
                return Character.valueOf(c);
            }
            return null;
        }

        private static Object postIncrement(Object operand) {
            if (operand instanceof Number) {
                return operand;
            }
            if (operand instanceof Character) {
                return operand;
            }
            return null;
        }

        private static Object postDecrement(Object operand) {
            if (operand instanceof Number) {
                return operand;
            }
            if (operand instanceof Character) {
                return operand;
            }
            return null;
        }
    }
}

