/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdge;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdgeType;
import com.strobel.decompiler.languages.java.analysis.ControlFlowGraphBuilder;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNode;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNodeType;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.DefiniteAssignmentStatus;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.JavaResolver;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.LocalTypeDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.UnaryOperatorType;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import com.strobel.util.ContractUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class DefiniteAssignmentAnalysis {
    private final DefiniteAssignmentVisitor visitor = new DefiniteAssignmentVisitor();
    private final ArrayList<DefiniteAssignmentNode> allNodes = new ArrayList();
    private final LinkedHashMap<Statement, DefiniteAssignmentNode> beginNodeMap = new LinkedHashMap();
    private final LinkedHashMap<Statement, DefiniteAssignmentNode> endNodeMap = new LinkedHashMap();
    private final LinkedHashMap<Statement, DefiniteAssignmentNode> conditionNodeMap = new LinkedHashMap();
    private final LinkedHashMap<ControlFlowEdge, DefiniteAssignmentStatus> edgeStatus = new LinkedHashMap();
    private final ArrayList<IdentifierExpression> unassignedVariableUses = new ArrayList();
    private final List<IdentifierExpression> unassignedVariableUsesView = Collections.unmodifiableList(this.unassignedVariableUses);
    private final ArrayDeque<DefiniteAssignmentNode> nodesWithModifiedInput = new ArrayDeque();
    private final Function<AstNode, ResolveResult> resolver;
    private String variableName;
    private int analyzedRangeStart;
    private int analyzedRangeEnd;

    public DefiniteAssignmentAnalysis(DecompilerContext context, Statement rootStatement) {
        this(rootStatement, new JavaResolver(context));
    }

    public DefiniteAssignmentAnalysis(Statement rootStatement, Function<AstNode, ResolveResult> resolver) {
        VerifyArgument.notNull(rootStatement, "rootStatement");
        VerifyArgument.notNull(resolver, "resolver");
        this.resolver = resolver;
        DerivedControlFlowGraphBuilder builder = new DerivedControlFlowGraphBuilder();
        builder.setEvaluateOnlyPrimitiveConstants(true);
        for (ControlFlowNode node : builder.buildControlFlowGraph(rootStatement, resolver)) {
            this.allNodes.add((DefiniteAssignmentNode)node);
        }
        int i = 0;
        while (i < this.allNodes.size()) {
            DefiniteAssignmentNode node = this.allNodes.get(i);
            node.setIndex(i);
            if (node.getType() == ControlFlowNodeType.StartNode || node.getType() == ControlFlowNodeType.BetweenStatements) {
                AstNode child = node.getNextStatement().getLastChild();
                while (child != null) {
                    this.insertAnonymousMethods(i + 1, child, builder);
                    child = child.getPreviousSibling();
                }
            }
            if (node.getType() == ControlFlowNodeType.StartNode || node.getType() == ControlFlowNodeType.BetweenStatements) {
                this.beginNodeMap.put(node.getNextStatement(), node);
            }
            if (node.getType() == ControlFlowNodeType.BetweenStatements || node.getType() == ControlFlowNodeType.EndNode) {
                this.endNodeMap.put(node.getPreviousStatement(), node);
            }
            if (node.getType() == ControlFlowNodeType.LoopCondition) {
                this.conditionNodeMap.put(node.getNextStatement(), node);
            }
            ++i;
        }
        this.analyzedRangeStart = 0;
        this.analyzedRangeEnd = this.allNodes.size() - 1;
    }

    private void insertAnonymousMethods(int insertPosition, AstNode node, ControlFlowGraphBuilder builder) {
        LambdaExpression lambda;
        if (node instanceof Statement) {
            return;
        }
        if (node instanceof LambdaExpression && (lambda = (LambdaExpression)node).getBody() instanceof Statement) {
            List<ControlFlowNode> nodes = builder.buildControlFlowGraph((Statement)lambda.getBody(), this.resolver);
            this.allNodes.addAll(insertPosition, nodes);
            return;
        }
        AstNode child = node.getLastChild();
        while (child != null) {
            this.insertAnonymousMethods(insertPosition, child, builder);
            child = child.getPreviousSibling();
        }
    }

    public List<IdentifierExpression> getUnassignedVariableUses() {
        return this.unassignedVariableUsesView;
    }

    public void setAnalyzedRange(Statement start, Statement end) {
        this.setAnalyzedRange(start, end, true, true);
    }

    public void setAnalyzedRange(Statement start, Statement end, boolean startInclusive, boolean endInclusive) {
        int endIndex;
        LinkedHashMap<Statement, DefiniteAssignmentNode> endMap;
        LinkedHashMap<Statement, DefiniteAssignmentNode> startMap = startInclusive ? this.beginNodeMap : this.endNodeMap;
        LinkedHashMap<Statement, DefiniteAssignmentNode> linkedHashMap = endMap = endInclusive ? this.endNodeMap : this.beginNodeMap;
        assert (startMap.containsKey(start) && endMap.containsKey(end));
        int startIndex = ((DefiniteAssignmentNode)startMap.get(start)).getIndex();
        if (startIndex > (endIndex = ((DefiniteAssignmentNode)endMap.get(end)).getIndex())) {
            throw new IllegalStateException("The start statement must lexically precede the end statement.");
        }
        this.analyzedRangeStart = startIndex;
        this.analyzedRangeEnd = endIndex;
    }

    public void analyze(String variable) {
        this.analyze(variable, DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED);
    }

    public void analyze(String variable, DefiniteAssignmentStatus initialStatus) {
        this.variableName = variable;
        try {
            this.unassignedVariableUses.clear();
            for (DefiniteAssignmentNode node : this.allNodes) {
                node.setNodeStatus(DefiniteAssignmentStatus.CODE_UNREACHABLE);
                for (ControlFlowEdge edge : node.getOutgoing()) {
                    this.edgeStatus.put(edge, DefiniteAssignmentStatus.CODE_UNREACHABLE);
                }
            }
            this.changeNodeStatus(this.allNodes.get(this.analyzedRangeStart), initialStatus);
            while (!this.nodesWithModifiedInput.isEmpty()) {
                DefiniteAssignmentNode node;
                node = this.nodesWithModifiedInput.poll();
                DefiniteAssignmentStatus inputStatus = DefiniteAssignmentStatus.CODE_UNREACHABLE;
                for (ControlFlowEdge edge : node.getIncoming()) {
                    inputStatus = this.mergeStatus(inputStatus, this.edgeStatus.get(edge));
                }
                this.changeNodeStatus(node, inputStatus);
            }
        }
        finally {
            this.variableName = null;
        }
    }

    public boolean isPotentiallyAssigned() {
        for (DefiniteAssignmentNode node : this.allNodes) {
            DefiniteAssignmentStatus status = node.getNodeStatus();
            if (status == null) {
                return true;
            }
            switch (status) {
                case POTENTIALLY_ASSIGNED: 
                case DEFINITELY_ASSIGNED: 
                case ASSIGNED_AFTER_TRUE_EXPRESSION: 
                case ASSIGNED_AFTER_FALSE_EXPRESSION: {
                    return true;
                }
            }
        }
        return false;
    }

    public DefiniteAssignmentStatus getStatusBefore(Statement statement) {
        return this.beginNodeMap.get(statement).getNodeStatus();
    }

    public DefiniteAssignmentStatus getStatusAfter(Statement statement) {
        return this.endNodeMap.get(statement).getNodeStatus();
    }

    public DefiniteAssignmentStatus getBeforeLoopCondition(Statement statement) {
        return this.conditionNodeMap.get(statement).getNodeStatus();
    }

    private DefiniteAssignmentStatus cleanSpecialValues(DefiniteAssignmentStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case ASSIGNED_AFTER_TRUE_EXPRESSION: 
            case ASSIGNED_AFTER_FALSE_EXPRESSION: {
                return DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED;
            }
        }
        return status;
    }

    private DefiniteAssignmentStatus mergeStatus(DefiniteAssignmentStatus a, DefiniteAssignmentStatus b) {
        if (a == b) {
            return a;
        }
        if (a == DefiniteAssignmentStatus.CODE_UNREACHABLE) {
            return b;
        }
        if (b == DefiniteAssignmentStatus.CODE_UNREACHABLE) {
            return a;
        }
        return DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED;
    }

    private void changeNodeStatus(DefiniteAssignmentNode node, DefiniteAssignmentStatus inputStatus) {
        DefiniteAssignmentStatus outputStatus;
        if (node.getNodeStatus() == inputStatus) {
            return;
        }
        node.setNodeStatus(inputStatus);
        switch (node.getType()) {
            case StartNode: 
            case BetweenStatements: {
                if (!(node.getNextStatement() instanceof IfElseStatement)) {
                    if (inputStatus == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED) {
                        outputStatus = DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                        break;
                    }
                    outputStatus = this.cleanSpecialValues(node.getNextStatement().acceptVisitor(this.visitor, inputStatus));
                    break;
                }
            }
            case LoopCondition: {
                if (node.getNextStatement() instanceof ForEachStatement) {
                    ForEachStatement forEach = (ForEachStatement)node.getNextStatement();
                    outputStatus = this.cleanSpecialValues(forEach.getInExpression().acceptVisitor(this.visitor, inputStatus));
                    if (!StringUtilities.equals(forEach.getVariableName(), this.variableName)) break;
                    outputStatus = DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                    break;
                }
                assert (node.getNextStatement() instanceof IfElseStatement || node.getNextStatement() instanceof WhileStatement || node.getNextStatement() instanceof DoWhileStatement || node.getNextStatement() instanceof ForStatement);
                Expression condition = node.getNextStatement().getChildByRole(Roles.CONDITION);
                DefiniteAssignmentStatus outputStatus2 = condition.isNull() ? inputStatus : condition.acceptVisitor(this.visitor, inputStatus);
                for (ControlFlowEdge edge : node.getOutgoing()) {
                    if (edge.getType() == ControlFlowEdgeType.ConditionTrue && outputStatus2 == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                        this.changeEdgeStatus(edge, DefiniteAssignmentStatus.DEFINITELY_ASSIGNED);
                        continue;
                    }
                    if (edge.getType() == ControlFlowEdgeType.ConditionFalse && outputStatus2 == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                        this.changeEdgeStatus(edge, DefiniteAssignmentStatus.DEFINITELY_ASSIGNED);
                        continue;
                    }
                    this.changeEdgeStatus(edge, this.cleanSpecialValues(outputStatus2));
                }
                return;
            }
            case EndNode: {
                outputStatus = inputStatus;
                if (node.getPreviousStatement().getRole() != TryCatchStatement.FINALLY_BLOCK_ROLE || outputStatus != DefiniteAssignmentStatus.DEFINITELY_ASSIGNED && outputStatus != DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED) break;
                TryCatchStatement tryFinally = (TryCatchStatement)node.getPreviousStatement().getParent();
                for (DefiniteAssignmentNode n : this.allNodes) {
                    for (ControlFlowEdge edge : n.getOutgoing()) {
                        DefiniteAssignmentStatus s;
                        if (!edge.isLeavingTryFinally() || !CollectionUtilities.contains(edge.getTryFinallyStatements(), tryFinally) || (s = this.edgeStatus.get(edge)) != DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED) continue;
                        this.changeEdgeStatus(edge, outputStatus);
                    }
                }
                break;
            }
            default: {
                throw ContractUtils.unreachable();
            }
        }
        for (ControlFlowEdge edge : node.getOutgoing()) {
            this.changeEdgeStatus(edge, outputStatus);
        }
    }

    private void changeEdgeStatus(ControlFlowEdge edge, DefiniteAssignmentStatus newStatus) {
        DefiniteAssignmentStatus oldStatus = this.edgeStatus.get(edge);
        if (oldStatus == newStatus) {
            return;
        }
        if (oldStatus == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED) {
            return;
        }
        if (newStatus == DefiniteAssignmentStatus.CODE_UNREACHABLE || newStatus == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION || newStatus == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
            throw new IllegalStateException("Illegal edge output status:" + (Object)((Object)newStatus));
        }
        this.edgeStatus.put(edge, newStatus);
        DefiniteAssignmentNode targetNode = (DefiniteAssignmentNode)edge.getTo();
        if (this.analyzedRangeStart <= targetNode.getIndex() && targetNode.getIndex() <= this.analyzedRangeEnd) {
            this.nodesWithModifiedInput.add(targetNode);
        }
    }

    protected ResolveResult evaluateConstant(Expression e) {
        return this.resolver.apply(e);
    }

    protected Boolean evaluateCondition(Expression e) {
        ResolveResult result = this.evaluateConstant(e);
        if (result != null && result.isCompileTimeConstant()) {
            Object constantValue = result.getConstantValue();
            if (constantValue instanceof Boolean) {
                return (Boolean)constantValue;
            }
            return null;
        }
        return null;
    }

    final class DefiniteAssignmentNode
    extends ControlFlowNode {
        private int _index;
        private DefiniteAssignmentStatus _nodeStatus;

        public DefiniteAssignmentNode(Statement previousStatement, Statement nextStatement, ControlFlowNodeType type) {
            super(previousStatement, nextStatement, type);
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        public DefiniteAssignmentStatus getNodeStatus() {
            return this._nodeStatus;
        }

        public void setNodeStatus(DefiniteAssignmentStatus nodeStatus) {
            this._nodeStatus = nodeStatus;
        }

        public String toString() {
            return "[" + this._index + "] " + (Object)((Object)this._nodeStatus);
        }
    }

    final class DefiniteAssignmentVisitor
    extends DepthFirstAstVisitor<DefiniteAssignmentStatus, DefiniteAssignmentStatus> {
        DefiniteAssignmentVisitor() {
        }

        @Override
        protected DefiniteAssignmentStatus visitChildren(AstNode node, DefiniteAssignmentStatus data) {
            assert (data == DefiniteAssignmentAnalysis.this.cleanSpecialValues(data));
            DefiniteAssignmentStatus status = data;
            AstNode child = node.getFirstChild();
            while (child != null) {
                assert (!(child instanceof Statement));
                if (!(child instanceof TypeDeclaration)) {
                    status = child.acceptVisitor(this, status);
                    status = DefiniteAssignmentAnalysis.this.cleanSpecialValues(status);
                }
                child = child.getNextSibling();
            }
            return status;
        }

        @Override
        public DefiniteAssignmentStatus visitLabeledStatement(LabeledStatement node, DefiniteAssignmentStatus data) {
            return node.getStatement().acceptVisitor(this, data);
        }

        @Override
        public DefiniteAssignmentStatus visitBlockStatement(BlockStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitTypeDeclaration(TypeDeclaration node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitLocalTypeDeclarationStatement(LocalTypeDeclarationStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitVariableInitializer(VariableInitializer node, DefiniteAssignmentStatus data) {
            if (node.getInitializer().isNull()) {
                return data;
            }
            DefiniteAssignmentStatus status = node.getInitializer().acceptVisitor(this, data);
            if (StringUtilities.equals(DefiniteAssignmentAnalysis.this.variableName, node.getName())) {
                return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
            }
            return status;
        }

        @Override
        public DefiniteAssignmentStatus visitSwitchStatement(SwitchStatement node, DefiniteAssignmentStatus data) {
            return node.getExpression().acceptVisitor(this, data);
        }

        @Override
        public DefiniteAssignmentStatus visitDoWhileStatement(DoWhileStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitWhileStatement(WhileStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitForStatement(ForStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitTryCatchStatement(TryCatchStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitForEachStatement(ForEachStatement node, DefiniteAssignmentStatus data) {
            return data;
        }

        @Override
        public DefiniteAssignmentStatus visitSynchronizedStatement(SynchronizedStatement node, DefiniteAssignmentStatus data) {
            return node.getExpression().acceptVisitor(this, data);
        }

        @Override
        public DefiniteAssignmentStatus visitAssignmentExpression(AssignmentExpression node, DefiniteAssignmentStatus data) {
            if (node.getOperator() == AssignmentOperatorType.ASSIGN) {
                return this.handleAssignment(node.getLeft(), node.getRight(), data);
            }
            return this.visitChildren((AstNode)node, data);
        }

        @Override
        public DefiniteAssignmentStatus visitLambdaExpression(LambdaExpression node, DefiniteAssignmentStatus data) {
            if (node.getBody() instanceof Statement) {
                DefiniteAssignmentAnalysis.this.changeNodeStatus((DefiniteAssignmentNode)DefiniteAssignmentAnalysis.this.beginNodeMap.get(node.getBody()), data);
            } else {
                node.getBody().acceptVisitor(this, data);
            }
            return data;
        }

        final DefiniteAssignmentStatus handleAssignment(Expression left, Expression right, DefiniteAssignmentStatus initialStatus) {
            if (left instanceof IdentifierExpression) {
                IdentifierExpression identifier = (IdentifierExpression)left;
                if (StringUtilities.equals(DefiniteAssignmentAnalysis.this.variableName, identifier.getIdentifier())) {
                    if (right != null) {
                        right.acceptVisitor(this, initialStatus);
                    }
                    return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                }
            }
            DefiniteAssignmentStatus status = left.acceptVisitor(this, initialStatus);
            if (right != null) {
                status = right.acceptVisitor(this, status);
            }
            return DefiniteAssignmentAnalysis.this.cleanSpecialValues(status);
        }

        @Override
        public DefiniteAssignmentStatus visitParenthesizedExpression(ParenthesizedExpression node, DefiniteAssignmentStatus data) {
            return node.getExpression().acceptVisitor(DefiniteAssignmentAnalysis.this.visitor, data);
        }

        @Override
        public DefiniteAssignmentStatus visitBinaryOperatorExpression(BinaryOperatorExpression node, DefiniteAssignmentStatus data) {
            BinaryOperatorType operator = node.getOperator();
            if (operator == BinaryOperatorType.LOGICAL_AND) {
                Boolean condition = DefiniteAssignmentAnalysis.this.evaluateCondition(node.getLeft());
                if (Boolean.TRUE.equals(condition)) {
                    return node.getRight().acceptVisitor(this, data);
                }
                if (Boolean.FALSE.equals(condition)) {
                    return data;
                }
                DefiniteAssignmentStatus afterLeft = node.getLeft().acceptVisitor(this, data);
                DefiniteAssignmentStatus beforeRight = afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION ? DefiniteAssignmentStatus.DEFINITELY_ASSIGNED : (afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION ? DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED : afterLeft);
                DefiniteAssignmentStatus afterRight = node.getRight().acceptVisitor(this, beforeRight);
                if (afterLeft == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED) {
                    return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                }
                if (afterRight == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED && afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                    return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                }
                if (afterRight == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED || afterRight == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION;
                }
                if (afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION && afterRight == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION;
                }
                if (afterLeft == DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED && afterRight == DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED) {
                    return DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED;
                }
                return DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED;
            }
            if (operator == BinaryOperatorType.LOGICAL_OR) {
                Boolean condition = DefiniteAssignmentAnalysis.this.evaluateCondition(node.getLeft());
                if (Boolean.FALSE.equals(condition)) {
                    return node.getRight().acceptVisitor(this, data);
                }
                if (Boolean.TRUE.equals(condition)) {
                    return data;
                }
                DefiniteAssignmentStatus afterLeft = node.getLeft().acceptVisitor(this, data);
                DefiniteAssignmentStatus beforeRight = afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION ? DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED : (afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION ? DefiniteAssignmentStatus.DEFINITELY_ASSIGNED : afterLeft);
                DefiniteAssignmentStatus afterRight = node.getRight().acceptVisitor(this, beforeRight);
                if (afterLeft == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED) {
                    return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                }
                if (afterRight == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED && afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                    return DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                }
                if (afterRight == DefiniteAssignmentStatus.DEFINITELY_ASSIGNED || afterRight == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION;
                }
                if (afterLeft == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION && afterRight == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION;
                }
                if (afterLeft == DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED && afterRight == DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED) {
                    return DefiniteAssignmentStatus.DEFINITELY_NOT_ASSIGNED;
                }
                return DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED;
            }
            return this.visitChildren((AstNode)node, data);
        }

        @Override
        public DefiniteAssignmentStatus visitUnaryOperatorExpression(UnaryOperatorExpression node, DefiniteAssignmentStatus data) {
            if (node.getOperator() == UnaryOperatorType.NOT) {
                DefiniteAssignmentStatus status = node.getExpression().acceptVisitor(this, data);
                if (status == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION;
                }
                if (status == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                    return DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION;
                }
                return status;
            }
            return this.visitChildren((AstNode)node, data);
        }

        @Override
        public DefiniteAssignmentStatus visitConditionalExpression(ConditionalExpression node, DefiniteAssignmentStatus data) {
            DefiniteAssignmentStatus beforeFalse;
            DefiniteAssignmentStatus beforeTrue;
            Boolean condition = DefiniteAssignmentAnalysis.this.evaluateCondition(node.getCondition());
            if (Boolean.TRUE.equals(condition)) {
                return node.getTrueExpression().acceptVisitor(this, data);
            }
            if (Boolean.FALSE.equals(condition)) {
                return node.getFalseExpression().acceptVisitor(this, data);
            }
            DefiniteAssignmentStatus afterCondition = node.getCondition().acceptVisitor(this, data);
            if (afterCondition == DefiniteAssignmentStatus.ASSIGNED_AFTER_TRUE_EXPRESSION) {
                beforeTrue = DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
                beforeFalse = DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
            } else if (afterCondition == DefiniteAssignmentStatus.ASSIGNED_AFTER_FALSE_EXPRESSION) {
                beforeTrue = DefiniteAssignmentStatus.POTENTIALLY_ASSIGNED;
                beforeFalse = DefiniteAssignmentStatus.DEFINITELY_ASSIGNED;
            } else {
                beforeTrue = afterCondition;
                beforeFalse = afterCondition;
            }
            DefiniteAssignmentStatus afterTrue = node.getTrueExpression().acceptVisitor(this, beforeTrue);
            DefiniteAssignmentStatus afterFalse = node.getTrueExpression().acceptVisitor(this, beforeFalse);
            return DefiniteAssignmentAnalysis.this.mergeStatus(DefiniteAssignmentAnalysis.this.cleanSpecialValues(afterTrue), DefiniteAssignmentAnalysis.this.cleanSpecialValues(afterFalse));
        }

        @Override
        public DefiniteAssignmentStatus visitIdentifierExpression(IdentifierExpression node, DefiniteAssignmentStatus data) {
            if (data != DefiniteAssignmentStatus.DEFINITELY_ASSIGNED && StringUtilities.equals(node.getIdentifier(), DefiniteAssignmentAnalysis.this.variableName) && node.getTypeArguments().isEmpty()) {
                DefiniteAssignmentAnalysis.this.unassignedVariableUses.add(node);
            }
            return data;
        }
    }

    final class DerivedControlFlowGraphBuilder
    extends ControlFlowGraphBuilder {
        DerivedControlFlowGraphBuilder() {
        }

        @Override
        protected ControlFlowNode createNode(Statement previousStatement, Statement nextStatement, ControlFlowNodeType type) {
            return new DefiniteAssignmentNode(previousStatement, nextStatement, type);
        }
    }
}

