/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.decompiler.languages.java.ast.ArraySpecifier;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class ComposedType
extends AstType {
    public static final Role<ArraySpecifier> ARRAY_SPECIFIER_ROLE = new Role<ArraySpecifier>("ArraySpecifier", ArraySpecifier.class);

    public ComposedType() {
    }

    public ComposedType(AstType baseType) {
        this.setBaseType(baseType);
    }

    public final AstType getBaseType() {
        return this.getChildByRole(Roles.BASE_TYPE);
    }

    public final void setBaseType(AstType value) {
        this.setChildByRole(Roles.BASE_TYPE, value);
    }

    public final AstNodeCollection<ArraySpecifier> getArraySpecifiers() {
        return this.getChildrenByRole(ARRAY_SPECIFIER_ROLE);
    }

    @Override
    public TypeReference toTypeReference() {
        TypeReference typeReference = this.getBaseType().toTypeReference();
        ArraySpecifier specifier = this.getArraySpecifiers().firstOrNullObject();
        while (specifier != null) {
            typeReference = typeReference.makeArrayType();
            specifier = specifier.getNextSibling(ARRAY_SPECIFIER_ROLE);
        }
        return typeReference;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitComposedType(this, data);
    }

    @Override
    public AstType makeArrayType() {
        this.insertChildBefore(CollectionUtilities.firstOrDefault(this.getArraySpecifiers()), new ArraySpecifier(), ARRAY_SPECIFIER_ROLE);
        TypeReference typeReference = this.getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null) {
            this.putUserData(Keys.TYPE_REFERENCE, typeReference.makeArrayType());
        }
        return this;
    }

    @Override
    public String toString() {
        AstNodeCollection<ArraySpecifier> arraySpecifiers = this.getArraySpecifiers();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBaseType());
        for (ArraySpecifier arraySpecifier : arraySpecifiers) {
            sb.append(arraySpecifier);
        }
        return sb.toString();
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof ComposedType && this.getArraySpecifiers().matches(((ComposedType)other).getArraySpecifiers(), match);
    }
}

