/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.analysis;

import com.strobel.core.Comparer;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdge;
import com.strobel.decompiler.languages.java.analysis.ControlFlowEdgeType;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNode;
import com.strobel.decompiler.languages.java.analysis.ControlFlowNodeType;
import com.strobel.decompiler.languages.java.ast.AssertStatement;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.CaseLabel;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.DoWhileStatement;
import com.strobel.decompiler.languages.java.ast.EmptyStatement;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.ForEachStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.IfElseStatement;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.SynchronizedStatement;
import com.strobel.decompiler.languages.java.ast.ThrowStatement;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;

public class ControlFlowGraphBuilder {
    private Statement rootStatement;
    private Function<AstNode, ResolveResult> resolver;
    private ArrayList<ControlFlowNode> nodes;
    private HashMap<String, ControlFlowNode> labels;
    private ArrayList<ControlFlowNode> gotoStatements;
    private boolean _evaluateOnlyPrimitiveConstants;

    protected ControlFlowNode createNode(Statement previousStatement, Statement nextStatement, ControlFlowNodeType type) {
        return new ControlFlowNode(previousStatement, nextStatement, type);
    }

    protected ControlFlowNode createStartNode(Statement statement) {
        ControlFlowNode node = this.createNode(null, statement, ControlFlowNodeType.StartNode);
        this.nodes.add(node);
        return node;
    }

    protected ControlFlowNode createSpecialNode(Statement statement, ControlFlowNodeType type) {
        return this.createSpecialNode(statement, type, true);
    }

    protected ControlFlowNode createSpecialNode(Statement statement, ControlFlowNodeType type, boolean addNodeToList) {
        ControlFlowNode node = this.createNode(null, statement, type);
        if (addNodeToList) {
            this.nodes.add(node);
        }
        return node;
    }

    protected ControlFlowNode createEndNode(Statement statement) {
        return this.createEndNode(statement, true);
    }

    protected ControlFlowNode createEndNode(Statement statement, boolean addNodeToList) {
        Statement nextStatement = null;
        if (statement == this.rootStatement) {
            nextStatement = null;
        } else {
            AstNode next = statement;
            while ((next = next.getNextSibling()) != null && next.getRole() != statement.getRole()) {
            }
            if (next instanceof Statement) {
                nextStatement = (Statement)next;
            }
        }
        ControlFlowNodeType type = nextStatement != null ? ControlFlowNodeType.BetweenStatements : ControlFlowNodeType.EndNode;
        ControlFlowNode node = this.createNode(statement, nextStatement, type);
        if (addNodeToList) {
            this.nodes.add(node);
        }
        return node;
    }

    protected ControlFlowEdge createEdge(ControlFlowNode from, ControlFlowNode to, ControlFlowEdgeType type) {
        return new ControlFlowEdge(from, to, type);
    }

    public List<ControlFlowNode> buildControlFlowGraph(Statement statement, Function<AstNode, ResolveResult> resolver) {
        NodeCreationVisitor nodeCreationVisitor = new NodeCreationVisitor();
        try {
            this.nodes = new ArrayList();
            this.labels = new HashMap();
            this.gotoStatements = new ArrayList();
            this.rootStatement = statement;
            this.resolver = resolver;
            ControlFlowNode entryPoint = this.createStartNode(statement);
            statement.acceptVisitor(nodeCreationVisitor, entryPoint);
            for (ControlFlowNode gotoStatement : this.gotoStatements) {
                String label = gotoStatement.getNextStatement() instanceof BreakStatement ? ((BreakStatement)gotoStatement.getNextStatement()).getLabel() : (gotoStatement.getNextStatement() instanceof ContinueStatement ? ((ContinueStatement)gotoStatement.getNextStatement()).getLabel() : ((GotoStatement)gotoStatement.getNextStatement()).getLabel());
                ControlFlowNode labelNode = this.labels.get(label);
                if (labelNode == null) continue;
                nodeCreationVisitor.connect(gotoStatement, labelNode, ControlFlowEdgeType.Jump);
            }
            this.annotateLeaveEdgesWithTryFinallyBlocks();
            ArrayList<ControlFlowNode> arrayList = this.nodes;
            return arrayList;
        }
        finally {
            this.nodes = null;
            this.labels = null;
            this.gotoStatements = null;
            this.rootStatement = null;
            this.resolver = null;
        }
    }

    final void annotateLeaveEdgesWithTryFinallyBlocks() {
        for (ControlFlowNode n : this.nodes) {
            block1: for (ControlFlowEdge edge : n.getOutgoing()) {
                Statement targetStatement;
                if (edge.getType() != ControlFlowEdgeType.Jump) continue;
                Statement gotoStatement = edge.getFrom().getNextStatement();
                assert (gotoStatement instanceof GotoStatement || gotoStatement instanceof BreakStatement || gotoStatement instanceof ContinueStatement);
                Statement statement = targetStatement = edge.getTo().getPreviousStatement() != null ? edge.getTo().getPreviousStatement() : edge.getTo().getNextStatement();
                if (gotoStatement.getParent() == targetStatement.getParent()) continue;
                LinkedHashSet<TryCatchStatement> targetParentTryCatch = new LinkedHashSet<TryCatchStatement>();
                for (AstNode ancestor : targetStatement.getAncestors()) {
                    if (!(ancestor instanceof TryCatchStatement)) continue;
                    targetParentTryCatch.add((TryCatchStatement)ancestor);
                }
                AstNode node = gotoStatement.getParent();
                while (node != null) {
                    if (node instanceof TryCatchStatement) {
                        TryCatchStatement leftTryCatch = (TryCatchStatement)node;
                        if (targetParentTryCatch.contains(leftTryCatch)) continue block1;
                        if (!leftTryCatch.getFinallyBlock().isNull()) {
                            edge.AddJumpOutOfTryFinally(leftTryCatch);
                        }
                    }
                    node = node.getParent();
                }
            }
        }
    }

    public final boolean isEvaluateOnlyPrimitiveConstants() {
        return this._evaluateOnlyPrimitiveConstants;
    }

    public final void setEvaluateOnlyPrimitiveConstants(boolean evaluateOnlyPrimitiveConstants) {
        this._evaluateOnlyPrimitiveConstants = evaluateOnlyPrimitiveConstants;
    }

    protected ResolveResult evaluateConstant(Expression e) {
        if (this._evaluateOnlyPrimitiveConstants && !(e instanceof PrimitiveExpression) && !(e instanceof NullReferenceExpression)) {
            return null;
        }
        return this.resolver.apply(e);
    }

    private boolean areEqualConstants(ResolveResult c1, ResolveResult c2) {
        if (c1 == null || c2 == null || !c1.isCompileTimeConstant() || !c2.isCompileTimeConstant()) {
            return false;
        }
        return Comparer.equals(c1.getConstantValue(), c2.getConstantValue());
    }

    protected Boolean evaluateCondition(Expression e) {
        ResolveResult result = this.evaluateConstant(e);
        if (result != null && result.isCompileTimeConstant()) {
            Object constantValue = result.getConstantValue();
            if (constantValue instanceof Boolean) {
                return (Boolean)constantValue;
            }
            return null;
        }
        return null;
    }

    final class NodeCreationVisitor
    extends DepthFirstAstVisitor<ControlFlowNode, ControlFlowNode> {
        final Stack<ControlFlowNode> breakTargets = new Stack();
        final Stack<ControlFlowNode> continueTargets = new Stack();
        final Stack<ControlFlowNode> gotoTargets = new Stack();

        NodeCreationVisitor() {
        }

        final ControlFlowEdge connect(ControlFlowNode from, ControlFlowNode to) {
            return this.connect(from, to, ControlFlowEdgeType.Normal);
        }

        final ControlFlowEdge connect(ControlFlowNode from, ControlFlowNode to, ControlFlowEdgeType type) {
            ControlFlowEdge edge = ControlFlowGraphBuilder.this.createEdge(from, to, type);
            from.getOutgoing().add(edge);
            to.getIncoming().add(edge);
            return edge;
        }

        final ControlFlowNode createConnectedEndNode(Statement statement, ControlFlowNode from) {
            ControlFlowNode newNode = ControlFlowGraphBuilder.this.createEndNode(statement);
            this.connect(from, newNode);
            return newNode;
        }

        final ControlFlowNode handleStatementList(AstNodeCollection<Statement> statements, ControlFlowNode source) {
            ControlFlowNode childNode = null;
            for (Statement statement : statements) {
                if (childNode == null) {
                    childNode = ControlFlowGraphBuilder.this.createStartNode(statement);
                    if (source != null) {
                        this.connect(source, childNode);
                    }
                }
                assert (childNode.getNextStatement() == statement);
                childNode = statement.acceptVisitor(this, childNode);
                assert (childNode.getPreviousStatement() == statement);
            }
            return childNode != null ? childNode : source;
        }

        @Override
        protected ControlFlowNode visitChildren(AstNode node, ControlFlowNode data) {
            throw ContractUtils.unreachable();
        }

        @Override
        public ControlFlowNode visitBlockStatement(BlockStatement node, ControlFlowNode data) {
            ControlFlowNode childNode = this.handleStatementList(node.getStatements(), data);
            return this.createConnectedEndNode(node, childNode);
        }

        @Override
        public ControlFlowNode visitEmptyStatement(EmptyStatement node, ControlFlowNode data) {
            return this.createConnectedEndNode(node, data);
        }

        @Override
        public ControlFlowNode visitLabelStatement(LabelStatement node, ControlFlowNode data) {
            ControlFlowNode end = this.createConnectedEndNode(node, data);
            ControlFlowGraphBuilder.this.labels.put(node.getLabel(), end);
            return end;
        }

        @Override
        public ControlFlowNode visitLabeledStatement(LabeledStatement node, ControlFlowNode data) {
            ControlFlowNode end = this.createConnectedEndNode(node, data);
            ControlFlowGraphBuilder.this.labels.put(node.getLabel(), end);
            this.connect(end, node.getStatement().acceptVisitor(this, data));
            return end;
        }

        @Override
        public ControlFlowNode visitVariableDeclaration(VariableDeclarationStatement node, ControlFlowNode data) {
            return this.createConnectedEndNode(node, data);
        }

        @Override
        public ControlFlowNode visitExpressionStatement(ExpressionStatement node, ControlFlowNode data) {
            return this.createConnectedEndNode(node, data);
        }

        @Override
        public ControlFlowNode visitIfElseStatement(IfElseStatement node, ControlFlowNode data) {
            ControlFlowNode falseEnd;
            Boolean condition = ControlFlowGraphBuilder.this.evaluateCondition(node.getCondition());
            ControlFlowNode trueBegin = ControlFlowGraphBuilder.this.createStartNode(node.getTrueStatement());
            if (!Boolean.FALSE.equals(condition)) {
                this.connect(data, trueBegin, ControlFlowEdgeType.ConditionTrue);
            }
            ControlFlowNode trueEnd = node.getTrueStatement().acceptVisitor(this, trueBegin);
            if (node.getFalseStatement().isNull()) {
                falseEnd = null;
            } else {
                ControlFlowNode falseBegin = ControlFlowGraphBuilder.this.createStartNode(node.getFalseStatement());
                if (!Boolean.TRUE.equals(condition)) {
                    this.connect(data, falseBegin, ControlFlowEdgeType.ConditionFalse);
                }
                falseEnd = node.getFalseStatement().acceptVisitor(this, falseBegin);
            }
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node);
            if (trueEnd != null) {
                this.connect(trueEnd, end);
            }
            if (falseEnd != null) {
                this.connect(falseEnd, end);
            } else if (!Boolean.TRUE.equals(condition)) {
                this.connect(data, end, ControlFlowEdgeType.ConditionFalse);
            }
            return end;
        }

        @Override
        public ControlFlowNode visitAssertStatement(AssertStatement node, ControlFlowNode data) {
            return this.createConnectedEndNode(node, data);
        }

        @Override
        public ControlFlowNode visitSwitchStatement(SwitchStatement node, ControlFlowNode data) {
            ResolveResult constant = ControlFlowGraphBuilder.this.evaluateConstant(node.getExpression());
            SwitchSection defaultSection = null;
            SwitchSection sectionMatchedByConstant = null;
            for (SwitchSection section : node.getSwitchSections()) {
                for (CaseLabel label : section.getCaseLabels()) {
                    ResolveResult labelConstant;
                    if (label.getExpression().isNull()) {
                        defaultSection = section;
                        continue;
                    }
                    if (constant == null || !constant.isCompileTimeConstant() || !ControlFlowGraphBuilder.this.areEqualConstants(constant, labelConstant = ControlFlowGraphBuilder.this.evaluateConstant(label.getExpression()))) continue;
                    sectionMatchedByConstant = section;
                }
            }
            if (constant != null && constant.isCompileTimeConstant() && sectionMatchedByConstant == null) {
                sectionMatchedByConstant = defaultSection;
            }
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            this.breakTargets.push(end);
            for (SwitchSection section : node.getSwitchSections()) {
                assert (section != null);
                if (constant == null || !constant.isCompileTimeConstant() || section == sectionMatchedByConstant) {
                    this.handleStatementList(section.getStatements(), data);
                    continue;
                }
                this.handleStatementList(section.getStatements(), null);
            }
            this.breakTargets.pop();
            if (defaultSection == null || sectionMatchedByConstant == null) {
                this.connect(data, end);
            }
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        @Override
        public ControlFlowNode visitWhileStatement(WhileStatement node, ControlFlowNode data) {
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            ControlFlowNode conditionNode = ControlFlowGraphBuilder.this.createSpecialNode(node, ControlFlowNodeType.LoopCondition);
            this.breakTargets.push(end);
            this.continueTargets.push(conditionNode);
            this.connect(data, conditionNode);
            Boolean condition = ControlFlowGraphBuilder.this.evaluateCondition(node.getCondition());
            ControlFlowNode bodyStart = ControlFlowGraphBuilder.this.createStartNode(node.getEmbeddedStatement());
            if (!Boolean.FALSE.equals(condition)) {
                this.connect(conditionNode, bodyStart, ControlFlowEdgeType.ConditionTrue);
            }
            ControlFlowNode bodyEnd = node.getEmbeddedStatement().acceptVisitor(this, bodyStart);
            this.connect(bodyEnd, conditionNode);
            if (!Boolean.TRUE.equals(condition)) {
                this.connect(conditionNode, end, ControlFlowEdgeType.ConditionFalse);
            }
            this.breakTargets.pop();
            this.continueTargets.pop();
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        @Override
        public ControlFlowNode visitDoWhileStatement(DoWhileStatement node, ControlFlowNode data) {
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            ControlFlowNode conditionNode = ControlFlowGraphBuilder.this.createSpecialNode(node, ControlFlowNodeType.LoopCondition, false);
            this.breakTargets.push(end);
            this.continueTargets.push(conditionNode);
            ControlFlowNode bodyStart = ControlFlowGraphBuilder.this.createStartNode(node.getEmbeddedStatement());
            this.connect(data, bodyStart);
            ControlFlowNode bodyEnd = node.getEmbeddedStatement().acceptVisitor(this, bodyStart);
            this.connect(bodyEnd, conditionNode);
            Boolean condition = ControlFlowGraphBuilder.this.evaluateCondition(node.getCondition());
            if (!Boolean.FALSE.equals(condition)) {
                this.connect(conditionNode, bodyStart, ControlFlowEdgeType.ConditionTrue);
            }
            if (!Boolean.TRUE.equals(condition)) {
                this.connect(conditionNode, end, ControlFlowEdgeType.ConditionFalse);
            }
            this.breakTargets.pop();
            this.continueTargets.pop();
            ControlFlowGraphBuilder.this.nodes.add(conditionNode);
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        @Override
        public ControlFlowNode visitForStatement(ForStatement node, ControlFlowNode data) {
            Boolean condition;
            ControlFlowNode newData = this.handleStatementList(node.getInitializers(), data);
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            ControlFlowNode conditionNode = ControlFlowGraphBuilder.this.createSpecialNode(node, ControlFlowNodeType.LoopCondition);
            this.connect(newData, conditionNode);
            int iteratorStartNodeId = ControlFlowGraphBuilder.this.nodes.size();
            ControlFlowNode iteratorEnd = this.handleStatementList(node.getIterators(), null);
            ControlFlowNode iteratorStart = iteratorEnd != null ? (ControlFlowNode)ControlFlowGraphBuilder.this.nodes.get(iteratorStartNodeId) : conditionNode;
            this.breakTargets.push(end);
            this.continueTargets.push(iteratorStart);
            ControlFlowNode bodyStart = ControlFlowGraphBuilder.this.createStartNode(node.getEmbeddedStatement());
            ControlFlowNode bodyEnd = node.getEmbeddedStatement().acceptVisitor(this, bodyStart);
            if (bodyEnd != null) {
                this.connect(bodyEnd, iteratorStart);
            }
            this.breakTargets.pop();
            this.continueTargets.pop();
            Boolean bl = condition = node.getCondition().isNull() ? Boolean.TRUE : ControlFlowGraphBuilder.this.evaluateCondition(node.getCondition());
            if (!Boolean.FALSE.equals(condition)) {
                this.connect(conditionNode, bodyStart, ControlFlowEdgeType.ConditionTrue);
            }
            if (!Boolean.TRUE.equals(condition)) {
                this.connect(conditionNode, end, ControlFlowEdgeType.ConditionFalse);
            }
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        final ControlFlowNode handleEmbeddedStatement(Statement embeddedStatement, ControlFlowNode source) {
            if (embeddedStatement == null || embeddedStatement.isNull()) {
                return source;
            }
            ControlFlowNode bodyStart = ControlFlowGraphBuilder.this.createStartNode(embeddedStatement);
            if (source != null) {
                this.connect(source, bodyStart);
            }
            return embeddedStatement.acceptVisitor(this, bodyStart);
        }

        @Override
        public ControlFlowNode visitForEachStatement(ForEachStatement node, ControlFlowNode data) {
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            ControlFlowNode conditionNode = ControlFlowGraphBuilder.this.createSpecialNode(node, ControlFlowNodeType.LoopCondition);
            this.connect(data, conditionNode);
            this.breakTargets.push(end);
            this.continueTargets.push(conditionNode);
            ControlFlowNode bodyEnd = this.handleEmbeddedStatement(node.getEmbeddedStatement(), conditionNode);
            this.connect(bodyEnd, conditionNode);
            this.breakTargets.pop();
            this.continueTargets.pop();
            this.connect(conditionNode, end);
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        @Override
        public ControlFlowNode visitGotoStatement(GotoStatement node, ControlFlowNode data) {
            ControlFlowGraphBuilder.this.gotoStatements.add(data);
            return ControlFlowGraphBuilder.this.createEndNode(node);
        }

        @Override
        public ControlFlowNode visitBreakStatement(BreakStatement node, ControlFlowNode data) {
            if (!StringUtilities.isNullOrEmpty(node.getLabel())) {
                ControlFlowGraphBuilder.this.gotoStatements.add(data);
                return ControlFlowGraphBuilder.this.createEndNode(node);
            }
            if (!this.breakTargets.isEmpty()) {
                this.connect(data, this.breakTargets.peek(), ControlFlowEdgeType.Jump);
            }
            return ControlFlowGraphBuilder.this.createEndNode(node);
        }

        @Override
        public ControlFlowNode visitContinueStatement(ContinueStatement node, ControlFlowNode data) {
            if (!StringUtilities.isNullOrEmpty(node.getLabel())) {
                ControlFlowGraphBuilder.this.gotoStatements.add(data);
                return ControlFlowGraphBuilder.this.createEndNode(node);
            }
            if (!this.continueTargets.isEmpty()) {
                this.connect(data, this.continueTargets.peek(), ControlFlowEdgeType.Jump);
            }
            return ControlFlowGraphBuilder.this.createEndNode(node);
        }

        @Override
        public ControlFlowNode visitReturnStatement(ReturnStatement node, ControlFlowNode data) {
            return ControlFlowGraphBuilder.this.createEndNode(node);
        }

        @Override
        public ControlFlowNode visitThrowStatement(ThrowStatement node, ControlFlowNode data) {
            return ControlFlowGraphBuilder.this.createEndNode(node);
        }

        @Override
        public ControlFlowNode visitTryCatchStatement(TryCatchStatement node, ControlFlowNode data) {
            boolean hasFinally = !node.getFinallyBlock().isNull();
            ControlFlowNode end = ControlFlowGraphBuilder.this.createEndNode(node, false);
            ControlFlowEdge edge = this.connect(this.handleEmbeddedStatement(node.getTryBlock(), data), end);
            if (hasFinally) {
                edge.AddJumpOutOfTryFinally(node);
            }
            for (CatchClause cc : node.getCatchClauses()) {
                edge = this.connect(this.handleEmbeddedStatement(cc.getBody(), data), end);
                if (!hasFinally) continue;
                edge.AddJumpOutOfTryFinally(node);
            }
            if (hasFinally) {
                this.handleEmbeddedStatement(node.getFinallyBlock(), data);
            }
            ControlFlowGraphBuilder.this.nodes.add(end);
            return end;
        }

        @Override
        public ControlFlowNode visitSynchronizedStatement(SynchronizedStatement node, ControlFlowNode data) {
            ControlFlowNode bodyEnd = this.handleEmbeddedStatement(node.getEmbeddedStatement(), data);
            return this.createConnectedEndNode(node, bodyEnd);
        }
    }
}

