/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.CoreMetadataFactory;
import com.strobel.assembler.metadata.DefaultTypeVisitor;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.IGenericParameterProvider;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodHandle;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.TypeSubstitutionVisitor;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringComparison;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Condition;
import com.strobel.decompiler.ast.DefaultMap;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Lambda;
import com.strobel.decompiler.ast.Loop;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Variable;
import com.strobel.functions.Supplier;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class TypeAnalysis {
    private static final int FLAG_BOOLEAN_PROHIBITED = 1;
    private final List<ExpressionToInfer> _allExpressions = new ArrayList<ExpressionToInfer>();
    private final Set<Variable> _singleStoreVariables = new LinkedHashSet<Variable>();
    private final Set<Variable> _singleLoadVariables = new LinkedHashSet<Variable>();
    private final Set<Variable> _allVariables = new LinkedHashSet<Variable>();
    private final Map<Variable, List<ExpressionToInfer>> _assignmentExpressions = new LinkedHashMap<Variable, List<ExpressionToInfer>>(){

        @Override
        public List<ExpressionToInfer> get(Object key) {
            ArrayList value = (ArrayList)super.get(key);
            if (value == null) {
                if (TypeAnalysis.this._doneInitializing) {
                    return Collections.emptyList();
                }
                value = new ArrayList();
                this.put((Variable)key, value);
            }
            return value;
        }
    };
    private final Map<Variable, Set<TypeReference>> _previouslyInferred = new DefaultMap(CollectionUtilities.setFactory());
    private final IdentityHashMap<Variable, TypeReference> _inferredVariableTypes = new IdentityHashMap();
    private final Stack<Expression> _stack = new Stack();
    private DecompilerContext _context;
    private CoreMetadataFactory _factory;
    private boolean _preserveMetadataTypes;
    private boolean _preserveMetadataGenericTypes;
    private boolean _doneInitializing;

    public static void run(DecompilerContext context, Block method) {
        TypeAnalysis ta = new TypeAnalysis();
        Object localVariableTable = SourceAttribute.find("LocalVariableTable", context.getCurrentMethod().getSourceAttributes());
        Object localVariableTypeTable = SourceAttribute.find("LocalVariableTypeTable", context.getCurrentMethod().getSourceAttributes());
        ta._context = context;
        ta._factory = CoreMetadataFactory.make(context.getCurrentType(), (IGenericContext)context.getCurrentMethod());
        ta._preserveMetadataTypes = localVariableTable != null;
        ta._preserveMetadataGenericTypes = localVariableTypeTable != null;
        ta.createDependencyGraph(method);
        ta.identifySingleLoadVariables();
        ta._doneInitializing = true;
        ta.runInference();
    }

    public static void reset(DecompilerContext context, Block method) {
        Object localVariableTable = SourceAttribute.find("LocalVariableTable", context.getCurrentMethod().getSourceAttributes());
        Object localVariableTypeTable = SourceAttribute.find("LocalVariableTypeTable", context.getCurrentMethod().getSourceAttributes());
        boolean preserveTypesFromMetadata = localVariableTable != null;
        boolean preserveGenericTypesFromMetadata = localVariableTypeTable != null;
        for (Expression e : method.getSelfAndChildrenRecursive(Expression.class)) {
            Variable variable;
            e.setInferredType(null);
            e.setExpectedType(null);
            Object operand = e.getOperand();
            if (!(operand instanceof Variable) || !TypeAnalysis.shouldResetVariableType(variable = (Variable)operand, preserveTypesFromMetadata, preserveGenericTypesFromMetadata)) continue;
            variable.setType(null);
        }
    }

    private void createDependencyGraph(Node node) {
        block5: {
            block8: {
                ExpressionToInfer expressionToInfer;
                Expression expression;
                block9: {
                    block7: {
                        block6: {
                            block4: {
                                if (!(node instanceof Condition)) break block4;
                                ((Condition)node).getCondition().setExpectedType(BuiltinTypes.Boolean);
                                break block5;
                            }
                            if (!(node instanceof Loop) || ((Loop)node).getCondition() == null) break block6;
                            ((Loop)node).getCondition().setExpectedType(BuiltinTypes.Boolean);
                            break block5;
                        }
                        if (!(node instanceof CatchBlock)) break block7;
                        CatchBlock catchBlock = (CatchBlock)node;
                        if (catchBlock.getExceptionVariable() != null && catchBlock.getExceptionType() != null && catchBlock.getExceptionVariable().getType() == null) {
                            catchBlock.getExceptionVariable().setType(catchBlock.getExceptionType());
                        }
                        break block5;
                    }
                    if (!(node instanceof Expression)) break block8;
                    expression = (Expression)node;
                    expressionToInfer = new ExpressionToInfer();
                    expressionToInfer.expression = expression;
                    this._allExpressions.add(expressionToInfer);
                    this.findNestedAssignments(expression, expressionToInfer);
                    if (!expression.getCode().isStore()) break block5;
                    if (!(expression.getOperand() instanceof Variable) || !this.shouldInferVariableType((Variable)expression.getOperand())) break block9;
                    this._assignmentExpressions.get(expression.getOperand()).add(expressionToInfer);
                    this._allVariables.add((Variable)expression.getOperand());
                    break block5;
                }
                StrongBox<Variable> v = new StrongBox<Variable>();
                if (!PatternMatching.matchLoad((Node)expression.getArguments().get(0), v) || !this.shouldInferVariableType((Variable)v.value)) break block5;
                this._assignmentExpressions.get(v.value).add(expressionToInfer);
                this._allVariables.add((Variable)v.value);
                break block5;
            }
            if (node instanceof Lambda) {
                Lambda lambda = (Lambda)node;
                List<Variable> parameters = lambda.getParameters();
                for (Variable parameter : parameters) {
                    this._assignmentExpressions.get(parameter);
                }
            }
        }
        for (Node child : node.getChildren()) {
            this.createDependencyGraph(child);
        }
    }

    private void findNestedAssignments(Expression expression, ExpressionToInfer parent) {
        for (Expression argument : expression.getArguments()) {
            Variable variable;
            ExpressionToInfer expressionToInfer;
            Object operand = argument.getOperand();
            if (operand instanceof Variable) {
                this._allVariables.add((Variable)operand);
            }
            if (argument.getCode() == AstCode.Store) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                variable = (Variable)operand;
                if (this.shouldInferVariableType(variable)) {
                    this._assignmentExpressions.get(variable).add(expressionToInfer);
                    this._allVariables.add(variable);
                    parent.dependencies.add(variable);
                }
            } else if (argument.getCode() == AstCode.Inc) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                variable = (Variable)operand;
                if (this.shouldInferVariableType(variable)) {
                    this._assignmentExpressions.get(variable).add(expressionToInfer);
                    this._allVariables.add(variable);
                    parent.dependencies.add(variable);
                }
            } else if (argument.getCode() == AstCode.PreIncrement || argument.getCode() == AstCode.PostIncrement) {
                expressionToInfer = new ExpressionToInfer();
                expressionToInfer.expression = argument;
                this._allExpressions.add(expressionToInfer);
                Expression load = CollectionUtilities.firstOrDefault(argument.getArguments());
                StrongBox<Variable> variable2 = new StrongBox<Variable>();
                if (load != null && PatternMatching.matchLoadOrRet(load, variable2) && this.shouldInferVariableType((Variable)variable2.value)) {
                    this._assignmentExpressions.get(variable2.value).add(expressionToInfer);
                    this._allVariables.add((Variable)variable2.value);
                    parent.dependencies.add((Variable)variable2.value);
                }
            } else {
                StrongBox<Variable> variable3 = new StrongBox<Variable>();
                if (PatternMatching.matchLoadOrRet(argument, variable3) && this.shouldInferVariableType((Variable)variable3.value)) {
                    parent.dependencies.add((Variable)variable3.value);
                    this._allVariables.add((Variable)variable3.value);
                }
            }
            this.findNestedAssignments(argument, parent);
        }
    }

    private boolean isSingleStoreBoolean(Variable variable) {
        if (this._singleStoreVariables.contains(variable)) {
            List<ExpressionToInfer> assignments = this._assignmentExpressions.get(variable);
            ExpressionToInfer e = CollectionUtilities.single(assignments);
            return PatternMatching.matchBooleanConstant(CollectionUtilities.last(e.expression.getArguments())) != null;
        }
        return false;
    }

    private void identifySingleLoadVariables() {
        DefaultMap groupedExpressions = new DefaultMap(new Supplier<List<ExpressionToInfer>>(){

            @Override
            public List<ExpressionToInfer> get() {
                return new ArrayList<ExpressionToInfer>();
            }
        });
        for (ExpressionToInfer expressionToInfer : this._allExpressions) {
            for (Variable variable : expressionToInfer.dependencies) {
                ((List)groupedExpressions.get(variable)).add(expressionToInfer);
            }
        }
        for (Variable variable : groupedExpressions.keySet()) {
            List expressions = (List)groupedExpressions.get(variable);
            if (expressions.size() != 1) continue;
            int references = 0;
            for (Expression expression : ((ExpressionToInfer)expressions.get((int)0)).expression.getSelfAndChildrenRecursive(Expression.class)) {
                if (expression.getOperand() == variable && ++references > 1) break;
            }
            if (references != true) continue;
            this._singleLoadVariables.add(variable);
            for (ExpressionToInfer assignment : this._assignmentExpressions.get(variable)) {
                assignment.dependsOnSingleLoad = variable;
            }
        }
        for (Variable variable : this._assignmentExpressions.keySet()) {
            if (this._assignmentExpressions.get(variable).size() != 1) continue;
            this._singleStoreVariables.add(variable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runInference() {
        this._previouslyInferred.clear();
        this._inferredVariableTypes.clear();
        int numberOfExpressionsAlreadyInferred = 0;
        boolean ignoreSingleLoadDependencies = false;
        boolean assignVariableTypesBasedOnPartialInformation = false;
        Predicate<Variable> dependentVariableTypesKnown = new Predicate<Variable>(){

            @Override
            public boolean test(Variable v) {
                return TypeAnalysis.this.inferTypeForVariable(v, null) != null || TypeAnalysis.this._singleLoadVariables.contains(v);
            }
        };
        while (numberOfExpressionsAlreadyInferred < this._allExpressions.size()) {
            block6: {
                int oldCount = numberOfExpressionsAlreadyInferred;
                for (ExpressionToInfer e : this._allExpressions) {
                    if (e.done || !TypeAnalysis.trueForAll(e.dependencies, dependentVariableTypesKnown) || e.dependsOnSingleLoad != null && e.dependsOnSingleLoad.getType() == null && !ignoreSingleLoadDependencies) continue;
                    this.runInference(e.expression);
                    e.done = true;
                    ++numberOfExpressionsAlreadyInferred;
                }
                if (numberOfExpressionsAlreadyInferred == oldCount) {
                    if (ignoreSingleLoadDependencies) {
                        if (assignVariableTypesBasedOnPartialInformation) {
                            throw new IllegalStateException("Could not infer any expression.");
                        }
                        assignVariableTypesBasedOnPartialInformation = true;
                        break block6;
                    } else {
                        ignoreSingleLoadDependencies = true;
                        continue;
                    }
                }
                assignVariableTypesBasedOnPartialInformation = false;
                ignoreSingleLoadDependencies = false;
            }
            this.inferTypesForVariables(assignVariableTypesBasedOnPartialInformation);
        }
        this.verifyResults();
    }

    private void verifyResults() {
        StrongBox<Expression> a = new StrongBox<Expression>();
        for (Variable variable : this._allVariables) {
            TypeReference type = variable.getType();
            if (type == null || type == BuiltinTypes.Null) {
                TypeReference inferredType = this.inferTypeForVariable(variable, BuiltinTypes.Object);
                if (inferredType == null || inferredType == BuiltinTypes.Null) {
                    variable.setType(BuiltinTypes.Object);
                    continue;
                }
                variable.setType(inferredType);
                continue;
            }
            if (type.isWildcardType()) {
                variable.setType(MetadataHelper.getUpperBound(type));
                continue;
            }
            if (type.getSimpleType() == JvmType.Boolean) {
                for (ExpressionToInfer e : this._assignmentExpressions.get(variable)) {
                    Boolean booleanConstant;
                    if (!PatternMatching.matchStore((Node)e.expression, variable, a) || (booleanConstant = PatternMatching.matchBooleanConstant((Node)a.value)) == null) continue;
                    e.expression.setExpectedType(BuiltinTypes.Boolean);
                    e.expression.setInferredType(BuiltinTypes.Boolean);
                    ((Expression)a.value).setExpectedType(BuiltinTypes.Boolean);
                    ((Expression)a.value).setInferredType(BuiltinTypes.Boolean);
                }
                continue;
            }
            if (type.getSimpleType() != JvmType.Character) continue;
            for (ExpressionToInfer e : this._assignmentExpressions.get(variable)) {
                Character characterConstant;
                if (!PatternMatching.matchStore((Node)e.expression, variable, a) || (characterConstant = PatternMatching.matchCharacterConstant((Node)a.value)) == null) continue;
                e.expression.setExpectedType(BuiltinTypes.Character);
                e.expression.setInferredType(BuiltinTypes.Character);
                ((Expression)a.value).setExpectedType(BuiltinTypes.Character);
                ((Expression)a.value).setInferredType(BuiltinTypes.Character);
            }
        }
    }

    private void inferTypesForVariables(boolean assignVariableTypesBasedOnPartialInformation) {
        for (Variable variable : this._allVariables) {
            List<ExpressionToInfer> expressionsToInfer = this._assignmentExpressions.get(variable);
            boolean inferredFromNull = false;
            TypeReference inferredType = null;
            if (variable.isLambdaParameter()) {
                inferredType = this._inferredVariableTypes.get(variable);
                if (inferredType == null) {
                    continue;
                }
            } else {
                if (expressionsToInfer.isEmpty() || !(assignVariableTypesBasedOnPartialInformation ? this.anyDone(expressionsToInfer) : this.allDone(expressionsToInfer))) continue;
                for (ExpressionToInfer e : expressionsToInfer) {
                    List<Expression> arguments = e.expression.getArguments();
                    assert (e.expression.getCode().isStore() && arguments.size() == 1 || e.expression.getCode() == AstCode.Inc || e.expression.getCode() == AstCode.PreIncrement || e.expression.getCode() == AstCode.PostIncrement);
                    Expression assignedValue = arguments.get(0);
                    if (assignedValue.getInferredType() == null) continue;
                    if (inferredType == null) {
                        inferredType = TypeAnalysis.adjustType(assignedValue.getInferredType(), e.flags);
                        inferredFromNull = PatternMatching.match(assignedValue, AstCode.AConstNull);
                        continue;
                    }
                    TypeReference assigned = this.cleanTypeArguments(assignedValue.getInferredType(), inferredType);
                    TypeReference commonSuper = TypeAnalysis.adjustType(this.typeWithMoreInformation(inferredType, assigned), e.flags);
                    if (inferredFromNull && assigned != BuiltinTypes.Null && !MetadataHelper.isAssignableFrom(commonSuper, assigned)) {
                        TypeReference asSubType = MetadataHelper.asSubType(commonSuper, assigned);
                        inferredType = asSubType != null ? asSubType : assigned;
                        inferredFromNull = false;
                        continue;
                    }
                    inferredType = commonSuper;
                }
            }
            if (inferredType == null) {
                inferredType = variable.getType();
            } else if (!inferredType.isUnbounded()) {
                TypeReference typeReference = inferredType = inferredType.hasSuperBound() ? inferredType.getSuperBound() : inferredType.getExtendsBound();
            }
            if (!this.shouldInferVariableType(variable) || inferredType == null) continue;
            variable.setType(inferredType);
            this._inferredVariableTypes.put(variable, inferredType);
            for (ExpressionToInfer e : this._allExpressions) {
                if (!e.dependencies.contains(variable) && !expressionsToInfer.contains(e) || this._stack.contains(e.expression)) continue;
                boolean invalidate = false;
                for (Expression c : e.expression.getSelfAndChildrenRecursive(Expression.class)) {
                    if (this._stack.contains(c)) continue;
                    c.setExpectedType(null);
                    if ((PatternMatching.matchLoad((Node)c, variable) || PatternMatching.matchStore(c, variable)) && !MetadataHelper.isSameType(c.getInferredType(), inferredType)) {
                        c.setExpectedType(inferredType);
                    }
                    c.setInferredType(null);
                    invalidate = true;
                }
                if (!invalidate) continue;
                this.runInference(e.expression, e.flags);
            }
        }
    }

    private boolean shouldInferVariableType(Variable variable) {
        VariableDefinition variableDefinition = variable.getOriginalVariable();
        if (variable.isGenerated() || variable.isLambdaParameter()) {
            return true;
        }
        ParameterDefinition parameter = variable.getOriginalParameter();
        if (parameter != null) {
            if (parameter == this._context.getCurrentMethod().getBody().getThisParameter()) {
                return false;
            }
            TypeReference parameterType = parameter.getParameterType();
            return !this._preserveMetadataGenericTypes && (parameterType.isGenericType() || MetadataHelper.isRawType(parameterType));
        }
        return variableDefinition == null || !variableDefinition.isFromMetadata() || !(variableDefinition.getVariableType().isGenericType() ? this._preserveMetadataGenericTypes : this._preserveMetadataTypes);
    }

    private static boolean shouldResetVariableType(Variable variable, boolean preserveTypesFromMetadata, boolean preserveGenericTypesFromMetadata) {
        if (variable.isGenerated() || variable.isLambdaParameter()) {
            return true;
        }
        VariableDefinition variableDefinition = variable.getOriginalVariable();
        if (variableDefinition != null && variableDefinition.isFromMetadata() && (variableDefinition.getVariableType().isGenericType() ? preserveGenericTypesFromMetadata : preserveTypesFromMetadata)) {
            return false;
        }
        return variableDefinition != null && variableDefinition.getVariableType() == BuiltinTypes.Integer || variableDefinition != null && !variableDefinition.isTypeKnown();
    }

    private void runInference(Expression expression) {
        this.runInference(expression, 0);
    }

    private void runInference(Expression expression, int flags) {
        Variable variable;
        List<Expression> arguments = expression.getArguments();
        Variable changedVariable = null;
        boolean anyArgumentIsMissingExpectedType = false;
        for (Expression argument : arguments) {
            if (argument.getExpectedType() != null) continue;
            anyArgumentIsMissingExpectedType = true;
            break;
        }
        if (expression.getInferredType() == null || anyArgumentIsMissingExpectedType) {
            this.inferTypeForExpression(expression, expression.getExpectedType(), anyArgumentIsMissingExpectedType, flags);
        } else if (expression.getInferredType() == BuiltinTypes.Integer && expression.getExpectedType() == BuiltinTypes.Boolean) {
            if (expression.getCode() == AstCode.Load || expression.getCode() == AstCode.Store) {
                variable = (Variable)expression.getOperand();
                expression.setInferredType(BuiltinTypes.Boolean);
                if (variable.getType() == BuiltinTypes.Integer && this.shouldInferVariableType(variable)) {
                    variable.setType(BuiltinTypes.Boolean);
                    changedVariable = variable;
                }
            }
        } else if (expression.getInferredType() == BuiltinTypes.Integer && expression.getExpectedType() == BuiltinTypes.Character && (expression.getCode() == AstCode.Load || expression.getCode() == AstCode.Store)) {
            variable = (Variable)expression.getOperand();
            expression.setInferredType(BuiltinTypes.Character);
            if (variable.getType() == BuiltinTypes.Integer && this.shouldInferVariableType(variable) && this._singleLoadVariables.contains(variable)) {
                variable.setType(BuiltinTypes.Character);
                changedVariable = variable;
            }
        }
        for (Expression argument : arguments) {
            if (argument.getCode().isStore()) continue;
            this.runInference(argument, flags);
        }
        if (changedVariable != null && this._previouslyInferred.get(changedVariable).add(changedVariable.getType())) {
            this.invalidateDependentExpressions(expression, changedVariable);
        }
    }

    private void invalidateDependentExpressions(Expression expression, Variable variable) {
        List<ExpressionToInfer> assignments = this._assignmentExpressions.get(variable);
        TypeReference inferredType = this._inferredVariableTypes.get(variable);
        for (ExpressionToInfer e : this._allExpressions) {
            if (e.expression == expression || !e.dependencies.contains(variable) && !assignments.contains(e) || this._stack.contains(e.expression)) continue;
            boolean invalidate = false;
            for (Expression c : e.expression.getSelfAndChildrenRecursive(Expression.class)) {
                if (this._stack.contains(c)) continue;
                c.setExpectedType(null);
                if ((PatternMatching.matchLoad((Node)c, variable) || PatternMatching.matchStore(c, variable)) && !MetadataHelper.isSameType(c.getInferredType(), inferredType)) {
                    c.setExpectedType(inferredType);
                }
                c.setInferredType(null);
                invalidate = true;
            }
            if (!invalidate) continue;
            this.runInference(e.expression, e.flags);
        }
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType) {
        return this.inferTypeForExpression(expression, expectedType, 0);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, int flags) {
        return this.inferTypeForExpression(expression, expectedType, false, flags);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        return this.inferTypeForExpression(expression, expectedType, forceInferChildren, 0);
    }

    private TypeReference inferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren, int flags) {
        boolean actualForceInferChildren = forceInferChildren;
        if (expectedType != null && !this.isSameType(expression.getExpectedType(), expectedType)) {
            expression.setExpectedType(expectedType);
            if (!expression.getCode().isStore()) {
                actualForceInferChildren = true;
            }
        }
        if (actualForceInferChildren || expression.getInferredType() == null) {
            expression.setInferredType(this.doInferTypeForExpression(expression, expectedType, actualForceInferChildren, flags));
        }
        return expression.getInferredType();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TypeReference doInferTypeForExpression(Expression expression, TypeReference expectedType, boolean forceInferChildren, int flags) {
        block266: {
            block264: {
                block265: {
                    if (this._stack.contains(expression) && !PatternMatching.match(expression, AstCode.LdC)) {
                        return expectedType;
                    }
                    this._stack.push(expression);
                    code = expression.getCode();
                    operand = expression.getOperand();
                    arguments = expression.getArguments();
                    switch (TypeAnalysis.$SWITCH_TABLE$com$strobel$decompiler$ast$AstCode()[code.ordinal()]) {
                        case 245: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                            }
                            var30_8 = BuiltinTypes.Boolean;
                            return var30_8;
                        }
                        case 246: 
                        case 247: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                                this.inferTypeForExpression(arguments.get(1), BuiltinTypes.Boolean);
                            }
                            var30_9 = BuiltinTypes.Boolean;
                            return var30_9;
                        }
                        case 253: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Boolean);
                            }
                            var30_10 = this.inferBinaryArguments(arguments.get(1), arguments.get(2), expectedType, forceInferChildren, null, null, 0);
                            return var30_10;
                        }
                        case 195: 
                        case 196: {
                            return null;
                        }
                        case 218: {
                            v = (Variable)operand;
                            lastInferredType = this._inferredVariableTypes.get(v);
                            if (PatternMatching.matchBooleanConstant(expression.getArguments().get(0)) != null && this.shouldInferVariableType(v) && TypeAnalysis.isBoolean(this.inferTypeForVariable(v, expectedType != null ? expectedType : BuiltinTypes.Boolean, true, flags))) {
                                var30_11 = BuiltinTypes.Boolean;
                                return var30_11;
                            }
                            if (forceInferChildren || lastInferredType == null && v.getType() == null) {
                                inferredType = this.inferTypeForExpression(expression.getArguments().get(0), this.inferTypeForVariable(v, null, flags), flags);
                                if (inferredType != null && inferredType.isWildcardType()) {
                                    inferredType = MetadataHelper.getUpperBound(inferredType);
                                }
                                if (inferredType != null) {
                                    var30_12 = TypeAnalysis.adjustType(inferredType, flags);
                                    return var30_12;
                                }
                            }
                            var30_13 = TypeAnalysis.adjustType(lastInferredType != null ? lastInferredType : v.getType(), flags);
                            return var30_13;
                        }
                        case 217: {
                            v = (Variable)expression.getOperand();
                            inferredType = this.inferTypeForVariable(v, expectedType, flags);
                            thisType = this._context.getCurrentType();
                            if (v.isParameter() && v.getOriginalParameter() == this._context.getCurrentMethod().getBody().getThisParameter()) {
                                if (this._singleLoadVariables.contains(v) && v.getType() == null) {
                                    v.setType(thisType);
                                }
                                var30_14 = thisType;
                                return var30_14;
                            }
                            result = inferredType;
                            if (expectedType != null && expectedType != BuiltinTypes.Null && this.shouldInferVariableType(v)) {
                                tempResult = MetadataHelper.isSubType(inferredType, expectedType) != false ? inferredType : MetadataHelper.asSubType(inferredType, expectedType);
                                if (tempResult != null && tempResult.containsGenericParameters()) {
                                    mappings = MetadataHelper.adapt(tempResult, inferredType);
                                    mappingsToRemove = null;
                                    var16_137 = mappings.keySet().iterator();
                                    while (true) {
                                        if (!var16_137.hasNext()) {
                                            if (mappingsToRemove != null) {
                                                mappings.keySet().removeAll(mappingsToRemove);
                                            }
                                            if (mappings.isEmpty()) break;
                                            tempResult = TypeSubstitutionVisitor.instance().visit(tempResult, mappings);
                                            break;
                                        }
                                        key = var16_137.next();
                                        gp = this._context.getCurrentMethod().findTypeVariable(key.getSimpleName());
                                        if (!MetadataHelper.isSameType(gp, key, true)) continue;
                                        if (mappingsToRemove == null) {
                                            mappingsToRemove = new ArrayList<TypeReference>();
                                        }
                                        mappingsToRemove.add(key);
                                    }
                                }
                                if (tempResult == null && v.getType() != null && (tempResult = MetadataHelper.asSubType(v.getType(), expectedType)) == null) {
                                    tempResult = MetadataHelper.asSubType(MetadataHelper.eraseRecursive(v.getType()), expectedType);
                                }
                                if (tempResult == null) {
                                    tempResult = expectedType;
                                }
                                if ((result = tempResult).isGenericType()) {
                                    if (expectedType.isGenericDefinition() && !result.isGenericDefinition()) {
                                        result = result.getUnderlyingType();
                                    }
                                    if (MetadataHelper.areGenericsSupported(thisType) && MetadataHelper.getUnboundGenericParameterCount(result) > 0) {
                                        result = MetadataHelper.substituteGenericArguments(result, inferredType);
                                    }
                                }
                                if (result.isGenericDefinition() && !MetadataHelper.canReferenceTypeVariablesOf(result, this._context.getCurrentType())) {
                                    result = new RawType(result.getUnderlyingType());
                                }
                            }
                            assignments = this._assignmentExpressions.get(v);
                            if (result == null && assignments.isEmpty()) {
                                result = BuiltinTypes.Object;
                            }
                            if (result != null && result.isWildcardType()) {
                                result = MetadataHelper.getUpperBound(result);
                            }
                            result = TypeAnalysis.adjustType(result, flags);
                            if (flags != 0) {
                                i = 0;
                                while (i < assignments.size()) {
                                    assignments.get((int)i).flags |= flags;
                                    ++i;
                                }
                            }
                            this._inferredVariableTypes.put(v, result);
                            if (result != null && !MetadataHelper.isSameType(result, inferredType) && this._previouslyInferred.get(v).add(result)) {
                                expression.setInferredType(result);
                                this.invalidateDependentExpressions(expression, v);
                            }
                            if (this._singleLoadVariables.contains(v) && v.getType() == null) {
                                v.setType(result);
                            }
                            var30_15 = result;
                            return var30_15;
                        }
                        case 187: {
                            var30_16 = this.inferDynamicCall(expression, expectedType, forceInferChildren);
                            return var30_16;
                        }
                        case 183: 
                        case 184: 
                        case 185: 
                        case 186: {
                            var30_17 = this.inferCall(expression, expectedType, forceInferChildren);
                            return var30_17;
                        }
                        case 181: {
                            field = (FieldReference)operand;
                            if (forceInferChildren) {
                                resolvedField = field.resolve();
                                effectiveField /* !! */  = resolvedField != null ? resolvedField : field;
                                targetType = this.inferTypeForExpression(arguments.get(0), field.getDeclaringType());
                                if (targetType != null) {
                                    asMember = MetadataHelper.asMemberOf(effectiveField /* !! */ , targetType);
                                    var30_18 = asMember.getFieldType();
                                    return var30_18;
                                }
                            }
                            var30_19 = TypeAnalysis.getFieldType((FieldReference)operand);
                            return var30_19;
                        }
                        case 179: {
                            var30_20 = TypeAnalysis.getFieldType((FieldReference)operand);
                            return var30_20;
                        }
                        case 182: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), ((FieldReference)operand).getDeclaringType());
                                this.inferTypeForExpression(arguments.get(1), TypeAnalysis.getFieldType((FieldReference)operand));
                            }
                            var30_21 = TypeAnalysis.getFieldType((FieldReference)operand);
                            return var30_21;
                        }
                        case 180: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), TypeAnalysis.getFieldType((FieldReference)operand));
                            }
                            var30_22 = TypeAnalysis.getFieldType((FieldReference)operand);
                            return var30_22;
                        }
                        case 188: {
                            var30_23 = (TypeReference)operand;
                            return var30_23;
                        }
                        case 257: 
                        case 258: {
                            inferredType = this.inferTypeForExpression(arguments.get(0), null, flags | 1);
                            if (inferredType != null && inferredType != BuiltinTypes.Boolean) {
                                var30_26 = inferredType;
                                return var30_26;
                            }
                            n = (Number)operand;
                            if (n instanceof Long) {
                                var30_24 = BuiltinTypes.Long;
                                return var30_24;
                            }
                            var30_25 = BuiltinTypes.Integer;
                            return var30_25;
                        }
                        case 226: 
                        case 232: {
                            var30_27 = this.inferTypeForExpression(arguments.get(0), expectedType);
                            return var30_27;
                        }
                        case 221: 
                        case 222: 
                        case 223: 
                        case 224: 
                        case 225: 
                        case 230: 
                        case 231: 
                        case 233: {
                            var30_28 = this.inferBinaryExpression(code, arguments, flags);
                            return var30_28;
                        }
                        case 227: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                            }
                            if (expectedType != null && (expectedType.getSimpleType() == JvmType.Integer || expectedType.getSimpleType() == JvmType.Long)) {
                                var30_29 = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), expectedType, flags | 1));
                                return var30_29;
                            }
                            var30_30 = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), null, flags | 1));
                            return var30_30;
                        }
                        case 228: 
                        case 229: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                            }
                            if ((type = this.doBinaryNumericPromotion(this.inferTypeForExpression(arguments.get(0), null, flags | 1))) == null) {
                                return null;
                            }
                            expectedInputType = null;
                            switch (TypeAnalysis.$SWITCH_TABLE$com$strobel$assembler$metadata$JvmType()[type.getSimpleType().ordinal()]) {
                                case 5: {
                                    expectedInputType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 6: {
                                    expectedInputType = BuiltinTypes.Long;
                                    break;
                                }
                            }
                            if (expectedInputType != null) {
                                this.inferTypeForExpression(arguments.get(0), expectedInputType);
                                var30_31 = expectedInputType;
                                return var30_31;
                            }
                            var30_32 = type;
                            return var30_32;
                        }
                        case 256: {
                            op = arguments.get(0);
                            targetType = this.inferTypeForExpression(op.getArguments().get(0), null);
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), targetType);
                            }
                            var30_33 = targetType;
                            return var30_33;
                        }
                        case 2: {
                            if (expectedType != null && !expectedType.isPrimitive()) {
                                var30_34 = expectedType;
                                return var30_34;
                            }
                            var30_35 = BuiltinTypes.Null;
                            return var30_35;
                        }
                        case 19: {
                            if (operand instanceof Boolean && PatternMatching.matchBooleanConstant(expression) != null && !Flags.testAny(flags, 1)) {
                                var30_36 = BuiltinTypes.Boolean;
                                return var30_36;
                            }
                            if (operand instanceof Character && PatternMatching.matchCharacterConstant(expression) != null) {
                                var30_37 = BuiltinTypes.Character;
                                return var30_37;
                            }
                            if (operand instanceof Number) {
                                number = (Number)operand;
                                if (number instanceof Integer) {
                                    if (expectedType != null) {
                                        switch (TypeAnalysis.$SWITCH_TABLE$com$strobel$assembler$metadata$JvmType()[expectedType.getSimpleType().ordinal()]) {
                                            case 1: {
                                                if (number.intValue() != 0 && number.intValue() != 1) {
                                                    var30_39 = BuiltinTypes.Integer;
                                                    return var30_39;
                                                }
                                                var30_38 = TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
                                                return var30_38;
                                            }
                                            case 2: {
                                                if (number.intValue() >= -128 && number.intValue() <= 127) {
                                                    var30_40 = BuiltinTypes.Byte;
                                                    return var30_40;
                                                }
                                                var30_41 = BuiltinTypes.Integer;
                                                return var30_41;
                                            }
                                            case 3: {
                                                if (number.intValue() >= 0 && number.intValue() <= 65535) {
                                                    var30_42 = BuiltinTypes.Character;
                                                    return var30_42;
                                                }
                                                var30_43 = BuiltinTypes.Integer;
                                                return var30_43;
                                            }
                                            case 4: {
                                                if (number.intValue() >= -32768 && number.intValue() <= 32767) {
                                                    var30_44 = BuiltinTypes.Short;
                                                    return var30_44;
                                                }
                                                var30_45 = BuiltinTypes.Integer;
                                                return var30_45;
                                            }
                                        }
                                    } else if (PatternMatching.matchBooleanConstant(expression) != null) {
                                        var30_46 = TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
                                        return var30_46;
                                    }
                                    var30_47 = BuiltinTypes.Integer;
                                    return var30_47;
                                }
                                if (number instanceof Long) {
                                    var30_48 = BuiltinTypes.Long;
                                    return var30_48;
                                }
                                if (number instanceof Float) {
                                    var30_49 = BuiltinTypes.Float;
                                    return var30_49;
                                }
                                var30_50 = BuiltinTypes.Double;
                                return var30_50;
                            }
                            if (operand instanceof TypeReference) {
                                var30_51 = this._factory.makeParameterizedType(this._factory.makeNamedType("java.lang.Class"), null, new TypeReference[]{(TypeReference)operand});
                                return var30_51;
                            }
                            var30_52 = this._factory.makeNamedType("java.lang.String");
                            return var30_52;
                        }
                        case 189: 
                        case 190: 
                        case 243: {
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), (TypeReference)BuiltinTypes.Integer, flags | 1);
                            }
                            var30_53 = ((TypeReference)operand).makeArrayType();
                            return var30_53;
                        }
                        case 197: {
                            if (forceInferChildren) {
                                i = 0;
                                while (i < arguments.size()) {
                                    this.inferTypeForExpression(arguments.get(i), (TypeReference)BuiltinTypes.Integer, flags | 1);
                                    ++i;
                                }
                            }
                            var30_54 = (TypeReference)operand;
                            return var30_54;
                        }
                        case 248: {
                            var30_55 = this.inferInitObject(expression, expectedType, forceInferChildren, (MethodReference)operand, arguments);
                            return var30_55;
                        }
                        case 249: {
                            arrayType = (TypeReference)operand;
                            elementType = arrayType.getElementType();
                            if (forceInferChildren) {
                                for (Expression argument : arguments) {
                                    this.inferTypeForExpression(argument, elementType);
                                }
                            }
                            var30_56 = arrayType;
                            return var30_56;
                        }
                        case 191: {
                            var30_57 = BuiltinTypes.Integer;
                            return var30_57;
                        }
                        case 219: {
                            arrayType = this.inferTypeForExpression(arguments.get(0), null);
                            this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                            if (arrayType == null) return null;
                            if (arrayType.isArray() == false) return null;
                            var30_58 = arrayType.getElementType();
                            return var30_58;
                        }
                        case 220: {
                            arrayType = this.inferTypeForExpression(arguments.get(0), null);
                            this.inferTypeForExpression(arguments.get(1), (TypeReference)BuiltinTypes.Integer, flags | 1);
                            expectedElementType = arrayType != null && arrayType.isArray() != false ? arrayType.getElementType() : null;
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(2), expectedElementType);
                            }
                            var30_59 = expectedElementType;
                            return var30_59;
                        }
                        case 17: 
                        case 18: {
                            number = (Number)operand;
                            if (expectedType != null) {
                                if (expectedType.getSimpleType() == JvmType.Boolean && (number.intValue() == 0 || number.intValue() == 1)) {
                                    var30_60 = BuiltinTypes.Boolean;
                                    return var30_60;
                                }
                                if (expectedType.getSimpleType() == JvmType.Byte && number.intValue() >= -128 && number.intValue() <= 127) {
                                    var30_61 = BuiltinTypes.Byte;
                                    return var30_61;
                                }
                                if (expectedType.getSimpleType() == JvmType.Character && number.intValue() >= 0 && number.intValue() <= 65535) {
                                    var30_62 = BuiltinTypes.Character;
                                    return var30_62;
                                }
                                if (expectedType.getSimpleType().isIntegral()) {
                                    var30_63 = expectedType;
                                    return var30_63;
                                }
                            } else if (code == AstCode.__BIPush) {
                                var30_64 = BuiltinTypes.Byte;
                                return var30_64;
                            }
                            var30_65 = BuiltinTypes.Short;
                            return var30_65;
                        }
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: {
                            switch (TypeAnalysis.$SWITCH_TABLE$com$strobel$decompiler$ast$AstCode()[code.ordinal()]) {
                                case 134: {
                                    conversionResult = BuiltinTypes.Long;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 135: {
                                    conversionResult = BuiltinTypes.Float;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 136: {
                                    conversionResult = BuiltinTypes.Double;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 137: {
                                    conversionResult = BuiltinTypes.Integer;
                                    expectedArgumentType = BuiltinTypes.Long;
                                    break;
                                }
                                case 138: {
                                    conversionResult = BuiltinTypes.Float;
                                    expectedArgumentType = BuiltinTypes.Long;
                                    break;
                                }
                                case 139: {
                                    conversionResult = BuiltinTypes.Double;
                                    expectedArgumentType = BuiltinTypes.Long;
                                    break;
                                }
                                case 140: {
                                    conversionResult = BuiltinTypes.Integer;
                                    expectedArgumentType = BuiltinTypes.Float;
                                    break;
                                }
                                case 141: {
                                    conversionResult = BuiltinTypes.Long;
                                    expectedArgumentType = BuiltinTypes.Float;
                                    break;
                                }
                                case 142: {
                                    conversionResult = BuiltinTypes.Double;
                                    expectedArgumentType = BuiltinTypes.Float;
                                    break;
                                }
                                case 143: {
                                    conversionResult = BuiltinTypes.Integer;
                                    expectedArgumentType = BuiltinTypes.Double;
                                    break;
                                }
                                case 144: {
                                    conversionResult = BuiltinTypes.Long;
                                    expectedArgumentType = BuiltinTypes.Double;
                                    break;
                                }
                                case 145: {
                                    conversionResult = BuiltinTypes.Float;
                                    expectedArgumentType = BuiltinTypes.Double;
                                    break;
                                }
                                case 146: {
                                    conversionResult = BuiltinTypes.Byte;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 147: {
                                    conversionResult = BuiltinTypes.Character;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                case 148: {
                                    conversionResult = BuiltinTypes.Short;
                                    expectedArgumentType = BuiltinTypes.Integer;
                                    break;
                                }
                                default: {
                                    throw ContractUtils.unsupported();
                                }
                            }
                            arguments.get(0).setExpectedType(expectedArgumentType);
                            var30_66 = conversionResult;
                            return var30_66;
                        }
                        case 193: 
                        case 260: {
                            if (expectedType != null) {
                                castType = (TypeReference)operand;
                                inferredType = MetadataHelper.asSubType(castType, expectedType);
                                if (forceInferChildren) {
                                    inferredType = this.inferTypeForExpression(arguments.get(0), inferredType != null ? inferredType : (TypeReference)operand);
                                }
                                if (inferredType != null && MetadataHelper.isSubType(inferredType, MetadataHelper.eraseRecursive(castType))) {
                                    expression.setOperand(inferredType);
                                    var30_67 = inferredType;
                                    return var30_67;
                                }
                            }
                            var30_68 = (TypeReference)operand;
                            return var30_68;
                        }
                        case 259: {
                            type = (TypeReference)operand;
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), type);
                            }
                            var30_69 /* !! */  = type.isPrimitive() != false ? BuiltinTypes.Object : type;
                            return var30_69 /* !! */ ;
                        }
                        case 235: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: 
                        case 240: {
                            if (forceInferChildren) {
                                var30_70 = this.inferBinaryExpression(code, arguments, flags);
                                return var30_70;
                            }
                            var30_71 = BuiltinTypes.Boolean;
                            return var30_71;
                        }
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 153: {
                            if (forceInferChildren) {
                                var30_72 = this.inferBinaryExpression(code, arguments, flags);
                                return var30_72;
                            }
                            var30_73 = BuiltinTypes.Integer;
                            return var30_73;
                        }
                        case 241: {
                            if (forceInferChildren == false) return null;
                            this.inferTypeForExpression(arguments.get(0), (TypeReference)BuiltinTypes.Boolean, true);
                            return null;
                        }
                        case 168: 
                        case 178: 
                        case 192: 
                        case 250: 
                        case 254: 
                        case 255: {
                            return null;
                        }
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: 
                        case 242: {
                            lambdaBinding = expression.getUserData(AstKeys.PARENT_LAMBDA_BINDING);
                            if (lambdaBinding == null) ** GOTO lbl460
                            lambda = (Lambda)lambdaBinding.getOperand();
                            method = lambda.getMethod();
                            if (method == null) {
                                return null;
                            }
                            oldInferredType = lambda.getInferredReturnType();
                            inferredType = expectedType;
                            v0 = returnType = oldInferredType != null ? oldInferredType : expectedType;
                            if (!forceInferChildren) break block264;
                            if (returnType == null) {
                                returnType = lambda.getMethod().getReturnType();
                            }
                            if (!returnType.containsGenericParameters()) break block265;
                            mappings = null;
                            declaringType = method.getDeclaringType();
                            if (!declaringType.isGenericType()) break block265;
                            gp = declaringType.getGenericParameters().iterator();
                            if (true) ** GOTO lbl541
lbl460:
                            // 1 sources

                            returnType = this._context.getCurrentMethod().getReturnType();
                            if (forceInferChildren && arguments.size() == 1) {
                                this.inferTypeForExpression(arguments.get(0), returnType, true);
                            }
                            var30_75 = returnType;
                            return var30_75;
                        }
                        case 252: {
                            lambda = (Lambda)expression.getOperand();
                            if (lambda == null) {
                                return null;
                            }
                            method = lambda.getMethod();
                            parameters = lambda.getParameters();
                            functionType = lambda.getFunctionType();
                            if (functionType != null && expectedType != null && (asSubType = MetadataHelper.asSubType(functionType, expectedType)) != null) {
                                functionType = asSubType;
                            }
                            if ((boundMethod = MetadataHelper.asMemberOf(method, functionType)) == null) {
                                boundMethod = method;
                            }
                            methodParameters = boundMethod.getParameters();
                            argumentCount = Math.min(arguments.size(), methodParameters.size());
                            inferredReturnType = null;
                            if (!forceInferChildren) break block266;
                            i = 0;
                            while (true) {
                                if (i < argumentCount) ** GOTO lbl488
                                lambdaParameters = lambda.getParameters();
                                i = 0;
                                n = lambdaParameters.size();
                                if (true) ** GOTO lbl557
lbl488:
                                // 1 sources

                                argument = arguments.get(i);
                                this.inferTypeForExpression(argument, methodParameters.get(i).getParameterType());
                                ++i;
                            }
                        }
                        case 169: {
                            var30_77 = BuiltinTypes.Integer;
                            return var30_77;
                        }
                        case 170: {
                            if (forceInferChildren == false) return null;
                            this.inferTypeForExpression(arguments.get(0), BuiltinTypes.Integer);
                            return null;
                        }
                        case 88: 
                        case 89: {
                            return null;
                        }
                        case 90: 
                        case 93: {
                            argument = arguments.get(0);
                            result = this.inferTypeForExpression(argument, expectedType);
                            argument.setExpectedType(result);
                            var30_78 = result;
                            return var30_78;
                        }
                        case 194: {
                            var30_79 = BuiltinTypes.Boolean;
                            return var30_79;
                        }
                        case 133: 
                        case 213: 
                        case 234: {
                            inferredType = this.inferTypeForVariable((Variable)operand, BuiltinTypes.Integer, flags | 1);
                            if (forceInferChildren) {
                                this.inferTypeForExpression(arguments.get(0), inferredType, true);
                            }
                            var30_80 = inferredType;
                            return var30_80;
                        }
                        case 1: 
                        case 215: 
                        case 216: {
                            return null;
                        }
                        case 261: {
                            var30_81 = (TypeReference)expression.getOperand();
                            return var30_81;
                        }
                        default: {
                            System.err.printf("Type inference can't handle opcode '%s'.\n", new Object[]{code.getName()});
                            return null;
                        }
                    }
                    finally {
                        this._stack.pop();
                    }
                    do {
                        gp = gp.next();
                        inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                        if (inScope != null && MetadataHelper.isSameType(gp, inScope)) continue;
                        if (mappings == null) {
                            mappings = new HashMap<GenericParameter, TypeReference>();
                        }
                        if (mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
lbl541:
                        // 4 sources

                    } while (gp.hasNext());
                    if (mappings != null && (declaringType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)mappings)) != null && (boundMethod = MetadataHelper.asMemberOf(method, declaringType)) != null) {
                        returnType = boundMethod.getReturnType();
                    }
                }
                if (!arguments.isEmpty() && returnType != BuiltinTypes.Void) {
                    inferredType = this.inferTypeForExpression(arguments.get(0), returnType);
                }
                if (oldInferredType != null && inferredType != BuiltinTypes.Void && (newInferredType = MetadataHelper.asSuper(inferredType, oldInferredType)) != null) {
                    inferredType = newInferredType;
                }
            }
            lambda.setExpectedReturnType(returnType);
            lambda.setInferredReturnType(inferredType);
            var30_74 = inferredType;
            return var30_74;
            do {
                this.invalidateDependentExpressions(expression, lambdaParameters.get(i));
                ++i;
lbl557:
                // 2 sources

            } while (i < n);
            for (Expression e : lambda.getChildrenAndSelfRecursive(Expression.class)) {
                if (!PatternMatching.match(e, AstCode.Return)) continue;
                this.runInference(e);
                if (e.getInferredType() == null) continue;
                inferredReturnType = inferredReturnType != null ? MetadataHelper.asSuper(e.getInferredType(), inferredReturnType) : e.getInferredType();
            }
        }
        r = boundMethod.resolve();
        if (functionType.containsGenericParameters() && boundMethod.containsGenericParameters() || r != null && r.getDeclaringType().containsGenericParameters() && r.containsGenericParameters()) {
            oldMappings = new HashMap<TypeReference, TypeReference>();
            newMappings = new HashMap<TypeReference, TypeReference>();
            p = boundMethod.getParameters();
            rp = r != null ? r.getParameters() : method.getParameters();
            v1 = returnType = r != null ? r.getReturnType() : method.getReturnType();
            if (inferredReturnType != null) {
                if (returnType.isGenericParameter()) {
                    boundReturnType = TypeAnalysis.ensureReferenceType(inferredReturnType);
                    if (!MetadataHelper.isSameType(boundReturnType, returnType)) {
                        newMappings.put(returnType, boundReturnType);
                    }
                } else if (returnType.containsGenericParameters()) {
                    returnMappings = new HashMap<TypeReference, TypeReference>();
                    new AddMappingsForArgumentVisitor(returnType).visit(inferredReturnType, (Map<TypeReference, TypeReference>)returnMappings);
                    newMappings.putAll(returnMappings);
                }
            }
            i = 0;
            j = Math.max(0, parameters.size() - arguments.size());
            while (i < arguments.size()) {
                argument = arguments.get(i);
                rType = rp.get(j).getParameterType();
                pType = p.get(j).getParameterType();
                aType = argument.getInferredType();
                if (pType != null && rType.containsGenericParameters()) {
                    new AddMappingsForArgumentVisitor(pType).visit(rType, (Map<TypeReference, TypeReference>)oldMappings);
                }
                if (aType != null && rType.containsGenericParameters()) {
                    new AddMappingsForArgumentVisitor(aType).visit(rType, (Map<TypeReference, TypeReference>)newMappings);
                }
                ++i;
                ++j;
            }
            mappings = oldMappings;
            if (!newMappings.isEmpty()) {
                for (TypeReference t : newMappings.keySet()) {
                    oldMapping = (TypeReference)oldMappings.get(t);
                    newMapping = (TypeReference)newMappings.get(t);
                    if (oldMapping != null && !MetadataHelper.isSubType(newMapping, oldMapping)) continue;
                    mappings.put(t, newMapping);
                }
            }
            if (!mappings.isEmpty()) {
                declaringType = (r != null ? r : method).getDeclaringType();
                boundDeclaringType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)mappings);
                if (boundDeclaringType != null && boundDeclaringType.isGenericType()) {
                    for (GenericParameter gp : boundDeclaringType.getGenericParameters()) {
                        inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                        if (inScope != null && MetadataHelper.isSameType(gp, inScope) || mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                    }
                    boundDeclaringType = TypeSubstitutionVisitor.instance().visit(boundDeclaringType, (Map<TypeReference, TypeReference>)mappings);
                }
                if (boundDeclaringType != null) {
                    functionType = boundDeclaringType;
                }
                if ((newBoundMethod = MetadataHelper.asMemberOf(boundMethod, boundDeclaringType)) != null) {
                    boundMethod = newBoundMethod;
                    lambda.setMethod(boundMethod);
                    methodParameters = boundMethod.getParameters();
                }
            }
            i = 0;
            while (i < methodParameters.size()) {
                variable = parameters.get(i);
                variableType = methodParameters.get(i).getParameterType();
                oldVariableType = variable.getType();
                if (oldVariableType == null || !MetadataHelper.isSameType(variableType, oldVariableType)) {
                    this.invalidateDependentExpressions(expression, variable);
                }
                ++i;
            }
        }
        var30_76 = functionType;
        return var30_76;
    }

    private TypeReference inferInitObject(Expression expression, TypeReference expectedType, boolean forceInferChildren, MethodReference operand, List<Expression> arguments) {
        Map<TypeReference, TypeReference> mappings;
        TypeReference asSubType;
        MethodReference resolvedCtor = operand instanceof IGenericInstance ? operand.resolve() : operand;
        MethodReference constructor = resolvedCtor != null ? resolvedCtor : operand;
        TypeReference type = constructor.getDeclaringType();
        TypeReference inferredType = expectedType != null && !MetadataHelper.isSameType(expectedType, BuiltinTypes.Object) ? ((asSubType = MetadataHelper.asSubType(type, expectedType)) != null ? asSubType : type) : type;
        if (inferredType.isGenericDefinition()) {
            mappings = new HashMap();
            for (GenericParameter gp : inferredType.getGenericParameters()) {
                mappings.put(gp, MetadataHelper.eraseRecursive(gp));
            }
        } else {
            mappings = Collections.emptyMap();
        }
        if (forceInferChildren) {
            MethodReference asMember = MetadataHelper.asMemberOf(constructor, TypeSubstitutionVisitor.instance().visit(inferredType, mappings));
            List<ParameterDefinition> parameters = asMember.getParameters();
            int i = 0;
            while (i < arguments.size() && i < parameters.size()) {
                this.inferTypeForExpression(arguments.get(i), parameters.get(i).getParameterType());
                ++i;
            }
            expression.setOperand(asMember);
        }
        if (inferredType == null) {
            return type;
        }
        List<TypeReference> oldTypeArguments = expression.getUserData(AstKeys.TYPE_ARGUMENTS);
        if (inferredType instanceof IGenericInstance) {
            boolean typeArgumentsChanged = false;
            List<TypeReference> typeArguments = ((IGenericInstance)((Object)inferredType)).getTypeArguments();
            int i = 0;
            while (i < typeArguments.size()) {
                TypeReference t = typeArguments.get(i);
                while (t.isWildcardType()) {
                    TypeReference typeReference = t = t.hasExtendsBound() ? t.getExtendsBound() : MetadataHelper.getUpperBound(t);
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t);
                }
                while (t.isGenericParameter()) {
                    TypeReference o;
                    GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(t.getName());
                    if (inScope != null && MetadataHelper.isSameType(t, inScope)) break;
                    if (oldTypeArguments != null && oldTypeArguments.size() == typeArguments.size() && !MetadataHelper.isSameType(o = oldTypeArguments.get(i), t)) {
                        t = o;
                        if (!typeArgumentsChanged) {
                            typeArguments = CollectionUtilities.toList(typeArguments);
                            typeArgumentsChanged = true;
                        }
                        typeArguments.set(i, t);
                        continue;
                    }
                    TypeReference typeReference = t = t.hasExtendsBound() ? t.getExtendsBound() : MetadataHelper.getUpperBound(t);
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t);
                }
                ++i;
            }
            expression.putUserData(AstKeys.TYPE_ARGUMENTS, typeArguments);
            if (typeArgumentsChanged) {
                inferredType = inferredType.makeGenericType(typeArguments);
            }
        }
        return inferredType;
    }

    private TypeReference cleanTypeArguments(TypeReference newType, TypeReference alternateType) {
        List<TypeReference> typeArguments;
        if (!(alternateType instanceof IGenericInstance)) {
            return newType;
        }
        if (!StringUtilities.equals(newType.getInternalName(), alternateType.getInternalName())) {
            return newType;
        }
        List<TypeReference> alternateTypeArguments = ((IGenericInstance)((Object)alternateType)).getTypeArguments();
        boolean typeArgumentsChanged = false;
        if (newType instanceof IGenericInstance) {
            typeArguments = ((IGenericInstance)((Object)newType)).getTypeArguments();
        } else {
            typeArguments = new ArrayList<TypeReference>();
            typeArguments.addAll(newType.getGenericParameters());
        }
        int i = 0;
        while (i < typeArguments.size()) {
            TypeReference t = typeArguments.get(i);
            while (t.isGenericParameter()) {
                TypeReference o;
                GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(t.getName());
                if (inScope != null && MetadataHelper.isSameType(t, inScope)) break;
                if (alternateTypeArguments != null && alternateTypeArguments.size() == typeArguments.size() && !MetadataHelper.isSameType(o = alternateTypeArguments.get(i), t)) {
                    t = o;
                    if (!typeArgumentsChanged) {
                        typeArguments = CollectionUtilities.toList(typeArguments);
                        typeArgumentsChanged = true;
                    }
                    typeArguments.set(i, t);
                    continue;
                }
                TypeReference typeReference = t = t.hasExtendsBound() ? t.getExtendsBound() : MetadataHelper.getUpperBound(t);
                if (!typeArgumentsChanged) {
                    typeArguments = CollectionUtilities.toList(typeArguments);
                    typeArgumentsChanged = true;
                }
                typeArguments.set(i, t);
            }
            ++i;
        }
        if (typeArgumentsChanged) {
            return newType.makeGenericType(typeArguments);
        }
        return newType;
    }

    private TypeReference inferBinaryExpression(AstCode code, List<Expression> arguments, int flags) {
        Expression left = arguments.get(0);
        Expression right = arguments.get(1);
        this.runInference(left);
        this.runInference(right);
        TypeReference lInferred = left.getInferredType();
        TypeReference rInferred = right.getInferredType();
        left.setExpectedType(lInferred);
        right.setExpectedType(lInferred);
        left.setInferredType(null);
        right.setInferredType(null);
        int operandFlags = 0;
        switch (code) {
            case And: 
            case Or: 
            case Xor: 
            case CmpEq: 
            case CmpNe: {
                if (left.getExpectedType() == BuiltinTypes.Boolean) {
                    if (right.getExpectedType() == BuiltinTypes.Integer) {
                        if (PatternMatching.matchBooleanConstant(right) != null) {
                            right.setExpectedType(BuiltinTypes.Boolean);
                            break;
                        }
                        left.setExpectedType(BuiltinTypes.Integer);
                        operandFlags |= 1;
                        break;
                    }
                    if (right.getExpectedType() == BuiltinTypes.Boolean) break;
                    left.setExpectedType(BuiltinTypes.Integer);
                    operandFlags |= 1;
                    break;
                }
                if (right.getExpectedType() != BuiltinTypes.Boolean) break;
                if (left.getExpectedType() == BuiltinTypes.Integer) {
                    if (PatternMatching.matchBooleanConstant(left) != null) {
                        left.setExpectedType(BuiltinTypes.Boolean);
                        break;
                    }
                    right.setExpectedType(BuiltinTypes.Integer);
                    operandFlags |= 1;
                    break;
                }
                if (left.getExpectedType() == BuiltinTypes.Boolean) break;
                right.setExpectedType(BuiltinTypes.Integer);
                operandFlags |= 1;
                break;
            }
            default: {
                operandFlags |= 1;
                if (left.getExpectedType() == BuiltinTypes.Boolean || left.getExpectedType() == null && PatternMatching.matchBooleanConstant(left) != null) {
                    left.setExpectedType(BuiltinTypes.Integer);
                }
                if (right.getExpectedType() != BuiltinTypes.Boolean && (right.getExpectedType() != null || PatternMatching.matchBooleanConstant(right) == null)) break;
                right.setExpectedType(BuiltinTypes.Integer);
            }
        }
        if (left.getExpectedType() == BuiltinTypes.Character) {
            if (right.getExpectedType() == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(right) != null) {
                right.setExpectedType(BuiltinTypes.Character);
            }
        } else if (right.getExpectedType() == BuiltinTypes.Character && left.getExpectedType() == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(left) != null) {
            left.setExpectedType(BuiltinTypes.Character);
        }
        TypeReference lType = this.isSameType(lInferred, left.getExpectedType()) ? lInferred : this.doInferTypeForExpression(left, left.getExpectedType(), true, operandFlags);
        TypeReference rType = this.isSameType(rInferred, right.getExpectedType()) ? rInferred : this.doInferTypeForExpression(right, right.getExpectedType(), true, operandFlags);
        TypeReference operandType = this.inferBinaryArguments(left, right, this.typeWithMoreInformation(lType, rType), false, null, null, operandFlags);
        switch (code) {
            case CmpEq: 
            case CmpNe: 
            case CmpLt: 
            case CmpGe: 
            case CmpGt: 
            case CmpLe: {
                return BuiltinTypes.Boolean;
            }
            case Add: 
            case Sub: 
            case Mul: 
            case Div: 
            case Rem: 
            case And: 
            case Or: 
            case Xor: {
                return TypeAnalysis.adjustType(this.doBinaryNumericPromotion(operandType), flags);
            }
        }
        return TypeAnalysis.adjustType(operandType, flags);
    }

    private TypeReference inferDynamicCall(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        MethodReference bootstrapMethod;
        TypeReference result;
        List<Expression> arguments = expression.getArguments();
        DynamicCallSite callSite = (DynamicCallSite)expression.getOperand();
        TypeReference inferredType = expression.getInferredType();
        if (inferredType == null) {
            inferredType = callSite.getMethodType().getReturnType();
        }
        TypeReference typeReference = result = expectedType == null ? inferredType : MetadataHelper.asSubType(inferredType, expectedType);
        if (result == null) {
            result = inferredType;
        }
        if ((result.isGenericType() || MetadataHelper.isRawType(result)) && "java/lang/invoke/LambdaMetafactory".equals((bootstrapMethod = callSite.getBootstrapMethod()).getDeclaringType().getInternalName()) && StringUtilities.equals("metafactory", bootstrapMethod.getName(), StringComparison.OrdinalIgnoreCase) && callSite.getBootstrapArguments().size() == 3 && callSite.getBootstrapArguments().get(1) instanceof MethodHandle) {
            TypeReference resolvedTargetType;
            MethodHandle targetHandle = (MethodHandle)callSite.getBootstrapArguments().get(1);
            MethodReference targetMethod = targetHandle.getMethod();
            HashMap<GenericParameter, Object> expectedMappings = new HashMap<GenericParameter, Object>();
            HashMap<TypeReference, TypeReference> inferredMappings = new HashMap<TypeReference, TypeReference>();
            MethodDefinition functionMethod = null;
            TypeDefinition resolvedType = result.resolve();
            List<MethodReference> methods = MetadataHelper.findMethods(resolvedType != null ? resolvedType : result, MetadataFilters.matchName(callSite.getMethodName()));
            for (MethodReference m : methods) {
                MethodDefinition r = m.resolve();
                if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
                functionMethod = r;
                break;
            }
            if (functionMethod == null) {
                return null;
            }
            boolean firstArgIsTarget = false;
            MethodReference actualMethod = targetMethod;
            switch (targetHandle.getHandleType()) {
                case GetField: 
                case PutField: 
                case InvokeVirtual: 
                case InvokeSpecial: 
                case InvokeInterface: {
                    TypeReference targetType;
                    if (arguments.size() <= 0) break;
                    Expression arg = arguments.get(0);
                    TypeReference expectedArgType = targetMethod.getDeclaringType();
                    if (forceInferChildren) {
                        this.inferTypeForExpression(arg, expectedArgType, true);
                    }
                    if ((targetType = arg.getInferredType()) == null || !MetadataHelper.isSubType(targetType, expectedArgType)) break;
                    firstArgIsTarget = true;
                    MethodReference asMember = MetadataHelper.asMemberOf(actualMethod, targetType);
                    if (asMember == null) break;
                    actualMethod = asMember;
                }
            }
            if (expectedType != null && expectedType.isGenericType() && !expectedType.isGenericDefinition()) {
                List<GenericParameter> genericParameters = resolvedType != null ? resolvedType.getGenericParameters() : expectedType.getGenericParameters();
                List<TypeReference> typeArguments = ((IGenericInstance)((Object)expectedType)).getTypeArguments();
                if (typeArguments.size() == genericParameters.size()) {
                    int i = 0;
                    while (i < genericParameters.size()) {
                        GenericParameter genericParameter;
                        TypeReference typeArgument = typeArguments.get(i);
                        if (!MetadataHelper.isSameType(typeArgument, genericParameter = genericParameters.get(i), true)) {
                            expectedMappings.put(genericParameter, typeArgument);
                        }
                        ++i;
                    }
                }
            }
            new AddMappingsForArgumentVisitor(actualMethod.isConstructor() ? actualMethod.getDeclaringType() : actualMethod.getReturnType()).visit(((MethodReference)functionMethod).getReturnType(), (Map<TypeReference, TypeReference>)inferredMappings);
            List<ParameterDefinition> tp = actualMethod.getParameters();
            List<ParameterDefinition> fp = ((MethodReference)functionMethod).getParameters();
            if (tp.size() == fp.size()) {
                int i = 0;
                while (i < fp.size()) {
                    new AddMappingsForArgumentVisitor(tp.get(i).getParameterType()).visit(fp.get(i).getParameterType(), (Map<TypeReference, TypeReference>)inferredMappings);
                    ++i;
                }
            }
            for (TypeReference key : expectedMappings.keySet()) {
                TypeReference expectedMapping = (TypeReference)expectedMappings.get(key);
                TypeReference inferredMapping = (TypeReference)inferredMappings.get(key);
                if (inferredMapping != null && !MetadataHelper.isSubType(expectedMapping, inferredMapping)) continue;
                inferredMappings.put(key, expectedMapping);
            }
            result = TypeSubstitutionVisitor.instance().visit(resolvedType != null ? resolvedType : result, (Map<TypeReference, TypeReference>)inferredMappings);
            if (!firstArgIsTarget || expectedType == null) {
                return result;
            }
            TypeReference declaringType = actualMethod.getDeclaringType();
            if (!declaringType.isGenericDefinition() && !MetadataHelper.isRawType(actualMethod.getDeclaringType())) {
                return result;
            }
            TypeReference typeReference2 = declaringType = declaringType.isGenericDefinition() ? declaringType : declaringType.resolve();
            if (declaringType == null) {
                return result;
            }
            MethodReference resultMethod = MetadataHelper.asMemberOf(functionMethod, result);
            actualMethod = actualMethod.resolve();
            if (resultMethod == null || actualMethod == null) {
                return result;
            }
            inferredMappings.clear();
            new AddMappingsForArgumentVisitor(resultMethod.getReturnType()).visit(actualMethod.getReturnType(), (Map<TypeReference, TypeReference>)inferredMappings);
            List<ParameterDefinition> ap = actualMethod.getParameters();
            List<ParameterDefinition> rp = resultMethod.getParameters();
            if (ap.size() == rp.size()) {
                int i = 0;
                int n = ap.size();
                while (i < n) {
                    new AddMappingsForArgumentVisitor(rp.get(i).getParameterType()).visit(ap.get(i).getParameterType(), (Map<TypeReference, TypeReference>)inferredMappings);
                    ++i;
                }
            }
            if ((resolvedTargetType = TypeSubstitutionVisitor.instance().visit(declaringType, (Map<TypeReference, TypeReference>)inferredMappings)) != null) {
                this.inferTypeForExpression(arguments.get(0), resolvedTargetType, true);
            }
        }
        return result;
    }

    private TypeReference inferCall(Expression expression, TypeReference expectedType, boolean forceInferChildren) {
        AstCode code = expression.getCode();
        List<Expression> arguments = expression.getArguments();
        MethodReference method = (MethodReference)expression.getOperand();
        List<ParameterDefinition> parameters = method.getParameters();
        boolean hasThis = code != AstCode.InvokeStatic && code != AstCode.InvokeDynamic;
        TypeReference targetType = null;
        MethodReference boundMethod = method;
        if (forceInferChildren) {
            MethodReference actualMethod;
            MethodDefinition r = method.resolve();
            if (hasThis) {
                MethodReference m;
                TypeReference expectedTargetType;
                Expression thisArg = arguments.get(0);
                TypeReference typeReference = expectedTargetType = thisArg.getInferredType() != null ? thisArg.getInferredType() : thisArg.getExpectedType();
                if (expectedTargetType != null && expectedTargetType.isGenericType() && !expectedTargetType.isGenericDefinition()) {
                    boundMethod = MetadataHelper.asMemberOf(method, expectedTargetType);
                    targetType = this.inferTypeForExpression(arguments.get(0), expectedTargetType);
                } else {
                    targetType = method.isConstructor() ? method.getDeclaringType() : this.inferTypeForExpression(arguments.get(0), method.getDeclaringType());
                }
                if (!(targetType instanceof RawType) && MetadataHelper.isRawType(targetType) && !MetadataHelper.canReferenceTypeVariablesOf(targetType, this._context.getCurrentType())) {
                    targetType = MetadataHelper.erase(targetType);
                }
                MethodReference methodReference = targetType != null ? MetadataHelper.asMemberOf(r != null ? r : method, targetType) : (m = method);
                actualMethod = m != null ? m : (r != null ? r : boundMethod);
            } else {
                actualMethod = r != null ? r : boundMethod;
            }
            boundMethod = actualMethod;
            expression.setOperand(boundMethod);
            List<ParameterDefinition> p = method.getParameters();
            HashMap<TypeReference, TypeReference> mappings = null;
            if (actualMethod.containsGenericParameters() || r != null && r.containsGenericParameters()) {
                TypeReference boundDeclaringType;
                HashMap<TypeReference, TypeReference> oldMappings = new HashMap<TypeReference, TypeReference>();
                HashMap<TypeReference, TypeReference> newMappings = new HashMap<TypeReference, TypeReference>();
                HashMap<TypeReference, TypeReference> inferredMappings = new HashMap<TypeReference, TypeReference>();
                if (targetType != null && targetType.isGenericType()) {
                    oldMappings.putAll(MetadataHelper.getGenericSubTypeMappings(targetType.getUnderlyingType(), targetType));
                }
                List<ParameterDefinition> rp = r != null ? r.getParameters() : actualMethod.getParameters();
                List<ParameterDefinition> cp = boundMethod.getParameters();
                boolean mapOld = method instanceof IGenericInstance;
                int i = 0;
                while (i < parameters.size()) {
                    TypeReference rType = rp.get(i).getParameterType();
                    TypeReference pType = p.get(i).getParameterType();
                    TypeReference cType = cp.get(i).getParameterType();
                    TypeReference aType = this.inferTypeForExpression(arguments.get(hasThis ? i + 1 : i), cType);
                    if (mapOld && rType != null && rType.containsGenericParameters()) {
                        new AddMappingsForArgumentVisitor(pType).visit(rType, (Map<TypeReference, TypeReference>)oldMappings);
                    }
                    if (cType != null && rType.containsGenericParameters()) {
                        new AddMappingsForArgumentVisitor(cType).visit(rType, (Map<TypeReference, TypeReference>)newMappings);
                    }
                    if (aType != null && rType.containsGenericParameters()) {
                        new AddMappingsForArgumentVisitor(aType).visit(rType, (Map<TypeReference, TypeReference>)inferredMappings);
                    }
                    ++i;
                }
                if (expectedType != null) {
                    TypeReference returnType;
                    TypeReference typeReference = returnType = r != null ? r.getReturnType() : actualMethod.getReturnType();
                    if (returnType.containsGenericParameters()) {
                        Iterator returnMappings = new HashMap();
                        new AddMappingsForArgumentVisitor(expectedType).visit(returnType, (Map<TypeReference, TypeReference>)((Object)returnMappings));
                        newMappings.putAll((Map<TypeReference, TypeReference>)((Object)returnMappings));
                    }
                }
                if (!(oldMappings.isEmpty() && newMappings.isEmpty() && inferredMappings.isEmpty())) {
                    TypeReference newMapping;
                    Object oldMapping;
                    mappings = oldMappings;
                    for (TypeReference t : newMappings.keySet()) {
                        oldMapping = (TypeReference)mappings.get(t);
                        newMapping = (TypeReference)newMappings.get(t);
                        if (oldMapping != null && !MetadataHelper.isSubType(newMapping, (TypeReference)oldMapping)) continue;
                        mappings.put(t, newMapping);
                    }
                    for (TypeReference t : inferredMappings.keySet()) {
                        oldMapping = (TypeReference)mappings.get(t);
                        newMapping = (TypeReference)inferredMappings.get(t);
                        if (oldMapping != null && !MetadataHelper.isSubType(newMapping, (TypeReference)oldMapping)) continue;
                        mappings.put(t, newMapping);
                    }
                }
                if (mappings != null) {
                    actualMethod = boundMethod = TypeSubstitutionVisitor.instance().visitMethod(r != null ? r : actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if ((boundDeclaringType = boundMethod.getDeclaringType()).isGenericType()) {
                    if (mappings == null) {
                        mappings = new HashMap();
                    }
                    for (GenericParameter gp : boundDeclaringType.getGenericParameters()) {
                        GenericParameter inScope = this._context.getCurrentMethod().findTypeVariable(gp.getName());
                        if (inScope != null && MetadataHelper.isSameType(gp, inScope) || mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                    }
                    boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if (boundMethod.isGenericMethod()) {
                    if (mappings == null) {
                        mappings = new HashMap();
                    }
                    for (GenericParameter gp : boundMethod.getGenericParameters()) {
                        if (mappings.containsKey(gp)) continue;
                        mappings.put(gp, MetadataHelper.eraseRecursive(gp));
                    }
                    boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                    expression.setOperand(boundMethod);
                    p = boundMethod.getParameters();
                }
                if (r != null && method.isGenericMethod()) {
                    HashMap<TypeReference, TypeReference> tempMappings = new HashMap<TypeReference, TypeReference>();
                    List<ParameterDefinition> bp = method.getParameters();
                    int i2 = 0;
                    int n = bp.size();
                    while (i2 < n) {
                        new AddMappingsForArgumentVisitor(bp.get(i2).getParameterType()).visit(rp.get(i2).getParameterType(), (Map<TypeReference, TypeReference>)tempMappings);
                        ++i2;
                    }
                    boolean changed = false;
                    if (mappings == null) {
                        mappings = tempMappings;
                        changed = true;
                    } else {
                        for (TypeReference key : tempMappings.keySet()) {
                            if (mappings.containsKey(key)) continue;
                            mappings.put(key, tempMappings.get(key));
                            changed = true;
                        }
                    }
                    if (changed) {
                        boundMethod = TypeSubstitutionVisitor.instance().visitMethod(actualMethod, (Map<TypeReference, TypeReference>)mappings);
                        expression.setOperand(boundMethod);
                        p = boundMethod.getParameters();
                    }
                }
            } else {
                boundMethod = actualMethod;
            }
            if (hasThis && mappings != null) {
                TypeReference inferredTargetType;
                TypeReference expectedTargetType = boundMethod.isConstructor() ? MetadataHelper.substituteGenericArguments(boundMethod.getDeclaringType(), mappings) : boundMethod.getDeclaringType();
                if (expectedTargetType != null && expectedTargetType.isGenericDefinition() && arguments.get(0).getInferredType() != null) {
                    expectedTargetType = MetadataHelper.asSuper(expectedTargetType, arguments.get(0).getInferredType());
                }
                if ((inferredTargetType = this.inferTypeForExpression(arguments.get(0), expectedTargetType, forceInferChildren)) != null) {
                    targetType = MetadataHelper.substituteGenericArguments(inferredTargetType, mappings);
                    if (MetadataHelper.isRawType(targetType) && !MetadataHelper.canReferenceTypeVariablesOf(targetType, this._context.getCurrentType())) {
                        targetType = MetadataHelper.erase(targetType);
                    }
                    boundMethod = MetadataHelper.asMemberOf(boundMethod, targetType);
                    p = boundMethod.getParameters();
                    expression.setOperand(boundMethod);
                }
            }
            int i = 0;
            while (i < parameters.size()) {
                TypeReference pType = p.get(i).getParameterType();
                Expression argument = arguments.get(hasThis ? i + 1 : i);
                this.inferTypeForExpression(argument, pType, forceInferChildren, PatternMatching.match(argument, AstCode.Load) && pType != BuiltinTypes.Boolean ? 1 : 0);
                ++i;
            }
        }
        if (hasThis && boundMethod.isConstructor()) {
            return boundMethod.getDeclaringType();
        }
        return boundMethod.getReturnType();
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType) {
        return this.inferTypeForVariable(v, expectedType, false, 0);
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType, int flags) {
        return this.inferTypeForVariable(v, expectedType, false, flags);
    }

    private TypeReference inferTypeForVariable(Variable v, TypeReference expectedType, boolean favorExpectedOverActual, int flags) {
        TypeReference lastInferredType = this._inferredVariableTypes.get(v);
        if (lastInferredType != null) {
            return TypeAnalysis.adjustType(lastInferredType, flags);
        }
        if (this.isSingleStoreBoolean(v)) {
            return TypeAnalysis.adjustType(BuiltinTypes.Boolean, flags);
        }
        if (favorExpectedOverActual && expectedType != null) {
            return TypeAnalysis.adjustType(expectedType, flags);
        }
        TypeReference variableType = v.getType();
        if (variableType != null) {
            return TypeAnalysis.adjustType(variableType, flags);
        }
        if (v.isGenerated()) {
            return TypeAnalysis.adjustType(expectedType, flags);
        }
        ParameterDefinition p = v.getOriginalParameter();
        return TypeAnalysis.adjustType(p != null ? p.getParameterType() : v.getOriginalVariable().getVariableType(), flags);
    }

    private static TypeReference adjustType(TypeReference type, int flags) {
        if (Flags.testAny(flags, 1) && type == BuiltinTypes.Boolean) {
            return BuiltinTypes.Integer;
        }
        return type;
    }

    private TypeReference doBinaryNumericPromotion(TypeReference type) {
        if (type == null) {
            return null;
        }
        switch (type.getSimpleType()) {
            case Byte: 
            case Character: 
            case Short: {
                return BuiltinTypes.Integer;
            }
        }
        return type;
    }

    private TypeReference inferBinaryArguments(Expression left, Expression right, TypeReference expectedType, boolean forceInferChildren, TypeReference leftPreferred, TypeReference rightPreferred, int operandFlags) {
        TypeReference actualLeftPreferred = leftPreferred;
        TypeReference actualRightPreferred = rightPreferred;
        if (actualLeftPreferred == null) {
            actualLeftPreferred = this.doInferTypeForExpression(left, expectedType, forceInferChildren, operandFlags);
        }
        if (actualRightPreferred == null) {
            actualRightPreferred = this.doInferTypeForExpression(right, expectedType, forceInferChildren, operandFlags);
        }
        if (actualLeftPreferred == BuiltinTypes.Null) {
            if (actualRightPreferred != null && !actualRightPreferred.isPrimitive()) {
                actualLeftPreferred = actualRightPreferred;
            }
        } else if (actualRightPreferred == BuiltinTypes.Null && actualLeftPreferred != null && !actualLeftPreferred.isPrimitive()) {
            actualRightPreferred = actualLeftPreferred;
        }
        if (actualLeftPreferred == BuiltinTypes.Character) {
            if (actualRightPreferred == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(right) != null) {
                actualRightPreferred = BuiltinTypes.Character;
            }
        } else if (actualRightPreferred == BuiltinTypes.Character && actualLeftPreferred == BuiltinTypes.Integer && PatternMatching.matchCharacterConstant(left) != null) {
            actualLeftPreferred = BuiltinTypes.Character;
        }
        if (this.isSameType(actualLeftPreferred, actualRightPreferred)) {
            left.setInferredType(actualLeftPreferred);
            left.setExpectedType(actualLeftPreferred);
            right.setInferredType(actualLeftPreferred);
            right.setExpectedType(actualLeftPreferred);
            return actualLeftPreferred;
        }
        if (this.isSameType(actualRightPreferred, this.doInferTypeForExpression(left, actualRightPreferred, forceInferChildren, operandFlags))) {
            left.setInferredType(actualRightPreferred);
            left.setExpectedType(actualRightPreferred);
            right.setInferredType(actualRightPreferred);
            right.setExpectedType(actualRightPreferred);
            return actualRightPreferred;
        }
        if (this.isSameType(actualLeftPreferred, this.doInferTypeForExpression(right, actualLeftPreferred, forceInferChildren, operandFlags))) {
            left.setInferredType(actualLeftPreferred);
            left.setExpectedType(actualLeftPreferred);
            right.setInferredType(actualLeftPreferred);
            right.setExpectedType(actualLeftPreferred);
            return actualLeftPreferred;
        }
        TypeReference result = this.typeWithMoreInformation(actualLeftPreferred, actualRightPreferred);
        left.setExpectedType(result);
        right.setExpectedType(result);
        left.setInferredType(this.doInferTypeForExpression(left, result, forceInferChildren, operandFlags));
        right.setInferredType(this.doInferTypeForExpression(right, result, forceInferChildren, operandFlags));
        return result;
    }

    private TypeReference typeWithMoreInformation(TypeReference leftPreferred, TypeReference rightPreferred) {
        int right;
        if (leftPreferred == rightPreferred) {
            return leftPreferred;
        }
        int left = TypeAnalysis.getInformationAmount(leftPreferred);
        if (left < (right = TypeAnalysis.getInformationAmount(rightPreferred))) {
            return rightPreferred;
        }
        if (left > right) {
            return leftPreferred;
        }
        if (leftPreferred != null && rightPreferred != null) {
            return MetadataHelper.findCommonSuperType(leftPreferred.isGenericDefinition() ? new RawType(leftPreferred) : leftPreferred, rightPreferred.isGenericDefinition() ? new RawType(rightPreferred) : rightPreferred);
        }
        return leftPreferred;
    }

    private static int getInformationAmount(TypeReference type) {
        if (type == null || type == BuiltinTypes.Null) {
            return 0;
        }
        switch (type.getSimpleType()) {
            case Boolean: {
                return 1;
            }
            case Byte: {
                return 8;
            }
            case Character: 
            case Short: {
                return 16;
            }
            case Integer: 
            case Float: {
                return 32;
            }
            case Long: 
            case Double: {
                return 64;
            }
        }
        return 100;
    }

    static TypeReference getFieldType(FieldReference field) {
        FieldDefinition resolvedField = field.resolve();
        if (resolvedField != null) {
            FieldReference asMember = MetadataHelper.asMemberOf(resolvedField, field.getDeclaringType());
            return asMember.getFieldType();
        }
        return TypeAnalysis.substituteTypeArguments(field.getFieldType(), field);
    }

    static TypeReference substituteTypeArguments(TypeReference type, MemberReference member) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            TypeReference elementType = TypeAnalysis.substituteTypeArguments(arrayType.getElementType(), member);
            if (!MetadataResolver.areEquivalent(elementType, arrayType.getElementType())) {
                return elementType.makeArrayType();
            }
            return type;
        }
        if (type instanceof IGenericInstance) {
            IGenericInstance genericInstance = (IGenericInstance)((Object)type);
            ArrayList<TypeReference> newTypeArguments = new ArrayList<TypeReference>();
            boolean isChanged = false;
            for (TypeReference typeArgument : genericInstance.getTypeArguments()) {
                TypeReference newTypeArgument = TypeAnalysis.substituteTypeArguments(typeArgument, member);
                newTypeArguments.add(newTypeArgument);
                isChanged |= newTypeArgument != typeArgument;
            }
            return isChanged ? type.makeGenericType(newTypeArguments) : type;
        }
        if (type instanceof GenericParameter) {
            TypeReference declaringType;
            GenericParameter genericParameter = (GenericParameter)type;
            IGenericParameterProvider owner = genericParameter.getOwner();
            if (member.getDeclaringType() instanceof ArrayType) {
                return member.getDeclaringType().getElementType();
            }
            if (owner instanceof MethodReference && member instanceof MethodReference) {
                MethodReference method = (MethodReference)member;
                MethodReference ownerMethod = (MethodReference)owner;
                if (method.isGenericMethod() && MetadataResolver.areEquivalent(ownerMethod.getDeclaringType(), method.getDeclaringType()) && StringUtilities.equals(ownerMethod.getName(), method.getName()) && StringUtilities.equals(ownerMethod.getErasedSignature(), method.getErasedSignature())) {
                    if (method instanceof IGenericInstance) {
                        List<TypeReference> typeArguments = ((IGenericInstance)((Object)member)).getTypeArguments();
                        return typeArguments.get(genericParameter.getPosition());
                    }
                    return method.getGenericParameters().get(genericParameter.getPosition());
                }
            } else if (owner instanceof TypeReference && MetadataResolver.areEquivalent((TypeReference)owner, declaringType = member instanceof TypeReference ? (TypeReference)member : member.getDeclaringType())) {
                if (declaringType instanceof IGenericInstance) {
                    List<TypeReference> typeArguments = ((IGenericInstance)((Object)declaringType)).getTypeArguments();
                    return typeArguments.get(genericParameter.getPosition());
                }
                if (!declaringType.isGenericDefinition()) {
                    declaringType = declaringType.getUnderlyingType();
                }
                if (declaringType != null && declaringType.isGenericDefinition()) {
                    return declaringType.getGenericParameters().get(genericParameter.getPosition());
                }
            }
        }
        return type;
    }

    private boolean isSameType(TypeReference t1, TypeReference t2) {
        return MetadataHelper.isSameType(t1, t2, true);
    }

    private boolean anyDone(List<ExpressionToInfer> expressions) {
        for (ExpressionToInfer expression : expressions) {
            if (!expression.done) continue;
            return true;
        }
        return false;
    }

    private boolean allDone(List<ExpressionToInfer> expressions) {
        for (ExpressionToInfer expression : expressions) {
            if (expression.done) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean trueForAll(Iterable<T> sequence, Predicate<T> condition) {
        for (T item : sequence) {
            if (condition.test(item)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBoolean(TypeReference type) {
        return type != null && type.getSimpleType() == JvmType.Boolean;
    }

    private static TypeReference ensureReferenceType(TypeReference mappedType) {
        if (mappedType == null) {
            return null;
        }
        if (mappedType.isPrimitive()) {
            switch (mappedType.getSimpleType()) {
                case Boolean: {
                    return CommonTypeReferences.Boolean;
                }
                case Byte: {
                    return CommonTypeReferences.Byte;
                }
                case Character: {
                    return CommonTypeReferences.Character;
                }
                case Short: {
                    return CommonTypeReferences.Short;
                }
                case Integer: {
                    return CommonTypeReferences.Integer;
                }
                case Long: {
                    return CommonTypeReferences.Long;
                }
                case Float: {
                    return CommonTypeReferences.Float;
                }
                case Double: {
                    return CommonTypeReferences.Double;
                }
            }
        }
        return mappedType;
    }

    private static final class AddMappingsForArgumentVisitor
    extends DefaultTypeVisitor<Map<TypeReference, TypeReference>, Void> {
        private TypeReference argumentType;

        AddMappingsForArgumentVisitor(TypeReference argumentType) {
            this.argumentType = VerifyArgument.notNull(argumentType, "argumentType");
        }

        @Override
        public Void visit(TypeReference t, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            t.accept(this, map);
            this.argumentType = a;
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType t, Map<TypeReference, TypeReference> map) {
            TypeReference a = this.argumentType;
            if (a.isArray()) {
                this.argumentType = a.getElementType();
                this.visit(t.getElementType(), map);
            }
            return null;
        }

        @Override
        public Void visitGenericParameter(GenericParameter t, Map<TypeReference, TypeReference> map) {
            if (MetadataResolver.areEquivalent(this.argumentType, (TypeReference)t)) {
                return null;
            }
            TypeReference existingMapping = map.get(t);
            TypeReference mappedType = this.argumentType;
            mappedType = TypeAnalysis.ensureReferenceType(mappedType);
            if (existingMapping == null) {
                if (!(mappedType instanceof RawType) && MetadataHelper.isRawType(mappedType)) {
                    TypeReference bound = MetadataHelper.getUpperBound(t);
                    TypeReference asSuper = MetadataHelper.asSuper(mappedType, bound);
                    if (asSuper != null) {
                        if (MetadataHelper.isSameType(MetadataHelper.getUpperBound(t), asSuper)) {
                            return null;
                        }
                        mappedType = asSuper;
                    } else {
                        mappedType = MetadataHelper.erase(mappedType);
                    }
                }
                map.put(t, mappedType);
            } else if (!MetadataHelper.isSubType(this.argumentType, existingMapping)) {
                TypeReference commonSuperType = MetadataHelper.asSuper(mappedType, existingMapping);
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.asSuper(existingMapping, mappedType);
                }
                if (commonSuperType == null) {
                    commonSuperType = MetadataHelper.findCommonSuperType(existingMapping, mappedType);
                }
                map.put(t, commonSuperType);
            }
            return null;
        }

        @Override
        public Void visitWildcard(WildcardType t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitCompoundType(CompoundTypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitParameterizedType(TypeReference t, Map<TypeReference, TypeReference> map) {
            TypeReference r = MetadataHelper.asSuper(t.getUnderlyingType(), this.argumentType);
            TypeReference s = MetadataHelper.asSubType(this.argumentType, r != null ? r : t.getUnderlyingType());
            if (s != null && s instanceof IGenericInstance) {
                List<TypeReference> tArgs = ((IGenericInstance)((Object)t)).getTypeArguments();
                List<TypeReference> sArgs = ((IGenericInstance)((Object)s)).getTypeArguments();
                if (tArgs.size() == sArgs.size()) {
                    int i = 0;
                    int n = tArgs.size();
                    while (i < n) {
                        this.argumentType = sArgs.get(i);
                        this.visit(tArgs.get(i), map);
                        ++i;
                    }
                }
            }
            return null;
        }

        @Override
        public Void visitPrimitiveType(PrimitiveType t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitClassType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitNullType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitBottomType(TypeReference t, Map<TypeReference, TypeReference> map) {
            return null;
        }

        @Override
        public Void visitRawType(RawType t, Map<TypeReference, TypeReference> map) {
            return null;
        }
    }

    static final class ExpressionToInfer {
        private final List<Variable> dependencies = new ArrayList<Variable>();
        Expression expression;
        boolean done;
        Variable dependsOnSingleLoad;
        int flags;

        ExpressionToInfer() {
        }

        public String toString() {
            if (this.done) {
                return "[Done] " + this.expression;
            }
            return this.expression.toString();
        }
    }
}

