/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicate;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.BasicBlock;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.LockInfo;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.Variable;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.List;

public final class PatternMatching {
    private PatternMatching() {
        throw ContractUtils.unreachable();
    }

    public static boolean match(Node node, AstCode code) {
        return node instanceof Expression && ((Expression)node).getCode() == code;
    }

    public static boolean matchLeaveHandler(Node node) {
        return PatternMatching.match(node, AstCode.Leave) || PatternMatching.match(node, AstCode.EndFinally);
    }

    public static <T> boolean matchGetOperand(Node node, AstCode code, StrongBox<? super T> operand) {
        Expression expression;
        if (node instanceof Expression && (expression = (Expression)node).getCode() == code && expression.getArguments().isEmpty()) {
            operand.set(expression.getOperand());
            return true;
        }
        operand.set(null);
        return false;
    }

    public static <T> boolean matchGetOperand(Node node, AstCode code, Class<T> operandType, StrongBox<? super T> operand) {
        Expression expression;
        if (node instanceof Expression && (expression = (Expression)node).getCode() == code && expression.getArguments().isEmpty() && operandType.isInstance(expression.getOperand())) {
            operand.set(expression.getOperand());
            return true;
        }
        operand.set(null);
        return false;
    }

    public static boolean matchGetArguments(Node node, AstCode code, List<Expression> arguments) {
        Expression expression;
        if (node instanceof Expression && (expression = (Expression)node).getCode() == code) {
            assert (expression.getOperand() == null);
            arguments.clear();
            arguments.addAll(expression.getArguments());
            return true;
        }
        arguments.clear();
        return false;
    }

    public static <T> boolean matchGetArguments(Node node, AstCode code, StrongBox<? super T> operand, List<Expression> arguments) {
        Expression expression;
        if (node instanceof Expression && (expression = (Expression)node).getCode() == code) {
            operand.set(expression.getOperand());
            arguments.clear();
            arguments.addAll(expression.getArguments());
            return true;
        }
        operand.set(null);
        arguments.clear();
        return false;
    }

    public static boolean matchGetArgument(Node node, AstCode code, StrongBox<Expression> argument) {
        ArrayList<Expression> arguments = new ArrayList<Expression>(1);
        if (PatternMatching.matchGetArguments(node, code, arguments) && arguments.size() == 1) {
            argument.set(arguments.get(0));
            return true;
        }
        argument.set(null);
        return false;
    }

    public static <T> boolean matchGetArgument(Node node, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        ArrayList<Expression> arguments = new ArrayList<Expression>(1);
        if (PatternMatching.matchGetArguments(node, code, operand, arguments) && arguments.size() == 1) {
            argument.set(arguments.get(0));
            return true;
        }
        argument.set(null);
        return false;
    }

    public static <T> boolean matchGetArguments(Node node, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument1, StrongBox<Expression> argument2) {
        ArrayList<Expression> arguments = new ArrayList<Expression>(2);
        if (PatternMatching.matchGetArguments(node, code, operand, arguments) && arguments.size() == 2) {
            argument1.set(arguments.get(0));
            argument2.set(arguments.get(1));
            return true;
        }
        argument1.set(null);
        argument2.set(null);
        return false;
    }

    public static <T> boolean matchSingle(Block block, AstCode code, StrongBox<? super T> operand) {
        List<Node> body = block.getBody();
        if (body.size() == 1 && PatternMatching.matchGetOperand(body.get(0), code, operand)) {
            return true;
        }
        operand.set(null);
        return false;
    }

    public static <T> boolean matchSingle(Block block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        List<Node> body = block.getBody();
        if (body.size() == 1 && PatternMatching.matchGetArgument(body.get(0), code, operand, argument)) {
            return true;
        }
        operand.set(null);
        argument.set(null);
        return false;
    }

    public static boolean matchNullOrEmpty(Block block) {
        return block == null || block.getBody().size() == 0;
    }

    public static boolean matchEmptyReturn(Node node) {
        Node target = node;
        if (node instanceof Block || node instanceof BasicBlock) {
            List<Node> body;
            List<Node> list = body = node instanceof Block ? ((Block)node).getBody() : ((BasicBlock)node).getBody();
            if (body.size() != 1) {
                return false;
            }
            target = body.get(0);
        }
        if (target instanceof Expression) {
            Expression e = (Expression)target;
            return e.getCode() == AstCode.Return && e.getArguments().isEmpty();
        }
        return false;
    }

    public static boolean matchEmptyBlockOrLeave(Node node) {
        if (node instanceof Block || node instanceof BasicBlock) {
            List<Node> body = node instanceof Block ? ((Block)node).getBody() : ((BasicBlock)node).getBody();
            switch (body.size()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return PatternMatching.match(body.get(0), AstCode.Leave);
                }
            }
            return false;
        }
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            return e.getCode() == AstCode.Leave;
        }
        return false;
    }

    public static <T> boolean matchSingle(BasicBlock block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        List<Node> body = block.getBody();
        if (body.size() == 2 && body.get(0) instanceof Label && PatternMatching.matchGetArgument(body.get(1), code, operand, argument)) {
            return true;
        }
        operand.set(null);
        argument.set(null);
        return false;
    }

    public static <T> boolean matchSingleAndBreak(BasicBlock block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument, StrongBox<Label> label) {
        List<Node> body = block.getBody();
        if (body.size() == 3 && body.get(0) instanceof Label && PatternMatching.matchGetArgument(body.get(1), code, operand, argument) && PatternMatching.matchGetOperand(body.get(2), AstCode.Goto, label)) {
            return true;
        }
        operand.set(null);
        argument.set(null);
        label.set(null);
        return false;
    }

    public static boolean matchSimpleBreak(BasicBlock block, StrongBox<Label> label) {
        List<Node> body = block.getBody();
        if (body.size() == 2 && body.get(0) instanceof Label && PatternMatching.matchGetOperand(body.get(1), AstCode.Goto, label)) {
            return true;
        }
        label.set(null);
        return false;
    }

    public static boolean matchSimpleBreak(BasicBlock block, Label label) {
        List<Node> body = block.getBody();
        return body.size() == 2 && body.get(0) instanceof Label && PatternMatching.match(body.get(1), AstCode.Goto) && ((Expression)body.get(1)).getOperand() == label;
    }

    public static boolean matchAssignmentAndConditionalBreak(BasicBlock block, StrongBox<Expression> assignedValue, StrongBox<Expression> condition, StrongBox<Label> trueLabel, StrongBox<Label> falseLabel, StrongBox<Expression> equivalentLoad) {
        List<Node> body = block.getBody();
        if (body.size() >= 4 && body.get(0) instanceof Label && body.get(body.size() - 3) instanceof Expression && PatternMatching.matchLastAndBreak(block, AstCode.IfTrue, trueLabel, condition, falseLabel)) {
            Expression e = (Expression)body.get(body.size() - 3);
            if (PatternMatching.match(e, AstCode.Store)) {
                assignedValue.set(e.getArguments().get(0));
                equivalentLoad.set(new Expression(AstCode.Load, e.getOperand(), e.getOffset(), new Expression[0]));
                return true;
            }
            if (PatternMatching.match(e, AstCode.PutStatic)) {
                assignedValue.set(e.getArguments().get(0));
                equivalentLoad.set(new Expression(AstCode.GetStatic, e.getOperand(), e.getOffset(), new Expression[0]));
                return true;
            }
            if (PatternMatching.matchElementAssignment(e, assignedValue, equivalentLoad)) {
                return true;
            }
            if (PatternMatching.match(e, AstCode.PutField)) {
                Expression arg0 = e.getArguments().get(0).clone();
                assignedValue.set(e.getArguments().get(1));
                equivalentLoad.set(new Expression(AstCode.GetField, null, arg0.getOffset(), arg0));
                return true;
            }
        }
        assignedValue.set(null);
        condition.set(null);
        trueLabel.set(null);
        falseLabel.set(null);
        return false;
    }

    public static boolean matchAssignment(Node node, StrongBox<Expression> assignedValue) {
        if (PatternMatching.match(node, AstCode.Store) || PatternMatching.match(node, AstCode.PutStatic)) {
            assignedValue.set(((Expression)node).getArguments().get(0));
            return true;
        }
        if (PatternMatching.match(node, AstCode.StoreElement)) {
            assignedValue.set(((Expression)node).getArguments().get(2));
            return true;
        }
        if (PatternMatching.match(node, AstCode.PutField)) {
            assignedValue.set(((Expression)node).getArguments().get(1));
            return true;
        }
        assignedValue.set(null);
        return false;
    }

    public static boolean matchAssignment(Node node, StrongBox<Expression> assignedValue, StrongBox<Expression> equivalentLoad) {
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            if (PatternMatching.match(e, AstCode.Store)) {
                assignedValue.set(e.getArguments().get(0));
                equivalentLoad.set(new Expression(AstCode.Load, e.getOperand(), e.getOffset(), new Expression[0]));
                return true;
            }
            if (PatternMatching.match(e, AstCode.PutStatic)) {
                assignedValue.set(e.getArguments().get(0));
                equivalentLoad.set(new Expression(AstCode.GetStatic, e.getOperand(), e.getOffset(), new Expression[0]));
                return true;
            }
            if (PatternMatching.matchElementAssignment(e, assignedValue, equivalentLoad)) {
                return true;
            }
            if (PatternMatching.match(e, AstCode.PutField)) {
                Expression arg0 = e.getArguments().get(0).clone();
                assignedValue.set(e.getArguments().get(1));
                equivalentLoad.set(new Expression(AstCode.GetField, e.getOperand(), arg0.getOffset(), arg0));
                return true;
            }
        }
        assignedValue.set(null);
        return false;
    }

    private static boolean matchElementAssignment(Node node, StrongBox<Expression> assignedValue, StrongBox<Expression> equivalentLoad) {
        if (PatternMatching.match(node, AstCode.StoreElement)) {
            Expression e = (Expression)node;
            Expression a0 = e.getArguments().get(0).clone();
            Expression a1 = e.getArguments().get(1).clone();
            assignedValue.set(e.getArguments().get(2));
            equivalentLoad.set(new Expression(AstCode.LoadElement, null, a0.getOffset(), a0, a1));
            return true;
        }
        assignedValue.set(null);
        equivalentLoad.set(null);
        return false;
    }

    public static boolean matchLast(BasicBlock block, AstCode code) {
        List<Node> body = block.getBody();
        return body.size() >= 1 && PatternMatching.match(body.get(body.size() - 1), code);
    }

    public static boolean matchLast(Block block, AstCode code) {
        List<Node> body = block.getBody();
        return body.size() >= 1 && PatternMatching.match(body.get(body.size() - 1), code);
    }

    public static <T> boolean matchLast(BasicBlock block, AstCode code, StrongBox<? super T> operand) {
        List<Node> body = block.getBody();
        if (body.size() >= 1 && PatternMatching.matchGetOperand(body.get(body.size() - 1), code, operand)) {
            return true;
        }
        operand.set(null);
        return false;
    }

    public static <T> boolean matchLast(Block block, AstCode code, StrongBox<? super T> operand) {
        List<Node> body = block.getBody();
        if (body.size() >= 1 && PatternMatching.matchGetOperand(body.get(body.size() - 1), code, operand)) {
            return true;
        }
        operand.set(null);
        return false;
    }

    public static <T> boolean matchLast(Block block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        return PatternMatching.matchLast(block.getBody(), code, operand, argument);
    }

    public static <T> boolean matchLast(BasicBlock block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        return PatternMatching.matchLast(block.getBody(), code, operand, argument);
    }

    private static <T> boolean matchLast(List<Node> body, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument) {
        if (body.size() >= 1 && PatternMatching.matchGetArgument(body.get(body.size() - 1), code, operand, argument)) {
            return true;
        }
        operand.set(null);
        argument.set(null);
        return false;
    }

    public static <T> boolean matchLastAndBreak(BasicBlock block, AstCode code, StrongBox<? super T> operand, StrongBox<Expression> argument, StrongBox<Label> label) {
        List<Node> body = block.getBody();
        if (body.size() >= 2 && PatternMatching.matchGetArgument(body.get(body.size() - 2), code, operand, argument) && PatternMatching.matchGetOperand(body.get(body.size() - 1), AstCode.Goto, label)) {
            return true;
        }
        operand.set(null);
        argument.set(null);
        label.set(null);
        return false;
    }

    public static boolean matchThis(Node node) {
        ParameterDefinition p;
        StrongBox operand = new StrongBox();
        return PatternMatching.matchGetOperand(node, AstCode.Load, operand) && (p = ((Variable)operand.get()).getOriginalParameter()) != null && p.getPosition() == -1;
    }

    public static boolean matchLoadAny(final Node node, Iterable<Variable> expectedVariables) {
        return CollectionUtilities.any(expectedVariables, new Predicate<Variable>(){

            @Override
            public boolean test(Variable variable) {
                return PatternMatching.matchLoad(node, variable);
            }
        });
    }

    public static boolean matchLoad(Node node, StrongBox<Variable> variable) {
        return PatternMatching.matchGetOperand(node, AstCode.Load, variable);
    }

    public static boolean matchNumericLdC(Node node, StrongBox<Number> value) {
        if (PatternMatching.matchGetOperand(node, AstCode.LdC, value) && value.get() instanceof Number) {
            return true;
        }
        value.set(null);
        return false;
    }

    public static boolean matchVariableIncDec(Node node, StrongBox<Variable> variable) {
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            List<Expression> a = e.getArguments();
            AstCode code = e.getCode();
            if (code.isIncDec()) {
                Variable v;
                StrongBox<Variable> valueBox = variable;
                StrongBox<Expression> argument = new StrongBox<Expression>();
                if (PatternMatching.matchGetArgument(e, AstCode.Inc, variable, argument) && (v = variable.get()) != null && PatternMatching.matchNumericLdC(argument.get(), valueBox)) {
                    variable.set(v);
                    return true;
                }
                if (PatternMatching.matchGetArgument(e, code, valueBox, argument) && valueBox.get() instanceof Number && PatternMatching.matchLoad((Node)argument.get(), variable)) {
                    return true;
                }
            }
        }
        variable.set(null);
        return false;
    }

    public static boolean matchVariableIncDec(Node node, StrongBox<Variable> variable, StrongBox<Number> amount) {
        Expression e;
        AstCode code;
        if (node instanceof Expression && (code = (e = (Expression)node).getCode()).isIncDec()) {
            StrongBox<Expression> argument = new StrongBox<Expression>();
            if (PatternMatching.matchGetArgument(e, AstCode.Inc, variable, argument) && PatternMatching.matchNumericLdC(argument.get(), amount)) {
                return true;
            }
            if (PatternMatching.matchGetArgument(e, code, amount, argument) && amount.get() instanceof Number && PatternMatching.matchLoad((Node)argument.get(), variable)) {
                return true;
            }
        }
        variable.set(null);
        amount.set(null);
        return false;
    }

    public static boolean matchStore(Node node, StrongBox<Variable> variable, StrongBox<Expression> argument) {
        return PatternMatching.matchGetArgument(node, AstCode.Store, variable, argument);
    }

    public static boolean matchStore(Node node, StrongBox<Variable> variable, List<Expression> argument) {
        return PatternMatching.matchGetArguments(node, AstCode.Store, variable, argument);
    }

    public static boolean matchLoadOrRet(Node node, StrongBox<Variable> variable) {
        return PatternMatching.matchGetOperand(node, AstCode.Load, variable) || PatternMatching.matchGetOperand(node, AstCode.Ret, variable);
    }

    public static boolean matchLoad(Node node, Variable expectedVariable) {
        StrongBox operand = new StrongBox();
        return PatternMatching.matchGetOperand(node, AstCode.Load, operand) && Comparer.equals((Variable)operand.get(), expectedVariable);
    }

    public static boolean matchStore(Node node, Variable expectedVariable) {
        return PatternMatching.match(node, AstCode.Store) && Comparer.equals(((Expression)node).getOperand(), expectedVariable);
    }

    public static boolean matchStore(Node node, Variable expectedVariable, StrongBox<Expression> value) {
        StrongBox v = new StrongBox();
        if (PatternMatching.matchGetArgument(node, AstCode.Store, v, value) && Comparer.equals(((Expression)node).getOperand(), expectedVariable) && v.get() == expectedVariable) {
            return true;
        }
        value.set(null);
        return false;
    }

    public static boolean matchLoad(Node node, Variable expectedVariable, StrongBox<Expression> argument) {
        StrongBox operand = new StrongBox();
        return PatternMatching.matchGetArgument(node, AstCode.Load, operand, argument) && Comparer.equals((Variable)operand.get(), expectedVariable);
    }

    public static boolean matchLoadStore(Node node, Variable expectedVariable, StrongBox<Variable> targetVariable) {
        StrongBox<Expression> temp = new StrongBox<Expression>();
        if (PatternMatching.matchGetArgument(node, AstCode.Store, targetVariable, temp) && PatternMatching.matchLoad((Node)temp.get(), expectedVariable)) {
            return true;
        }
        targetVariable.set(null);
        return false;
    }

    public static boolean matchLoadStoreAny(Node node, Iterable<Variable> expectedVariables, StrongBox<Variable> targetVariable) {
        for (Variable variable : VerifyArgument.notNull(expectedVariables, "expectedVariables")) {
            if (!PatternMatching.matchLoadStore(node, variable, targetVariable)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchBooleanComparison(Node node, StrongBox<Expression> argument, StrongBox<Boolean> comparand) {
        ArrayList<Expression> a = new ArrayList<Expression>(2);
        if (PatternMatching.matchGetArguments(node, AstCode.CmpEq, a) || PatternMatching.matchGetArguments(node, AstCode.CmpNe, a)) {
            comparand.set(PatternMatching.matchBooleanConstant((Node)a.get(0)));
            if (comparand.get() == null) {
                comparand.set(PatternMatching.matchBooleanConstant((Node)a.get(1)));
                if (comparand.get() == null) {
                    return false;
                }
                argument.set(a.get(0));
            } else {
                argument.set(a.get(1));
            }
            comparand.set(PatternMatching.match(node, AstCode.CmpEq) ^ comparand.get() == Boolean.FALSE);
            return true;
        }
        return false;
    }

    public static boolean matchComparison(Node node, StrongBox<Expression> left, StrongBox<Expression> right) {
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            switch (e.getCode()) {
                case CmpEq: 
                case CmpNe: 
                case CmpLt: 
                case CmpGe: 
                case CmpGt: 
                case CmpLe: {
                    List<Expression> arguments = e.getArguments();
                    left.set(arguments.get(0));
                    right.set(arguments.get(1));
                    return true;
                }
            }
        }
        left.set(null);
        right.set(null);
        return false;
    }

    public static boolean matchSimplifiableComparison(Node node) {
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            switch (e.getCode()) {
                case CmpEq: 
                case CmpNe: 
                case CmpLt: 
                case CmpGe: 
                case CmpGt: 
                case CmpLe: {
                    Expression comparisonArgument = e.getArguments().get(0);
                    switch (comparisonArgument.getCode()) {
                        case __LCmp: 
                        case __FCmpL: 
                        case __FCmpG: 
                        case __DCmpL: 
                        case __DCmpG: {
                            Expression constantArgument = e.getArguments().get(1);
                            StrongBox comparand = new StrongBox();
                            return PatternMatching.matchGetOperand(constantArgument, AstCode.LdC, Integer.class, comparand) && (Integer)comparand.get() == 0;
                        }
                    }
                }
            }
        }
        return false;
    }

    public static boolean matchReversibleComparison(Node node) {
        if (PatternMatching.match(node, AstCode.LogicalNot)) {
            switch (((Expression)node).getArguments().get(0).getCode()) {
                case CmpEq: 
                case CmpNe: 
                case CmpLt: 
                case CmpGe: 
                case CmpGt: 
                case CmpLe: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean matchReturnOrThrow(Node node) {
        return PatternMatching.match(node, AstCode.Return) || PatternMatching.match(node, AstCode.AThrow);
    }

    public static Boolean matchTrue(Node node) {
        return Boolean.TRUE.equals(PatternMatching.matchBooleanConstant(node));
    }

    public static Boolean matchFalse(Node node) {
        return Boolean.FALSE.equals(PatternMatching.matchBooleanConstant(node));
    }

    public static Boolean matchBooleanConstant(Node node) {
        if (PatternMatching.match(node, AstCode.LdC)) {
            Object operand = ((Expression)node).getOperand();
            if (operand instanceof Boolean) {
                return (Boolean)operand;
            }
            if (operand instanceof Number && !(operand instanceof Float) && !(operand instanceof Double)) {
                long longValue = ((Number)operand).longValue();
                if (longValue == 0L) {
                    return Boolean.FALSE;
                }
                if (longValue == 1L) {
                    return Boolean.TRUE;
                }
            }
        }
        return null;
    }

    public static Character matchCharacterConstant(Node node) {
        if (PatternMatching.match(node, AstCode.LdC)) {
            long longValue;
            Object operand = ((Expression)node).getOperand();
            if (operand instanceof Character) {
                return (Character)operand;
            }
            if (operand instanceof Number && !(operand instanceof Float) && !(operand instanceof Double) && (longValue = ((Number)operand).longValue()) >= 0L && longValue <= 65535L) {
                return Character.valueOf((char)longValue);
            }
        }
        return null;
    }

    public static boolean matchBooleanConstant(Node node, StrongBox<Boolean> value) {
        Boolean booleanConstant = PatternMatching.matchBooleanConstant(node);
        if (booleanConstant != null) {
            value.set(booleanConstant);
            return true;
        }
        value.set(null);
        return false;
    }

    public static boolean matchCharacterConstant(Node node, StrongBox<Character> value) {
        Character characterConstant = PatternMatching.matchCharacterConstant(node);
        if (characterConstant != null) {
            value.set(characterConstant);
            return true;
        }
        value.set(null);
        return false;
    }

    public static boolean matchUnconditionalBranch(Node node) {
        return node instanceof Expression && ((Expression)node).getCode().isUnconditionalControlFlow();
    }

    public static boolean matchLock(List<Node> body, int position, StrongBox<LockInfo> result) {
        Label leadingLabel;
        VerifyArgument.notNull(body, "body");
        VerifyArgument.notNull(result, "result");
        result.set(null);
        int head = position;
        if (head < 0 || head >= body.size()) {
            return false;
        }
        ArrayList<Expression> a = new ArrayList<Expression>();
        if (body.get(head) instanceof Label) {
            leadingLabel = (Label)body.get(head);
            ++head;
        } else {
            leadingLabel = null;
        }
        if (head >= body.size()) {
            return false;
        }
        if (PatternMatching.matchGetArguments(body.get(head), AstCode.MonitorEnter, a)) {
            if (!PatternMatching.match((Node)a.get(0), AstCode.Load)) {
                return false;
            }
            result.set(new LockInfo(leadingLabel, (Expression)body.get(head)));
            return true;
        }
        StrongBox<Variable> v = new StrongBox<Variable>();
        if (head < body.size() - 1 && PatternMatching.matchGetArguments(body.get(head), AstCode.Store, v, a)) {
            Variable lockVariable = (Variable)v.get();
            Expression lockInit = (Expression)a.get(0);
            Expression lockStore = (Expression)body.get(head++);
            Expression lockStoreCopy = PatternMatching.matchLoadStore(body.get(head), lockVariable, v) ? (Expression)body.get(head++) : null;
            if (head < body.size() && PatternMatching.matchGetArguments(body.get(head), AstCode.MonitorEnter, a)) {
                if (!PatternMatching.matchLoad((Node)a.get(0), lockVariable)) {
                    if (PatternMatching.matchGetOperand(lockInit, AstCode.Load, v) && PatternMatching.matchLoad((Node)a.get(0), v.get())) {
                        lockStoreCopy = lockStore;
                        lockStore = null;
                        lockInit = null;
                    } else {
                        return false;
                    }
                }
                result.set(new LockInfo(leadingLabel, lockInit, lockStore, lockStoreCopy, (Expression)body.get(head)));
                return true;
            }
        }
        return false;
    }

    public static boolean matchUnlock(Node e, LockInfo lockInfo) {
        if (lockInfo == null) {
            return false;
        }
        StrongBox<Expression> a = new StrongBox<Expression>();
        return PatternMatching.matchGetArgument(e, AstCode.MonitorExit, a) && (PatternMatching.matchLoad((Node)a.get(), lockInfo.lock) || lockInfo.lockCopy != null && PatternMatching.matchLoad((Node)a.get(), lockInfo.lockCopy));
    }

    public static boolean matchVariableMutation(Node node, Variable variable) {
        VerifyArgument.notNull(node, "node");
        VerifyArgument.notNull(variable, "variable");
        if (node instanceof Expression) {
            Expression e = (Expression)node;
            switch (e.getCode()) {
                case Store: 
                case Inc: {
                    return e.getOperand() == variable;
                }
                case PreIncrement: 
                case PostIncrement: {
                    return PatternMatching.matchLoad((Node)CollectionUtilities.single(e.getArguments()), variable);
                }
            }
        }
        return false;
    }
}

