/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.assembler.Collection;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Block
extends Node {
    private final Collection<Node> _body = new Collection();
    private Expression _entryGoto;

    public Block() {
    }

    public Block(Iterable<Node> body) {
        this();
        for (Node node : VerifyArgument.notNull(body, "body")) {
            this._body.add(node);
        }
    }

    public Block(Node ... body) {
        this();
        Collections.addAll(this._body, VerifyArgument.notNull(body, "body"));
    }

    public final Expression getEntryGoto() {
        return this._entryGoto;
    }

    public final void setEntryGoto(Expression entryGoto) {
        this._entryGoto = entryGoto;
    }

    public final List<Node> getBody() {
        return this._body;
    }

    @Override
    public final List<Node> getChildren() {
        ArrayList<Node> childrenCopy = new ArrayList<Node>(this._body.size() + 1);
        if (this._entryGoto != null) {
            childrenCopy.add(this._entryGoto);
        }
        childrenCopy.addAll(this._body);
        return childrenCopy;
    }

    @Override
    public void writeTo(ITextOutput output) {
        List<Node> children = this.getChildren();
        boolean previousWasSimpleNode = true;
        int i = 0;
        int childrenSize = children.size();
        while (i < childrenSize) {
            boolean isSimpleNode;
            Node child = children.get(i);
            boolean bl = isSimpleNode = child instanceof Expression || child instanceof Label;
            if (i != 0 && !isSimpleNode || !previousWasSimpleNode) {
                output.writeLine();
            }
            child.writeTo(output);
            if (isSimpleNode) {
                output.writeLine();
            }
            previousWasSimpleNode = isSimpleNode;
            ++i;
        }
    }
}

