/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.flowanalysis.ControlFlowEdge;
import com.strobel.assembler.flowanalysis.ControlFlowGraph;
import com.strobel.assembler.flowanalysis.ControlFlowGraphBuilder;
import com.strobel.assembler.flowanalysis.ControlFlowNode;
import com.strobel.assembler.flowanalysis.ControlFlowNodeType;
import com.strobel.assembler.flowanalysis.JumpType;
import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.FlowControl;
import com.strobel.assembler.ir.Frame;
import com.strobel.assembler.ir.FrameType;
import com.strobel.assembler.ir.FrameValue;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionBlock;
import com.strobel.assembler.ir.InstructionCollection;
import com.strobel.assembler.ir.InstructionVisitor;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.StackMappingVisitor;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CoreMetadataFactory;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableDefinitionCollection;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.MutableInteger;
import com.strobel.core.Pair;
import com.strobel.core.Predicate;
import com.strobel.core.Predicates;
import com.strobel.core.StringUtilities;
import com.strobel.core.StrongBox;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.InstructionHelper;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.ast.AstCode;
import com.strobel.decompiler.ast.AstKeys;
import com.strobel.decompiler.ast.Block;
import com.strobel.decompiler.ast.CatchBlock;
import com.strobel.decompiler.ast.Expression;
import com.strobel.decompiler.ast.Label;
import com.strobel.decompiler.ast.Node;
import com.strobel.decompiler.ast.PatternMatching;
import com.strobel.decompiler.ast.Range;
import com.strobel.decompiler.ast.TryCatchBlock;
import com.strobel.decompiler.ast.Variable;
import com.strobel.functions.Function;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AstBuilder {
    private static final Logger LOG = Logger.getLogger(AstBuilder.class.getSimpleName());
    private static final AstCode[] CODES = AstCode.values();
    private static final StackSlot[] EMPTY_STACK = new StackSlot[0];
    private static final ByteCode[] EMPTY_DEFINITIONS = new ByteCode[0];
    private final Map<ExceptionHandler, ByteCode> _loadExceptions = new LinkedHashMap<ExceptionHandler, ByteCode>();
    private final Set<Instruction> _removed = new LinkedHashSet<Instruction>();
    private Map<Instruction, Instruction> _originalInstructionMap;
    private ControlFlowGraph _cfg;
    private InstructionCollection _instructions;
    private List<ExceptionHandler> _exceptionHandlers;
    private MethodBody _body;
    private boolean _optimize;
    private DecompilerContext _context;
    private CoreMetadataFactory _factory;
    private static final Predicate<Node> NOT_A_LABEL_OR_NOP = new Predicate<Node>(){

        @Override
        public boolean test(Node node) {
            return !(node instanceof Label) && !PatternMatching.match(node, AstCode.Nop);
        }
    };

    public static List<Node> build(MethodBody body, boolean optimize, DecompilerContext context) {
        AstBuilder builder = new AstBuilder();
        builder._body = VerifyArgument.notNull(body, "body");
        builder._optimize = optimize;
        builder._context = VerifyArgument.notNull(context, "context");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Beginning bytecode AST construction for %s:%s...", body.getMethod().getFullName(), body.getMethod().getSignature()));
        }
        if (body.getInstructions().isEmpty()) {
            return Collections.emptyList();
        }
        builder._instructions = AstBuilder.copyInstructions(body.getInstructions());
        InstructionCollection oldInstructions = body.getInstructions();
        InstructionCollection newInstructions = builder._instructions;
        builder._originalInstructionMap = new IdentityHashMap<Instruction, Instruction>();
        int i = 0;
        while (i < newInstructions.size()) {
            builder._originalInstructionMap.put((Instruction)newInstructions.get(i), (Instruction)oldInstructions.get(i));
            ++i;
        }
        builder._exceptionHandlers = AstBuilder.remapHandlers(body.getExceptionHandlers(), builder._instructions);
        Collections.sort(builder._exceptionHandlers);
        builder.removeGetClassCallsForInvokeDynamic();
        builder.pruneExceptionHandlers();
        builder.inlineSubroutines();
        FinallyInlining.run(builder._body, builder._instructions, builder._exceptionHandlers, builder._removed);
        builder._cfg = ControlFlowGraphBuilder.build(builder._instructions, builder._exceptionHandlers);
        builder._cfg.computeDominance();
        builder._cfg.computeDominanceFrontier();
        LOG.fine("Performing stack analysis...");
        List<ByteCode> byteCode = builder.performStackAnalysis();
        LOG.fine("Creating bytecode AST...");
        List<Node> ast = builder.convertToAst(byteCode, new LinkedHashSet<ExceptionHandler>(builder._exceptionHandlers), 0, new MutableInteger(byteCode.size()));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Finished bytecode AST construction for %s:%s.", body.getMethod().getFullName(), body.getMethod().getSignature()));
        }
        return ast;
    }

    private static boolean isGetClassInvocation(Instruction p) {
        return p != null && p.getOpCode() == OpCode.INVOKEVIRTUAL && ((MethodReference)p.getOperand(0)).getParameters().isEmpty() && StringUtilities.equals(((MethodReference)p.getOperand(0)).getName(), "getClass");
    }

    private void removeGetClassCallsForInvokeDynamic() {
        for (Instruction i : this._instructions) {
            Instruction p3;
            Instruction p2;
            Instruction p1;
            if (i.getOpCode() != OpCode.INVOKEDYNAMIC || (p1 = i.getPrevious()) == null || p1.getOpCode() != OpCode.POP || (p2 = p1.getPrevious()) == null || !AstBuilder.isGetClassInvocation(p2) || (p3 = p2.getPrevious()) == null || p3.getOpCode() != OpCode.DUP) continue;
            p1.setOpCode(OpCode.NOP);
            p1.setOperand(null);
            p2.setOpCode(OpCode.NOP);
            p2.setOperand(null);
            p3.setOpCode(OpCode.NOP);
            p3.setOperand(null);
        }
    }

    private void inlineSubroutines() {
        LOG.fine("Inlining subroutines...");
        List<SubroutineInfo> subroutines = this.findSubroutines();
        if (subroutines.isEmpty()) {
            return;
        }
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        HashSet<ExceptionHandler> originalHandlers = new HashSet<ExceptionHandler>(handlers);
        ArrayList<SubroutineInfo> inlinedSubroutines = new ArrayList<SubroutineInfo>();
        HashSet<Instruction> instructionsToKeep = new HashSet<Instruction>();
        for (SubroutineInfo subroutine : subroutines) {
            if (this.callsOtherSubroutine(subroutine, subroutines)) continue;
            boolean fullyInlined = true;
            for (Instruction reference : subroutine.liveReferences) {
                fullyInlined &= this.inlineSubroutine(subroutine, reference);
            }
            for (Instruction p : subroutine.deadReferences) {
                p.setOpCode(OpCode.NOP);
                p.setOperand(null);
                this._removed.add(p);
            }
            if (fullyInlined) {
                inlinedSubroutines.add(subroutine);
                continue;
            }
            for (ControlFlowNode node : subroutine.contents) {
                Instruction p = node.getStart();
                while (p != null && p.getOffset() < node.getStart().getEndOffset()) {
                    instructionsToKeep.add(p);
                    p = p.getNext();
                }
            }
        }
        for (SubroutineInfo subroutine : inlinedSubroutines) {
            Instruction p = subroutine.start;
            while (p != null && p.getOffset() < subroutine.end.getEndOffset()) {
                if (!instructionsToKeep.contains(p)) {
                    p.setOpCode(OpCode.NOP);
                    p.setOperand(null);
                    this._removed.add(p);
                }
                p = p.getNext();
            }
            for (ExceptionHandler handler : subroutine.containedHandlers) {
                if (!originalHandlers.contains(handler)) continue;
                handlers.remove(handler);
            }
        }
    }

    private boolean inlineSubroutine(SubroutineInfo subroutine, Instruction reference) {
        boolean nonEmpty;
        if (!subroutine.start.getOpCode().isStore() && subroutine.start.getOpCode() != OpCode.POP) {
            return false;
        }
        InstructionCollection instructions = this._instructions;
        Map<Instruction, Instruction> originalInstructionMap = this._originalInstructionMap;
        boolean bl = nonEmpty = subroutine.start != subroutine.end && subroutine.start.getNext() != subroutine.end;
        if (nonEmpty) {
            int jumpIndex = instructions.indexOf(reference);
            ArrayList<Instruction> originalContents = new ArrayList<Instruction>();
            for (ControlFlowNode node : subroutine.contents) {
                Instruction p = node.getStart();
                while (p != null && p.getOffset() < node.getEnd().getEndOffset()) {
                    originalContents.add(p);
                    p = p.getNext();
                }
            }
            IdentityHashMap<Instruction, Instruction> remappedJumps = new IdentityHashMap<Instruction, Instruction>();
            InstructionCollection contents = AstBuilder.copyInstructions(originalContents);
            int i = 0;
            int n = originalContents.size();
            while (i < n) {
                remappedJumps.put((Instruction)originalContents.get(i), (Instruction)contents.get(i));
                originalInstructionMap.put((Instruction)contents.get(i), AstBuilder.mappedInstruction(originalInstructionMap, (Instruction)originalContents.get(i)));
                ++i;
            }
            Instruction newStart = AstBuilder.mappedInstruction(remappedJumps, subroutine.start);
            Instruction newEnd = reference.getNext() != null ? reference.getNext() : AstBuilder.mappedInstruction(remappedJumps, subroutine.end).getPrevious();
            for (ControlFlowNode exitNode : subroutine.exitNodes) {
                Instruction newExit = AstBuilder.mappedInstruction(remappedJumps, exitNode.getEnd());
                if (newExit == null) continue;
                newExit.setOpCode(OpCode.GOTO);
                newExit.setOperand(newEnd);
                remappedJumps.put(newExit, newEnd);
            }
            newStart.setOpCode(OpCode.NOP);
            newStart.setOperand(null);
            instructions.addAll(jumpIndex, CollectionUtilities.toList(contents));
            if (newStart != CollectionUtilities.first(contents)) {
                instructions.add(jumpIndex, new Instruction(OpCode.GOTO, (Object)newStart));
            }
            instructions.remove(reference);
            instructions.recomputeOffsets();
            remappedJumps.put(reference, CollectionUtilities.first(contents));
            remappedJumps.put(subroutine.end, newEnd);
            remappedJumps.put(subroutine.start, newStart);
            this.remapJumps(Collections.singletonMap(reference, newStart));
            this.remapHandlersForInlinedSubroutine(reference, CollectionUtilities.first(contents), CollectionUtilities.last(contents));
            this.duplicateHandlersForInlinedSubroutine(subroutine, remappedJumps);
        } else {
            reference.setOpCode(OpCode.NOP);
            reference.setOperand((Object)OpCode.NOP);
        }
        return true;
    }

    private void remapHandlersForInlinedSubroutine(Instruction jump, Instruction start, Instruction end) {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            InstructionBlock oldTry = handler.getTryBlock();
            InstructionBlock oldHandler = handler.getHandlerBlock();
            InstructionBlock newTryBlock = oldTry.getFirstInstruction() == jump || oldTry.getLastInstruction() == jump ? new InstructionBlock(oldTry.getFirstInstruction() == jump ? start : oldTry.getFirstInstruction(), oldTry.getLastInstruction() == jump ? end : oldTry.getLastInstruction()) : oldTry;
            InstructionBlock newHandlerBlock = oldHandler.getFirstInstruction() == jump || oldHandler.getLastInstruction() == jump ? new InstructionBlock(oldHandler.getFirstInstruction() == jump ? start : oldHandler.getFirstInstruction(), oldHandler.getLastInstruction() == jump ? end : oldHandler.getLastInstruction()) : oldHandler;
            if (newTryBlock != oldTry || newHandlerBlock != oldHandler) {
                if (handler.isCatch()) {
                    handlers.set(i, ExceptionHandler.createCatch(newTryBlock, newHandlerBlock, handler.getCatchType()));
                } else {
                    handlers.set(i, ExceptionHandler.createFinally(newTryBlock, newHandlerBlock));
                }
            }
            ++i;
        }
    }

    private void duplicateHandlersForInlinedSubroutine(SubroutineInfo subroutine, Map<Instruction, Instruction> oldToNew) {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        for (ExceptionHandler handler : subroutine.containedHandlers) {
            InstructionBlock oldTry = handler.getTryBlock();
            InstructionBlock oldHandler = handler.getHandlerBlock();
            Instruction newTryStart = AstBuilder.mappedInstruction(oldToNew, oldTry.getFirstInstruction());
            Instruction newTryEnd = AstBuilder.mappedInstruction(oldToNew, oldTry.getLastInstruction());
            Instruction newHandlerStart = AstBuilder.mappedInstruction(oldToNew, oldHandler.getFirstInstruction());
            Instruction newHandlerEnd = AstBuilder.mappedInstruction(oldToNew, oldHandler.getLastInstruction());
            InstructionBlock newTryBlock = newTryStart != null || newTryEnd != null ? new InstructionBlock(newTryStart != null ? newTryStart : oldTry.getFirstInstruction(), newTryEnd != null ? newTryEnd : oldTry.getLastInstruction()) : oldTry;
            InstructionBlock newHandlerBlock = newHandlerStart != null || newHandlerEnd != null ? new InstructionBlock(newHandlerStart != null ? newHandlerStart : oldHandler.getFirstInstruction(), newHandlerEnd != null ? newHandlerEnd : oldHandler.getLastInstruction()) : oldHandler;
            if (newTryBlock == oldTry && newHandlerBlock == oldHandler) continue;
            handlers.add(handler.isCatch() ? ExceptionHandler.createCatch(newTryBlock, newHandlerBlock, handler.getCatchType()) : ExceptionHandler.createFinally(newTryBlock, newHandlerBlock));
        }
    }

    private void remapJumps(Map<Instruction, Instruction> remappedJumps) {
        for (Instruction instruction : this._instructions) {
            if (instruction.hasLabel()) {
                instruction.getLabel().setIndex(instruction.getOffset());
            }
            if (instruction.getOperandCount() == 0) continue;
            Object operand = instruction.getOperand(0);
            if (operand instanceof Instruction) {
                Instruction oldTarget = (Instruction)operand;
                Instruction newTarget = AstBuilder.mappedInstruction(remappedJumps, oldTarget);
                if (newTarget == null) continue;
                if (newTarget == instruction) {
                    instruction.setOpCode(OpCode.NOP);
                    instruction.setOperand(null);
                    continue;
                }
                instruction.setOperand(newTarget);
                if (newTarget.hasLabel()) continue;
                newTarget.setLabel(new com.strobel.assembler.metadata.Label(newTarget.getOffset()));
                continue;
            }
            if (!(operand instanceof SwitchInfo)) continue;
            SwitchInfo oldOperand = (SwitchInfo)operand;
            Instruction oldDefault = oldOperand.getDefaultTarget();
            Instruction newDefault = AstBuilder.mappedInstruction(remappedJumps, oldDefault);
            if (newDefault != null && !newDefault.hasLabel()) {
                newDefault.setLabel(new com.strobel.assembler.metadata.Label(newDefault.getOffset()));
            }
            Instruction[] oldTargets = oldOperand.getTargets();
            Instruction[] newTargets = null;
            int i = 0;
            while (i < oldTargets.length) {
                Instruction newTarget = AstBuilder.mappedInstruction(remappedJumps, oldTargets[i]);
                if (newTarget != null) {
                    if (newTargets == null) {
                        newTargets = Arrays.copyOf(oldTargets, oldTargets.length);
                    }
                    newTargets[i] = newTarget;
                    if (!newTarget.hasLabel()) {
                        newTarget.setLabel(new com.strobel.assembler.metadata.Label(newTarget.getOffset()));
                    }
                }
                ++i;
            }
            if (newDefault == null && newTargets == null) continue;
            SwitchInfo newOperand = new SwitchInfo(oldOperand.getKeys(), newDefault != null ? newDefault : oldDefault, newTargets != null ? newTargets : oldTargets);
            instruction.setOperand(newOperand);
        }
    }

    private boolean callsOtherSubroutine(final SubroutineInfo subroutine, List<SubroutineInfo> subroutines) {
        return CollectionUtilities.any(subroutines, new Predicate<SubroutineInfo>(){

            @Override
            public boolean test(SubroutineInfo info) {
                return info != subroutine && CollectionUtilities.any(info.liveReferences, new Predicate<Instruction>(){

                    @Override
                    public boolean test(Instruction p) {
                        return p.getOffset() >= subroutine.start.getOffset() && p.getOffset() < subroutine.end.getEndOffset();
                    }
                }) && !subroutine.contents.containsAll(info.contents);
            }
        });
    }

    private List<SubroutineInfo> findSubroutines() {
        InstructionCollection instructions = this._instructions;
        if (instructions.isEmpty()) {
            return Collections.emptyList();
        }
        IdentityHashMap<ExceptionHandler, Pair<Set<ControlFlowNode>, Set<ControlFlowNode>>> handlerContents = null;
        IdentityHashMap<Instruction, SubroutineInfo> subroutineMap = null;
        ControlFlowGraph cfg = null;
        Instruction p = CollectionUtilities.first(instructions);
        while (p != null) {
            if (p.getOpCode().isJumpToSubroutine()) {
                Instruction target;
                boolean isLive;
                boolean bl = isLive = !this._removed.contains(p);
                if (cfg == null) {
                    cfg = ControlFlowGraphBuilder.build(instructions, this._exceptionHandlers);
                    cfg.computeDominance();
                    cfg.computeDominanceFrontier();
                    subroutineMap = new IdentityHashMap<Instruction, SubroutineInfo>();
                    handlerContents = new IdentityHashMap<ExceptionHandler, Pair<Set<ControlFlowNode>, Set<ControlFlowNode>>>();
                    for (ExceptionHandler handler : this._exceptionHandlers) {
                        InstructionBlock tryBlock = handler.getTryBlock();
                        InstructionBlock handlerBlock = handler.getHandlerBlock();
                        Set<ControlFlowNode> tryNodes = AstBuilder.findDominatedNodes(cfg, AstBuilder.findNode(cfg, tryBlock.getFirstInstruction()), true, Collections.emptySet());
                        Set<ControlFlowNode> handlerNodes = AstBuilder.findDominatedNodes(cfg, AstBuilder.findNode(cfg, handlerBlock.getFirstInstruction()), true, Collections.emptySet());
                        handlerContents.put(handler, Pair.create(tryNodes, handlerNodes));
                    }
                }
                if (!this._removed.contains(target = (Instruction)p.getOperand(0))) {
                    SubroutineInfo info = (SubroutineInfo)subroutineMap.get(target);
                    if (info == null) {
                        ControlFlowNode start = AstBuilder.findNode(cfg, target);
                        List<ControlFlowNode> contents = CollectionUtilities.toList(AstBuilder.findDominatedNodes(cfg, start, true, Collections.emptySet()));
                        Collections.sort(contents);
                        info = new SubroutineInfo(start, contents, cfg);
                        subroutineMap.put(target, info);
                        for (ExceptionHandler handler : this._exceptionHandlers) {
                            Pair pair = (Pair)handlerContents.get(handler);
                            if (!contents.containsAll((Collection)pair.getFirst()) || !contents.containsAll((Collection)pair.getSecond())) continue;
                            info.containedHandlers.add(handler);
                        }
                    }
                    if (isLive) {
                        info.liveReferences.add(p);
                    } else {
                        info.deadReferences.add(p);
                    }
                }
            }
            p = p.getNext();
        }
        if (subroutineMap == null) {
            return Collections.emptyList();
        }
        List<SubroutineInfo> subroutines = CollectionUtilities.toList(subroutineMap.values());
        Collections.sort(subroutines, new Comparator<SubroutineInfo>(){

            @Override
            public int compare(@NotNull SubroutineInfo o1, @NotNull SubroutineInfo o2) {
                if (o1.contents.containsAll(o2.contents)) {
                    return 1;
                }
                if (o2.contents.containsAll(o1.contents)) {
                    return -1;
                }
                return Integer.compare(o2.start.getOffset(), o1.start.getOffset());
            }
        });
        return subroutines;
    }

    private static ControlFlowNode findNode(ControlFlowGraph cfg, Instruction instruction) {
        int offset = instruction.getOffset();
        for (ControlFlowNode node : cfg.getNodes()) {
            if (node.getNodeType() != ControlFlowNodeType.Normal || offset < node.getStart().getOffset() || offset >= node.getEnd().getEndOffset()) continue;
            return node;
        }
        return null;
    }

    private static Set<ControlFlowNode> findDominatedNodes(ControlFlowGraph cfg, ControlFlowNode head, boolean diveIntoHandlers, Set<ControlFlowNode> terminals) {
        LinkedHashSet<ControlFlowNode> visited = new LinkedHashSet<ControlFlowNode>();
        ArrayDeque<ControlFlowNode> agenda = new ArrayDeque<ControlFlowNode>();
        LinkedHashSet<ControlFlowNode> result = new LinkedHashSet<ControlFlowNode>();
        agenda.add(head);
        visited.add(head);
        while (!agenda.isEmpty()) {
            ControlFlowNode addNode = (ControlFlowNode)agenda.removeFirst();
            if (terminals.contains(addNode)) continue;
            if (diveIntoHandlers && addNode.getExceptionHandler() != null) {
                addNode = AstBuilder.findNode(cfg, addNode.getExceptionHandler().getHandlerBlock().getFirstInstruction());
            } else if (diveIntoHandlers && addNode.getNodeType() == ControlFlowNodeType.EndFinally) {
                agenda.addAll(addNode.getDominatorTreeChildren());
                continue;
            }
            if (addNode == null || addNode.getNodeType() != ControlFlowNodeType.Normal || !head.dominates(addNode) && !AstBuilder.shouldIncludeExceptionalExit(cfg, head, addNode) || !result.add(addNode)) continue;
            for (ControlFlowNode successor : addNode.getSuccessors()) {
                if (!visited.add(successor)) continue;
                agenda.add(successor);
            }
        }
        return result;
    }

    private static boolean shouldIncludeExceptionalExit(ControlFlowGraph cfg, ControlFlowNode head, ControlFlowNode node) {
        ControlFlowNode innermostHandlerNode;
        if (node.getNodeType() != ControlFlowNodeType.Normal) {
            return false;
        }
        if (!(node.getDominanceFrontier().contains(cfg.getExceptionalExit()) || node.dominates(cfg.getExceptionalExit()) || (innermostHandlerNode = AstBuilder.findInnermostExceptionHandlerNode(cfg, node.getEnd().getOffset(), false)) != null && node.getDominanceFrontier().contains(innermostHandlerNode))) {
            return false;
        }
        return head.getNodeType() == ControlFlowNodeType.Normal && node.getNodeType() == ControlFlowNodeType.Normal && node.getStart().getNext() == node.getEnd() && head.getStart().getOpCode().isStore() && node.getStart().getOpCode().isLoad() && node.getEnd().getOpCode() == OpCode.ATHROW && InstructionHelper.getLoadOrStoreSlot(head.getStart()) == InstructionHelper.getLoadOrStoreSlot(node.getStart());
    }

    private static ControlFlowNode findInnermostExceptionHandlerNode(ControlFlowGraph cfg, int offsetInTryBlock, boolean finallyOnly) {
        ExceptionHandler result = null;
        ControlFlowNode resultNode = null;
        List<ControlFlowNode> nodes = cfg.getNodes();
        int i = nodes.size() - 1;
        while (i >= 0) {
            InstructionBlock tryBlock;
            ControlFlowNode node = nodes.get(i);
            ExceptionHandler handler = node.getExceptionHandler();
            if (handler == null) break;
            if (!(finallyOnly && handler.isCatch() || (tryBlock = handler.getTryBlock()).getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= tryBlock.getLastInstruction().getEndOffset() || result != null && tryBlock.getFirstInstruction().getOffset() <= result.getTryBlock().getFirstInstruction().getOffset())) {
                result = handler;
                resultNode = node;
            }
            --i;
        }
        return resultNode != null ? resultNode : cfg.getExceptionalExit();
    }

    private static boolean opCodesMatch(Instruction tail1, Instruction tail2, int count, Function<Instruction, Instruction> previous) {
        int i = 0;
        if (tail1 == null || tail2 == null) {
            return false;
        }
        Instruction p1 = tail1;
        Instruction p2 = tail2;
        while (p1 != null && p2 != null && i < count) {
            OpCode c1 = p1.getOpCode();
            OpCode c2 = p2.getOpCode();
            if (c1.isLoad() ? !c2.isLoad() || c2.getStackBehaviorPush() != c1.getStackBehaviorPush() : (c1.isStore() ? !c2.isStore() || c2.getStackBehaviorPop() != c1.getStackBehaviorPop() : c1 != p2.getOpCode())) {
                return false;
            }
            switch (c1.getOperandType()) {
                case TypeReferenceU1: {
                    if (!Objects.equals(p1.getOperand(1), p2.getOperand(1))) {
                        return false;
                    }
                }
                case PrimitiveTypeCode: 
                case TypeReference: {
                    if (Objects.equals(p1.getOperand(0), p2.getOperand(0))) break;
                    return false;
                }
                case MethodReference: 
                case FieldReference: {
                    MemberReference m1 = (MemberReference)p1.getOperand(0);
                    MemberReference m2 = (MemberReference)p2.getOperand(0);
                    if (StringUtilities.equals(m1.getFullName(), m2.getFullName()) && StringUtilities.equals(m1.getErasedSignature(), m2.getErasedSignature())) break;
                    return false;
                }
                case I1: 
                case I2: 
                case I8: 
                case Constant: 
                case WideConstant: {
                    if (Objects.equals(p1.getOperand(0), p2.getOperand(0))) break;
                    return false;
                }
                case LocalI1: 
                case LocalI2: {
                    if (Objects.equals(p1.getOperand(1), p2.getOperand(1))) break;
                    return false;
                }
            }
            p1 = previous.apply(p1);
            p2 = previous.apply(p2);
            ++i;
        }
        return i == count;
    }

    private static Map<Instruction, ControlFlowNode> createNodeMap(ControlFlowGraph cfg) {
        IdentityHashMap<Instruction, ControlFlowNode> nodeMap = new IdentityHashMap<Instruction, ControlFlowNode>();
        for (ControlFlowNode node : cfg.getNodes()) {
            if (node.getNodeType() != ControlFlowNodeType.Normal) continue;
            Instruction p = node.getStart();
            while (p != null && p.getOffset() < node.getEnd().getEndOffset()) {
                nodeMap.put(p, node);
                p = p.getNext();
            }
        }
        return nodeMap;
    }

    private static List<ExceptionHandler> remapHandlers(List<ExceptionHandler> handlers, InstructionCollection instructions) {
        ArrayList<ExceptionHandler> newHandlers = new ArrayList<ExceptionHandler>();
        for (ExceptionHandler handler : handlers) {
            InstructionBlock oldTry = handler.getTryBlock();
            InstructionBlock oldHandler = handler.getHandlerBlock();
            InstructionBlock newTry = new InstructionBlock(instructions.atOffset(oldTry.getFirstInstruction().getOffset()), instructions.atOffset(oldTry.getLastInstruction().getOffset()));
            InstructionBlock newHandler = new InstructionBlock(instructions.atOffset(oldHandler.getFirstInstruction().getOffset()), instructions.atOffset(oldHandler.getLastInstruction().getOffset()));
            if (handler.isCatch()) {
                newHandlers.add(ExceptionHandler.createCatch(newTry, newHandler, handler.getCatchType()));
                continue;
            }
            newHandlers.add(ExceptionHandler.createFinally(newTry, newHandler));
        }
        return newHandlers;
    }

    private static InstructionCollection copyInstructions(List<Instruction> instructions) {
        InstructionCollection instructionsCopy = new InstructionCollection();
        IdentityHashMap<Instruction, Instruction> oldToNew = new IdentityHashMap<Instruction, Instruction>();
        for (Instruction instruction : instructions) {
            Instruction copy = new Instruction(instruction.getOffset(), instruction.getOpCode());
            if (instruction.getOperandCount() > 1) {
                Object[] operands = new Object[instruction.getOperandCount()];
                int i = 0;
                while (i < operands.length) {
                    operands[i] = instruction.getOperand(i);
                    ++i;
                }
                copy.setOperand(operands);
            } else {
                copy.setOperand(instruction.getOperand(0));
            }
            copy.setLabel(instruction.getLabel());
            instructionsCopy.add(copy);
            oldToNew.put(instruction, copy);
        }
        for (Instruction instruction : instructionsCopy) {
            if (!instruction.hasOperand()) continue;
            Object operand = instruction.getOperand(0);
            if (operand instanceof Instruction) {
                instruction.setOperand(AstBuilder.mappedInstruction(oldToNew, (Instruction)operand));
                continue;
            }
            if (!(operand instanceof SwitchInfo)) continue;
            SwitchInfo oldOperand = (SwitchInfo)operand;
            Instruction oldDefault = oldOperand.getDefaultTarget();
            Instruction newDefault = AstBuilder.mappedInstruction(oldToNew, oldDefault);
            Instruction[] oldTargets = oldOperand.getTargets();
            Instruction[] newTargets = new Instruction[oldTargets.length];
            int i = 0;
            while (i < newTargets.length) {
                newTargets[i] = AstBuilder.mappedInstruction(oldToNew, oldTargets[i]);
                ++i;
            }
            SwitchInfo newOperand = new SwitchInfo(oldOperand.getKeys(), newDefault, newTargets);
            newOperand.setLowValue(oldOperand.getLowValue());
            newOperand.setHighValue(oldOperand.getHighValue());
            instruction.setOperand(newOperand);
        }
        instructionsCopy.recomputeOffsets();
        return instructionsCopy;
    }

    private void pruneExceptionHandlers() {
        InstructionBlock handlerBlock;
        List<ExceptionHandler> siblings;
        InstructionBlock tryBlock;
        ExceptionHandler handler;
        LOG.fine("Pruning exception handlers...");
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        if (handlers.isEmpty()) {
            return;
        }
        this.removeSelfHandlingFinallyHandlers();
        this.removeEmptyCatchBlockBodies();
        this.trimAggressiveFinallyBlocks();
        this.trimAggressiveCatchBlocks();
        this.closeTryHandlerGaps();
        this.mergeSharedHandlers();
        this.alignFinallyBlocksWithSiblingCatchBlocks();
        this.ensureDesiredProtectedRanges();
        int i = 0;
        while (i < handlers.size()) {
            handler = handlers.get(i);
            if (handler.isFinally()) {
                tryBlock = handler.getTryBlock();
                siblings = AstBuilder.findHandlers(tryBlock, handlers);
                int j = 0;
                while (j < siblings.size()) {
                    ExceptionHandler sibling = siblings.get(j);
                    if (sibling.isCatch() && j < siblings.size() - 1) {
                        ExceptionHandler nextSibling = siblings.get(j + 1);
                        if (sibling.getHandlerBlock().getLastInstruction() != nextSibling.getHandlerBlock().getFirstInstruction().getPrevious()) {
                            int index = handlers.indexOf(sibling);
                            handlers.set(index, ExceptionHandler.createCatch(sibling.getTryBlock(), new InstructionBlock(sibling.getHandlerBlock().getFirstInstruction(), nextSibling.getHandlerBlock().getFirstInstruction().getPrevious()), sibling.getCatchType()));
                            siblings.set(j, handlers.get(j));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < handlers.size()) {
            handler = handlers.get(i);
            if (handler.isFinally()) {
                tryBlock = handler.getTryBlock();
                siblings = AstBuilder.findHandlers(tryBlock, handlers);
                block3: for (ExceptionHandler sibling : siblings) {
                    if (sibling == handler || sibling.isFinally()) continue;
                    int j = 0;
                    while (j < handlers.size()) {
                        ExceptionHandler e = handlers.get(j);
                        if (e != handler && e != sibling && e.isFinally() && e.getTryBlock().getFirstInstruction() == sibling.getHandlerBlock().getFirstInstruction() && e.getHandlerBlock().equals(handler.getHandlerBlock())) {
                            handlers.remove(j);
                            int removeIndex = j--;
                            if (removeIndex < i) {
                                --i;
                                break block3;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < handlers.size()) {
            handler = handlers.get(i);
            if (handler.isFinally()) {
                tryBlock = handler.getTryBlock();
                handlerBlock = handler.getHandlerBlock();
                int j = 0;
                while (j < handlers.size()) {
                    ExceptionHandler other = handlers.get(j);
                    if (other != handler && other.isFinally() && other.getHandlerBlock().equals(handlerBlock) && tryBlock.contains(other.getTryBlock()) && tryBlock.getLastInstruction() == other.getTryBlock().getLastInstruction()) {
                        handlers.remove(j);
                        if (j < i) {
                            --i;
                            break;
                        }
                        --j;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < handlers.size()) {
            handler = handlers.get(i);
            tryBlock = handler.getTryBlock();
            ExceptionHandler firstHandler = AstBuilder.findFirstHandler(tryBlock, handlers);
            InstructionBlock firstHandlerBlock = firstHandler.getHandlerBlock();
            Instruction firstAfterTry = tryBlock.getLastInstruction().getNext();
            Instruction firstInHandler = firstHandlerBlock.getFirstInstruction();
            Instruction lastBeforeHandler = firstInHandler.getPrevious();
            if (firstAfterTry != firstInHandler && firstAfterTry != null && lastBeforeHandler != null) {
                InstructionBlock newTryBlock = null;
                FlowControl flowControl = lastBeforeHandler.getOpCode().getFlowControl();
                if (flowControl == FlowControl.Branch || flowControl == FlowControl.Return && lastBeforeHandler.getOpCode() == OpCode.RETURN) {
                    if (lastBeforeHandler == firstAfterTry) {
                        newTryBlock = new InstructionBlock(tryBlock.getFirstInstruction(), lastBeforeHandler);
                    }
                } else if ((flowControl == FlowControl.Throw || flowControl == FlowControl.Return && lastBeforeHandler.getOpCode() != OpCode.RETURN) && lastBeforeHandler.getPrevious() == firstAfterTry) {
                    newTryBlock = new InstructionBlock(tryBlock.getFirstInstruction(), lastBeforeHandler);
                }
                if (newTryBlock != null) {
                    List<ExceptionHandler> siblings2 = AstBuilder.findHandlers(tryBlock, handlers);
                    int j = 0;
                    while (j < siblings2.size()) {
                        ExceptionHandler sibling = siblings2.get(j);
                        int index = handlers.indexOf(sibling);
                        if (sibling.isCatch()) {
                            handlers.set(index, ExceptionHandler.createCatch(newTryBlock, sibling.getHandlerBlock(), sibling.getCatchType()));
                        } else {
                            handlers.set(index, ExceptionHandler.createFinally(newTryBlock, sibling.getHandlerBlock()));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < handlers.size()) {
            ExceptionHandler innermostHandler;
            handler = handlers.get(i);
            tryBlock = handler.getTryBlock();
            handlerBlock = handler.getHandlerBlock();
            if (handler.isFinally() && (innermostHandler = this.findInnermostExceptionHandler(tryBlock.getFirstInstruction().getOffset(), handler)) != null && innermostHandler != handler && !innermostHandler.isFinally()) {
                int j = 0;
                while (j < handlers.size()) {
                    ExceptionHandler sibling = handlers.get(j);
                    if (sibling != handler && sibling != innermostHandler && sibling.getTryBlock().equals(handlerBlock) && sibling.getHandlerBlock().equals(innermostHandler.getHandlerBlock())) {
                        handlers.remove(j);
                        if (j < i) {
                            --i;
                            break;
                        }
                        --j;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void removeEmptyCatchBlockBodies() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            Instruction end;
            InstructionBlock catchBlock;
            Instruction start;
            ExceptionHandler handler = handlers.get(i);
            if (handler.isCatch() && (start = (catchBlock = handler.getHandlerBlock()).getFirstInstruction()) == (end = catchBlock.getLastInstruction()) && start.getOpCode().isStore()) {
                end.setOpCode(OpCode.POP);
                end.setOperand(null);
                this._removed.add(end);
            }
            ++i;
        }
    }

    private void ensureDesiredProtectedRanges() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            InstructionBlock tryBlock = handler.getTryBlock();
            List<ExceptionHandler> siblings = AstBuilder.findHandlers(tryBlock, handlers);
            ExceptionHandler firstSibling = CollectionUtilities.first(siblings);
            InstructionBlock firstHandler = firstSibling.getHandlerBlock();
            Instruction desiredEndTry = firstHandler.getFirstInstruction().getPrevious();
            int j = 0;
            while (j < siblings.size()) {
                ExceptionHandler sibling = siblings.get(j);
                if (handler.getTryBlock().getLastInstruction() != desiredEndTry) {
                    int index = handlers.indexOf(sibling);
                    if (sibling.isCatch()) {
                        handlers.set(index, ExceptionHandler.createCatch(new InstructionBlock(tryBlock.getFirstInstruction(), desiredEndTry), sibling.getHandlerBlock(), sibling.getCatchType()));
                    } else {
                        handlers.set(index, ExceptionHandler.createFinally(new InstructionBlock(tryBlock.getFirstInstruction(), desiredEndTry), sibling.getHandlerBlock()));
                    }
                    sibling = handlers.get(index);
                    siblings.set(j, sibling);
                }
                ++j;
            }
            ++i;
        }
    }

    private void alignFinallyBlocksWithSiblingCatchBlocks() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            if (!handler.isCatch()) {
                InstructionBlock tryBlock = handler.getTryBlock();
                InstructionBlock handlerBlock = handler.getHandlerBlock();
                int j = 0;
                while (j < handlers.size()) {
                    if (i != j) {
                        ExceptionHandler other = handlers.get(j);
                        InstructionBlock otherTry = other.getTryBlock();
                        InstructionBlock otherHandler = other.getHandlerBlock();
                        if (other.isCatch() && otherHandler.getLastInstruction().getNext() == handlerBlock.getFirstInstruction() && otherTry.getFirstInstruction() == tryBlock.getFirstInstruction() && otherTry.getLastInstruction().getOffset() < tryBlock.getLastInstruction().getOffset() && tryBlock.getLastInstruction().getEndOffset() > otherHandler.getFirstInstruction().getOffset()) {
                            handlers.set(i, ExceptionHandler.createFinally(new InstructionBlock(tryBlock.getFirstInstruction(), otherHandler.getFirstInstruction().getPrevious()), handlerBlock));
                            --i;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void mergeSharedHandlers() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            List<ExceptionHandler> duplicates = AstBuilder.findDuplicateHandlers(handler, handlers);
            int j = 0;
            while (j < duplicates.size() - 1) {
                ExceptionHandler h1 = duplicates.get(j);
                ExceptionHandler h2 = duplicates.get(1 + j);
                InstructionBlock try1 = h1.getTryBlock();
                InstructionBlock try2 = h2.getTryBlock();
                Instruction head = try1.getLastInstruction().getNext();
                Instruction tail = try2.getFirstInstruction().getPrevious();
                int i1 = handlers.indexOf(h1);
                int i2 = handlers.indexOf(h2);
                if (head != tail) {
                    if (h1.isCatch()) {
                        handlers.set(i1, ExceptionHandler.createCatch(new InstructionBlock(try1.getFirstInstruction(), try2.getLastInstruction()), h1.getHandlerBlock(), h1.getCatchType()));
                    } else {
                        handlers.set(i1, ExceptionHandler.createFinally(new InstructionBlock(try1.getFirstInstruction(), try2.getLastInstruction()), h1.getHandlerBlock()));
                    }
                    duplicates.set(j, handlers.get(i1));
                    duplicates.remove(j + 1);
                    handlers.remove(i2);
                    if (i2 <= i) {
                        --i;
                    }
                    --j;
                }
                ++j;
            }
            ++i;
        }
    }

    private void trimAggressiveCatchBlocks() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            InstructionBlock tryBlock = handler.getTryBlock();
            InstructionBlock handlerBlock = handler.getHandlerBlock();
            if (handler.isCatch()) {
                int j = 0;
                while (j < handlers.size()) {
                    ExceptionHandler other;
                    if (i != j && (other = handlers.get(j)).isFinally()) {
                        InstructionBlock otherTry = other.getTryBlock();
                        InstructionBlock otherHandler = other.getHandlerBlock();
                        if (!(handlerBlock.getFirstInstruction().getOffset() >= otherHandler.getFirstInstruction().getOffset() || !handlerBlock.intersects(otherHandler) || handlerBlock.contains(otherTry) && handlerBlock.contains(otherHandler) || otherTry.contains(tryBlock))) {
                            handlers.set(i--, ExceptionHandler.createCatch(tryBlock, new InstructionBlock(handlerBlock.getFirstInstruction(), otherHandler.getFirstInstruction().getPrevious()), handler.getCatchType()));
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void removeSelfHandlingFinallyHandlers() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            InstructionBlock tryBlock = handler.getTryBlock();
            InstructionBlock handlerBlock = handler.getHandlerBlock();
            if (handler.isFinally() && handlerBlock.getFirstInstruction() == tryBlock.getFirstInstruction() && tryBlock.getLastInstruction().getOffset() < handlerBlock.getLastInstruction().getEndOffset()) {
                handlers.remove(i--);
            }
            ++i;
        }
    }

    private void trimAggressiveFinallyBlocks() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size()) {
            ExceptionHandler handler = handlers.get(i);
            InstructionBlock tryBlock = handler.getTryBlock();
            InstructionBlock handlerBlock = handler.getHandlerBlock();
            if (handler.isFinally()) {
                int j = 0;
                while (j < handlers.size()) {
                    ExceptionHandler other;
                    if (i != j && (other = handlers.get(j)).isCatch()) {
                        InstructionBlock otherTry = other.getTryBlock();
                        InstructionBlock otherHandler = other.getHandlerBlock();
                        if (tryBlock.getFirstInstruction() == otherTry.getFirstInstruction() && tryBlock.getLastInstruction() == otherHandler.getFirstInstruction()) {
                            handlers.set(i--, ExceptionHandler.createFinally(new InstructionBlock(tryBlock.getFirstInstruction(), otherHandler.getFirstInstruction().getPrevious()), handlerBlock));
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static ControlFlowNode findHandlerNode(ControlFlowGraph cfg, ExceptionHandler handler) {
        List<ControlFlowNode> nodes = cfg.getNodes();
        int i = nodes.size() - 1;
        while (i >= 0) {
            ControlFlowNode node = nodes.get(i);
            if (node.getExceptionHandler() == handler) {
                return node;
            }
            --i;
        }
        return null;
    }

    private ExceptionHandler findInnermostExceptionHandler(int offsetInTryBlock, ExceptionHandler exclude) {
        ExceptionHandler result = null;
        for (ExceptionHandler handler : this._exceptionHandlers) {
            InstructionBlock tryBlock;
            if (handler == exclude || (tryBlock = handler.getTryBlock()).getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= tryBlock.getLastInstruction().getEndOffset() || result != null && tryBlock.getFirstInstruction().getOffset() <= result.getTryBlock().getFirstInstruction().getOffset()) continue;
            result = handler;
        }
        return result;
    }

    private void closeTryHandlerGaps() {
        List<ExceptionHandler> handlers = this._exceptionHandlers;
        int i = 0;
        while (i < handlers.size() - 1) {
            ExceptionHandler current = handlers.get(i);
            ExceptionHandler next = handlers.get(i + 1);
            if (current.getHandlerBlock().equals(next.getHandlerBlock())) {
                Instruction lastInCurrent = current.getTryBlock().getLastInstruction();
                Instruction firstInNext = next.getTryBlock().getFirstInstruction();
                Instruction branchInBetween = firstInNext.getPrevious();
                Instruction beforeBranch = branchInBetween != null ? branchInBetween.getPrevious() : null;
                if (branchInBetween != null && branchInBetween.getOpCode().isBranch() && (lastInCurrent == beforeBranch || lastInCurrent == branchInBetween)) {
                    ExceptionHandler newHandler = current.isFinally() ? ExceptionHandler.createFinally(new InstructionBlock(current.getTryBlock().getFirstInstruction(), next.getTryBlock().getLastInstruction()), new InstructionBlock(current.getHandlerBlock().getFirstInstruction(), current.getHandlerBlock().getLastInstruction())) : ExceptionHandler.createCatch(new InstructionBlock(current.getTryBlock().getFirstInstruction(), next.getTryBlock().getLastInstruction()), new InstructionBlock(current.getHandlerBlock().getFirstInstruction(), current.getHandlerBlock().getLastInstruction()), current.getCatchType());
                    handlers.set(i, newHandler);
                    handlers.remove(i + 1);
                    --i;
                }
            }
            ++i;
        }
    }

    private static ExceptionHandler findFirstHandler(InstructionBlock tryBlock, Collection<ExceptionHandler> handlers) {
        ExceptionHandler result = null;
        for (ExceptionHandler handler : handlers) {
            if (!handler.getTryBlock().equals(tryBlock) || result != null && handler.getHandlerBlock().getFirstInstruction().getOffset() >= result.getHandlerBlock().getFirstInstruction().getOffset()) continue;
            result = handler;
        }
        return result;
    }

    private static List<ExceptionHandler> findHandlers(InstructionBlock tryBlock, Collection<ExceptionHandler> handlers) {
        ArrayList<ExceptionHandler> result = null;
        for (ExceptionHandler handler : handlers) {
            if (!handler.getTryBlock().equals(tryBlock)) continue;
            if (result == null) {
                result = new ArrayList<ExceptionHandler>();
            }
            result.add(handler);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        Collections.sort(result, new Comparator<ExceptionHandler>(){

            @Override
            public int compare(@NotNull ExceptionHandler o1, @NotNull ExceptionHandler o2) {
                return Integer.compare(o1.getHandlerBlock().getFirstInstruction().getOffset(), o2.getHandlerBlock().getFirstInstruction().getOffset());
            }
        });
        return result;
    }

    private static List<ExceptionHandler> findDuplicateHandlers(ExceptionHandler handler, Collection<ExceptionHandler> handlers) {
        ArrayList<ExceptionHandler> result = new ArrayList<ExceptionHandler>();
        for (ExceptionHandler other : handlers) {
            if (!other.getHandlerBlock().equals(handler.getHandlerBlock())) continue;
            if (handler.isFinally()) {
                if (!other.isFinally()) continue;
                result.add(other);
                continue;
            }
            if (!other.isCatch() || !MetadataHelper.isSameType(other.getCatchType(), handler.getCatchType())) continue;
            result.add(other);
        }
        Collections.sort(result, new Comparator<ExceptionHandler>(){

            @Override
            public int compare(@NotNull ExceptionHandler o1, @NotNull ExceptionHandler o2) {
                return Integer.compare(o1.getTryBlock().getFirstInstruction().getOffset(), o2.getTryBlock().getFirstInstruction().getOffset());
            }
        });
        return result;
    }

    private List<ByteCode> performStackAnalysis() {
        int isHandlerStart;
        HashSet<ByteCode> handlerStarts = new HashSet<ByteCode>();
        LinkedHashMap<Instruction, ByteCode> byteCodeMap = new LinkedHashMap<Instruction, ByteCode>();
        IdentityHashMap<Instruction, ControlFlowNode> nodeMap = new IdentityHashMap<Instruction, ControlFlowNode>();
        InstructionCollection instructions = this._instructions;
        ArrayList<ExceptionHandler> exceptionHandlers = new ArrayList<ExceptionHandler>();
        ArrayList<ControlFlowNode> successors = new ArrayList<ControlFlowNode>();
        for (ControlFlowNode node : this._cfg.getNodes()) {
            if (node.getExceptionHandler() != null) {
                exceptionHandlers.add(node.getExceptionHandler());
            }
            if (node.getNodeType() != ControlFlowNodeType.Normal) continue;
            Instruction p = node.getStart();
            while (p != null && p.getOffset() < node.getEnd().getEndOffset()) {
                nodeMap.put(p, node);
                p = p.getNext();
            }
        }
        this._exceptionHandlers.retainAll(exceptionHandlers);
        ArrayList<ByteCode> body = new ArrayList<ByteCode>(instructions.size());
        StackMappingVisitor stackMapper = new StackMappingVisitor();
        InstructionVisitor instructionVisitor = stackMapper.visitBody(this._body);
        StrongBox<AstCode> codeBox = new StrongBox<AstCode>();
        StrongBox<Object> operandBox = new StrongBox<Object>();
        this._factory = CoreMetadataFactory.make(this._context.getCurrentType(), (IGenericContext)this._context.getCurrentMethod());
        for (Instruction instruction : instructions) {
            OpCode opCode = instruction.getOpCode();
            AstCode code = CODES[opCode.ordinal()];
            Object operand = instruction.hasOperand() ? (Object)instruction.getOperand(0) : null;
            Object secondOperand = instruction.getOperandCount() > 1 ? instruction.getOperand(1) : null;
            codeBox.set((Object)code);
            operandBox.set(operand);
            int offset = AstBuilder.mappedInstruction(this._originalInstructionMap, instruction).getOffset();
            if (AstCode.expandMacro(codeBox, operandBox, this._body, offset)) {
                code = codeBox.get();
                operand = operandBox.get();
            }
            ByteCode byteCode = new ByteCode();
            byteCode.instruction = instruction;
            byteCode.offset = instruction.getOffset();
            byteCode.endOffset = instruction.getEndOffset();
            byteCode.code = code;
            byteCode.operand = operand;
            byteCode.secondOperand = secondOperand;
            byteCode.popCount = InstructionHelper.getPopDelta(instruction, this._body);
            byteCode.pushCount = InstructionHelper.getPushDelta(instruction, this._body);
            byteCodeMap.put(instruction, byteCode);
            body.add(byteCode);
        }
        int i = 0;
        int n = body.size() - 1;
        while (i < n) {
            ByteCode next = (ByteCode)body.get(i + 1);
            ByteCode current = (ByteCode)body.get(i);
            current.next = next;
            next.previous = current;
            ++i;
        }
        ArrayDeque<ByteCode> agenda = new ArrayDeque<ByteCode>();
        ArrayDeque<ByteCode> handlerAgenda = new ArrayDeque<ByteCode>();
        int variableCount = this._body.getMaxLocals();
        VariableSlot[] unknownVariables = VariableSlot.makeUnknownState(variableCount);
        MethodDefinition method = this._body.getMethod();
        List<ParameterDefinition> parameters = ((MethodReference)method).getParameters();
        boolean hasThis = this._body.hasThis();
        if (hasThis) {
            unknownVariables[0] = method.isConstructor() ? new VariableSlot(FrameValue.UNINITIALIZED_THIS, EMPTY_DEFINITIONS) : new VariableSlot(FrameValue.makeReference(this._context.getCurrentType()), EMPTY_DEFINITIONS);
        }
        ByteCode[] definitions = new ByteCode[]{new ByteCode()};
        int i2 = 0;
        while (i2 < parameters.size()) {
            ParameterDefinition parameter = parameters.get(i2);
            TypeReference parameterType = parameter.getParameterType();
            int slot = parameter.getSlot();
            switch (parameterType.getSimpleType()) {
                case Boolean: 
                case Byte: 
                case Character: 
                case Short: 
                case Integer: {
                    unknownVariables[slot] = new VariableSlot(FrameValue.INTEGER, definitions);
                    break;
                }
                case Long: {
                    unknownVariables[slot] = new VariableSlot(FrameValue.LONG, definitions);
                    unknownVariables[slot + 1] = new VariableSlot(FrameValue.TOP, definitions);
                    break;
                }
                case Float: {
                    unknownVariables[slot] = new VariableSlot(FrameValue.FLOAT, definitions);
                    break;
                }
                case Double: {
                    unknownVariables[slot] = new VariableSlot(FrameValue.DOUBLE, definitions);
                    unknownVariables[slot + 1] = new VariableSlot(FrameValue.TOP, definitions);
                    break;
                }
                default: {
                    unknownVariables[slot] = new VariableSlot(FrameValue.makeReference(parameterType), definitions);
                }
            }
            ++i2;
        }
        for (ExceptionHandler handler : exceptionHandlers) {
            ByteCode handlerStart = (ByteCode)byteCodeMap.get(handler.getHandlerBlock().getFirstInstruction());
            handlerStarts.add(handlerStart);
            handlerStart.stackBefore = EMPTY_STACK;
            handlerStart.variablesBefore = VariableSlot.cloneVariableState(unknownVariables);
            ByteCode loadException = new ByteCode();
            TypeReference catchType = handler.isFinally() ? this._factory.makeNamedType("java.lang.Throwable") : handler.getCatchType();
            loadException.code = AstCode.LoadException;
            loadException.operand = catchType;
            loadException.popCount = 0;
            loadException.pushCount = 1;
            this._loadExceptions.put(handler, loadException);
            handlerStart.stackBefore = new StackSlot[]{new StackSlot(FrameValue.makeReference(catchType), new ByteCode[]{loadException})};
            handlerAgenda.addLast(handlerStart);
        }
        ((ByteCode)body.get((int)0)).stackBefore = EMPTY_STACK;
        ((ByteCode)body.get((int)0)).variablesBefore = unknownVariables;
        agenda.addFirst((ByteCode)body.get(0));
        while (!agenda.isEmpty() || !handlerAgenda.isEmpty()) {
            Iterator<ControlFlowNode> instruction;
            ByteCode byteCode = agenda.isEmpty() ? (ByteCode)handlerAgenda.removeFirst() : (ByteCode)agenda.removeFirst();
            stackMapper.visitFrame(byteCode.getFrameBefore());
            instructionVisitor.visit(byteCode.instruction);
            StackSlot[] newStack = AstBuilder.createModifiedStack(byteCode, stackMapper);
            VariableSlot[] newVariableState = VariableSlot.cloneVariableState(byteCode.variablesBefore);
            Map<Instruction, TypeReference> initializations = stackMapper.getInitializations();
            int i3 = 0;
            while (i3 < newVariableState.length) {
                TypeReference initializedType;
                Object parameter;
                VariableSlot slot = newVariableState[i3];
                if (slot.isUninitialized() && (parameter = slot.value.getParameter()) instanceof Instruction && (initializedType = initializations.get(instruction = (Instruction)parameter)) != null) {
                    newVariableState[i3] = new VariableSlot(FrameValue.makeReference(initializedType), slot.definitions);
                }
                ++i3;
            }
            if (byteCode.isVariableDefinition()) {
                int slot = ((VariableReference)byteCode.operand).getSlot();
                newVariableState[slot] = new VariableSlot(stackMapper.getLocalValue(slot), new ByteCode[]{byteCode});
                if (newVariableState[slot].value.getType().isDoubleWord()) {
                    newVariableState[slot + 1] = new VariableSlot(stackMapper.getLocalValue(slot + 1), new ByteCode[]{byteCode});
                }
            }
            ArrayList<ByteCode> branchTargets = new ArrayList<ByteCode>();
            ControlFlowNode node = (ControlFlowNode)nodeMap.get(byteCode.instruction);
            successors.clear();
            if (byteCode.instruction != node.getEnd()) {
                branchTargets.add(byteCode.next);
            } else {
                if (!byteCode.instruction.getOpCode().isUnconditionalBranch()) {
                    branchTargets.add(byteCode.next);
                }
                for (ControlFlowNode successor : node.getSuccessors()) {
                    if (successor.getNodeType() == ControlFlowNodeType.Normal) {
                        successors.add(successor);
                        continue;
                    }
                    if (successor.getNodeType() != ControlFlowNodeType.EndFinally) continue;
                    for (ControlFlowNode s : successor.getSuccessors()) {
                        successors.add(s);
                    }
                }
            }
            for (ControlFlowNode successor : node.getSuccessors()) {
                if (successor.getExceptionHandler() == null) continue;
                successors.add((ControlFlowNode)nodeMap.get(successor.getExceptionHandler().getHandlerBlock().getFirstInstruction()));
            }
            for (ControlFlowNode successor : successors) {
                if (successor.getNodeType() != ControlFlowNodeType.Normal) continue;
                Instruction targetInstruction = successor.getStart();
                ByteCode target = (ByteCode)byteCodeMap.get(targetInstruction);
                if (target.label == null) {
                    target.label = new Label();
                    target.label.setOffset(target.offset);
                    target.label.setName(target.makeLabelName());
                }
                branchTargets.add(target);
            }
            instruction = branchTargets.iterator();
            while (instruction.hasNext()) {
                ByteCode[] newDefinitions;
                ByteCode[] oldDefinitions;
                Frame outputFrame;
                ByteCode branchTarget = (ByteCode)((Object)instruction.next());
                boolean isSubroutineJump = byteCode.code == AstCode.Jsr && byteCode.instruction.getOperand(0) == branchTarget.instruction;
                StackSlot[] effectiveStack = isSubroutineJump ? ArrayUtilities.append(newStack, new StackSlot(FrameValue.makeAddress(byteCode.next.instruction), new ByteCode[]{byteCode})) : newStack;
                if (branchTarget.stackBefore == null && branchTarget.variablesBefore == null) {
                    branchTarget.stackBefore = StackSlot.modifyStack(effectiveStack, 0, null, new FrameValue[0]);
                    branchTarget.variablesBefore = VariableSlot.cloneVariableState(newVariableState);
                    agenda.push(branchTarget);
                    continue;
                }
                isHandlerStart = handlerStarts.contains(branchTarget) ? 1 : 0;
                if (branchTarget.stackBefore.length != effectiveStack.length && isHandlerStart == 0 && !isSubroutineJump) {
                    throw new IllegalStateException("Inconsistent stack size at " + branchTarget.name() + " (coming from " + byteCode.name() + ").");
                }
                boolean modified = false;
                int stackSize = newStack.length;
                Frame inputFrame = outputFrame = AstBuilder.createFrame(effectiveStack, newVariableState);
                Frame nextFrame = AstBuilder.createFrame(branchTarget.stackBefore.length > stackSize ? Arrays.copyOfRange(branchTarget.stackBefore, 0, stackSize) : branchTarget.stackBefore, branchTarget.variablesBefore);
                Frame mergedFrame = Frame.merge(inputFrame, outputFrame, nextFrame, initializations);
                List<FrameValue> stack = mergedFrame.getStackValues();
                List<FrameValue> locals = mergedFrame.getLocalValues();
                if (isHandlerStart == 0) {
                    StackSlot[] oldStack = branchTarget.stackBefore;
                    int oldStart = oldStack != null && oldStack.length > stackSize ? oldStack.length - 1 : stackSize - 1;
                    int i4 = stack.size() - 1;
                    int j = oldStart;
                    while (i4 >= 0 && j >= 0) {
                        FrameValue oldValue = oldStack[j].value;
                        FrameValue newValue = stack.get(i4);
                        oldDefinitions = oldStack[j].definitions;
                        newDefinitions = ArrayUtilities.union(oldDefinitions, effectiveStack[i4].definitions);
                        if (!Comparer.equals(newValue, oldValue) || newDefinitions.length > oldDefinitions.length) {
                            oldStack[j] = new StackSlot(newValue, newDefinitions);
                            modified = true;
                        }
                        --i4;
                        --j;
                    }
                }
                int i5 = 0;
                int n2 = locals.size();
                while (i5 < n2) {
                    VariableSlot oldSlot = branchTarget.variablesBefore[i5];
                    VariableSlot newSlot = newVariableState[i5];
                    FrameValue oldLocal = oldSlot.value;
                    FrameValue newLocal = locals.get(i5);
                    oldDefinitions = oldSlot.definitions;
                    newDefinitions = ArrayUtilities.union(oldSlot.definitions, newSlot.definitions);
                    if (!Comparer.equals(oldLocal, newLocal) || newDefinitions.length > oldDefinitions.length) {
                        branchTarget.variablesBefore[i5] = new VariableSlot(newLocal, newDefinitions);
                        modified = true;
                    }
                    ++i5;
                }
                if (!modified) continue;
                agenda.addLast(branchTarget);
            }
        }
        ArrayList<ByteCode> unreachable = null;
        for (ByteCode byteCode : body) {
            if (byteCode.stackBefore != null) continue;
            if (unreachable == null) {
                unreachable = new ArrayList<ByteCode>();
            }
            unreachable.add(byteCode);
        }
        if (unreachable != null) {
            body.removeAll(unreachable);
        }
        for (ByteCode byteCode : body) {
            int popCount = byteCode.popCount != -1 ? byteCode.popCount : byteCode.stackBefore.length;
            int argumentIndex = 0;
            int i6 = byteCode.stackBefore.length - popCount;
            while (i6 < byteCode.stackBefore.length) {
                Variable tempVariable = new Variable();
                tempVariable.setName(String.format("stack_%1$02X_%2$d", byteCode.offset, argumentIndex));
                tempVariable.setGenerated(true);
                FrameValue value = byteCode.stackBefore[i6].value;
                switch (value.getType()) {
                    case Integer: {
                        tempVariable.setType(BuiltinTypes.Integer);
                        break;
                    }
                    case Float: {
                        tempVariable.setType(BuiltinTypes.Float);
                        break;
                    }
                    case Long: {
                        tempVariable.setType(BuiltinTypes.Long);
                        break;
                    }
                    case Double: {
                        tempVariable.setType(BuiltinTypes.Double);
                        break;
                    }
                    case UninitializedThis: {
                        tempVariable.setType(this._context.getCurrentType());
                        break;
                    }
                    case Reference: {
                        TypeReference refType = (TypeReference)value.getParameter();
                        if (refType.isWildcardType()) {
                            refType = refType.hasSuperBound() ? refType.getSuperBound() : refType.getExtendsBound();
                        }
                        tempVariable.setType(refType);
                    }
                }
                byteCode.stackBefore[i6] = new StackSlot(value, byteCode.stackBefore[i6].definitions, tempVariable);
                ByteCode[] byteCodeArray = byteCode.stackBefore[i6].definitions;
                isHandlerStart = byteCode.stackBefore[i6].definitions.length;
                int effectiveStack = 0;
                while (effectiveStack < isHandlerStart) {
                    ByteCode pushedBy = byteCodeArray[effectiveStack];
                    if (pushedBy.storeTo == null) {
                        pushedBy.storeTo = new ArrayList<Variable>();
                    }
                    pushedBy.storeTo.add(tempVariable);
                    ++effectiveStack;
                }
                ++argumentIndex;
                ++i6;
            }
        }
        for (ByteCode byteCode : body) {
            if (byteCode.storeTo == null || byteCode.storeTo.size() <= 1) continue;
            List<Variable> localVariables = byteCode.storeTo;
            ArrayList<StackSlot> loadedBy = null;
            block41: for (Variable local : localVariables) {
                for (ByteCode bc : body) {
                    StackSlot[] stackSlotArray = bc.stackBefore;
                    int n3 = bc.stackBefore.length;
                    isHandlerStart = 0;
                    while (isHandlerStart < n3) {
                        StackSlot s = stackSlotArray[isHandlerStart];
                        if (s.loadFrom == local) {
                            if (loadedBy == null) {
                                loadedBy = new ArrayList<StackSlot>();
                            }
                            loadedBy.add(s);
                            continue block41;
                        }
                        ++isHandlerStart;
                    }
                }
            }
            if (loadedBy == null) continue;
            boolean singleStore = true;
            TypeReference type = null;
            for (StackSlot slot : loadedBy) {
                if (slot.definitions.length != 1) {
                    singleStore = false;
                    break;
                }
                if (slot.definitions[0] != byteCode) {
                    singleStore = false;
                    break;
                }
                if (type != null) continue;
                switch (slot.value.getType()) {
                    case Integer: {
                        type = BuiltinTypes.Integer;
                        break;
                    }
                    case Float: {
                        type = BuiltinTypes.Float;
                        break;
                    }
                    case Long: {
                        type = BuiltinTypes.Long;
                        break;
                    }
                    case Double: {
                        type = BuiltinTypes.Double;
                        break;
                    }
                    case Reference: {
                        type = (TypeReference)slot.value.getParameter();
                        if (!type.isWildcardType()) break;
                        TypeReference typeReference = type = type.hasSuperBound() ? type.getSuperBound() : type.getExtendsBound();
                    }
                }
            }
            if (!singleStore) continue;
            Variable tempVariable = new Variable();
            tempVariable.setName(String.format("expr_%1$02X", byteCode.offset));
            tempVariable.setGenerated(true);
            tempVariable.setType(type);
            byteCode.storeTo = Collections.singletonList(tempVariable);
            for (ByteCode bc : body) {
                int i7 = 0;
                while (i7 < bc.stackBefore.length) {
                    if (localVariables.contains(bc.stackBefore[i7].loadFrom)) {
                        bc.stackBefore[i7] = new StackSlot(bc.stackBefore[i7].value, bc.stackBefore[i7].definitions, tempVariable);
                    }
                    ++i7;
                }
            }
        }
        this.convertLocalVariables(definitions, body);
        for (ByteCode byteCode : body) {
            if (byteCode.operand instanceof Instruction[]) {
                Instruction[] branchTargets = (Instruction[])byteCode.operand;
                Label[] newOperand = new Label[branchTargets.length];
                int i8 = 0;
                while (i8 < branchTargets.length) {
                    newOperand[i8] = ((ByteCode)byteCodeMap.get((Object)branchTargets[i8])).label;
                    ++i8;
                }
                byteCode.operand = newOperand;
                continue;
            }
            if (byteCode.operand instanceof Instruction) {
                byteCode.operand = ((ByteCode)byteCodeMap.get((Object)byteCode.operand)).label;
                continue;
            }
            if (!(byteCode.operand instanceof SwitchInfo)) continue;
            SwitchInfo switchInfo = (SwitchInfo)byteCode.operand;
            Instruction[] branchTargets = ArrayUtilities.prepend(switchInfo.getTargets(), switchInfo.getDefaultTarget());
            Label[] newOperand = new Label[branchTargets.length];
            int i9 = 0;
            while (i9 < branchTargets.length) {
                newOperand[i9] = ((ByteCode)byteCodeMap.get((Object)branchTargets[i9])).label;
                ++i9;
            }
            byteCode.operand = newOperand;
        }
        return body;
    }

    private static Instruction mappedInstruction(Map<Instruction, Instruction> map, Instruction instruction) {
        Instruction newInstruction;
        Instruction current = instruction;
        while ((newInstruction = map.get(current)) != null) {
            if (newInstruction == current) {
                return current;
            }
            current = newInstruction;
        }
        return current;
    }

    private static StackSlot[] createModifiedStack(ByteCode byteCode, StackMappingVisitor stackMapper) {
        Map<Instruction, TypeReference> initializations = stackMapper.getInitializations();
        StackSlot[] oldStack = (StackSlot[])byteCode.stackBefore.clone();
        int i = 0;
        while (i < oldStack.length) {
            TypeReference initializedType;
            if (oldStack[i].value.getParameter() instanceof Instruction && (initializedType = initializations.get(oldStack[i].value.getParameter())) != null) {
                oldStack[i] = new StackSlot(FrameValue.makeReference(initializedType), oldStack[i].definitions, oldStack[i].loadFrom);
            }
            ++i;
        }
        if (byteCode.popCount == 0 && byteCode.pushCount == 0) {
            return oldStack;
        }
        switch (byteCode.code) {
            case Dup: {
                return ArrayUtilities.append(oldStack, new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case DupX1: {
                return ArrayUtilities.insert(oldStack, oldStack.length - 2, new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case DupX2: {
                return ArrayUtilities.insert(oldStack, oldStack.length - 3, new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case Dup2: {
                return ArrayUtilities.append(oldStack, new StackSlot(stackMapper.getStackValue(1), oldStack[oldStack.length - 2].definitions), new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case Dup2X1: {
                return ArrayUtilities.insert(oldStack, oldStack.length - 3, new StackSlot(stackMapper.getStackValue(1), oldStack[oldStack.length - 2].definitions), new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case Dup2X2: {
                return ArrayUtilities.insert(oldStack, oldStack.length - 4, new StackSlot(stackMapper.getStackValue(1), oldStack[oldStack.length - 2].definitions), new StackSlot(stackMapper.getStackValue(0), oldStack[oldStack.length - 1].definitions));
            }
            case Swap: {
                StackSlot[] newStack = new StackSlot[oldStack.length];
                ArrayUtilities.copy(oldStack, newStack);
                StackSlot temp = newStack[oldStack.length - 1];
                newStack[oldStack.length - 1] = newStack[oldStack.length - 2];
                newStack[oldStack.length - 2] = temp;
                return newStack;
            }
        }
        FrameValue[] pushValues = new FrameValue[byteCode.pushCount];
        int i2 = 0;
        while (i2 < byteCode.pushCount) {
            pushValues[pushValues.length - i2 - 1] = stackMapper.getStackValue(i2);
            ++i2;
        }
        return StackSlot.modifyStack(oldStack, byteCode.popCount != -1 ? byteCode.popCount : oldStack.length, byteCode, pushValues);
    }

    /*
     * Could not resolve type clashes
     */
    private void convertLocalVariables(ByteCode[] parameterDefinitions, List<ByteCode> body) {
        MethodDefinition method = this._context.getCurrentMethod();
        List<ParameterDefinition> parameters = method.getParameters();
        VariableDefinitionCollection variables = this._body.getVariables();
        ParameterDefinition[] parameterMap = new ParameterDefinition[this._body.getMaxLocals()];
        boolean hasThis = this._body.hasThis();
        if (hasThis) {
            parameterMap[0] = this._body.getThisParameter();
        }
        Iterator<ParameterDefinition> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            ParameterDefinition parameter;
            parameterMap[parameter.getSlot()] = parameter = iterator.next();
        }
        HashSet<Pair<Integer, JvmType>> undefinedSlots = new HashSet<Pair<Integer, JvmType>>();
        ArrayList<VariableReference> varReferences = new ArrayList<VariableReference>();
        Map<String, VariableDefinition> lookup = AstBuilder.makeVariableLookup(variables);
        for (VariableDefinition variableDefinition : variables) {
            varReferences.add(variableDefinition);
        }
        for (ByteCode b : body) {
            VariableReference reference;
            if (!(b.operand instanceof VariableReference) || b.operand instanceof VariableDefinition || !undefinedSlots.add(Pair.create((reference = (VariableReference)b.operand).getSlot(), this.getStackType(reference.getVariableType())))) continue;
            varReferences.add(reference);
        }
        for (VariableReference vRef : varReferences) {
            List<Object> newVariables;
            int slot = vRef.getSlot();
            ArrayList<ByteCode> definitions = new ArrayList<ByteCode>();
            ArrayList<ByteCode> references = new ArrayList<ByteCode>();
            VariableDefinition vDef = vRef instanceof VariableDefinition ? lookup.get(AstBuilder.key((VariableDefinition)vRef)) : null;
            for (ByteCode b : body) {
                if (vDef != null) {
                    if (!(b.operand instanceof VariableDefinition) || lookup.get(AstBuilder.key((VariableDefinition)b.operand)) != vDef) continue;
                    if (b.isVariableDefinition()) {
                        definitions.add(b);
                        continue;
                    }
                    references.add(b);
                    continue;
                }
                if (!(b.operand instanceof VariableReference) || !this.variablesMatch(vRef, (VariableReference)b.operand)) continue;
                if (b.isVariableDefinition()) {
                    definitions.add(b);
                    continue;
                }
                references.add(b);
            }
            ParameterDefinition parameter = parameterMap[slot];
            if (!this._optimize) {
                newVariables = this.processVariableUnoptimized(method, slot, definitions, references, vDef);
            } else {
                newVariables = new ArrayList();
                boolean parameterVariableAdded = false;
                Object parameterVariable = null;
                if (parameter != null) {
                    Variable variable = new Variable();
                    variable.setName(StringUtilities.isNullOrEmpty(parameter.getName()) ? "p" + parameter.getPosition() : parameter.getName());
                    variable.setType(parameter.getParameterType());
                    variable.setOriginalParameter(parameter);
                    variable.setOriginalVariable(vDef);
                    parameterVariable = new VariableInfo(slot, variable, new ArrayList<ByteCode>(), new ArrayList<ByteCode>());
                    Collections.addAll(((VariableInfo)parameterVariable).definitions, parameterDefinitions);
                }
                for (ByteCode b : definitions) {
                    boolean useParameter;
                    TypeReference variableType;
                    FrameValue stackValue = b.code == AstCode.Inc ? FrameValue.INTEGER : b.stackBefore[b.stackBefore.length - b.popCount].value;
                    if (vDef != null && vDef.isFromMetadata()) {
                        variableType = vDef.getVariableType();
                    } else {
                        switch (stackValue.getType()) {
                            case Integer: {
                                variableType = BuiltinTypes.Integer;
                                break;
                            }
                            case Float: {
                                variableType = BuiltinTypes.Float;
                                break;
                            }
                            case Long: {
                                variableType = BuiltinTypes.Long;
                                break;
                            }
                            case Double: {
                                variableType = BuiltinTypes.Double;
                                break;
                            }
                            case UninitializedThis: {
                                variableType = this._context.getCurrentType();
                                break;
                            }
                            case Reference: {
                                variableType = (TypeReference)stackValue.getParameter();
                                break;
                            }
                            case Address: {
                                variableType = BuiltinTypes.Integer;
                                break;
                            }
                            case Null: {
                                variableType = BuiltinTypes.Null;
                                break;
                            }
                            default: {
                                variableType = vDef != null ? vDef.getVariableType() : BuiltinTypes.Object;
                            }
                        }
                    }
                    if (parameterVariable != null && (useParameter = variableType.isPrimitive() || ((VariableInfo)parameterVariable).variable.getType().isPrimitive() ? variableType.getSimpleType() == ((VariableInfo)parameterVariable).variable.getType().getSimpleType() : MetadataHelper.isSameType(variableType, ((VariableInfo)parameterVariable).variable.getType()))) {
                        if (!parameterVariableAdded) {
                            newVariables.add(parameterVariable);
                            parameterVariableAdded = true;
                        }
                        ((VariableInfo)parameterVariable).definitions.add(b);
                        continue;
                    }
                    Variable variable = new Variable();
                    if (vDef != null && !StringUtilities.isNullOrEmpty(vDef.getName())) {
                        variable.setName(vDef.getName());
                    } else {
                        variable.setName(String.format("var_%1$d_%2$02X", slot, b.offset));
                    }
                    variable.setType(variableType);
                    if (vDef == null) {
                        variable.setOriginalVariable(new VariableDefinition(slot, variable.getName(), method, variable.getType()));
                    } else {
                        variable.setOriginalVariable(vDef);
                    }
                    variable.setGenerated(false);
                    VariableInfo variableInfo = new VariableInfo(slot, variable, new ArrayList<ByteCode>(), new ArrayList<ByteCode>());
                    variableInfo.definitions.add(b);
                    newVariables.add(variableInfo);
                }
                for (ByteCode ref : references) {
                    ByteCode[] refDefinitions = ref.variablesBefore[slot].definitions;
                    if (refDefinitions.length == 0 && parameterVariable != null) {
                        ((VariableInfo)parameterVariable).references.add(ref);
                        if (parameterVariableAdded) continue;
                        newVariables.add(parameterVariable);
                        parameterVariableAdded = true;
                        continue;
                    }
                    if (refDefinitions.length == 1) {
                        Object newVariable = null;
                        for (VariableInfo v : newVariables) {
                            if (!v.definitions.contains(refDefinitions[0])) continue;
                            newVariable = v;
                            break;
                        }
                        if (newVariable == null && parameterVariable != null) {
                            newVariable = parameterVariable;
                            if (!parameterVariableAdded) {
                                newVariables.add(parameterVariable);
                                parameterVariableAdded = true;
                            }
                        }
                        assert (newVariable != null);
                        ((VariableInfo)newVariable).references.add(ref);
                        continue;
                    }
                    ArrayList<VariableInfo> mergeVariables = new ArrayList<VariableInfo>();
                    for (VariableInfo v : newVariables) {
                        boolean hasIntersection = false;
                        block19: for (ByteCode b1 : v.definitions) {
                            ByteCode[] byteCodeArray = refDefinitions;
                            int n = refDefinitions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ByteCode b2 = byteCodeArray[n2];
                                if (b1 == b2) {
                                    hasIntersection = true;
                                    break block19;
                                }
                                ++n2;
                            }
                        }
                        if (!hasIntersection) continue;
                        mergeVariables.add(v);
                    }
                    ArrayList<ByteCode> mergedDefinitions = new ArrayList<ByteCode>();
                    ArrayList<ByteCode> mergedReferences = new ArrayList<ByteCode>();
                    if (parameterVariable != null && (mergeVariables.isEmpty() || !mergeVariables.contains(parameterVariable) && ArrayUtilities.contains(refDefinitions, parameterDefinitions[0]))) {
                        mergeVariables.add((VariableInfo)parameterVariable);
                        parameterVariableAdded = true;
                    }
                    for (VariableInfo v : mergeVariables) {
                        mergedDefinitions.addAll(v.definitions);
                        mergedReferences.addAll(v.references);
                    }
                    if (mergeVariables.isEmpty()) {
                        newVariables = this.processVariableUnoptimized(method, slot, definitions, references, vDef);
                        continue;
                    }
                    VariableInfo mergedVariable = new VariableInfo(slot, ((VariableInfo)mergeVariables.get((int)0)).variable, mergedDefinitions, mergedReferences);
                    if (parameterVariable != null && mergeVariables.contains(parameterVariable)) {
                        parameterVariable = mergedVariable;
                        ((VariableInfo)parameterVariable).variable.setOriginalParameter(parameter);
                        parameterVariableAdded = true;
                    }
                    mergedVariable.variable.setType(this.mergeVariableType(mergeVariables));
                    mergedVariable.references.add(ref);
                    newVariables.removeAll(mergeVariables);
                    newVariables.add(mergedVariable);
                }
            }
            if (this._context.getSettings().getMergeVariables()) {
                for (VariableInfo variable : newVariables) {
                    variable.recomputeLifetime();
                }
                Collections.sort(newVariables, new Comparator<VariableInfo>(){

                    @Override
                    public int compare(@NotNull VariableInfo o1, @NotNull VariableInfo o2) {
                        return o1.lifetime.compareTo(o2.lifetime);
                    }
                });
                int j = 0;
                while (j < newVariables.size() - 1) {
                    VariableInfo prev = (VariableInfo)newVariables.get(j);
                    if (prev.variable.getType().isPrimitive() && (prev.variable.getOriginalVariable() == null || !prev.variable.getOriginalVariable().isFromMetadata())) {
                        int k = j + 1;
                        while (k < newVariables.size()) {
                            VariableInfo next = (VariableInfo)newVariables.get(k);
                            if (next.variable.getOriginalVariable().isFromMetadata() || !MetadataHelper.isSameType(prev.variable.getType(), next.variable.getType()) || this.mightBeBoolean(prev) != this.mightBeBoolean(next)) break;
                            prev.definitions.addAll(next.definitions);
                            prev.references.addAll(next.references);
                            newVariables.remove(k--);
                            prev.lifetime.setStart(Math.min(prev.lifetime.getStart(), next.lifetime.getStart()));
                            prev.lifetime.setEnd(Math.max(prev.lifetime.getEnd(), next.lifetime.getEnd()));
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            for (VariableInfo newVariable : newVariables) {
                if (newVariable.variable.getType() == BuiltinTypes.Null) {
                    newVariable.variable.setType(BuiltinTypes.Null);
                }
                for (ByteCode definition : newVariable.definitions) {
                    definition.operand = newVariable.variable;
                }
                for (ByteCode reference : newVariable.references) {
                    reference.operand = newVariable.variable;
                }
            }
        }
    }

    private List<VariableInfo> processVariableUnoptimized(MethodDefinition method, int slot, List<ByteCode> definitions, List<ByteCode> references, VariableDefinition vDef) {
        Variable variable = new Variable();
        if (vDef != null) {
            variable.setType(vDef.getVariableType());
            variable.setName(StringUtilities.isNullOrEmpty(vDef.getName()) ? "var_" + slot : vDef.getName());
        } else {
            variable.setName("var_" + slot);
            for (ByteCode b : definitions) {
                TypeReference variableType;
                FrameValue stackValue = b.stackBefore[b.stackBefore.length - b.popCount].value;
                if (stackValue == FrameValue.UNINITIALIZED || stackValue == FrameValue.UNINITIALIZED_THIS) continue;
                switch (stackValue.getType()) {
                    case Integer: {
                        variableType = BuiltinTypes.Integer;
                        break;
                    }
                    case Float: {
                        variableType = BuiltinTypes.Float;
                        break;
                    }
                    case Long: {
                        variableType = BuiltinTypes.Long;
                        break;
                    }
                    case Double: {
                        variableType = BuiltinTypes.Double;
                        break;
                    }
                    case Uninitialized: {
                        if (stackValue.getParameter() instanceof Instruction && ((Instruction)stackValue.getParameter()).getOpCode() == OpCode.NEW) {
                            variableType = (TypeReference)((Instruction)stackValue.getParameter()).getOperand(0);
                            break;
                        }
                        if (vDef != null) {
                            variableType = vDef.getVariableType();
                            break;
                        }
                        variableType = BuiltinTypes.Object;
                        break;
                    }
                    case UninitializedThis: {
                        variableType = this._context.getCurrentType();
                        break;
                    }
                    case Reference: {
                        variableType = (TypeReference)stackValue.getParameter();
                        break;
                    }
                    case Address: {
                        variableType = BuiltinTypes.Integer;
                        break;
                    }
                    case Null: {
                        variableType = BuiltinTypes.Null;
                        break;
                    }
                    default: {
                        variableType = vDef != null ? vDef.getVariableType() : BuiltinTypes.Object;
                    }
                }
                variable.setType(variableType);
                break;
            }
            if (variable.getType() == null) {
                variable.setType(BuiltinTypes.Object);
            }
        }
        if (vDef == null) {
            variable.setOriginalVariable(new VariableDefinition(slot, variable.getName(), method, variable.getType()));
        } else {
            variable.setOriginalVariable(vDef);
        }
        variable.setGenerated(false);
        VariableInfo variableInfo = new VariableInfo(slot, variable, definitions, references);
        return Collections.singletonList(variableInfo);
    }

    private boolean mightBeBoolean(VariableInfo info) {
        TypeReference type = info.variable.getType();
        if (type == BuiltinTypes.Boolean) {
            return true;
        }
        if (type != BuiltinTypes.Integer) {
            return false;
        }
        for (ByteCode b : info.definitions) {
            if (b.code != AstCode.Store || b.stackBefore.length < 1) {
                return false;
            }
            StackSlot value = b.stackBefore[b.stackBefore.length - 1];
            ByteCode[] byteCodeArray = value.definitions;
            int n = value.definitions.length;
            int n2 = 0;
            while (n2 < n) {
                ByteCode d = byteCodeArray[n2];
                switch (d.code) {
                    case LdC: {
                        if (Objects.equals(d.operand, 0) || Objects.equals(d.operand, 1)) break;
                        return false;
                    }
                    case GetStatic: 
                    case GetField: {
                        if (((FieldReference)d.operand).getFieldType() == BuiltinTypes.Boolean) break;
                        return false;
                    }
                    case LoadElement: {
                        if (d.instruction.getOpCode() == OpCode.BALOAD) break;
                        return false;
                    }
                    case InvokeVirtual: 
                    case InvokeSpecial: 
                    case InvokeStatic: 
                    case InvokeInterface: {
                        if (((MethodReference)d.operand).getReturnType() == BuiltinTypes.Boolean) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                ++n2;
            }
        }
        for (ByteCode r : info.references) {
            if (r.code != AstCode.Inc) continue;
            return false;
        }
        return true;
    }

    private TypeReference mergeVariableType(List<VariableInfo> info) {
        TypeReference result = CollectionUtilities.first(info).variable.getType();
        int i = 0;
        while (i < info.size()) {
            VariableInfo variableInfo = info.get(i);
            TypeReference t = variableInfo.variable.getType();
            if (result == BuiltinTypes.Null) {
                result = t;
            } else if (t != BuiltinTypes.Null) {
                result = MetadataHelper.findCommonSuperType(result, t);
            }
            ++i;
        }
        return result != null ? result : BuiltinTypes.Object;
    }

    private JvmType getStackType(TypeReference type) {
        JvmType t = type.getSimpleType();
        switch (t) {
            case Boolean: 
            case Byte: 
            case Character: 
            case Short: 
            case Integer: {
                return JvmType.Integer;
            }
            case Long: 
            case Float: 
            case Double: {
                return t;
            }
        }
        return JvmType.Object;
    }

    private boolean variablesMatch(VariableReference v1, VariableReference v2) {
        if (v1.getSlot() == v2.getSlot()) {
            JvmType t2;
            JvmType t1 = this.getStackType(v1.getVariableType());
            return t1 == (t2 = this.getStackType(v2.getVariableType()));
        }
        return false;
    }

    private static Map<String, VariableDefinition> makeVariableLookup(VariableDefinitionCollection variables) {
        HashMap<String, VariableDefinition> lookup = new HashMap<String, VariableDefinition>();
        for (VariableDefinition variable : variables) {
            String key = AstBuilder.key(variable);
            if (lookup.containsKey(key)) continue;
            lookup.put(key, variable);
        }
        return lookup;
    }

    private static String key(VariableDefinition variable) {
        StringBuilder sb = new StringBuilder().append(variable.getSlot()).append(':');
        if (variable.hasName()) {
            sb.append(variable.getName());
        } else {
            sb.append("#unnamed_").append(variable.getScopeStart()).append('_').append(variable.getScopeEnd());
        }
        return sb.append(':').append(variable.getVariableType().getSignature()).toString();
    }

    private List<Node> convertToAst(List<ByteCode> body, Set<ExceptionHandler> exceptionHandlers, int startIndex, MutableInteger endIndex) {
        ArrayList<Node> ast = new ArrayList<Node>();
        int headStartIndex = startIndex;
        int tailStartIndex = startIndex;
        MutableInteger tempIndex = new MutableInteger();
        while (!exceptionHandlers.isEmpty()) {
            Block finallyBlock;
            CatchBlock lastCatch;
            Node lastInTry;
            int end;
            int start;
            TryCatchBlock tryCatchBlock = new TryCatchBlock();
            int minTryStart = body.get((int)headStartIndex).offset;
            int tryStart = Integer.MAX_VALUE;
            int tryEnd = -1;
            int firstHandlerStart = -1;
            headStartIndex = tailStartIndex;
            for (ExceptionHandler handler : exceptionHandlers) {
                start = handler.getTryBlock().getFirstInstruction().getOffset();
                if (start >= tryStart || start < minTryStart) continue;
                tryStart = start;
            }
            for (ExceptionHandler handler : exceptionHandlers) {
                Instruction lastInstruction;
                start = handler.getTryBlock().getFirstInstruction().getOffset();
                if (start != tryStart || (end = (lastInstruction = handler.getTryBlock().getLastInstruction()).getEndOffset()) <= tryEnd) continue;
                tryEnd = end;
                int handlerStart = handler.getHandlerBlock().getFirstInstruction().getOffset();
                if (firstHandlerStart >= 0 && handlerStart >= firstHandlerStart) continue;
                firstHandlerStart = handlerStart;
            }
            ArrayList<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();
            for (ExceptionHandler handler : exceptionHandlers) {
                int start2 = handler.getTryBlock().getFirstInstruction().getOffset();
                end = handler.getTryBlock().getLastInstruction().getEndOffset();
                if (start2 != tryStart || end != tryEnd) continue;
                handlers.add(handler);
            }
            Collections.sort(handlers, new Comparator<ExceptionHandler>(){

                @Override
                public int compare(@NotNull ExceptionHandler o1, @NotNull ExceptionHandler o2) {
                    return Integer.compare(o1.getTryBlock().getFirstInstruction().getOffset(), o2.getTryBlock().getFirstInstruction().getOffset());
                }
            });
            int tryStartIndex = 0;
            while (tryStartIndex < body.size() && body.get((int)tryStartIndex).offset < tryStart) {
                ++tryStartIndex;
            }
            if (headStartIndex < tryStartIndex) {
                ast.addAll(this.convertToAst(body.subList(headStartIndex, tryStartIndex)));
            }
            LinkedHashSet<ExceptionHandler> nestedHandlers = new LinkedHashSet<ExceptionHandler>();
            for (ExceptionHandler eh : exceptionHandlers) {
                int ts = eh.getTryBlock().getFirstInstruction().getOffset();
                int te = eh.getTryBlock().getLastInstruction().getEndOffset();
                if ((tryStart >= ts || te > tryEnd) && (tryStart > ts || te >= tryEnd)) continue;
                nestedHandlers.add(eh);
            }
            exceptionHandlers.removeAll(nestedHandlers);
            int tryEndIndex = 0;
            while (tryEndIndex < body.size() && body.get((int)tryEndIndex).offset < tryEnd) {
                ++tryEndIndex;
            }
            Block tryBlock = new Block();
            tempIndex.setValue(tryEndIndex);
            List<Node> tryAst = this.convertToAst(body, nestedHandlers, tryStartIndex, tempIndex);
            if (tempIndex.getValue() > tailStartIndex) {
                tailStartIndex = tempIndex.getValue();
            }
            if ((lastInTry = CollectionUtilities.lastOrDefault(tryAst, NOT_A_LABEL_OR_NOP)) == null || !lastInTry.isUnconditionalControlFlow()) {
                tryAst.add(new Expression(AstCode.Leave, null, -34, new Expression[0]));
            }
            tryBlock.getBody().addAll(tryAst);
            tryCatchBlock.setTryBlock(tryBlock);
            tailStartIndex = Math.max(tryEndIndex, tailStartIndex);
            int i = 0;
            int n = handlers.size();
            while (i < n) {
                ExceptionHandler eh = (ExceptionHandler)handlers.get(i);
                TypeReference catchType = eh.getCatchType();
                InstructionBlock handlerBlock = eh.getHandlerBlock();
                int handlerStart = handlerBlock.getFirstInstruction().getOffset();
                int handlerEnd = handlerBlock.getLastInstruction() != null ? handlerBlock.getLastInstruction().getEndOffset() : this._body.getCodeSize();
                int handlersStartIndex = tailStartIndex;
                while (handlersStartIndex < body.size() && body.get((int)handlersStartIndex).offset < handlerStart) {
                    ++handlersStartIndex;
                }
                int handlersEndIndex = handlersStartIndex;
                while (handlersEndIndex < body.size() && body.get((int)handlersEndIndex).offset < handlerEnd) {
                    ++handlersEndIndex;
                }
                tailStartIndex = Math.max(tailStartIndex, handlersEndIndex);
                if (eh.isCatch()) {
                    for (CatchBlock catchBlock : tryCatchBlock.getCatchBlocks()) {
                        int otherHandlerStart;
                        Expression firstExpression = CollectionUtilities.firstOrDefault(catchBlock.getSelfAndChildrenRecursive(Expression.class), new Predicate<Expression>(){

                            @Override
                            public boolean test(Expression e) {
                                return !e.getRanges().isEmpty();
                            }
                        });
                        if (firstExpression == null || (otherHandlerStart = firstExpression.getRanges().get(0).getStart()) != handlerStart) continue;
                        catchBlock.getCaughtTypes().add(catchType);
                        TypeReference commonCatchType = MetadataHelper.findCommonSuperType(catchBlock.getExceptionType(), catchType);
                        catchBlock.setExceptionType(commonCatchType);
                        if (catchBlock.getExceptionVariable() == null) {
                            this.updateExceptionVariable(catchBlock, eh);
                        }
                        break;
                    }
                } else {
                    LinkedHashSet<ExceptionHandler> nestedHandlers2 = new LinkedHashSet<ExceptionHandler>();
                    for (final ExceptionHandler e : exceptionHandlers) {
                        int ts = e.getTryBlock().getFirstInstruction().getOffset();
                        int te = e.getTryBlock().getLastInstruction().getOffset();
                        if (ts == tryStart && te == tryEnd || e == eh || handlerStart > ts || te >= handlerEnd) continue;
                        nestedHandlers2.add(e);
                        int nestedEndIndex = CollectionUtilities.firstIndexWhere(body, new Predicate<ByteCode>(){

                            @Override
                            public boolean test(ByteCode code) {
                                return code.instruction == e.getHandlerBlock().getLastInstruction();
                            }
                        });
                        if (nestedEndIndex <= handlersEndIndex) continue;
                        handlersEndIndex = nestedEndIndex;
                    }
                    tailStartIndex = Math.max(tailStartIndex, handlersEndIndex);
                    exceptionHandlers.removeAll(nestedHandlers2);
                    tempIndex.setValue(handlersEndIndex);
                    List<Node> handlerAst = this.convertToAst(body, nestedHandlers2, handlersStartIndex, tempIndex);
                    Node lastInHandler = CollectionUtilities.lastOrDefault(handlerAst, NOT_A_LABEL_OR_NOP);
                    if (tempIndex.getValue() > tailStartIndex) {
                        tailStartIndex = tempIndex.getValue();
                    }
                    if (lastInHandler == null || !lastInHandler.isUnconditionalControlFlow()) {
                        handlerAst.add(new Expression(eh.isCatch() ? AstCode.Leave : AstCode.EndFinally, null, -34, new Expression[0]));
                    }
                    if (eh.isCatch()) {
                        CatchBlock catchBlock = new CatchBlock();
                        catchBlock.setExceptionType(catchType);
                        catchBlock.getCaughtTypes().add(catchType);
                        catchBlock.getBody().addAll(handlerAst);
                        this.updateExceptionVariable(catchBlock, eh);
                        tryCatchBlock.getCatchBlocks().add(catchBlock);
                    } else if (eh.isFinally()) {
                        ByteCode loadException = this._loadExceptions.get(eh);
                        Block finallyBlock2 = new Block();
                        finallyBlock2.getBody().addAll(handlerAst);
                        tryCatchBlock.setFinallyBlock(finallyBlock2);
                        Variable exceptionTemp = new Variable();
                        exceptionTemp.setName(String.format("ex_%1$02X", handlerStart));
                        exceptionTemp.setGenerated(true);
                        if (loadException == null || loadException.storeTo == null) {
                            Expression finallyStart = CollectionUtilities.firstOrDefault(finallyBlock2.getSelfAndChildrenRecursive(Expression.class));
                            if (PatternMatching.match(finallyStart, AstCode.Store)) {
                                finallyStart.getArguments().set(0, new Expression(AstCode.Load, (Object)exceptionTemp, -34, new Expression[0]));
                            }
                        } else {
                            for (Variable storeTo : loadException.storeTo) {
                                finallyBlock2.getBody().add(0, new Expression(AstCode.Store, (Object)storeTo, -34, new Expression(AstCode.Load, (Object)exceptionTemp, -34, new Expression[0])));
                            }
                        }
                        finallyBlock2.getBody().add(0, new Expression(AstCode.Store, (Object)exceptionTemp, -34, new Expression(AstCode.LoadException, (Object)this._factory.makeNamedType("java.lang.Throwable"), -34, new Expression[0])));
                    }
                }
                ++i;
            }
            exceptionHandlers.removeAll(handlers);
            Expression first = CollectionUtilities.firstOrDefault(tryCatchBlock.getTryBlock().getSelfAndChildrenRecursive(Expression.class));
            Expression last = !tryCatchBlock.getCatchBlocks().isEmpty() ? ((lastCatch = CollectionUtilities.lastOrDefault(tryCatchBlock.getCatchBlocks())) == null ? null : CollectionUtilities.lastOrDefault(lastCatch.getSelfAndChildrenRecursive(Expression.class))) : ((finallyBlock = tryCatchBlock.getFinallyBlock()) == null ? null : CollectionUtilities.lastOrDefault(finallyBlock.getSelfAndChildrenRecursive(Expression.class)));
            if (first == null && last == null) continue;
            ast.add(tryCatchBlock);
        }
        if (tailStartIndex < endIndex.getValue()) {
            ast.addAll(this.convertToAst(body.subList(tailStartIndex, endIndex.getValue())));
        } else {
            endIndex.setValue(tailStartIndex);
        }
        return ast;
    }

    private void updateExceptionVariable(CatchBlock catchBlock, ExceptionHandler handler) {
        StrongBox<Expression> popArgument;
        ByteCode loadException = this._loadExceptions.get(handler);
        int handlerStart = handler.getHandlerBlock().getFirstInstruction().getOffset();
        if (loadException.storeTo == null || loadException.storeTo.size() != 1) {
            Variable exceptionTemp = new Variable();
            exceptionTemp.setName(String.format("ex_%1$02X", handlerStart));
            exceptionTemp.setGenerated(true);
            exceptionTemp.setType(catchBlock.getExceptionType());
            catchBlock.setExceptionVariable(exceptionTemp);
            if (loadException.storeTo != null) {
                for (Variable storeTo : loadException.storeTo) {
                    catchBlock.getBody().add(0, new Expression(AstCode.Store, (Object)storeTo, -34, new Expression(AstCode.Load, (Object)exceptionTemp, -34, new Expression[0])));
                }
            }
            return;
        }
        Node firstNode = CollectionUtilities.firstOrDefault(CollectionUtilities.skipWhile(catchBlock.getBody(), Predicates.instanceOf(Label.class)));
        if (firstNode != null && PatternMatching.matchGetArgument(firstNode, AstCode.Pop, popArgument = new StrongBox<Expression>()) && PatternMatching.matchLoad((Node)popArgument.value, CollectionUtilities.first(loadException.storeTo))) {
            Variable exceptionVariable = new Variable();
            exceptionVariable.setName(String.format("ex_%1$02X", handlerStart));
            exceptionVariable.setGenerated(true);
            catchBlock.setExceptionVariable(exceptionVariable);
            return;
        }
        catchBlock.setExceptionVariable(loadException.storeTo.get(0));
    }

    private List<Node> convertToAst(List<ByteCode> body) {
        ArrayList<Node> ast = new ArrayList<Node>();
        block3: for (ByteCode byteCode : body) {
            Instruction originalInstruction = AstBuilder.mappedInstruction(this._originalInstructionMap, byteCode.instruction);
            Range codeRange = new Range(originalInstruction.getOffset(), originalInstruction.getEndOffset());
            if (byteCode.stackBefore == null) continue;
            if (byteCode.label != null) {
                ast.add(byteCode.label);
            }
            switch (byteCode.code) {
                case Dup: 
                case DupX1: 
                case DupX2: 
                case Dup2: 
                case Dup2X1: 
                case Dup2X2: 
                case Swap: {
                    break;
                }
                default: {
                    Expression expression;
                    if (this._removed.contains(byteCode.instruction)) {
                        expression = new Expression(AstCode.Nop, null, -34, new Expression[0]);
                        ast.add(expression);
                        break;
                    }
                    expression = new Expression(byteCode.code, byteCode.operand, byteCode.offset, new Expression[0]);
                    if (byteCode.code == AstCode.Inc) {
                        assert (byteCode.secondOperand instanceof Integer);
                        expression.setCode(AstCode.Inc);
                        expression.getArguments().add(new Expression(AstCode.LdC, byteCode.secondOperand, byteCode.offset, new Expression[0]));
                    } else if (byteCode.code == AstCode.Switch) {
                        expression.putUserData(AstKeys.SWITCH_INFO, (SwitchInfo)byteCode.instruction.getOperand(0));
                    }
                    expression.getRanges().add(codeRange);
                    int popCount = byteCode.popCount != -1 ? byteCode.popCount : byteCode.stackBefore.length;
                    int i = byteCode.stackBefore.length - popCount;
                    while (i < byteCode.stackBefore.length) {
                        StackSlot slot = byteCode.stackBefore[i];
                        if (slot.value.getType().isDoubleWord()) {
                            ++i;
                        }
                        expression.getArguments().add(new Expression(AstCode.Load, (Object)slot.loadFrom, byteCode.offset, new Expression[0]));
                        ++i;
                    }
                    if (byteCode.storeTo == null || byteCode.storeTo.isEmpty()) {
                        ast.add(expression);
                        break;
                    }
                    if (byteCode.storeTo.size() == 1) {
                        ast.add(new Expression(AstCode.Store, (Object)byteCode.storeTo.get(0), expression.getOffset(), expression));
                        break;
                    }
                    Variable tempVariable = new Variable();
                    tempVariable.setName(String.format("expr_%1$02X", byteCode.offset));
                    tempVariable.setGenerated(true);
                    ast.add(new Expression(AstCode.Store, (Object)tempVariable, expression.getOffset(), expression));
                    int i2 = byteCode.storeTo.size() - 1;
                    while (i2 >= 0) {
                        ast.add(new Expression(AstCode.Store, (Object)byteCode.storeTo.get(i2), -34, new Expression(AstCode.Load, (Object)tempVariable, byteCode.offset, new Expression[0])));
                        --i2;
                    }
                    continue block3;
                }
            }
        }
        return ast;
    }

    private static Frame createFrame(StackSlot[] stack, VariableSlot[] locals) {
        FrameValue[] variableValues;
        int i;
        FrameValue[] stackValues;
        if (stack.length == 0) {
            stackValues = FrameValue.EMPTY_VALUES;
        } else {
            stackValues = new FrameValue[stack.length];
            i = 0;
            while (i < stack.length) {
                stackValues[i] = stack[i].value;
                ++i;
            }
        }
        if (locals.length == 0) {
            variableValues = FrameValue.EMPTY_VALUES;
        } else {
            variableValues = new FrameValue[locals.length];
            i = 0;
            while (i < locals.length) {
                variableValues[i] = locals[i].value;
                ++i;
            }
        }
        return new Frame(FrameType.New, variableValues, stackValues);
    }

    static /* synthetic */ ByteCode[] access$0() {
        return EMPTY_DEFINITIONS;
    }

    private static final class ByteCode {
        Label label;
        Instruction instruction;
        String name;
        int offset;
        int endOffset;
        AstCode code;
        Object operand;
        Object secondOperand;
        int popCount = -1;
        int pushCount;
        ByteCode next;
        ByteCode previous;
        FrameValue type;
        StackSlot[] stackBefore;
        VariableSlot[] variablesBefore;
        List<Variable> storeTo;

        private ByteCode() {
        }

        public final String name() {
            if (this.name == null) {
                this.name = String.format("#%1$04d", this.offset);
            }
            return this.name;
        }

        public final String makeLabelName() {
            return String.format("Label_%1$04d", this.offset);
        }

        public final Frame getFrameBefore() {
            return AstBuilder.createFrame(this.stackBefore, this.variablesBefore);
        }

        public final boolean isVariableDefinition() {
            return this.code == AstCode.Store;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name()).append(':');
            if (this.label != null) {
                sb.append('*');
            }
            sb.append(' ');
            sb.append(this.code.getName());
            if (this.operand != null) {
                int n;
                int n2;
                Object[] objectArray;
                sb.append(' ');
                if (this.operand instanceof Instruction) {
                    sb.append(String.format("#%1$04d", ((Instruction)this.operand).getOffset()));
                } else if (this.operand instanceof Instruction[]) {
                    objectArray = (Instruction[])this.operand;
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object instruction = objectArray[n];
                        sb.append(String.format("#%1$04d", ((Instruction)instruction).getOffset()));
                        sb.append(' ');
                        ++n;
                    }
                } else if (this.operand instanceof Label) {
                    sb.append(((Label)this.operand).getName());
                } else if (this.operand instanceof Label[]) {
                    objectArray = (Label[])this.operand;
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        Object l = objectArray[n];
                        sb.append(((Label)l).getName());
                        sb.append(' ');
                        ++n;
                    }
                } else if (this.operand instanceof VariableReference) {
                    VariableReference variable = (VariableReference)this.operand;
                    if (variable.hasName()) {
                        sb.append(variable.getName());
                    } else {
                        sb.append("$").append(String.valueOf(variable.getSlot()));
                    }
                } else {
                    sb.append(this.operand);
                }
            }
            if (this.stackBefore != null) {
                sb.append(" StackBefore={");
                int i = 0;
                while (i < this.stackBefore.length) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    StackSlot slot = this.stackBefore[i];
                    ByteCode[] definitions = slot.definitions;
                    int j = 0;
                    while (j < definitions.length) {
                        if (j != 0) {
                            sb.append('|');
                        }
                        sb.append(String.format("#%1$04d", definitions[j].offset));
                        ++j;
                    }
                    ++i;
                }
                sb.append('}');
            }
            if (this.storeTo != null && !this.storeTo.isEmpty()) {
                sb.append(" StoreTo={");
                int i = 0;
                while (i < this.storeTo.size()) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(this.storeTo.get(i).getName());
                    ++i;
                }
                sb.append('}');
            }
            if (this.variablesBefore != null) {
                sb.append(" VariablesBefore={");
                int i = 0;
                while (i < this.variablesBefore.length) {
                    VariableSlot slot;
                    if (i != 0) {
                        sb.append(',');
                    }
                    if ((slot = this.variablesBefore[i]).isUninitialized()) {
                        sb.append('?');
                    } else {
                        ByteCode[] definitions = slot.definitions;
                        int j = 0;
                        while (j < definitions.length) {
                            if (j != 0) {
                                sb.append('|');
                            }
                            sb.append(String.format("#%1$04d", definitions[j].offset));
                            ++j;
                        }
                    }
                    ++i;
                }
                sb.append('}');
            }
            return sb.toString();
        }
    }

    private static final class FinallyInlining {
        private final MethodBody _body;
        private final InstructionCollection _instructions;
        private final List<ExceptionHandler> _exceptionHandlers;
        private final Set<Instruction> _removed;
        private final Function<Instruction, Instruction> _previous;
        private final ControlFlowGraph _cfg;
        private final Map<Instruction, ControlFlowNode> _nodeMap;
        private final Map<ExceptionHandler, HandlerInfo> _handlerMap = new IdentityHashMap<ExceptionHandler, HandlerInfo>();
        private final Set<ControlFlowNode> _processedNodes = new LinkedHashSet<ControlFlowNode>();
        private final Set<ControlFlowNode> _allFinallyNodes = new LinkedHashSet<ControlFlowNode>();

        private FinallyInlining(MethodBody body, InstructionCollection instructions, List<ExceptionHandler> handlers, Set<Instruction> removedInstructions) {
            this._body = body;
            this._instructions = instructions;
            this._exceptionHandlers = handlers;
            this._removed = removedInstructions;
            this._previous = new Function<Instruction, Instruction>(){

                @Override
                public Instruction apply(Instruction i) {
                    return this.previous(i);
                }
            };
            this.preProcess();
            this._cfg = ControlFlowGraphBuilder.build(instructions, handlers);
            this._cfg.computeDominance();
            this._cfg.computeDominanceFrontier();
            this._nodeMap = AstBuilder.createNodeMap(this._cfg);
            HashSet<ControlFlowNode> terminals = new HashSet<ControlFlowNode>();
            int i = 0;
            while (i < handlers.size()) {
                ExceptionHandler handler = handlers.get(i);
                InstructionBlock handlerBlock = handler.getHandlerBlock();
                ControlFlowNode handlerNode = AstBuilder.findHandlerNode(this._cfg, handler);
                ControlFlowNode head = this._nodeMap.get(handlerBlock.getFirstInstruction());
                ControlFlowNode tryHead = this._nodeMap.get(handler.getTryBlock().getFirstInstruction());
                terminals.clear();
                int j = 0;
                while (j < handlers.size()) {
                    ExceptionHandler otherHandler = handlers.get(j);
                    if (otherHandler.getTryBlock().equals(handler.getTryBlock())) {
                        terminals.add(AstBuilder.findHandlerNode(this._cfg, otherHandler));
                    }
                    ++j;
                }
                ArrayList<ControlFlowNode> tryNodes = new ArrayList<ControlFlowNode>(AstBuilder.findDominatedNodes(this._cfg, tryHead, true, terminals));
                terminals.remove(handlerNode);
                if (handler.isFinally() && handlerNode != null) {
                    terminals.add(handlerNode.getEndFinallyNode());
                }
                ArrayList<ControlFlowNode> handlerNodes = new ArrayList<ControlFlowNode>(AstBuilder.findDominatedNodes(this._cfg, head, true, terminals));
                Collections.sort(tryNodes);
                Collections.sort(handlerNodes);
                ControlFlowNode tail = (ControlFlowNode)CollectionUtilities.last(handlerNodes);
                HandlerInfo handlerInfo = new HandlerInfo(handler, handlerNode, head, tail, tryNodes, handlerNodes);
                this._handlerMap.put(handler, handlerInfo);
                if (handler.isFinally()) {
                    this._allFinallyNodes.addAll(handlerNodes);
                }
                ++i;
            }
        }

        private static void dumpHandlerNodes(ExceptionHandler handler, List<ControlFlowNode> tryNodes, List<ControlFlowNode> handlerNodes) {
            PlainTextOutput output = new PlainTextOutput();
            output.writeLine(handler.toString());
            output.writeLine("Try Nodes:");
            output.indent();
            for (ControlFlowNode node : tryNodes) {
                output.writeLine(node.toString());
            }
            output.unindent();
            output.writeLine("Handler Nodes:");
            output.indent();
            for (ControlFlowNode node : handlerNodes) {
                output.writeLine(node.toString());
            }
            output.unindent();
            output.writeLine();
            System.out.println(output);
        }

        static void run(MethodBody body, InstructionCollection instructions, List<ExceptionHandler> handlers, Set<Instruction> removedInstructions) {
            Collections.reverse(handlers);
            try {
                LOG.fine("Removing inlined `finally` code...");
                FinallyInlining inlining = new FinallyInlining(body, instructions, handlers, removedInstructions);
                inlining.runCore();
            }
            finally {
                Collections.reverse(handlers);
            }
        }

        private void runCore() {
            List<ExceptionHandler> handlers = this._exceptionHandlers;
            if (handlers.isEmpty()) {
                return;
            }
            final List<ExceptionHandler> originalHandlers = CollectionUtilities.toList(this._exceptionHandlers);
            List<ExceptionHandler> sortedHandlers = CollectionUtilities.toList(originalHandlers);
            Collections.sort(sortedHandlers, new Comparator<ExceptionHandler>(){

                @Override
                public int compare(@NotNull ExceptionHandler o1, @NotNull ExceptionHandler o2) {
                    if (o1.getHandlerBlock().contains(o2.getHandlerBlock())) {
                        return -1;
                    }
                    if (o2.getHandlerBlock().contains(o1.getHandlerBlock())) {
                        return 1;
                    }
                    return Integer.compare(originalHandlers.indexOf(o1), originalHandlers.indexOf(o2));
                }
            });
            for (ExceptionHandler handler : sortedHandlers) {
                if (!handler.isFinally()) continue;
                this.processFinally(handler);
            }
        }

        private void processFinally(ExceptionHandler handler) {
            HandlerInfo handlerInfo = this._handlerMap.get(handler);
            Instruction first = handlerInfo.head.getStart();
            Instruction last = handlerInfo.handler.getHandlerBlock().getLastInstruction();
            if (last.getOpCode() == OpCode.ENDFINALLY) {
                first = first.getNext();
                last = this.previous(last);
            } else if (first.getOpCode().isStore() || first.getOpCode() == OpCode.POP) {
                first = first.getNext();
            }
            if (first == null || last == null) {
                return;
            }
            int instructionCount = 0;
            Instruction p = last;
            while (p != null && p.getOffset() >= first.getOffset()) {
                ++instructionCount;
                p = this.previous(p);
            }
            if (instructionCount == 0 || instructionCount == 1 && !this._removed.contains(last) && last.getOpCode().isUnconditionalBranch()) {
                return;
            }
            Set<ControlFlowNode> toProcess = this.collectNodes(handlerInfo);
            LinkedHashSet<ControlFlowNode> forbiddenNodes = new LinkedHashSet<ControlFlowNode>(this._allFinallyNodes);
            forbiddenNodes.removeAll(handlerInfo.tryNodes);
            this._processedNodes.clear();
            this.processNodes(handlerInfo, first, last, instructionCount, toProcess, forbiddenNodes);
        }

        /*
         * WARNING - void declaration
         */
        private void processNodes(HandlerInfo handlerInfo, Instruction first, Instruction last, int instructionCount, Set<ControlFlowNode> toProcess, Set<ControlFlowNode> forbiddenNodes) {
            ExceptionHandler handler = handlerInfo.handler;
            ControlFlowNode tryHead = this._nodeMap.get(handler.getTryBlock().getFirstInstruction());
            ControlFlowNode finallyTail = this._nodeMap.get(handler.getHandlerBlock().getLastInstruction());
            ArrayList<Pair<Instruction, Instruction>> startingPoints = new ArrayList<Pair<Instruction, Instruction>>();
            block13: for (ControlFlowNode node : toProcess) {
                void var19_22;
                ExceptionHandler nodeHandler = node.getExceptionHandler();
                if (node.getNodeType() == ControlFlowNodeType.EndFinally) continue;
                if (nodeHandler != null) {
                    node = this._nodeMap.get(nodeHandler.getHandlerBlock().getLastInstruction());
                }
                if (this._processedNodes.contains(node) || forbiddenNodes.contains(node)) continue;
                Instruction tail = node.getEnd();
                boolean isLeave = false;
                boolean tryNext = false;
                boolean tryPrevious = false;
                if (finallyTail.getEnd().getOpCode().isReturn() || finallyTail.getEnd().getOpCode().isThrow()) {
                    isLeave = true;
                }
                if (last.getOpCode() == OpCode.GOTO || last.getOpCode() == OpCode.GOTO_W) {
                    tryNext = true;
                }
                if (tail.getOpCode().isUnconditionalBranch()) {
                    switch (tail.getOpCode()) {
                        case GOTO: 
                        case GOTO_W: {
                            tryPrevious = true;
                            break;
                        }
                        case RETURN: {
                            tail = this.previous(tail);
                            tryPrevious = true;
                            break;
                        }
                        case IRETURN: 
                        case LRETURN: 
                        case FRETURN: 
                        case DRETURN: 
                        case ARETURN: {
                            if (finallyTail.getEnd().getOpCode().getFlowControl() != FlowControl.Return) {
                                tail = this.previous(tail);
                            }
                            tryPrevious = true;
                            break;
                        }
                        case ATHROW: {
                            tryNext = true;
                            tryPrevious = true;
                        }
                    }
                }
                if (tail == null) continue;
                startingPoints.add(Pair.create(last, tail));
                if (tryPrevious) {
                    startingPoints.add(Pair.create(last, this.previous(tail)));
                }
                if (tryNext) {
                    startingPoints.add(Pair.create(last, tail.getNext()));
                }
                boolean matchFound = false;
                for (Pair pair : startingPoints) {
                    if (forbiddenNodes.contains(this._nodeMap.get(pair.getSecond())) || !AstBuilder.opCodesMatch((Instruction)pair.getFirst(), (Instruction)pair.getSecond(), instructionCount, this._previous)) continue;
                    tail = (Instruction)pair.getSecond();
                    matchFound = true;
                    break;
                }
                startingPoints.clear();
                if (!matchFound) {
                    Instruction target;
                    Instruction instruction;
                    if (last.getOpCode() != OpCode.JSR || tail != (instruction = handlerInfo.handler.getTryBlock().getLastInstruction()) || instruction.getOpCode() != OpCode.GOTO && instruction.getOpCode() != OpCode.GOTO_W || (target = (Instruction)instruction.getOperand(0)).getOpCode() != OpCode.JSR || target.getOperand(0) != last.getOperand(0)) continue;
                    target.setOpCode(OpCode.NOP);
                    target.setOperand(null);
                    continue;
                }
                if (tail.getOffset() - tryHead.getOffset() == last.getOffset() - first.getOffset() && handlerInfo.tryNodes.contains(node)) continue;
                boolean bl = false;
                while (var19_22 < instructionCount) {
                    this._removed.add(tail);
                    tail = this.previous(tail);
                    if (tail == null) continue block13;
                    ++var19_22;
                }
                if (isLeave) {
                    if (tail != null && tail.getOpCode().isStore() && !this._body.getMethod().getReturnType().isVoid()) {
                        Instruction instruction = InstructionHelper.reverseLoadOrStore(tail);
                        Instruction returnSite = node.getEnd();
                        Instruction loadSite = returnSite.getPrevious();
                        loadSite.setOpCode(instruction.getOpCode());
                        if (instruction.getOperandCount() == 1) {
                            loadSite.setOperand(instruction.getOperand(0));
                        }
                        switch (instruction.getOpCode().name().charAt(0)) {
                            case 'I': {
                                returnSite.setOpCode(OpCode.IRETURN);
                                break;
                            }
                            case 'L': {
                                returnSite.setOpCode(OpCode.LRETURN);
                                break;
                            }
                            case 'F': {
                                returnSite.setOpCode(OpCode.FRETURN);
                                break;
                            }
                            case 'D': {
                                returnSite.setOpCode(OpCode.DRETURN);
                                break;
                            }
                            case 'A': {
                                returnSite.setOpCode(OpCode.ARETURN);
                            }
                        }
                        returnSite.setOperand(null);
                        this._removed.remove(loadSite);
                        this._removed.remove(returnSite);
                    } else {
                        this._removed.add(node.getEnd());
                    }
                }
                this._processedNodes.add(node);
            }
        }

        private Set<ControlFlowNode> collectNodes(HandlerInfo handlerInfo) {
            ControlFlowGraph cfg = this._cfg;
            ArrayList<ControlFlowNode> successors = new ArrayList<ControlFlowNode>();
            LinkedHashSet<ControlFlowNode> toProcess = new LinkedHashSet<ControlFlowNode>();
            ControlFlowNode endFinallyNode = handlerInfo.handlerNode.getEndFinallyNode();
            LinkedHashSet<ControlFlowNode> exitOnlySuccessors = new LinkedHashSet<ControlFlowNode>();
            InstructionBlock tryBlock = handlerInfo.handler.getTryBlock();
            if (endFinallyNode != null) {
                successors.add(handlerInfo.handlerNode);
            }
            for (ControlFlowNode exit : cfg.getRegularExit().getPredecessors()) {
                if (exit.getNodeType() != ControlFlowNodeType.Normal || !tryBlock.contains(exit.getEnd())) continue;
                toProcess.add(exit);
            }
            for (ControlFlowNode exit : cfg.getExceptionalExit().getPredecessors()) {
                if (exit.getNodeType() != ControlFlowNodeType.Normal || !tryBlock.contains(exit.getEnd())) continue;
                toProcess.add(exit);
            }
            int i = 0;
            while (i < successors.size()) {
                ControlFlowNode successor = (ControlFlowNode)successors.get(i);
                for (final ControlFlowEdge edge : successor.getIncoming()) {
                    if (edge.getSource() == successor) continue;
                    if (edge.getType() == JumpType.Normal && edge.getSource().getNodeType() == ControlFlowNodeType.Normal && !exitOnlySuccessors.contains(successor)) {
                        toProcess.add(edge.getSource());
                        continue;
                    }
                    if (edge.getType() == JumpType.JumpToExceptionHandler && edge.getSource().getNodeType() == ControlFlowNodeType.Normal && (edge.getSource().getEnd().getOpCode().isThrow() || edge.getSource().getEnd().getOpCode().isReturn())) {
                        toProcess.add(edge.getSource());
                        if (!exitOnlySuccessors.contains(successor)) continue;
                        exitOnlySuccessors.add(edge.getSource());
                        continue;
                    }
                    if (edge.getSource().getNodeType() == ControlFlowNodeType.CatchHandler) {
                        ControlFlowNode endCatch = AstBuilder.findNode(cfg, edge.getSource().getExceptionHandler().getHandlerBlock().getLastInstruction());
                        if (!handlerInfo.handler.getTryBlock().contains(endCatch.getEnd())) continue;
                        toProcess.add(endCatch);
                        continue;
                    }
                    if (edge.getSource().getNodeType() == ControlFlowNodeType.FinallyHandler) {
                        successors.add(edge.getSource());
                        exitOnlySuccessors.add(edge.getSource());
                        continue;
                    }
                    if (edge.getSource().getNodeType() != ControlFlowNodeType.EndFinally) continue;
                    successors.add(edge.getSource());
                    HandlerInfo precedingFinally = CollectionUtilities.firstOrDefault(this._handlerMap.values(), new Predicate<HandlerInfo>(){

                        @Override
                        public boolean test(HandlerInfo o) {
                            return o.handlerNode.getEndFinallyNode() == edge.getSource();
                        }
                    });
                    if (precedingFinally == null) continue;
                    successors.add(precedingFinally.handlerNode);
                    exitOnlySuccessors.remove(precedingFinally.handlerNode);
                }
                ++i;
            }
            ArrayList<ControlFlowNode> finallyNodes = null;
            for (ControlFlowNode node : toProcess) {
                if (!this._allFinallyNodes.contains(node)) continue;
                if (finallyNodes == null) {
                    finallyNodes = new ArrayList<ControlFlowNode>();
                }
                finallyNodes.add(node);
            }
            if (finallyNodes != null) {
                toProcess.removeAll(finallyNodes);
                toProcess.addAll(finallyNodes);
            }
            return toProcess;
        }

        private void preProcess() {
            InstructionCollection instructions = this._instructions;
            List<ExceptionHandler> handlers = this._exceptionHandlers;
            ControlFlowGraph cfg = ControlFlowGraphBuilder.build(instructions, handlers);
            cfg.computeDominance();
            cfg.computeDominanceFrontier();
            int i = 0;
            while (i < handlers.size()) {
                ExceptionHandler handler = handlers.get(i);
                if (handler.isFinally()) {
                    InstructionBlock handlerBlock = handler.getHandlerBlock();
                    ControlFlowNode finallyHead = AstBuilder.findNode(cfg, handler.getHandlerBlock().getFirstInstruction());
                    List finallyNodes = CollectionUtilities.toList(AstBuilder.findDominatedNodes(cfg, finallyHead, true, Collections.emptySet()));
                    Collections.sort(finallyNodes);
                    Instruction first = handlerBlock.getFirstInstruction();
                    Instruction last = ((ControlFlowNode)CollectionUtilities.last(finallyNodes)).getEnd();
                    Instruction nextToLast = last.getPrevious();
                    boolean firstPass = true;
                    while (true) {
                        if (first.getOpCode().isStore() && last.getOpCode() == OpCode.ATHROW && nextToLast.getOpCode().isLoad() && InstructionHelper.getLoadOrStoreSlot(first) == InstructionHelper.getLoadOrStoreSlot(nextToLast)) {
                            nextToLast.setOpCode(OpCode.NOP);
                            nextToLast.setOperand(null);
                            this._removed.add(nextToLast);
                            last.setOpCode(OpCode.ENDFINALLY);
                            last.setOperand(null);
                            break;
                        }
                        if (firstPass = !firstPass) break;
                        last = handlerBlock.getLastInstruction();
                        nextToLast = last.getPrevious();
                    }
                }
                ++i;
            }
        }

        private Instruction previous(Instruction i) {
            Instruction p = i.getPrevious();
            while (p != null && this._removed.contains(p)) {
                p = p.getPrevious();
            }
            return p;
        }
    }

    private static final class HandlerInfo {
        final ExceptionHandler handler;
        final ControlFlowNode handlerNode;
        final ControlFlowNode head;
        final ControlFlowNode tail;
        final List<ControlFlowNode> tryNodes;
        final List<ControlFlowNode> handlerNodes;

        HandlerInfo(ExceptionHandler handler, ControlFlowNode handlerNode, ControlFlowNode head, ControlFlowNode tail, List<ControlFlowNode> tryNodes, List<ControlFlowNode> handlerNodes) {
            this.handler = handler;
            this.handlerNode = handlerNode;
            this.head = head;
            this.tail = tail;
            this.tryNodes = tryNodes;
            this.handlerNodes = handlerNodes;
        }
    }

    private static final class StackSlot {
        final FrameValue value;
        final ByteCode[] definitions;
        final Variable loadFrom;

        public StackSlot(FrameValue value, ByteCode[] definitions) {
            this.value = VerifyArgument.notNull(value, "value");
            this.definitions = VerifyArgument.notNull(definitions, "definitions");
            this.loadFrom = null;
        }

        public StackSlot(FrameValue value, ByteCode[] definitions, Variable loadFrom) {
            this.value = VerifyArgument.notNull(value, "value");
            this.definitions = VerifyArgument.notNull(definitions, "definitions");
            this.loadFrom = loadFrom;
        }

        public static StackSlot[] modifyStack(StackSlot[] stack, int popCount, ByteCode pushDefinition, FrameValue ... pushTypes) {
            VerifyArgument.notNull(stack, "stack");
            VerifyArgument.isNonNegative(popCount, "popCount");
            VerifyArgument.noNullElements(pushTypes, "pushTypes");
            StackSlot[] newStack = new StackSlot[stack.length - popCount + pushTypes.length];
            System.arraycopy(stack, 0, newStack, 0, stack.length - popCount);
            int i = stack.length - popCount;
            int j = 0;
            while (i < newStack.length) {
                newStack[i] = new StackSlot(pushTypes[j], new ByteCode[]{pushDefinition});
                ++i;
                ++j;
            }
            return newStack;
        }

        public String toString() {
            return "StackSlot(" + this.value + ')';
        }

        protected final StackSlot clone() {
            return new StackSlot(this.value, (ByteCode[])this.definitions.clone(), this.loadFrom);
        }
    }

    private static final class SubroutineInfo {
        final Instruction start;
        final Instruction end;
        final List<Instruction> liveReferences = new ArrayList<Instruction>();
        final List<Instruction> deadReferences = new ArrayList<Instruction>();
        final List<ControlFlowNode> contents;
        final ControlFlowNode entryNode;
        final List<ControlFlowNode> exitNodes = new ArrayList<ControlFlowNode>();
        final List<ExceptionHandler> containedHandlers = new ArrayList<ExceptionHandler>();
        final ControlFlowGraph cfg;

        public SubroutineInfo(ControlFlowNode entryNode, List<ControlFlowNode> contents, ControlFlowGraph cfg) {
            this.start = entryNode.getStart();
            this.end = CollectionUtilities.last(contents).getEnd();
            this.entryNode = entryNode;
            this.contents = contents;
            this.cfg = cfg;
            for (ControlFlowNode node : contents) {
                if (node.getNodeType() != ControlFlowNodeType.Normal || !node.getEnd().getOpCode().isReturnFromSubroutine()) continue;
                this.exitNodes.add(node);
            }
        }
    }

    private static final class VariableInfo {
        final int slot;
        final Variable variable;
        final List<ByteCode> definitions;
        final List<ByteCode> references;
        Range lifetime;

        VariableInfo(int slot, Variable variable, List<ByteCode> definitions, List<ByteCode> references) {
            this.slot = slot;
            this.variable = variable;
            this.definitions = definitions;
            this.references = references;
        }

        void recomputeLifetime() {
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            for (ByteCode d : this.definitions) {
                start = Math.min(d.offset, start);
                end = Math.max(d.offset, end);
            }
            for (ByteCode r : this.references) {
                start = Math.min(r.offset, start);
                end = Math.max(r.offset, end);
            }
            this.lifetime = new Range(start, end);
        }
    }

    private static final class VariableSlot {
        static final VariableSlot UNKNOWN_INSTANCE = new VariableSlot(FrameValue.EMPTY, AstBuilder.access$0());
        final ByteCode[] definitions;
        final FrameValue value;

        public VariableSlot(FrameValue value, ByteCode[] definitions) {
            this.value = VerifyArgument.notNull(value, "value");
            this.definitions = VerifyArgument.notNull(definitions, "definitions");
        }

        public static VariableSlot[] cloneVariableState(VariableSlot[] state) {
            return (VariableSlot[])state.clone();
        }

        public static VariableSlot[] makeUnknownState(int variableCount) {
            VariableSlot[] unknownVariableState = new VariableSlot[variableCount];
            int i = 0;
            while (i < variableCount) {
                unknownVariableState[i] = UNKNOWN_INSTANCE;
                ++i;
            }
            return unknownVariableState;
        }

        public final boolean isUninitialized() {
            return this.value == FrameValue.UNINITIALIZED || this.value == FrameValue.UNINITIALIZED_THIS;
        }

        protected final VariableSlot clone() {
            return new VariableSlot(this.value, (ByteCode[])this.definitions.clone());
        }
    }
}

