/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.StringUtilities;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class VerifyArgument {
    private VerifyArgument() {
    }

    public static <T> T notNull(T value, String parameterName) {
        if (value != null) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' cannot be null.", parameterName));
    }

    public static <T> T[] notEmpty(T[] array, String parameterName) {
        VerifyArgument.notNull(array, parameterName);
        if (array.length == 0) {
            throw new IllegalArgumentException(String.format("Argument '%s' must be a non-empty collection.", parameterName));
        }
        return array;
    }

    public static <T extends Iterable<?>> T notEmpty(T collection, String parameterName) {
        Iterator<?> iterator;
        VerifyArgument.notNull(collection, parameterName);
        if (collection instanceof Collection ? !((Collection)collection).isEmpty() : (iterator = collection.iterator()).hasNext()) {
            return collection;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be a non-empty collection.", parameterName));
    }

    public static <T> T[] noNullElements(T[] array, String parameterName) {
        VerifyArgument.notNull(array, parameterName);
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
            }
            ++n2;
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, int offset, int length, String parameterName) {
        VerifyArgument.notNull(array, parameterName);
        int i = offset;
        int end = offset + length;
        while (i < end) {
            T item = array[i];
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements in the range (%s, %s].", parameterName, offset, offset + length));
            }
            ++i;
        }
        return array;
    }

    public static <T extends Iterable<?>> T noNullElements(T collection, String parameterName) {
        VerifyArgument.notNull(collection, parameterName);
        if (collection instanceof List && collection instanceof RandomAccess) {
            List list = (List)collection;
            int i = 0;
            int n = list.size();
            while (i < n) {
                if (list.get(i) == null) {
                    throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
                }
                ++i;
            }
            return collection;
        }
        for (Object item : collection) {
            if (item != null) continue;
            throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
        }
        return collection;
    }

    public static <T> T[] noNullElementsAndNotEmpty(T[] array, String parameterName) {
        VerifyArgument.notEmpty(array, parameterName);
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
            }
            ++n2;
        }
        return array;
    }

    public static <T> T[] noNullElementsAndNotEmpty(T[] array, int offset, int length, String parameterName) {
        VerifyArgument.notEmpty(array, parameterName);
        int i = offset;
        int end = offset + length;
        while (i < end) {
            T item = array[i];
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements in the range (%s, %s].", parameterName, offset, offset + length));
            }
            ++i;
        }
        return array;
    }

    public static <T extends Iterable<?>> T noNullElementsAndNotEmpty(T collection, String parameterName) {
        VerifyArgument.notNull(collection, parameterName);
        if (collection instanceof List && collection instanceof RandomAccess) {
            List list = (List)collection;
            if (list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Argument '%s' must be a non-empty collection.", parameterName));
            }
            int i = 0;
            int n = list.size();
            while (i < n) {
                if (list.get(i) == null) {
                    throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
                }
                ++i;
            }
            return collection;
        }
        Iterator<?> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException(String.format("Argument '%s' must be a non-empty collection.", parameterName));
        }
        do {
            Object item;
            if ((item = iterator.next()) != null) continue;
            throw new IllegalArgumentException(String.format("Argument '%s' must not have any null elements.", parameterName));
        } while (iterator.hasNext());
        return collection;
    }

    public static <T> T[] elementsOfType(Class<?> elementType, T[] values, String parameterName) {
        VerifyArgument.notNull(elementType, "elementType");
        VerifyArgument.notNull(values, "values");
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (!elementType.isInstance(value)) {
                throw new IllegalArgumentException(String.format("Argument '%s' must only contain elements of type '%s'.", parameterName, elementType));
            }
            ++n2;
        }
        return values;
    }

    public static <T> T[] elementsOfTypeOrNull(Class<T> elementType, T[] values, String parameterName) {
        VerifyArgument.notNull(elementType, "elementType");
        VerifyArgument.notNull(values, "values");
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (value != null && !elementType.isInstance(value)) {
                throw new IllegalArgumentException(String.format("Argument '%s' must only contain elements of type '%s'.", parameterName, elementType));
            }
            ++n2;
        }
        return values;
    }

    public static int validElementRange(int size, int startInclusive, int endExclusive) {
        if (startInclusive >= 0 && endExclusive <= size && endExclusive >= startInclusive) {
            return endExclusive - startInclusive;
        }
        throw new IllegalArgumentException(String.format("The specified element range is not valid: range=(%d, %d], length=%d", startInclusive, endExclusive, size));
    }

    public static String notNullOrEmpty(String value, String parameterName) {
        if (!StringUtilities.isNullOrEmpty(value)) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be a non-null, non-empty string.", parameterName));
    }

    public static String notNullOrWhitespace(String value, String parameterName) {
        if (!StringUtilities.isNullOrWhitespace(value)) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be a non-null, non-empty string.", parameterName));
    }

    public static int isNonZero(int value, String parameterName) {
        if (value != 0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be non-zero, but value was: %d.", parameterName, value));
    }

    public static int isPositive(int value, String parameterName) {
        if (value > 0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be positive, but value was: %d.", parameterName, value));
    }

    public static int isNonNegative(int value, String parameterName) {
        if (value >= 0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be non-negative, but value was: %d.", parameterName, value));
    }

    public static int isNegative(int value, String parameterName) {
        if (value < 0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be negative, but value was: %d.", parameterName, value));
    }

    public static int inRange(int minInclusive, int maxInclusive, int value, String parameterName) {
        if (maxInclusive < minInclusive) {
            throw new IllegalArgumentException(String.format("The specified maximum value (%d) is less than the specified minimum value (%d).", maxInclusive, minInclusive));
        }
        if (value >= minInclusive && value <= maxInclusive) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be in the range [%s, %s], but value was: %d.", parameterName, minInclusive, maxInclusive, value));
    }

    public static double isNonZero(double value, String parameterName) {
        if (value != 0.0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be non-zero, but value was: %s.", parameterName, value));
    }

    public static double isPositive(double value, String parameterName) {
        if (value > 0.0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be positive, but value was: %s.", parameterName, value));
    }

    public static double isNonNegative(double value, String parameterName) {
        if (value >= 0.0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be non-negative, but value was: %s.", parameterName, value));
    }

    public static double isNegative(double value, String parameterName) {
        if (value < 0.0) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be negative, but value was: %s.", parameterName, value));
    }

    public static double inRange(double minInclusive, double maxInclusive, double value, String parameterName) {
        if (Double.isNaN(minInclusive)) {
            throw new IllegalArgumentException("The minimum value cannot be NaN.");
        }
        if (Double.isNaN(maxInclusive)) {
            throw new IllegalArgumentException("The maximum value cannot be NaN.");
        }
        if (maxInclusive < minInclusive) {
            throw new IllegalArgumentException(String.format("The specified maximum value (%s) is less than the specified minimum value (%s).", maxInclusive, minInclusive));
        }
        if (value >= minInclusive && value <= maxInclusive) {
            return value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be in the range [%s, %s], but value was: %s.", parameterName, minInclusive, maxInclusive, value));
    }

    public static <T> T instanceOf(Class<T> type, Object value, String parameterName) {
        Class<?> actualType = VerifyArgument.getBoxedType(VerifyArgument.notNull(type, "type"));
        if (actualType.isInstance(value)) {
            return (T)value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must be an instance of type %s.", parameterName, type.getCanonicalName()));
    }

    public static <T> T notInstanceOf(Class<T> type, Object value, String parameterName) {
        Class<?> actualType = VerifyArgument.getBoxedType(VerifyArgument.notNull(type, "type"));
        if (!actualType.isInstance(value)) {
            return (T)value;
        }
        throw new IllegalArgumentException(String.format("Argument '%s' must not be an instance of type %s.", parameterName, type.getCanonicalName()));
    }

    private static Class<?> getBoxedType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }
}

