/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.Predicate;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Predicates {
    public static final Predicate<Object> IS_NULL = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o == null;
        }
    };
    public static final Predicate<Object> NON_NULL = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o != null;
        }
    };
    public static final Predicate<Object> FALSE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }
    };
    public static final Predicate<Object> TRUE = new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }
    };

    private Predicates() {
        throw new AssertionError((Object)"No instances!");
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T> Predicate<T> nonNull() {
        return NON_NULL;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> instanceOf(final Class<?> clazz) {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return clazz.isInstance(o);
            }
        };
    }

    public static <T> Predicate<T> isSame(final T target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return t == target;
            }
        };
    }

    public static <T> Predicate<T> isEqual(final T target) {
        if (target == null) {
            return Predicates.isNull();
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return target.equals(t);
            }
        };
    }

    public static <T> Predicate<T> contains(final Collection<? extends T> target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return target.contains(t);
            }
        };
    }

    public static <T> Predicate<T> containsKey(final Map<? extends T, ?> target) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return target.containsKey(t);
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> negate(final P predicate) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> and(final Predicate<T> first, final P second) {
        if (first != null && first == second) {
            return first;
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) && second.test(t);
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> and(Iterable<P> components) {
        final List<P> predicates = Predicates.safeCopyOf(components);
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    static <T, P extends Predicate<? super T>> Predicate<T> and(P first, Iterable<P> components) {
        final List<P> predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    public static <T, P extends Predicate<? super T>> Predicate<T> and(P ... components) {
        final Predicate[] predicates = (Predicate[])Predicates.safeCopyOf(components);
        if (predicates.length == 0) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (!predicate.test(t)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    static <T, P extends Predicate<? super T>> Predicate<T> and(P first, P ... components) {
        final Predicate<Object>[] predicates = Predicates.safeCopyOf(first, components);
        if (predicates.length == 0) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (!predicate.test(t)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> or(final Predicate<T> first, final P second) {
        if (first != null && first == second) {
            return first;
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) || second.test(t);
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> or(Iterable<P> components) {
        final List<P> predicates = Predicates.safeCopyOf(components);
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static <T, P extends Predicate<? super T>> Predicate<T> or(P first, Iterable<P> components) {
        final List<P> predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T, P extends Predicate<? super T>> Predicate<T> or(P ... components) {
        final Predicate[] predicates = (Predicate[])Predicates.safeCopyOf(components);
        if (predicates.length == 0) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (predicate.test(t)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    static <T, P extends Predicate<? super T>> Predicate<T> or(Predicate<T> first, P ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (predicate.test(t)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> xor(final Predicate<T> first, final P second) {
        if (first != null && first == second) {
            return Predicates.alwaysFalse();
        }
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) ^ second.test(t);
            }
        };
    }

    public static <T, P extends Predicate<? super T>> Predicate<T> xor(Iterable<P> components) {
        final List<P> predicates = Predicates.safeCopyOf(components);
        if (predicates.isEmpty()) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Boolean initial = null;
                for (Predicate predicate : predicates) {
                    if (initial == null) {
                        initial = predicate.test(t);
                        continue;
                    }
                    if (initial ^ predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    public static <T, P extends Predicate<? super T>> Predicate<T> xor(P ... components) {
        final Predicate[] predicates = (Predicate[])Predicates.safeCopyOf(components);
        if (predicates.length == 0) {
            throw new IllegalArgumentException("no predicates");
        }
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Boolean initial = null;
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (initial == null) {
                        initial = predicate.test(t);
                    } else if (!(initial ^ predicate.test(t))) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    static <T, P extends Predicate<? super T>> Predicate<T> xor(Predicate<T> first, P ... components) {
        final Predicate[] predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Boolean initial = null;
                Predicate[] predicateArray = predicates;
                int n = predicates.length;
                int n2 = 0;
                while (n2 < n) {
                    Predicate predicate = predicateArray[n2];
                    if (initial == null) {
                        initial = predicate.test(t);
                    } else if (!(initial ^ predicate.test(t))) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    static <T, P extends Predicate<? super T>> Predicate<T> xor(Predicate<T> first, Iterable<P> components) {
        final List<Predicate<T>> predicates = Predicates.safeCopyOf(first, components);
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                Boolean initial = null;
                for (Predicate predicate : predicates) {
                    if (initial == null) {
                        initial = predicate.test(t);
                        continue;
                    }
                    if (initial ^ predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @SafeVarargs
    private static <T> T[] safeCopyOf(T ... array) {
        T[] copy;
        T[] TArray = copy = Arrays.copyOf(array, array.length);
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            T each = TArray[n2];
            Objects.requireNonNull(each);
            ++n2;
        }
        return copy;
    }

    @SafeVarargs
    private static <T> T[] safeCopyOf(T first, T ... array) {
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        copy[0] = Objects.requireNonNull(first);
        System.arraycopy(array, 0, copy, 1, array.length);
        Object[] objectArray = copy;
        int n = copy.length;
        int n2 = 0;
        while (n2 < n) {
            Object each = objectArray[n2];
            Objects.requireNonNull(each);
            ++n2;
        }
        return copy;
    }

    private static <T> List<T> safeCopyOf(T first, Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(Objects.requireNonNull(first));
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element));
        }
        return list;
    }

    private static <T> List<T> safeCopyOf(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element));
        }
        return list;
    }
}

