/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.util.ContractUtils;

public enum OS {
    WINDOWS_NT("Windows NT"),
    WINDOWS_95("Windows 95"),
    WINDOWS_98("Windows 98"),
    WINDOWS_2000("Windows 2000"),
    WINDOWS_VISTA("Windows Vista"),
    WINDOWS_7("Windows 7"),
    WINDOWS_OTHER("Windows"),
    SOLARIS("Solaris"),
    LINUX("Linux"),
    HP_UX("HP-UX"),
    IBM_AIX("AIX"),
    SGI_IRIX("Irix"),
    SUN_OS("SunOS"),
    COMPAQ_TRU64_UNIX("Digital UNIX"),
    MAC("Mac OS X", "Darwin"),
    FREE_BSD("freebsd"),
    OS2("OS/2"),
    COMPAQ_OPEN_VMS("OpenVMS"),
    OTHER("");

    private final String[] names;
    private static OS current;

    private OS(String ... names) {
        this.names = names;
    }

    public boolean isWindows() {
        return this.ordinal() <= WINDOWS_OTHER.ordinal();
    }

    public boolean isUnix() {
        return this.ordinal() > WINDOWS_OTHER.ordinal() && this.ordinal() < OS2.ordinal();
    }

    public static OS get(String osName) {
        osName = osName.toLowerCase();
        OS[] oSArray = OS.values();
        int n = oSArray.length;
        int n2 = 0;
        while (n2 < n) {
            OS os = oSArray[n2];
            String[] stringArray = os.names;
            int n3 = os.names.length;
            int n4 = 0;
            while (n4 < n3) {
                String name = stringArray[n4];
                if (osName.contains(name.toLowerCase())) {
                    return os;
                }
                ++n4;
            }
            ++n2;
        }
        throw ContractUtils.unreachable();
    }

    public static OS get() {
        if (current == null) {
            current = OS.get(System.getProperty("os.name"));
        }
        return current;
    }
}

