/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.TargetInvocationException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;

public final class ExceptionUtilities {
    public static RuntimeException asRuntimeException(Throwable t) {
        VerifyArgument.notNull(t, "t");
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new UndeclaredThrowableException(t, "An unhandled checked exception occurred.");
    }

    public static Throwable unwrap(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null || cause == t) {
            return t;
        }
        if (t instanceof InvocationTargetException || t instanceof TargetInvocationException || t instanceof UndeclaredThrowableException) {
            return ExceptionUtilities.unwrap(cause);
        }
        return t;
    }

    public static String getMessage(Throwable t) {
        String message = VerifyArgument.notNull(t, "t").getMessage();
        if (StringUtilities.isNullOrWhitespace(message)) {
            return String.valueOf(t.getClass().getSimpleName()) + " was thrown.";
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStackTraceString(Throwable t) {
        VerifyArgument.notNull(t, "t");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
                try {
                    String string;
                    block16: {
                        PrintWriter writer = new PrintWriter(stream);
                        try {
                            t.printStackTrace(writer);
                            writer.flush();
                            stream.flush();
                            string = StringUtilities.trimRight(stream.toString());
                            return string;
                        }
                        finally {
                            if (writer == null) break block16;
                            writer.close();
                        }
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Throwable ignored) {
            return t.toString();
        }
    }

    public static void rethrowCritical(Throwable t) {
        if (t instanceof ThreadDeath || t instanceof VirtualMachineError) {
            throw ExceptionUtilities.rethrow(t);
        }
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t) throws T {
        throw t;
    }

    public static <T extends Throwable, R> R rethrowAs(Throwable t) throws T {
        throw t;
    }
}

