/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.core;

import com.strobel.core.SafeCloseable;
import com.strobel.core.VerifyArgument;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class Closeables {
    private static final SafeCloseable EMPTY = new SafeCloseable(){

        @Override
        public void close() {
        }
    };

    public static SafeCloseable empty() {
        return EMPTY;
    }

    public static SafeCloseable create(Runnable delegate) {
        return new AnonymousCloseable(VerifyArgument.notNull(delegate, "delegate"));
    }

    public static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public static void close(AutoCloseable ... closeables) {
        AutoCloseable[] autoCloseableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            AutoCloseable closeable = autoCloseableArray[n2];
            Closeables.close(closeable);
            ++n2;
        }
    }

    public static void tryClose(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void tryClose(AutoCloseable ... closeables) {
        if (closeables != null) {
            AutoCloseable[] autoCloseableArray = closeables;
            int n = closeables.length;
            int n2 = 0;
            while (n2 < n) {
                AutoCloseable closeable = autoCloseableArray[n2];
                Closeables.tryClose(closeable);
                ++n2;
            }
        }
    }

    private static final class AnonymousCloseable
    implements SafeCloseable {
        private static final AtomicIntegerFieldUpdater<AnonymousCloseable> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AnonymousCloseable.class, "_closed");
        private final Runnable _delegate;
        private volatile int _closed;

        private AnonymousCloseable(Runnable delegate) {
            this._delegate = VerifyArgument.notNull(delegate, "delegate");
        }

        @Override
        public void close() {
            if (CLOSED_UPDATER.getAndSet(this, 1) == 0) {
                this._delegate.run();
            }
        }
    }
}

