/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.concurrent;

import com.strobel.annotations.NotNull;
import java.lang.reflect.Array;

public abstract class StripedLock<T> {
    private static final int LOCK_COUNT = 256;
    protected final T[] locks;
    private int _lockAllocationCounter;

    protected StripedLock(Class<T> lockType) {
        this.locks = (Object[])Array.newInstance(lockType, 256);
        int i = 0;
        while (i < this.locks.length) {
            this.locks[i] = this.createLock();
            ++i;
        }
    }

    @NotNull
    public T allocateLock() {
        return this.locks[this.allocateLockIndex()];
    }

    public int allocateLockIndex() {
        this._lockAllocationCounter = (this._lockAllocationCounter + 1) % 256;
        return this._lockAllocationCounter;
    }

    @NotNull
    protected abstract T createLock();

    public abstract void lock(int var1);

    public abstract void unlock(int var1);
}

