/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata.signatures;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.signatures.ArrayTypeSignature;
import com.strobel.assembler.metadata.signatures.BooleanSignature;
import com.strobel.assembler.metadata.signatures.BottomSignature;
import com.strobel.assembler.metadata.signatures.ByteSignature;
import com.strobel.assembler.metadata.signatures.CharSignature;
import com.strobel.assembler.metadata.signatures.ClassTypeSignature;
import com.strobel.assembler.metadata.signatures.DoubleSignature;
import com.strobel.assembler.metadata.signatures.FieldTypeSignature;
import com.strobel.assembler.metadata.signatures.FloatSignature;
import com.strobel.assembler.metadata.signatures.FormalTypeParameter;
import com.strobel.assembler.metadata.signatures.IntSignature;
import com.strobel.assembler.metadata.signatures.LongSignature;
import com.strobel.assembler.metadata.signatures.MetadataFactory;
import com.strobel.assembler.metadata.signatures.ShortSignature;
import com.strobel.assembler.metadata.signatures.SimpleClassTypeSignature;
import com.strobel.assembler.metadata.signatures.TypeArgument;
import com.strobel.assembler.metadata.signatures.TypeTreeVisitor;
import com.strobel.assembler.metadata.signatures.TypeVariableSignature;
import com.strobel.assembler.metadata.signatures.VoidSignature;
import com.strobel.assembler.metadata.signatures.Wildcard;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Reifier
implements TypeTreeVisitor<TypeReference> {
    private static final Logger LOG = Logger.getLogger(Reifier.class.getSimpleName());
    private final MetadataFactory factory;
    private TypeReference resultType;

    private Reifier(MetadataFactory f) {
        this.factory = f;
    }

    public static Reifier make(MetadataFactory f) {
        return new Reifier(f);
    }

    private MetadataFactory getFactory() {
        return this.factory;
    }

    private TypeReference[] reifyTypeArguments(TypeArgument[] tas) {
        Object[] ts = new TypeReference[tas.length];
        int i = 0;
        while (i < tas.length) {
            tas[i].accept(this);
            ts[i] = this.resultType;
            if (ts[i] == null) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("BAD TYPE ARGUMENTS: " + Arrays.toString(tas) + "; " + Arrays.toString(ts));
                }
                ts[i] = BuiltinTypes.Object;
            }
            ++i;
        }
        return ts;
    }

    @Override
    public TypeReference getResult() {
        assert (this.resultType != null);
        return this.resultType;
    }

    @Override
    public void visitFormalTypeParameter(FormalTypeParameter ftp) {
        FieldTypeSignature[] bounds = ftp.getBounds();
        this.resultType = this.getFactory().makeTypeVariable(ftp.getName(), bounds);
    }

    @Override
    public void visitClassTypeSignature(ClassTypeSignature ct) {
        boolean dollar;
        List<SimpleClassTypeSignature> scts = ct.getPath();
        assert (!scts.isEmpty());
        Iterator<SimpleClassTypeSignature> iter = scts.iterator();
        SimpleClassTypeSignature sc = iter.next();
        StringBuilder n = new StringBuilder(sc.getName());
        while (iter.hasNext() && sc.getTypeArguments().length == 0) {
            sc = iter.next();
            dollar = sc.useDollar();
            n.append(dollar ? "$" : ".").append(sc.getName());
        }
        assert (!iter.hasNext() || sc.getTypeArguments().length > 0);
        TypeReference c = this.getFactory().makeNamedType(n.toString());
        if (sc.getTypeArguments().length == 0) {
            assert (!iter.hasNext());
            this.resultType = c;
        } else {
            assert (sc.getTypeArguments().length > 0);
            TypeReference[] pts = this.reifyTypeArguments(sc.getTypeArguments());
            TypeReference owner = this.getFactory().makeParameterizedType(c, null, pts);
            while (iter.hasNext()) {
                sc = iter.next();
                dollar = sc.useDollar();
                n.append(dollar ? "$" : ".").append(sc.getName());
                c = this.getFactory().makeNamedType(n.toString());
                pts = this.reifyTypeArguments(sc.getTypeArguments());
                owner = this.getFactory().makeParameterizedType(c, owner, pts);
            }
            this.resultType = owner;
        }
    }

    @Override
    public void visitArrayTypeSignature(ArrayTypeSignature a) {
        a.getComponentType().accept(this);
        TypeReference ct = this.resultType;
        assert (ct != null);
        this.resultType = this.getFactory().makeArrayType(ct);
    }

    @Override
    public void visitTypeVariableSignature(TypeVariableSignature tv) {
        this.resultType = this.getFactory().findTypeVariable(tv.getName());
    }

    @Override
    public void visitWildcard(Wildcard w) {
        this.resultType = this.getFactory().makeWildcard(w.getSuperBound(), w.getExtendsBound());
    }

    @Override
    public void visitSimpleClassTypeSignature(SimpleClassTypeSignature sct) {
        this.resultType = this.getFactory().makeNamedType(sct.getName());
    }

    @Override
    public void visitBottomSignature(BottomSignature b) {
        this.resultType = null;
    }

    @Override
    public void visitByteSignature(ByteSignature b) {
        this.resultType = this.getFactory().makeByte();
    }

    @Override
    public void visitBooleanSignature(BooleanSignature b) {
        this.resultType = this.getFactory().makeBoolean();
    }

    @Override
    public void visitShortSignature(ShortSignature s) {
        this.resultType = this.getFactory().makeShort();
    }

    @Override
    public void visitCharSignature(CharSignature c) {
        this.resultType = this.getFactory().makeChar();
    }

    @Override
    public void visitIntSignature(IntSignature i) {
        this.resultType = this.getFactory().makeInt();
    }

    @Override
    public void visitLongSignature(LongSignature l) {
        this.resultType = this.getFactory().makeLong();
    }

    @Override
    public void visitFloatSignature(FloatSignature f) {
        this.resultType = this.getFactory().makeFloat();
    }

    @Override
    public void visitDoubleSignature(DoubleSignature d) {
        this.resultType = this.getFactory().makeDouble();
    }

    @Override
    public void visitVoidSignature(VoidSignature v) {
        this.resultType = this.getFactory().makeVoid();
    }
}

