/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.VerifyArgument;
import com.strobel.util.ContractUtils;
import java.util.NoSuchElementException;

public final class VariableDefinitionCollection
extends Collection<VariableDefinition> {
    private final MethodDefinition _declaringMethod;

    public VariableDefinitionCollection(MethodDefinition declaringMethod) {
        this._declaringMethod = VerifyArgument.notNull(declaringMethod, "declaringMethod");
    }

    public int slotCount() {
        int count = 0;
        int i = 0;
        while (i < this.size()) {
            VariableDefinition v = (VariableDefinition)this.get(i);
            count = Math.max(v.getSlot() + v.getSize(), count);
            ++i;
        }
        return count;
    }

    public VariableDefinition tryFind(int slot) {
        return this.find(slot, -1);
    }

    public VariableDefinition tryFind(int slot, int instructionOffset) {
        VariableDefinition result = null;
        int i = 0;
        while (i < this.size()) {
            VariableDefinition variable = (VariableDefinition)this.get(i);
            if (!(variable.getSlot() != slot || instructionOffset >= 0 && (variable.getScopeStart() < 0 || variable.getScopeStart() > instructionOffset || variable.getScopeEnd() >= 0 && variable.getScopeEnd() < instructionOffset) || result != null && variable.getScopeStart() <= result.getScopeStart())) {
                result = variable;
            }
            ++i;
        }
        return result;
    }

    public VariableDefinition find(int slot) {
        return this.find(slot, -1);
    }

    public VariableDefinition find(int slot, int instructionOffset) {
        VariableDefinition variable = this.tryFind(slot, instructionOffset);
        if (variable != null) {
            return variable;
        }
        throw new NoSuchElementException(String.format("Could not find variable at slot %d and offset %d.", slot, instructionOffset));
    }

    public VariableReference tryFind(int slot, OpCode op, int instructionOffset) {
        int effectiveOffset = op.isStore() ? instructionOffset + op.getSize() + op.getOperandType().getBaseSize() : instructionOffset;
        return this.tryFind(slot, effectiveOffset);
    }

    public VariableReference reference(int slot, OpCode op, int instructionOffset) {
        TypeDefinition variableType;
        VariableReference variable = this.tryFind(slot, op, instructionOffset);
        if (variable != null) {
            return variable;
        }
        switch (op) {
            case ILOAD: 
            case ILOAD_0: 
            case ILOAD_1: 
            case ILOAD_2: 
            case ILOAD_3: 
            case ISTORE: 
            case ISTORE_0: 
            case ISTORE_1: 
            case ISTORE_2: 
            case ISTORE_3: 
            case ILOAD_W: 
            case ISTORE_W: {
                variableType = BuiltinTypes.Integer;
                break;
            }
            case LLOAD: 
            case LLOAD_0: 
            case LLOAD_1: 
            case LLOAD_2: 
            case LLOAD_3: 
            case LSTORE: 
            case LSTORE_0: 
            case LSTORE_1: 
            case LSTORE_2: 
            case LSTORE_3: 
            case LLOAD_W: 
            case LSTORE_W: {
                variableType = BuiltinTypes.Long;
                break;
            }
            case FLOAD: 
            case FLOAD_0: 
            case FLOAD_1: 
            case FLOAD_2: 
            case FLOAD_3: 
            case FSTORE: 
            case FSTORE_0: 
            case FSTORE_1: 
            case FSTORE_2: 
            case FSTORE_3: 
            case FLOAD_W: 
            case FSTORE_W: {
                variableType = BuiltinTypes.Float;
                break;
            }
            case DLOAD: 
            case DLOAD_0: 
            case DLOAD_1: 
            case DLOAD_2: 
            case DLOAD_3: 
            case DSTORE: 
            case DSTORE_0: 
            case DSTORE_1: 
            case DSTORE_2: 
            case DSTORE_3: 
            case DLOAD_W: 
            case DSTORE_W: {
                variableType = BuiltinTypes.Double;
                break;
            }
            case IINC: 
            case IINC_W: {
                variableType = BuiltinTypes.Integer;
                break;
            }
            default: {
                variableType = BuiltinTypes.Object;
            }
        }
        return this.makeReference(slot, variableType);
    }

    public VariableReference makeReference(int slot, TypeReference variableType) {
        return new UnknownVariableReference(variableType, slot, this._declaringMethod.getDeclaringType());
    }

    private static final class UnknownVariableReference
    extends VariableReference {
        private final int _slot;
        private final TypeReference _declaringType;

        UnknownVariableReference(TypeReference variableType, int slot, TypeReference declaringType) {
            super(variableType);
            this._slot = slot;
            this._declaringType = VerifyArgument.notNull(declaringType, "declaringType");
        }

        @Override
        public final TypeReference getDeclaringType() {
            return this._declaringType;
        }

        @Override
        public final int getSlot() {
            return this._slot;
        }

        @Override
        public final VariableDefinition resolve() {
            throw ContractUtils.unsupported();
        }
    }
}

