/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.Collection;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeReference;

public final class ParameterDefinitionCollection
extends Collection<ParameterDefinition> {
    final IMethodSignature signature;
    private TypeReference _declaringType;

    ParameterDefinitionCollection(IMethodSignature signature) {
        this.signature = signature;
    }

    public final TypeReference getDeclaringType() {
        return this._declaringType;
    }

    final void setDeclaringType(TypeReference declaringType) {
        this._declaringType = declaringType;
        int i = 0;
        while (i < this.size()) {
            ((ParameterDefinition)this.get(i)).setDeclaringType(declaringType);
            ++i;
        }
    }

    @Override
    protected void afterAdd(int index, ParameterDefinition p, boolean appended) {
        p.setMethod(this.signature);
        p.setPosition(index);
        p.setDeclaringType(this._declaringType);
        if (!appended) {
            int i = index + 1;
            while (i < this.size()) {
                ((ParameterDefinition)this.get(i)).setPosition(i + 1);
                ++i;
            }
        }
        this.signature.invalidateSignature();
    }

    @Override
    protected void beforeSet(int index, ParameterDefinition p) {
        ParameterDefinition current = (ParameterDefinition)this.get(index);
        current.setMethod(null);
        current.setPosition(-1);
        current.setDeclaringType(null);
        p.setMethod(this.signature);
        p.setPosition(index);
        p.setDeclaringType(this._declaringType);
        this.signature.invalidateSignature();
    }

    @Override
    protected void afterRemove(int index, ParameterDefinition p) {
        p.setMethod(null);
        p.setPosition(-1);
        p.setDeclaringType(null);
        int i = index;
        while (i < this.size()) {
            ((ParameterDefinition)this.get(i)).setPosition(i);
            ++i;
        }
        this.signature.invalidateSignature();
    }

    @Override
    protected void beforeClear() {
        int i = 0;
        while (i < this.size()) {
            ((ParameterDefinition)this.get(i)).setMethod(null);
            ((ParameterDefinition)this.get(i)).setPosition(-1);
            ((ParameterDefinition)this.get(i)).setDeclaringType(null);
            ++i;
        }
        this.signature.invalidateSignature();
    }
}

