/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.ClassFileReader;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.compilerservices.RuntimeHelpers;
import com.strobel.core.Fences;
import com.strobel.core.VerifyArgument;
import java.util.concurrent.ConcurrentHashMap;

public class MetadataSystem
extends MetadataResolver {
    private static MetadataSystem _instance;
    private final ConcurrentHashMap<String, TypeDefinition> _types;
    private final ITypeLoader _typeLoader;
    private boolean _isEagerMethodLoadingEnabled;
    private static final TypeDefinition[] PRIMITIVE_TYPES_BY_NAME;
    private static final TypeDefinition[] PRIMITIVE_TYPES_BY_DESCRIPTOR;

    static {
        TypeDefinition[] allPrimitives;
        PRIMITIVE_TYPES_BY_NAME = new TypeDefinition[25];
        PRIMITIVE_TYPES_BY_DESCRIPTOR = new TypeDefinition[16];
        RuntimeHelpers.ensureClassInitialized(BuiltinTypes.class);
        TypeDefinition[] typeDefinitionArray = allPrimitives = new TypeDefinition[]{BuiltinTypes.Boolean, BuiltinTypes.Byte, BuiltinTypes.Character, BuiltinTypes.Short, BuiltinTypes.Integer, BuiltinTypes.Long, BuiltinTypes.Float, BuiltinTypes.Double, BuiltinTypes.Void};
        int n = allPrimitives.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDefinition t;
            MetadataSystem.PRIMITIVE_TYPES_BY_DESCRIPTOR[MetadataSystem.hashPrimitiveName((String)t.getName())] = t = typeDefinitionArray[n2];
            MetadataSystem.PRIMITIVE_TYPES_BY_NAME[t.getInternalName().charAt((int)0) - 66] = t;
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetadataSystem instance() {
        if (_instance != null) return _instance;
        Class<MetadataSystem> clazz = MetadataSystem.class;
        synchronized (MetadataSystem.class) {
            if (_instance != null) return _instance;
            _instance = Fences.orderWrites(new MetadataSystem());
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public MetadataSystem() {
        this(new ClasspathTypeLoader());
    }

    public MetadataSystem(ITypeLoader typeLoader) {
        this._typeLoader = VerifyArgument.notNull(typeLoader, "typeLoader");
        this._types = new ConcurrentHashMap();
    }

    public final boolean isEagerMethodLoadingEnabled() {
        return this._isEagerMethodLoadingEnabled;
    }

    public final void setEagerMethodLoadingEnabled(boolean value) {
        this._isEagerMethodLoadingEnabled = value;
    }

    public void addTypeDefinition(TypeDefinition type) {
        VerifyArgument.notNull(type, "type");
        this._types.putIfAbsent(type.getInternalName(), type);
    }

    @Override
    protected TypeDefinition resolveCore(TypeReference type) {
        VerifyArgument.notNull(type, "type");
        return this.resolveType(type.getInternalName(), false);
    }

    @Override
    protected TypeReference lookupTypeCore(String descriptor) {
        return this.resolveType(descriptor, true);
    }

    protected TypeDefinition resolveType(String descriptor, boolean mightBePrimitive) {
        TypeDefinition primitiveType;
        int primitiveHash;
        VerifyArgument.notNull(descriptor, "descriptor");
        if (mightBePrimitive && (descriptor.length() == 1 ? (primitiveHash = descriptor.charAt(0) - 66) >= 0 && primitiveHash < PRIMITIVE_TYPES_BY_DESCRIPTOR.length && (primitiveType = PRIMITIVE_TYPES_BY_DESCRIPTOR[primitiveHash]) != null : (primitiveHash = MetadataSystem.hashPrimitiveName(descriptor)) >= 0 && primitiveHash < PRIMITIVE_TYPES_BY_NAME.length && (primitiveType = PRIMITIVE_TYPES_BY_NAME[primitiveHash]) != null && descriptor.equals(primitiveType.getName()))) {
            return primitiveType;
        }
        TypeDefinition cachedDefinition = this._types.get(descriptor);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        Buffer buffer = new Buffer(0);
        if (!this._typeLoader.tryLoadType(descriptor, buffer)) {
            return null;
        }
        TypeDefinition typeDefinition = ClassFileReader.readClass(this._isEagerMethodLoadingEnabled ? 3 : 1, this, buffer);
        cachedDefinition = this._types.putIfAbsent(descriptor, typeDefinition);
        typeDefinition.setTypeLoader(this._typeLoader);
        if (cachedDefinition != null) {
            return cachedDefinition;
        }
        return typeDefinition;
    }

    private static int hashPrimitiveName(String name) {
        if (name.length() < 3) {
            return 0;
        }
        return (name.charAt(0) + name.charAt(2)) % 16;
    }
}

