/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.IAnnotationsProvider;
import com.strobel.assembler.metadata.IMetadataTypeMember;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.annotations.CustomAnnotation;
import java.util.Collections;
import java.util.List;

public abstract class MemberReference
implements IAnnotationsProvider,
IMetadataTypeMember {
    protected MemberReference() {
    }

    public boolean isSpecialName() {
        return false;
    }

    public boolean isDefinition() {
        return false;
    }

    public boolean containsGenericParameters() {
        TypeReference declaringType = this.getDeclaringType();
        return declaringType != null && declaringType.containsGenericParameters();
    }

    @Override
    public abstract TypeReference getDeclaringType();

    public boolean isEquivalentTo(MemberReference member) {
        return member == this;
    }

    @Override
    public boolean hasAnnotations() {
        return !this.getAnnotations().isEmpty();
    }

    @Override
    public List<CustomAnnotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public abstract String getName();

    public String getFullName() {
        StringBuilder name = new StringBuilder();
        this.appendName(name, true, false);
        return name.toString();
    }

    public String getSignature() {
        return this.appendSignature(new StringBuilder()).toString();
    }

    public String getErasedSignature() {
        return this.appendErasedSignature(new StringBuilder()).toString();
    }

    protected abstract StringBuilder appendName(StringBuilder var1, boolean var2, boolean var3);

    protected abstract StringBuilder appendSignature(StringBuilder var1);

    protected abstract StringBuilder appendErasedSignature(StringBuilder var1);

    public String toString() {
        return String.valueOf(this.getFullName()) + ":" + this.getSignature();
    }
}

