/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.Collection;
import com.strobel.assembler.flowanalysis.ControlFlowEdge;
import com.strobel.assembler.flowanalysis.ControlFlowGraph;
import com.strobel.assembler.flowanalysis.ControlFlowNode;
import com.strobel.assembler.flowanalysis.ControlFlowNodeType;
import com.strobel.assembler.flowanalysis.JumpType;
import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.FlowControl;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionBlock;
import com.strobel.assembler.ir.InstructionCollection;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OperandType;
import com.strobel.assembler.ir.attributes.ExceptionTableEntry;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicate;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.InstructionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ExceptionHandlerMapper {
    private final InstructionCollection _instructions;
    private final List<ExceptionTableEntry> _tableEntries;
    private final List<ExceptionHandler> _handlerPlaceholders;
    private final List<ControlFlowNode> _nodes = new Collection<ControlFlowNode>();
    private final int[] _offsets;
    private final boolean[] _hasIncomingJumps;
    private final ControlFlowNode _entryPoint;
    private final ControlFlowNode _regularExit;
    private final ControlFlowNode _exceptionalExit;
    private int _nextBlockId;
    boolean copyFinallyBlocks = false;

    public static List<ExceptionHandler> run(InstructionCollection instructions, List<ExceptionTableEntry> tableEntries) {
        Comparable<Instruction> handlerStart;
        VerifyArgument.notNull(instructions, "instructions");
        VerifyArgument.notNull(tableEntries, "tableEntries");
        ExceptionHandlerMapper builder = new ExceptionHandlerMapper(instructions, tableEntries);
        ControlFlowGraph cfg = builder.build();
        ArrayList<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();
        IdentityHashMap<ExceptionTableEntry, ControlFlowNode> handlerStartNodes = new IdentityHashMap<ExceptionTableEntry, ControlFlowNode>();
        for (ExceptionTableEntry entry : builder._tableEntries) {
            handlerStart = instructions.atOffset(entry.getHandlerOffset());
            ControlFlowNode handlerStartNode = builder.findNode((Instruction)handlerStart);
            if (handlerStartNode == null) {
                throw new IllegalStateException(String.format("Could not find entry node for handler at offset %d.", ((Instruction)handlerStart).getOffset()));
            }
            if (handlerStartNode.getIncoming().isEmpty()) {
                builder.createEdge(cfg.getEntryPoint(), handlerStartNode, JumpType.Normal);
            }
            handlerStartNodes.put(entry, handlerStartNode);
        }
        cfg.computeDominance();
        cfg.computeDominanceFrontier();
        for (ExceptionTableEntry entry : builder._tableEntries) {
            handlerStart = (ControlFlowNode)handlerStartNodes.get(entry);
            ArrayList<ControlFlowNode> dominatedNodes = new ArrayList<ControlFlowNode>();
            for (ControlFlowNode node : ExceptionHandlerMapper.findDominatedNodes(cfg, handlerStart)) {
                if (node.getNodeType() != ControlFlowNodeType.Normal) continue;
                dominatedNodes.add(node);
            }
            Collections.sort(dominatedNodes, new Comparator<ControlFlowNode>(){

                @Override
                public int compare(@NotNull ControlFlowNode o1, @NotNull ControlFlowNode o2) {
                    return Integer.compare(o1.getBlockIndex(), o2.getBlockIndex());
                }
            });
            int i = 1;
            while (i < dominatedNodes.size()) {
                int j;
                ControlFlowNode prev = (ControlFlowNode)dominatedNodes.get(i - 1);
                ControlFlowNode node = (ControlFlowNode)dominatedNodes.get(i);
                if (node.getBlockIndex() != prev.getBlockIndex() + 1 && (j = i) < dominatedNodes.size()) {
                    dominatedNodes.remove(i);
                }
                ++i;
            }
            Instruction lastInstruction = (Instruction)instructions.get(instructions.size() - 1);
            InstructionBlock tryBlock = entry.getEndOffset() == lastInstruction.getEndOffset() ? new InstructionBlock(instructions.atOffset(entry.getStartOffset()), lastInstruction) : new InstructionBlock(instructions.atOffset(entry.getStartOffset()), instructions.atOffset(entry.getEndOffset()).getPrevious());
            if (entry.getCatchType() == null) {
                handlers.add(ExceptionHandler.createFinally(tryBlock, new InstructionBlock(((ControlFlowNode)handlerStart).getStart(), ((ControlFlowNode)CollectionUtilities.lastOrDefault(dominatedNodes)).getEnd())));
                continue;
            }
            handlers.add(ExceptionHandler.createCatch(tryBlock, new InstructionBlock(((ControlFlowNode)handlerStart).getStart(), ((ControlFlowNode)CollectionUtilities.lastOrDefault(dominatedNodes)).getEnd()), entry.getCatchType()));
        }
        return handlers;
    }

    private ControlFlowNode findNode(final Instruction instruction) {
        if (instruction == null) {
            return null;
        }
        return CollectionUtilities.firstOrDefault(this._nodes, new Predicate<ControlFlowNode>(){

            @Override
            public boolean test(ControlFlowNode node) {
                return node.getNodeType() == ControlFlowNodeType.Normal && instruction.getOffset() >= node.getStart().getOffset() && instruction.getOffset() < node.getEnd().getEndOffset();
            }
        });
    }

    private static Set<ControlFlowNode> findDominatedNodes(ControlFlowGraph cfg, ControlFlowNode head) {
        LinkedHashSet<ControlFlowNode> agenda = new LinkedHashSet<ControlFlowNode>();
        LinkedHashSet<ControlFlowNode> result = new LinkedHashSet<ControlFlowNode>();
        agenda.add(head);
        while (!agenda.isEmpty()) {
            ControlFlowNode addNode = (ControlFlowNode)agenda.iterator().next();
            agenda.remove(addNode);
            if (!head.dominates(addNode) && !ExceptionHandlerMapper.shouldIncludeExceptionalExit(cfg, head, addNode) || !result.add(addNode)) continue;
            for (ControlFlowNode successor : addNode.getSuccessors()) {
                agenda.add(successor);
            }
        }
        return result;
    }

    private static boolean shouldIncludeExceptionalExit(ControlFlowGraph cfg, ControlFlowNode head, ControlFlowNode node) {
        ControlFlowNode innermostHandlerNode;
        if (node.getNodeType() != ControlFlowNodeType.Normal) {
            return false;
        }
        if (!(node.getDominanceFrontier().contains(cfg.getExceptionalExit()) || node.dominates(cfg.getExceptionalExit()) || (innermostHandlerNode = ExceptionHandlerMapper.findInnermostExceptionHandlerNode(cfg, node.getStart().getOffset())) != null && node.getDominanceFrontier().contains(innermostHandlerNode))) {
            return false;
        }
        if (node.getStart().getNext() != node.getEnd()) {
            return false;
        }
        if (head.getStart().getOpCode().isStore() && node.getStart().getOpCode().isLoad() && node.getEnd().getOpCode() == OpCode.ATHROW) {
            return InstructionHelper.getLoadOrStoreSlot(head.getStart()) == InstructionHelper.getLoadOrStoreSlot(node.getStart());
        }
        return false;
    }

    private ExceptionHandlerMapper(InstructionCollection instructions, List<ExceptionTableEntry> tableEntries) {
        this._instructions = VerifyArgument.notNull(instructions, "instructions");
        this._tableEntries = VerifyArgument.notNull(tableEntries, "tableEntries");
        this._handlerPlaceholders = this.createHandlerPlaceholders();
        this._offsets = new int[instructions.size()];
        this._hasIncomingJumps = new boolean[instructions.size()];
        int i = 0;
        while (i < instructions.size()) {
            this._offsets[i] = ((Instruction)instructions.get(i)).getOffset();
            ++i;
        }
        this._entryPoint = new ControlFlowNode(this._nextBlockId++, 0, ControlFlowNodeType.EntryPoint);
        this._regularExit = new ControlFlowNode(this._nextBlockId++, -1, ControlFlowNodeType.RegularExit);
        this._exceptionalExit = new ControlFlowNode(this._nextBlockId++, -2, ControlFlowNodeType.ExceptionalExit);
        this._nodes.add(this._entryPoint);
        this._nodes.add(this._regularExit);
        this._nodes.add(this._exceptionalExit);
    }

    private ControlFlowGraph build() {
        this.calculateIncomingJumps();
        this.createNodes();
        this.createRegularControlFlow();
        this.createExceptionalControlFlow();
        return new ControlFlowGraph(this._nodes.toArray(new ControlFlowNode[this._nodes.size()]));
    }

    private boolean isHandlerStart(Instruction instruction) {
        for (ExceptionTableEntry entry : this._tableEntries) {
            if (entry.getHandlerOffset() != instruction.getOffset()) continue;
            return true;
        }
        return false;
    }

    private void calculateIncomingJumps() {
        for (Instruction instruction : this._instructions) {
            OpCode opCode = instruction.getOpCode();
            if (opCode.getOperandType() == OperandType.BranchTarget || opCode.getOperandType() == OperandType.BranchTargetWide) {
                this._hasIncomingJumps[this.getInstructionIndex((Instruction)((Instruction)instruction.getOperand((int)0)))] = true;
                continue;
            }
            if (opCode.getOperandType() != OperandType.Switch) continue;
            SwitchInfo switchInfo = (SwitchInfo)instruction.getOperand(0);
            this._hasIncomingJumps[this.getInstructionIndex((Instruction)switchInfo.getDefaultTarget())] = true;
            Instruction[] instructionArray = switchInfo.getTargets();
            int n = instructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instruction target = instructionArray[n2];
                this._hasIncomingJumps[this.getInstructionIndex((Instruction)target)] = true;
                ++n2;
            }
        }
        for (ExceptionTableEntry entry : this._tableEntries) {
            this._hasIncomingJumps[this.getInstructionIndex((Instruction)this._instructions.atOffset((int)entry.getHandlerOffset()))] = true;
        }
    }

    private void createNodes() {
        InstructionCollection instructions = this._instructions;
        int i = 0;
        int n = instructions.size();
        while (i < n) {
            Instruction blockStart = (Instruction)instructions.get(i);
            ExceptionHandler blockStartExceptionHandler = this.findInnermostExceptionHandler(blockStart.getOffset());
            while (i + 1 < n) {
                ExceptionHandler innermostExceptionHandler;
                Instruction next;
                Instruction instruction = (Instruction)instructions.get(i);
                OpCode opCode = instruction.getOpCode();
                if (opCode.isBranch() && !opCode.isJumpToSubroutine() || this._hasIncomingJumps[i + 1] || (next = instruction.getNext()) != null && (innermostExceptionHandler = this.findInnermostExceptionHandler(next.getOffset())) != blockStartExceptionHandler) break;
                ++i;
            }
            ControlFlowNode node = new ControlFlowNode(this._nodes.size(), blockStart, (Instruction)instructions.get(i));
            node.setUserData(blockStartExceptionHandler);
            this._nodes.add(node);
            ++i;
        }
        for (ExceptionHandler handler : this._handlerPlaceholders) {
            int index = this._nodes.size();
            this._nodes.add(new ControlFlowNode(index, handler, null));
        }
    }

    private void createRegularControlFlow() {
        InstructionCollection instructions = this._instructions;
        this.createEdge(this._entryPoint, (Instruction)instructions.get(0), JumpType.Normal);
        for (ControlFlowNode node : this._nodes) {
            Instruction next;
            Instruction end = node.getEnd();
            if (end == null || end.getOffset() >= ((Instruction)this._instructions.get(this._instructions.size() - 1)).getEndOffset()) continue;
            OpCode endOpCode = end.getOpCode();
            if (!(endOpCode.isUnconditionalBranch() && !endOpCode.isJumpToSubroutine() || (next = end.getNext()) == null || this.isHandlerStart(next))) {
                this.createEdge(node, next, JumpType.Normal);
            }
            Instruction instruction = node.getStart();
            while (instruction != null && instruction.getOffset() <= end.getOffset()) {
                OpCode opCode = instruction.getOpCode();
                if (opCode.getOperandType() == OperandType.BranchTarget || opCode.getOperandType() == OperandType.BranchTargetWide) {
                    this.createEdge(node, (Instruction)instruction.getOperand(0), JumpType.Normal);
                } else if (opCode.getOperandType() == OperandType.Switch) {
                    SwitchInfo switchInfo = (SwitchInfo)instruction.getOperand(0);
                    this.createEdge(node, switchInfo.getDefaultTarget(), JumpType.Normal);
                    Instruction[] instructionArray = switchInfo.getTargets();
                    int n = instructionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Instruction target = instructionArray[n2];
                        this.createEdge(node, target, JumpType.Normal);
                        ++n2;
                    }
                }
                instruction = instruction.getNext();
            }
            if (endOpCode.getFlowControl() != FlowControl.Return) continue;
            this.createEdge(node, this._regularExit, JumpType.Normal);
        }
    }

    private void createExceptionalControlFlow() {
        for (ControlFlowNode node : this._nodes) {
            ExceptionHandler exceptionHandler;
            ControlFlowNode handlerNode;
            if (node.getNodeType() == ControlFlowNodeType.Normal) {
                Instruction end = node.getEnd();
                ExceptionHandler innermostHandler = this.findInnermostExceptionHandler(node.getEnd().getOffset());
                if (innermostHandler != null) {
                    for (final ExceptionHandler other : this._handlerPlaceholders) {
                        if (!other.getTryBlock().equals(innermostHandler.getTryBlock()) || node == (handlerNode = CollectionUtilities.firstOrDefault(this._nodes, new Predicate<ControlFlowNode>(){

                            @Override
                            public boolean test(ControlFlowNode node) {
                                return node.getExceptionHandler() == other;
                            }
                        }))) continue;
                        this.createEdge(node, handlerNode, JumpType.JumpToExceptionHandler);
                    }
                } else if (end.getOpCode() == OpCode.ATHROW) {
                    this.createEdge(node, this._exceptionalExit, JumpType.JumpToExceptionHandler);
                }
            }
            if ((exceptionHandler = node.getExceptionHandler()) == null) continue;
            ControlFlowNode parentHandler = this.findParentExceptionHandlerNode(node);
            if (parentHandler.getNodeType() != ControlFlowNodeType.ExceptionalExit) {
                for (final ExceptionHandler other : this._handlerPlaceholders) {
                    if (!Comparer.equals(other.getTryBlock(), parentHandler.getExceptionHandler().getTryBlock()) || (handlerNode = CollectionUtilities.firstOrDefault(this._nodes, new Predicate<ControlFlowNode>(){

                        @Override
                        public boolean test(ControlFlowNode node) {
                            return node.getExceptionHandler() == other;
                        }
                    })) == node) continue;
                    this.createEdge(node, handlerNode, JumpType.JumpToExceptionHandler);
                }
            }
            this.createEdge(node, exceptionHandler.getHandlerBlock().getFirstInstruction(), JumpType.Normal);
        }
    }

    private static ControlFlowNode findInnermostExceptionHandlerNode(ControlFlowGraph cfg, int offsetInTryBlock) {
        ExceptionHandler result = null;
        ControlFlowNode resultNode = null;
        List<ControlFlowNode> nodes = cfg.getNodes();
        int i = nodes.size() - 1;
        while (i >= 0) {
            ControlFlowNode node = nodes.get(i);
            ExceptionHandler handler = node.getExceptionHandler();
            if (handler == null) break;
            InstructionBlock tryBlock = handler.getTryBlock();
            if (tryBlock.getFirstInstruction().getOffset() <= offsetInTryBlock && offsetInTryBlock < tryBlock.getLastInstruction().getEndOffset() && ExceptionHandlerMapper.isNarrower(handler, result)) {
                result = handler;
                resultNode = node;
            }
            --i;
        }
        return resultNode;
    }

    private static boolean isNarrower(ExceptionHandler handler, ExceptionHandler anchor) {
        if (handler == null || anchor == null) {
            return false;
        }
        Instruction tryStart = handler.getTryBlock().getFirstInstruction();
        Instruction anchorTryStart = anchor.getTryBlock().getFirstInstruction();
        if (tryStart.getOffset() > anchorTryStart.getOffset()) {
            return true;
        }
        Instruction tryEnd = handler.getTryBlock().getLastInstruction();
        Instruction anchorTryEnd = anchor.getTryBlock().getLastInstruction();
        return tryStart.getOffset() == anchorTryStart.getOffset() && tryEnd.getOffset() < anchorTryEnd.getOffset();
    }

    private ExceptionHandler findInnermostExceptionHandler(int offsetInTryBlock) {
        ExceptionHandler result = null;
        for (ExceptionHandler handler : this._handlerPlaceholders) {
            InstructionBlock tryBlock = handler.getTryBlock();
            if (tryBlock.getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= tryBlock.getLastInstruction().getEndOffset() || result != null && !ExceptionHandlerMapper.isNarrower(handler, result)) continue;
            result = handler;
        }
        return result;
    }

    private ControlFlowNode findParentExceptionHandlerNode(ControlFlowNode node) {
        assert (node.getNodeType() == ControlFlowNodeType.CatchHandler || node.getNodeType() == ControlFlowNodeType.FinallyHandler);
        ControlFlowNode result = null;
        ExceptionHandler resultHandler = null;
        int offset = node.getExceptionHandler().getHandlerBlock().getFirstInstruction().getOffset();
        int i = 0;
        int n = this._nodes.size();
        while (i < n) {
            ControlFlowNode currentNode = this._nodes.get(i);
            ExceptionHandler handler = currentNode.getExceptionHandler();
            if (handler != null && handler.getTryBlock().getFirstInstruction().getOffset() <= offset && offset < handler.getTryBlock().getLastInstruction().getEndOffset() && (resultHandler == null || ExceptionHandlerMapper.isNarrower(handler, resultHandler))) {
                result = currentNode;
                resultHandler = handler;
            }
            ++i;
        }
        return result != null ? result : this._exceptionalExit;
    }

    private int getInstructionIndex(Instruction instruction) {
        int index = Arrays.binarySearch(this._offsets, instruction.getOffset());
        assert (index >= 0);
        return index;
    }

    private ControlFlowEdge createEdge(ControlFlowNode fromNode, Instruction toInstruction, JumpType type) {
        ControlFlowNode target = null;
        for (ControlFlowNode node : this._nodes) {
            if (node.getStart() == null || node.getStart().getOffset() != toInstruction.getOffset()) continue;
            if (target != null) {
                throw new IllegalStateException("Multiple edge targets detected!");
            }
            target = node;
        }
        if (target != null) {
            return this.createEdge(fromNode, target, type);
        }
        throw new IllegalStateException("Could not find target node!");
    }

    private ControlFlowEdge createEdge(ControlFlowNode fromNode, ControlFlowNode toNode, JumpType type) {
        ControlFlowEdge edge = new ControlFlowEdge(fromNode, toNode, type);
        fromNode.getOutgoing().add(edge);
        toNode.getIncoming().add(edge);
        return edge;
    }

    private List<ExceptionHandler> createHandlerPlaceholders() {
        ArrayList<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>();
        for (ExceptionTableEntry entry : this._tableEntries) {
            Instruction afterTry = this._instructions.tryGetAtOffset(entry.getEndOffset());
            ExceptionHandler handler = entry.getCatchType() == null ? ExceptionHandler.createFinally(new InstructionBlock(this._instructions.atOffset(entry.getStartOffset()), afterTry != null ? afterTry.getPrevious() : CollectionUtilities.last(this._instructions)), new InstructionBlock(this._instructions.atOffset(entry.getHandlerOffset()), this._instructions.atOffset(entry.getHandlerOffset()))) : ExceptionHandler.createCatch(new InstructionBlock(this._instructions.atOffset(entry.getStartOffset()), afterTry != null ? afterTry.getPrevious() : CollectionUtilities.last(this._instructions)), new InstructionBlock(this._instructions.atOffset(entry.getHandlerOffset()), this._instructions.atOffset(entry.getHandlerOffset())), entry.getCatchType());
            handlers.add(handler);
        }
        return handlers;
    }
}

