/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;

public class DeobfuscationUtilities {
    public static void processType(@NotNull TypeDefinition type) {
        VerifyArgument.notNull(type, "type");
        if (Flags.testAny(type.getFlags(), 0x800000000000L)) {
            return;
        }
        type.setFlags(type.getFlags() | 0x800000000000L);
        DeobfuscationUtilities.flagAnonymousEnumDefinitions(type);
    }

    private static void flagAnonymousEnumDefinitions(TypeDefinition type) {
        TypeDefinition resolvedBaseType;
        if (!type.isEnum() || type.getDeclaringType() != null) {
            return;
        }
        TypeReference baseType = type.getBaseType();
        if (!"java/lang/Enum".equals(baseType.getInternalName()) && (resolvedBaseType = baseType.resolve()) != null) {
            DeobfuscationUtilities.processType(resolvedBaseType);
        }
        if (type.getDeclaringType() != null && type.isAnonymous()) {
            return;
        }
        for (MethodDefinition method : type.getDeclaredMethods()) {
            MethodBody body;
            if (!method.isTypeInitializer() || (body = method.getBody()) == null) continue;
            for (Instruction p : body.getInstructions()) {
                TypeDefinition instantiatedTypeResolved;
                if (p.getOpCode() != OpCode.NEW) continue;
                TypeReference instantiatedType = (TypeReference)p.getOperand(0);
                TypeDefinition typeDefinition = instantiatedTypeResolved = instantiatedType != null ? instantiatedType.resolve() : null;
                if (instantiatedTypeResolved == null || !instantiatedTypeResolved.isEnum() || !type.isEquivalentTo(instantiatedTypeResolved.getBaseType())) continue;
                instantiatedTypeResolved.setDeclaringType(type);
                type.getDeclaredTypesInternal().add(instantiatedTypeResolved);
                instantiatedTypeResolved.setFlags(instantiatedTypeResolved.getFlags() | 0x100000000000L);
            }
        }
    }
}

