/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClasspathTypeLoader
implements ITypeLoader {
    private static final Logger LOG = Logger.getLogger(ClasspathTypeLoader.class.getSimpleName());
    private final ClassLoader _loader = ClassLoader.getSystemClassLoader();

    @Override
    public boolean tryLoadType(String internalName, Buffer buffer) {
        block17: {
            String path;
            URL resource;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Attempting to load type: " + internalName + "...");
            }
            if ((resource = this._loader.getResource(path = internalName.concat(".class"))) == null) {
                return false;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            InputStream stream = this._loader.getResourceAsStream(path);
            try {
                int bytesRead;
                byte[] temp = new byte[4096];
                while ((bytesRead = stream.read(temp, 0, temp.length)) > 0) {
                    buffer.ensureWriteableBytes(bytesRead);
                    buffer.putByteArray(temp, 0, bytesRead);
                }
                buffer.flip();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Type loaded from " + resource + ".");
                }
                if (stream == null) break block17;
            }
            catch (Throwable throwable2) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        return false;
                    }
                }
            }
            stream.close();
        }
        return true;
    }
}

