/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir.attributes;

import com.strobel.assembler.ir.attributes.LineNumberTableEntry;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.VerifyArgument;
import java.util.List;

public final class LineNumberTableAttribute
extends SourceAttribute {
    private final List<LineNumberTableEntry> _entries;
    private final int _maxOffset;

    public LineNumberTableAttribute(LineNumberTableEntry[] entries) {
        super("LineNumberTable", 2 + VerifyArgument.notNull(entries, "entries").length * 4);
        this._entries = ArrayUtilities.asUnmodifiableList((LineNumberTableEntry[])entries.clone());
        int max = Integer.MIN_VALUE;
        LineNumberTableEntry[] lineNumberTableEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            LineNumberTableEntry entry = lineNumberTableEntryArray[n2];
            int offset = entry.getOffset();
            if (offset > max) {
                max = offset;
            }
            ++n2;
        }
        this._maxOffset = max;
    }

    public List<LineNumberTableEntry> getEntries() {
        return this._entries;
    }

    public int getMaxOffset() {
        return this._maxOffset;
    }
}

