/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.Collection;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.OpCode;
import com.strobel.core.CollectionUtilities;
import java.util.Collections;
import java.util.Comparator;

public final class InstructionCollection
extends Collection<Instruction> {
    public Instruction atOffset(int offset) {
        Instruction result = this.tryGetAtOffset(offset);
        if (result != null) {
            return result;
        }
        throw new IndexOutOfBoundsException("No instruction found at offset " + offset + '.');
    }

    public Instruction tryGetAtOffset(int offset) {
        int index = Collections.binarySearch(this, new Instruction(offset, OpCode.NOP), new Comparator<Instruction>(){

            @Override
            public int compare(@NotNull Instruction o1, @NotNull Instruction o2) {
                return Integer.compare(o1.getOffset(), o2.getOffset());
            }
        });
        if (index < 0) {
            Instruction last = CollectionUtilities.lastOrDefault(this);
            if (last != null && last.getNext() != null && last.getNext().getOffset() == offset) {
                return last.getNext();
            }
            return null;
        }
        return (Instruction)this.get(index);
    }

    @Override
    protected void afterAdd(int index, Instruction item, boolean appended) {
        Instruction previous;
        Instruction next = index < this.size() - 1 ? (Instruction)this.get(index + 1) : null;
        Instruction instruction = previous = index > 0 ? (Instruction)this.get(index - 1) : null;
        if (previous != null) {
            previous.setNext(item);
        }
        if (next != null) {
            next.setPrevious(item);
        }
        item.setPrevious(previous);
        item.setNext(next);
    }

    @Override
    protected void beforeSet(int index, Instruction item) {
        Instruction current = (Instruction)this.get(index);
        item.setPrevious(current.getPrevious());
        item.setNext(current.getNext());
        current.setPrevious(null);
        current.setNext(null);
    }

    @Override
    protected void afterRemove(int index, Instruction item) {
        Instruction current = item.getNext();
        Instruction previous = item.getPrevious();
        if (previous != null) {
            previous.setNext(current);
        }
        if (current != null) {
            current.setPrevious(previous);
        }
        item.setPrevious(null);
        item.setNext(null);
    }

    @Override
    protected void beforeClear() {
        int i = 0;
        while (i < this.size()) {
            ((Instruction)this.get(i)).setNext(null);
            ((Instruction)this.get(i)).setPrevious(null);
            ++i;
        }
    }

    public void recomputeOffsets() {
        if (this.isEmpty()) {
            return;
        }
        Instruction previous = (Instruction)this.get(0);
        previous.setOffset(0);
        int i = 1;
        while (i < this.size()) {
            Instruction current = (Instruction)this.get(i);
            current.setOffset(previous.getOffset() + previous.getSize());
            previous = current;
            ++i;
        }
    }
}

