/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.flowanalysis;

import com.strobel.assembler.Collection;
import com.strobel.assembler.flowanalysis.ControlFlowEdge;
import com.strobel.assembler.flowanalysis.ControlFlowGraph;
import com.strobel.assembler.flowanalysis.ControlFlowNode;
import com.strobel.assembler.flowanalysis.ControlFlowNodeType;
import com.strobel.assembler.flowanalysis.JumpType;
import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.ExceptionHandlerType;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionBlock;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OperandType;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicate;
import com.strobel.core.VerifyArgument;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class ControlFlowGraphBuilder {
    private final List<Instruction> _instructions;
    private final List<ExceptionHandler> _exceptionHandlers;
    private final List<ControlFlowNode> _nodes = new Collection<ControlFlowNode>();
    private final int[] _offsets;
    private final boolean[] _hasIncomingJumps;
    private final ControlFlowNode _entryPoint;
    private final ControlFlowNode _regularExit;
    private final ControlFlowNode _exceptionalExit;
    private int _nextBlockId;
    boolean copyFinallyBlocks = false;

    public static ControlFlowGraph build(MethodBody methodBody) {
        VerifyArgument.notNull(methodBody, "methodBody");
        ControlFlowGraphBuilder builder = new ControlFlowGraphBuilder(methodBody.getInstructions(), methodBody.getExceptionHandlers());
        return builder.build();
    }

    public static ControlFlowGraph build(List<Instruction> instructions, List<ExceptionHandler> exceptionHandlers) {
        ControlFlowGraphBuilder builder = new ControlFlowGraphBuilder(VerifyArgument.notNull(instructions, "instructions"), VerifyArgument.notNull(exceptionHandlers, "exceptionHandlers"));
        return builder.build();
    }

    private ControlFlowGraphBuilder(List<Instruction> instructions, List<ExceptionHandler> exceptionHandlers) {
        this._instructions = VerifyArgument.notNull(instructions, "instructions");
        this._exceptionHandlers = ControlFlowGraphBuilder.coalesceExceptionHandlers(VerifyArgument.notNull(exceptionHandlers, "exceptionHandlers"));
        this._offsets = new int[instructions.size()];
        this._hasIncomingJumps = new boolean[this._offsets.length];
        int i = 0;
        while (i < instructions.size()) {
            this._offsets[i] = instructions.get(i).getOffset();
            ++i;
        }
        this._entryPoint = new ControlFlowNode(this._nextBlockId++, 0, ControlFlowNodeType.EntryPoint);
        this._regularExit = new ControlFlowNode(this._nextBlockId++, -1, ControlFlowNodeType.RegularExit);
        this._exceptionalExit = new ControlFlowNode(this._nextBlockId++, -1, ControlFlowNodeType.ExceptionalExit);
        this._nodes.add(this._entryPoint);
        this._nodes.add(this._regularExit);
        this._nodes.add(this._exceptionalExit);
    }

    public final ControlFlowGraph build() {
        this.calculateIncomingJumps();
        this.createNodes();
        this.createRegularControlFlow();
        this.createExceptionalControlFlow();
        if (this.copyFinallyBlocks) {
            this.copyFinallyBlocksIntoLeaveEdges();
        } else {
            this.transformLeaveEdges();
        }
        return new ControlFlowGraph(this._nodes.toArray(new ControlFlowNode[this._nodes.size()]));
    }

    private void calculateIncomingJumps() {
        for (Instruction instruction : this._instructions) {
            OpCode opCode = instruction.getOpCode();
            if (opCode.getOperandType() == OperandType.BranchTarget || opCode.getOperandType() == OperandType.BranchTargetWide) {
                this._hasIncomingJumps[this.getInstructionIndex((Instruction)((Instruction)instruction.getOperand((int)0)))] = true;
                continue;
            }
            if (opCode.getOperandType() != OperandType.Switch) continue;
            SwitchInfo switchInfo = (SwitchInfo)instruction.getOperand(0);
            this._hasIncomingJumps[this.getInstructionIndex((Instruction)switchInfo.getDefaultTarget())] = true;
            Instruction[] instructionArray = switchInfo.getTargets();
            int n = instructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instruction target = instructionArray[n2];
                this._hasIncomingJumps[this.getInstructionIndex((Instruction)target)] = true;
                ++n2;
            }
        }
        for (ExceptionHandler handler : this._exceptionHandlers) {
            this._hasIncomingJumps[this.getInstructionIndex((Instruction)handler.getHandlerBlock().getFirstInstruction())] = true;
        }
    }

    private void createNodes() {
        List<Instruction> instructions = this._instructions;
        int i = 0;
        int n = instructions.size();
        while (i < n) {
            Instruction blockStart = instructions.get(i);
            ExceptionHandler blockStartExceptionHandler = this.findInnermostExceptionHandler(blockStart.getOffset());
            while (i + 1 < n) {
                ExceptionHandler innermostExceptionHandler;
                Instruction next;
                Instruction instruction = instructions.get(i);
                OpCode opCode = instruction.getOpCode();
                if (opCode.isBranch() || this._hasIncomingJumps[i + 1] || (next = instruction.getNext()) != null && (innermostExceptionHandler = this.findInnermostExceptionHandler(next.getOffset())) != blockStartExceptionHandler) break;
                ++i;
            }
            this._nodes.add(new ControlFlowNode(this._nodes.size(), blockStart, instructions.get(i)));
            ++i;
        }
        for (ExceptionHandler handler : this._exceptionHandlers) {
            int index = this._nodes.size();
            ControlFlowNode endFinallyNode = handler.getHandlerType() == ExceptionHandlerType.Finally ? new ControlFlowNode(index, handler.getHandlerBlock().getLastInstruction().getEndOffset(), ControlFlowNodeType.EndFinally) : null;
            this._nodes.add(new ControlFlowNode(index, handler, endFinallyNode));
        }
    }

    private void createRegularControlFlow() {
        List<Instruction> instructions = this._instructions;
        this.createEdge(this._entryPoint, instructions.get(0), JumpType.Normal);
        for (ControlFlowNode node : this._nodes) {
            ControlFlowNode handlerBlock;
            boolean isHandlerStart;
            Instruction next;
            Instruction end = node.getEnd();
            if (end == null || end.getOffset() >= this._instructions.get(this._instructions.size() - 1).getEndOffset()) continue;
            OpCode endOpCode = end.getOpCode();
            if (!(endOpCode.isUnconditionalBranch() && !endOpCode.isJumpToSubroutine() || (next = end.getNext()) == null || (isHandlerStart = CollectionUtilities.any(this._exceptionHandlers, new Predicate<ExceptionHandler>(){

                @Override
                public boolean test(ExceptionHandler handler) {
                    return handler.getHandlerBlock().getFirstInstruction() == next;
                }
            })))) {
                this.createEdge(node, next, JumpType.Normal);
            }
            Instruction instruction = node.getStart();
            while (instruction != null && instruction.getOffset() <= end.getOffset()) {
                OpCode opCode = instruction.getOpCode();
                if (opCode.getOperandType() == OperandType.BranchTarget || opCode.getOperandType() == OperandType.BranchTargetWide) {
                    this.createBranchControlFlow(node, instruction, (Instruction)instruction.getOperand(0));
                } else if (opCode.getOperandType() == OperandType.Switch) {
                    SwitchInfo switchInfo = (SwitchInfo)instruction.getOperand(0);
                    this.createEdge(node, switchInfo.getDefaultTarget(), JumpType.Normal);
                    Instruction[] instructionArray = switchInfo.getTargets();
                    int n = instructionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Instruction target = instructionArray[n2];
                        this.createEdge(node, target, JumpType.Normal);
                        ++n2;
                    }
                }
                instruction = instruction.getNext();
            }
            if (endOpCode == OpCode.ENDFINALLY) {
                handlerBlock = this.findInnermostFinallyBlock(end.getOffset());
                if (handlerBlock.getEndFinallyNode() == null) continue;
                this.createEdge(node, handlerBlock.getEndFinallyNode(), JumpType.Normal);
                continue;
            }
            if (endOpCode == OpCode.LEAVE) {
                handlerBlock = this.findInnermostHandlerBlock(end.getOffset());
                if (handlerBlock == this._exceptionalExit) continue;
                if (handlerBlock.getEndFinallyNode() == null) {
                    handlerBlock = this.findInnermostFinallyHandlerNode(handlerBlock.getExceptionHandler().getTryBlock().getLastInstruction().getOffset());
                }
                if (handlerBlock.getEndFinallyNode() == null) continue;
                this.createEdge(node, handlerBlock.getEndFinallyNode(), JumpType.LeaveTry);
                continue;
            }
            if (!endOpCode.isReturn()) continue;
            this.createReturnControlFlow(node, end);
        }
    }

    private void createExceptionalControlFlow() {
        for (ControlFlowNode node : this._nodes) {
            ExceptionHandler exceptionHandler;
            ControlFlowNode handlerBlock;
            Instruction end = node.getEnd();
            if (end != null && end.getOffset() < this._instructions.get(this._instructions.size() - 1).getEndOffset()) {
                Object finallyBlock;
                ControlFlowNode innermostHandler = this.findInnermostExceptionHandlerNode(node.getEnd().getOffset());
                if (innermostHandler == this._exceptionalExit) {
                    handlerBlock = this.findInnermostHandlerBlock(node.getEnd().getOffset());
                    if (handlerBlock.getExceptionHandler() != null) {
                        finallyBlock = this.findInnermostFinallyHandlerNode(handlerBlock.getExceptionHandler().getTryBlock().getLastInstruction().getOffset());
                        if (((ControlFlowNode)finallyBlock).getNodeType() == ControlFlowNodeType.FinallyHandler && ((ControlFlowNode)finallyBlock).getExceptionHandler().getHandlerBlock().contains(end)) {
                            finallyBlock = this._exceptionalExit;
                        }
                    } else {
                        finallyBlock = this._exceptionalExit;
                    }
                    this.createEdge(node, (ControlFlowNode)finallyBlock, JumpType.JumpToExceptionHandler);
                } else {
                    finallyBlock = this._exceptionHandlers.iterator();
                    while (finallyBlock.hasNext()) {
                        final ExceptionHandler handler = finallyBlock.next();
                        if (!Comparer.equals(handler.getTryBlock(), innermostHandler.getExceptionHandler().getTryBlock())) continue;
                        ControlFlowNode handlerNode = CollectionUtilities.firstOrDefault(this._nodes, new Predicate<ControlFlowNode>(){

                            @Override
                            public boolean test(ControlFlowNode node) {
                                return node.getExceptionHandler() == handler;
                            }
                        });
                        this.createEdge(node, handlerNode, JumpType.JumpToExceptionHandler);
                    }
                    handlerBlock = this.findInnermostHandlerBlock(node.getEnd().getOffset());
                    if (handlerBlock != innermostHandler && handlerBlock.getNodeType() == ControlFlowNodeType.CatchHandler && ((ControlFlowNode)(finallyBlock = this.findInnermostFinallyHandlerNode(handlerBlock.getExceptionHandler().getTryBlock().getLastInstruction().getOffset()))).getNodeType() == ControlFlowNodeType.FinallyHandler) {
                        this.createEdge(node, (ControlFlowNode)finallyBlock, JumpType.JumpToExceptionHandler);
                    }
                }
            }
            if ((exceptionHandler = node.getExceptionHandler()) == null) continue;
            if (exceptionHandler.isFinally()) {
                handlerBlock = this.findInnermostFinallyHandlerNode(exceptionHandler.getHandlerBlock().getLastInstruction().getOffset());
                if (handlerBlock.getNodeType() == ControlFlowNodeType.FinallyHandler && handlerBlock != node) {
                    this.createEdge(node, handlerBlock, JumpType.JumpToExceptionHandler);
                }
            } else {
                ControlFlowNode adjacentFinally = this.findInnermostFinallyHandlerNode(exceptionHandler.getTryBlock().getLastInstruction().getOffset());
                this.createEdge(node, adjacentFinally != null ? adjacentFinally : this.findParentExceptionHandlerNode(node), JumpType.JumpToExceptionHandler);
            }
            this.createEdge(node, exceptionHandler.getHandlerBlock().getFirstInstruction(), JumpType.Normal);
        }
    }

    private void createBranchControlFlow(ControlFlowNode node, Instruction jump, Instruction target) {
        ControlFlowNode handlerNode = this.findInnermostHandlerBlock(jump.getOffset());
        ControlFlowNode outerFinally = this.findInnermostHandlerBlock(jump.getOffset(), true);
        ControlFlowNode targetHandlerNode = this.findInnermostHandlerBlock(target.getOffset());
        ExceptionHandler handler = handlerNode.getExceptionHandler();
        if (jump.getOpCode().isJumpToSubroutine() || targetHandlerNode == handlerNode || handler != null && (handler.getTryBlock().contains(jump) ? handler.getTryBlock().contains(target) : handler.getHandlerBlock().contains(target))) {
            this.createEdge(node, target, JumpType.Normal);
            return;
        }
        if (handlerNode.getNodeType() == ControlFlowNodeType.CatchHandler) {
            ControlFlowNode finallyHandlerNode = this.findInnermostFinallyHandlerNode(handler.getTryBlock().getLastInstruction().getOffset());
            ExceptionHandler finallyHandler = finallyHandlerNode.getExceptionHandler();
            ExceptionHandler outerFinallyHandler = outerFinally.getExceptionHandler();
            if (finallyHandlerNode.getNodeType() != ControlFlowNodeType.FinallyHandler || outerFinally.getNodeType() == ControlFlowNodeType.FinallyHandler && finallyHandler.getTryBlock().contains(outerFinallyHandler.getHandlerBlock())) {
                finallyHandlerNode = outerFinally;
            }
            if (finallyHandlerNode.getNodeType() == ControlFlowNodeType.FinallyHandler && finallyHandlerNode != targetHandlerNode) {
                this.createEdge(node, target, JumpType.LeaveTry);
            } else {
                this.createEdge(node, target, JumpType.Normal);
            }
            return;
        }
        if (handlerNode.getNodeType() == ControlFlowNodeType.FinallyHandler) {
            if (handler.getTryBlock().contains(jump)) {
                this.createEdge(node, target, JumpType.LeaveTry);
            } else {
                ControlFlowNode parentHandler = this.findParentExceptionHandlerNode(handlerNode);
                while (parentHandler != handlerNode && parentHandler.getNodeType() == ControlFlowNodeType.CatchHandler) {
                    parentHandler = this.findParentExceptionHandlerNode(parentHandler);
                }
                if (parentHandler.getNodeType() == ControlFlowNodeType.FinallyHandler && !parentHandler.getExceptionHandler().getTryBlock().contains(target)) {
                    this.createEdge(node, target, JumpType.LeaveTry);
                } else {
                    this.createEdge(node, handlerNode.getEndFinallyNode(), JumpType.Normal);
                    this.createEdge(handlerNode.getEndFinallyNode(), target, JumpType.Normal);
                }
            }
            return;
        }
        this.createEdge(node, target, JumpType.Normal);
    }

    private void createReturnControlFlow(ControlFlowNode node, Instruction end) {
        this.createEdge(node, this._regularExit, JumpType.Normal);
    }

    private void transformLeaveEdges() {
        int n = this._nodes.size();
        int i = n - 1;
        while (i >= 0) {
            ControlFlowNode node = this._nodes.get(i);
            Instruction end = node.getEnd();
            if (end != null && !node.getOutgoing().isEmpty()) {
                for (ControlFlowEdge edge : node.getOutgoing()) {
                    ControlFlowNode finallyBlock;
                    if (edge.getType() != JumpType.LeaveTry) continue;
                    assert (end.getOpCode().isBranch());
                    ControlFlowNode handlerBlock = this.findInnermostHandlerBlock(end.getOffset());
                    if (handlerBlock != (finallyBlock = this.findInnermostFinallyHandlerNode(end.getOffset()))) {
                        ExceptionHandler handler = handlerBlock.getExceptionHandler();
                        ControlFlowNode adjacentFinally = this.findInnermostFinallyHandlerNode(handler.getTryBlock().getLastInstruction().getOffset());
                        if (finallyBlock.getNodeType() != ControlFlowNodeType.FinallyHandler || finallyBlock != adjacentFinally) {
                            finallyBlock = adjacentFinally;
                        }
                    }
                    ControlFlowNode target = edge.getTarget();
                    target.getIncoming().remove(edge);
                    node.getOutgoing().remove(edge);
                    if (finallyBlock.getNodeType() == ControlFlowNodeType.ExceptionalExit) {
                        this.createEdge(node, finallyBlock, JumpType.Normal);
                        continue;
                    }
                    assert (finallyBlock.getNodeType() == ControlFlowNodeType.FinallyHandler);
                    Instruction targetAddress = target.getStart();
                    if (targetAddress == null && target.getExceptionHandler() != null) {
                        targetAddress = target.getExceptionHandler().getHandlerBlock().getFirstInstruction();
                    }
                    if (finallyBlock.getExceptionHandler().getHandlerBlock().contains(end)) {
                        this.createEdge(node, finallyBlock.getEndFinallyNode(), JumpType.Normal);
                    } else {
                        this.createEdge(node, finallyBlock, JumpType.Normal);
                    }
                    if (targetAddress != null) {
                        while (true) {
                            ControlFlowNode parentHandler = this.findParentExceptionHandlerNode(finallyBlock);
                            while (parentHandler.getNodeType() == ControlFlowNodeType.CatchHandler && !parentHandler.getExceptionHandler().getTryBlock().contains(targetAddress)) {
                                if ((parentHandler = this.findInnermostFinallyHandlerNode(parentHandler.getExceptionHandler().getTryBlock().getLastInstruction().getOffset())) != finallyBlock) continue;
                                parentHandler = this.findParentExceptionHandlerNode(finallyBlock);
                            }
                            if (parentHandler.getNodeType() != ControlFlowNodeType.FinallyHandler || parentHandler.getExceptionHandler().getTryBlock().contains(targetAddress)) break;
                            this.createEdge(finallyBlock.getEndFinallyNode(), parentHandler, JumpType.EndFinally);
                            finallyBlock = parentHandler;
                        }
                    }
                    if (finallyBlock == target) continue;
                    this.createEdge(finallyBlock.getEndFinallyNode(), target, JumpType.EndFinally);
                    this.createEdge(this.findNode(finallyBlock.getExceptionHandler().getHandlerBlock().getLastInstruction()), finallyBlock.getEndFinallyNode(), JumpType.Normal);
                }
            }
            --i;
        }
    }

    private void copyFinallyBlocksIntoLeaveEdges() {
        int n = this._nodes.size();
        int i = n - 1;
        while (i >= 0) {
            ControlFlowNode node = this._nodes.get(i);
            Instruction end = node.getEnd();
            if (end != null && node.getOutgoing().size() == 1 && node.getOutgoing().get(0).getType() == JumpType.LeaveTry) {
                assert (end.getOpCode() == OpCode.GOTO || end.getOpCode() == OpCode.GOTO_W);
                ControlFlowEdge edge = node.getOutgoing().get(0);
                ControlFlowNode target = edge.getTarget();
                target.getIncoming().remove(edge);
                node.getOutgoing().clear();
                ControlFlowNode handler = this.findInnermostExceptionHandlerNode(end.getEndOffset());
                assert (handler.getNodeType() == ControlFlowNodeType.FinallyHandler);
                ControlFlowNode copy = this.copyFinallySubGraph(handler, handler.getEndFinallyNode(), target);
                this.createEdge(node, copy, JumpType.Normal);
            }
            --i;
        }
    }

    private ControlFlowNode copyFinallySubGraph(ControlFlowNode start, ControlFlowNode end, ControlFlowNode newEnd) {
        return new CopyFinallySubGraphLogic(start, end, newEnd).copyFinallySubGraph();
    }

    private static boolean isNarrower(ExceptionHandler handler, ExceptionHandler anchor) {
        if (handler == null || anchor == null) {
            return false;
        }
        Instruction tryStart = handler.getTryBlock().getFirstInstruction();
        Instruction anchorTryStart = anchor.getTryBlock().getFirstInstruction();
        if (tryStart.getOffset() > anchorTryStart.getOffset()) {
            return true;
        }
        Instruction tryEnd = handler.getTryBlock().getLastInstruction();
        Instruction anchorTryEnd = anchor.getTryBlock().getLastInstruction();
        return tryStart.getOffset() == anchorTryStart.getOffset() && tryEnd.getOffset() < anchorTryEnd.getOffset();
    }

    private static boolean isNarrower(InstructionBlock block, InstructionBlock anchor) {
        if (block == null || anchor == null) {
            return false;
        }
        Instruction start = block.getFirstInstruction();
        Instruction anchorStart = anchor.getFirstInstruction();
        Instruction end = block.getLastInstruction();
        Instruction anchorEnd = anchor.getLastInstruction();
        if (start.getOffset() > anchorStart.getOffset()) {
            return end.getOffset() < anchorEnd.getEndOffset();
        }
        return start.getOffset() == anchorStart.getOffset() && end.getOffset() < anchorEnd.getOffset();
    }

    private ControlFlowNode findParentExceptionHandlerNode(ControlFlowNode node) {
        assert (node.getNodeType() == ControlFlowNodeType.CatchHandler || node.getNodeType() == ControlFlowNodeType.FinallyHandler);
        ControlFlowNode result = null;
        ExceptionHandler resultHandler = null;
        int offset = node.getExceptionHandler().getHandlerBlock().getFirstInstruction().getOffset();
        int i = 0;
        int n = this._nodes.size();
        while (i < n) {
            ControlFlowNode currentNode = this._nodes.get(i);
            ExceptionHandler handler = currentNode.getExceptionHandler();
            if (handler != null && handler.getTryBlock().getFirstInstruction().getOffset() <= offset && offset < handler.getTryBlock().getLastInstruction().getEndOffset() && (resultHandler == null || ControlFlowGraphBuilder.isNarrower(handler, resultHandler))) {
                result = currentNode;
                resultHandler = handler;
            }
            ++i;
        }
        return result != null ? result : this._exceptionalExit;
    }

    private ControlFlowNode findInnermostExceptionHandlerNode(int offset) {
        ExceptionHandler handler = this.findInnermostExceptionHandler(offset);
        if (handler == null) {
            return this._exceptionalExit;
        }
        for (ControlFlowNode node : this._nodes) {
            if (node.getExceptionHandler() != handler || node.getCopyFrom() != null) continue;
            return node;
        }
        throw new IllegalStateException("Could not find node for exception handler!");
    }

    private ControlFlowNode findInnermostFinallyHandlerNode(int offset) {
        ExceptionHandler handler = this.findInnermostFinallyHandler(offset);
        if (handler == null) {
            return this._exceptionalExit;
        }
        for (ControlFlowNode node : this._nodes) {
            if (node.getExceptionHandler() != handler || node.getCopyFrom() != null) continue;
            return node;
        }
        throw new IllegalStateException("Could not find node for exception handler!");
    }

    private int getInstructionIndex(Instruction instruction) {
        int index = Arrays.binarySearch(this._offsets, instruction.getOffset());
        assert (index >= 0);
        return index;
    }

    private ControlFlowNode findNode(Instruction instruction) {
        int offset = instruction.getOffset();
        for (ControlFlowNode node : this._nodes) {
            if (node.getNodeType() != ControlFlowNodeType.Normal || offset < node.getStart().getOffset() || offset >= node.getEnd().getEndOffset()) continue;
            return node;
        }
        return null;
    }

    private ExceptionHandler findInnermostExceptionHandler(int offsetInTryBlock) {
        ExceptionHandler result = null;
        for (ExceptionHandler handler : this._exceptionHandlers) {
            InstructionBlock tryBlock = handler.getTryBlock();
            if (tryBlock.getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= tryBlock.getLastInstruction().getEndOffset() || result != null && !ControlFlowGraphBuilder.isNarrower(handler, result)) continue;
            result = handler;
        }
        return result;
    }

    private ExceptionHandler findInnermostFinallyHandler(int offsetInTryBlock) {
        ExceptionHandler result = null;
        for (ExceptionHandler handler : this._exceptionHandlers) {
            InstructionBlock tryBlock;
            if (!handler.isFinally() || (tryBlock = handler.getTryBlock()).getFirstInstruction().getOffset() > offsetInTryBlock || offsetInTryBlock >= tryBlock.getLastInstruction().getEndOffset() || result != null && !ControlFlowGraphBuilder.isNarrower(handler, result)) continue;
            result = handler;
        }
        return result;
    }

    private ControlFlowNode findInnermostHandlerBlock(int instructionOffset) {
        return this.findInnermostHandlerBlock(instructionOffset, false);
    }

    private ControlFlowNode findInnermostFinallyBlock(int instructionOffset) {
        return this.findInnermostHandlerBlock(instructionOffset, true);
    }

    private ControlFlowNode findInnermostHandlerBlock(int instructionOffset, boolean finallyOnly) {
        InstructionBlock innerBlock;
        ExceptionHandler result = null;
        InstructionBlock resultBlock = null;
        for (ExceptionHandler handler : this._exceptionHandlers) {
            InstructionBlock handlerBlock;
            if (finallyOnly && handler.isCatch() || (handlerBlock = handler.getHandlerBlock()).getFirstInstruction().getOffset() > instructionOffset || instructionOffset >= handlerBlock.getLastInstruction().getEndOffset() || resultBlock != null && !ControlFlowGraphBuilder.isNarrower(handler.getHandlerBlock(), resultBlock)) continue;
            result = handler;
            resultBlock = handlerBlock;
        }
        ControlFlowNode innerMost = finallyOnly ? this.findInnermostExceptionHandlerNode(instructionOffset) : this.findInnermostFinallyHandlerNode(instructionOffset);
        ExceptionHandler innerHandler = innerMost.getExceptionHandler();
        InstructionBlock instructionBlock = innerBlock = innerHandler != null ? innerHandler.getTryBlock() : null;
        if (innerBlock != null && (resultBlock == null || ControlFlowGraphBuilder.isNarrower(innerBlock, resultBlock))) {
            result = innerHandler;
        }
        if (result == null) {
            return this._exceptionalExit;
        }
        for (ControlFlowNode node : this._nodes) {
            if (node.getExceptionHandler() != result || node.getCopyFrom() != null) continue;
            return node;
        }
        throw new IllegalStateException("Could not find innermost handler block!");
    }

    private ControlFlowEdge createEdge(ControlFlowNode fromNode, Instruction toInstruction, JumpType type) {
        ControlFlowNode target = null;
        for (ControlFlowNode node : this._nodes) {
            if (node.getStart() == null || node.getStart().getOffset() != toInstruction.getOffset()) continue;
            if (target != null) {
                throw new IllegalStateException("Multiple edge targets detected!");
            }
            target = node;
        }
        if (target != null) {
            return this.createEdge(fromNode, target, type);
        }
        throw new IllegalStateException("Could not find target node!");
    }

    private ControlFlowEdge createEdge(ControlFlowNode fromNode, ControlFlowNode toNode, JumpType type) {
        ControlFlowEdge edge = new ControlFlowEdge(fromNode, toNode, type);
        for (ControlFlowEdge existingEdge : fromNode.getOutgoing()) {
            if (existingEdge.getSource() != fromNode || existingEdge.getTarget() != toNode || existingEdge.getType() != type) continue;
            return existingEdge;
        }
        fromNode.getOutgoing().add(edge);
        toNode.getIncoming().add(edge);
        return edge;
    }

    private static List<ExceptionHandler> coalesceExceptionHandlers(List<ExceptionHandler> handlers) {
        ArrayList<ExceptionHandler> copy = new ArrayList<ExceptionHandler>(handlers);
        return copy;
    }

    private final class CopyFinallySubGraphLogic {
        final Map<ControlFlowNode, ControlFlowNode> oldToNew = new IdentityHashMap<ControlFlowNode, ControlFlowNode>();
        final ControlFlowNode start;
        final ControlFlowNode end;
        final ControlFlowNode newEnd;

        CopyFinallySubGraphLogic(ControlFlowNode start, ControlFlowNode end, ControlFlowNode newEnd) {
            this.start = start;
            this.end = end;
            this.newEnd = newEnd;
        }

        final ControlFlowNode copyFinallySubGraph() {
            for (ControlFlowNode node : this.end.getPredecessors()) {
                this.collectNodes(node);
            }
            for (ControlFlowNode old : this.oldToNew.keySet()) {
                this.reconstructEdges(old, this.oldToNew.get(old));
            }
            return this.getNew(this.start);
        }

        private void collectNodes(ControlFlowNode node) {
            ControlFlowNode copy;
            if (node == this.end || node == this.newEnd) {
                throw new IllegalStateException("Unexpected cycle involving finally constructs!");
            }
            if (this.oldToNew.containsKey(node)) {
                return;
            }
            int newBlockIndex = ControlFlowGraphBuilder.this._nodes.size();
            switch (node.getNodeType()) {
                case Normal: {
                    copy = new ControlFlowNode(newBlockIndex, node.getStart(), node.getEnd());
                    break;
                }
                case FinallyHandler: {
                    copy = new ControlFlowNode(newBlockIndex, node.getExceptionHandler(), node.getEndFinallyNode());
                    break;
                }
                default: {
                    throw ContractUtils.unsupported();
                }
            }
            copy.setCopyFrom(node);
            ControlFlowGraphBuilder.this._nodes.add(copy);
            this.oldToNew.put(node, copy);
            if (node != this.start) {
                for (ControlFlowNode predecessor : node.getPredecessors()) {
                    this.collectNodes(predecessor);
                }
            }
        }

        private void reconstructEdges(ControlFlowNode oldNode, ControlFlowNode newNode) {
            for (ControlFlowEdge oldEdge : oldNode.getOutgoing()) {
                ControlFlowGraphBuilder.this.createEdge(newNode, this.getNew(oldEdge.getTarget()), oldEdge.getType());
            }
        }

        private ControlFlowNode getNew(ControlFlowNode oldNode) {
            if (oldNode == this.end) {
                return this.newEnd;
            }
            ControlFlowNode newNode = this.oldToNew.get(oldNode);
            return newNode != null ? newNode : oldNode;
        }
    }
}

