/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.flowanalysis;

import com.strobel.assembler.flowanalysis.ControlFlowEdge;
import com.strobel.assembler.flowanalysis.ControlFlowNode;
import com.strobel.assembler.flowanalysis.ControlFlowNodeType;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.BooleanBox;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.functions.Block;
import com.strobel.functions.Function;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;

public final class ControlFlowGraph {
    private final List<ControlFlowNode> _nodes;
    private static final Pattern SAFE_PATTERN = Pattern.compile("^[\\w\\d]+$");

    public final ControlFlowNode getEntryPoint() {
        return this._nodes.get(0);
    }

    public final ControlFlowNode getRegularExit() {
        return this._nodes.get(1);
    }

    public final ControlFlowNode getExceptionalExit() {
        return this._nodes.get(2);
    }

    public final List<ControlFlowNode> getNodes() {
        return this._nodes;
    }

    public ControlFlowGraph(ControlFlowNode ... nodes) {
        this._nodes = ArrayUtilities.asUnmodifiableList(VerifyArgument.noNullElements(nodes, "nodes"));
        assert (nodes.length >= 3);
        assert (this.getEntryPoint().getNodeType() == ControlFlowNodeType.EntryPoint);
        assert (this.getRegularExit().getNodeType() == ControlFlowNodeType.RegularExit);
        assert (this.getExceptionalExit().getNodeType() == ControlFlowNodeType.ExceptionalExit);
    }

    public final void resetVisited() {
        for (ControlFlowNode node : this._nodes) {
            node.setVisited(false);
        }
    }

    public final void computeDominance() {
        this.computeDominance(new BooleanBox());
    }

    public final void computeDominance(BooleanBox cancelled) {
        final ControlFlowNode entryPoint = this.getEntryPoint();
        entryPoint.setImmediateDominator(entryPoint);
        final BooleanBox changed = new BooleanBox(true);
        while (changed.get().booleanValue()) {
            changed.set(false);
            this.resetVisited();
            if (cancelled.get().booleanValue()) {
                throw new CancellationException();
            }
            entryPoint.traversePreOrder(new Function<ControlFlowNode, Iterable<ControlFlowNode>>(){

                @Override
                public final Iterable<ControlFlowNode> apply(ControlFlowNode input) {
                    return input.getSuccessors();
                }
            }, new Block<ControlFlowNode>(){

                @Override
                public final void accept(ControlFlowNode b) {
                    if (b == entryPoint) {
                        return;
                    }
                    ControlFlowNode newImmediateDominator = null;
                    for (ControlFlowNode p : b.getPredecessors()) {
                        if (!p.isVisited() || p == b) continue;
                        newImmediateDominator = p;
                        break;
                    }
                    if (newImmediateDominator == null) {
                        throw new IllegalStateException("Could not compute new immediate dominator!");
                    }
                    for (ControlFlowNode p : b.getPredecessors()) {
                        if (p == b || p.getImmediateDominator() == null) continue;
                        newImmediateDominator = ControlFlowGraph.findCommonDominator(p, newImmediateDominator);
                    }
                    if (b.getImmediateDominator() != newImmediateDominator) {
                        b.setImmediateDominator(newImmediateDominator);
                        changed.set(true);
                    }
                }
            });
        }
        entryPoint.setImmediateDominator(null);
        for (ControlFlowNode node : this._nodes) {
            ControlFlowNode immediateDominator = node.getImmediateDominator();
            if (immediateDominator == null) continue;
            immediateDominator.getDominatorTreeChildren().add(node);
        }
    }

    public final void computeDominanceFrontier() {
        this.resetVisited();
        this.getEntryPoint().traversePostOrder(new Function<ControlFlowNode, Iterable<ControlFlowNode>>(){

            @Override
            public final Iterable<ControlFlowNode> apply(ControlFlowNode input) {
                return input.getDominatorTreeChildren();
            }
        }, new Block<ControlFlowNode>(){

            @Override
            public void accept(ControlFlowNode n) {
                Set<ControlFlowNode> dominanceFrontier = n.getDominanceFrontier();
                dominanceFrontier.clear();
                for (ControlFlowNode s : n.getSuccessors()) {
                    if (s.getImmediateDominator() == n) continue;
                    dominanceFrontier.add(s);
                }
                for (ControlFlowNode child : n.getDominatorTreeChildren()) {
                    for (ControlFlowNode p : child.getDominanceFrontier()) {
                        if (p.getImmediateDominator() == n) continue;
                        dominanceFrontier.add(p);
                    }
                }
            }
        });
    }

    public static ControlFlowNode findCommonDominator(ControlFlowNode a, ControlFlowNode b) {
        LinkedHashSet<ControlFlowNode> path1 = new LinkedHashSet<ControlFlowNode>();
        ControlFlowNode node1 = a;
        ControlFlowNode node2 = b;
        while (node1 != null && path1.add(node1)) {
            node1 = node1.getImmediateDominator();
        }
        while (node2 != null) {
            if (path1.contains(node2)) {
                return node2;
            }
            node2 = node2.getImmediateDominator();
        }
        throw new IllegalStateException("No common dominator found!");
    }

    /*
     * WARNING - void declaration
     */
    public final void export(File path) {
        PlainTextOutput output = new PlainTextOutput();
        output.writeLine("digraph g {");
        output.indent();
        LinkedHashSet<ControlFlowEdge> edges = new LinkedHashSet<ControlFlowEdge>();
        for (ControlFlowNode controlFlowNode : this._nodes) {
            output.writeLine("\"%s\" [", ControlFlowGraph.nodeName(controlFlowNode));
            output.indent();
            output.writeLine("label = \"%s\\l\"", ControlFlowGraph.escapeGraphViz(controlFlowNode.toString()));
            output.writeLine(", shape = \"box\"");
            output.unindent();
            output.writeLine("];");
            edges.addAll(controlFlowNode.getIncoming());
            edges.addAll(controlFlowNode.getOutgoing());
            ControlFlowNode endFinallyNode = controlFlowNode.getEndFinallyNode();
            if (endFinallyNode == null) continue;
            output.writeLine("\"%s\" [", ControlFlowGraph.nodeName(endFinallyNode));
            output.indent();
            output.writeLine("label = \"%s\"", ControlFlowGraph.escapeGraphViz(endFinallyNode.toString()));
            output.writeLine("shape = \"box\"");
            output.unindent();
            output.writeLine("];");
            edges.addAll(endFinallyNode.getIncoming());
            edges.addAll(endFinallyNode.getOutgoing());
        }
        for (ControlFlowEdge controlFlowEdge : edges) {
            ControlFlowNode from = controlFlowEdge.getSource();
            ControlFlowNode to = controlFlowEdge.getTarget();
            output.writeLine("\"%s\" -> \"%s\" [", ControlFlowGraph.nodeName(from), ControlFlowGraph.nodeName(to));
            output.indent();
            switch (controlFlowEdge.getType()) {
                case Normal: {
                    break;
                }
                case LeaveTry: {
                    output.writeLine("color = \"blue\"");
                    break;
                }
                case EndFinally: {
                    output.writeLine("color = \"red\"");
                    break;
                }
                case JumpToExceptionHandler: {
                    output.writeLine("color = \"gray\"");
                    break;
                }
                default: {
                    output.writeLine("label = \"%s\"", new Object[]{controlFlowEdge.getType()});
                }
            }
            output.unindent();
            output.writeLine("];");
        }
        output.unindent();
        output.writeLine("}");
        try {
            Throwable throwable = null;
            Iterator<ControlFlowNode> iterator = null;
            try (FileWriter out = new FileWriter(path);){
                out.write(output.toString());
            }
            catch (Throwable throwable2) {
                void var4_12;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_12;
            }
        }
        catch (IOException iOException) {
            throw ExceptionUtilities.asRuntimeException(iOException);
        }
    }

    private static String nodeName(ControlFlowNode node) {
        String name = "node" + node.getBlockIndex();
        if (node.getNodeType() == ControlFlowNodeType.EndFinally) {
            name = String.valueOf(name) + "_ef";
        }
        return name;
    }

    private static String escapeGraphViz(String text) {
        return ControlFlowGraph.escapeGraphViz(text, false);
    }

    private static String escapeGraphViz(String text, boolean quote) {
        if (SAFE_PATTERN.matcher(text).matches()) {
            return quote ? "\"" + text + "\"" : text;
        }
        return String.valueOf(quote ? "\"" : "") + text.replace("\\", "\\\\").replace("\r", "").replace("\n", "\\l").replace("|", "\\|").replace("{", "\\{").replace("}", "\\}").replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"") + (quote ? "\"" : "");
    }
}

